/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.chart;

import com.mirth.connect.plugins.messagetrends.client.chart.TrendsChart;
import com.mirth.connect.plugins.messagetrends.client.panel.MessageTrendsDashboardPanel;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import javax.swing.JComponent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;

public abstract class AbstractTrendsChart
implements TrendsChart {
    protected JFreeChart chart;
    protected ChartPanel panel;
    protected XYPlot plot;
    protected XYItemRenderer renderer;
    protected DateAxis xAxis;
    protected NumberAxis yAxis;
    protected int minutes = 1;
    protected Long winStartMs;
    protected Long winEndMs;
    protected String currentTitle = "Message Volume";

    protected final void initCommon(JFreeChart jFreeChart, XYPlot xYPlot, ChartPanel chartPanel, XYItemRenderer xYItemRenderer) {
        this.chart = jFreeChart;
        this.plot = xYPlot;
        this.panel = chartPanel;
        this.renderer = xYItemRenderer;
        this.xAxis = (DateAxis)xYPlot.getDomainAxis();
        this.yAxis = (NumberAxis)xYPlot.getRangeAxis();
        this.applyCommonStyle();
    }

    private void applyCommonStyle() {
        this.chart.setBackgroundPaint((Paint)Color.WHITE);
        this.chart.setAntiAlias(true);
        if (this.chart.getLegend() != null) {
            this.chart.getLegend().setBackgroundPaint((Paint)Color.WHITE);
        }
        this.panel.setBackground(Color.WHITE);
        this.panel.setDomainZoomable(false);
        this.panel.setMouseWheelEnabled(false);
        this.plot.setBackgroundPaint((Paint)Color.WHITE);
        this.plot.setDomainGridlinePaint((Paint)new Color(238, 238, 238));
        this.plot.setRangeGridlinePaint((Paint)new Color(238, 238, 238));
        this.plot.setDomainPannable(false);
        this.xAxis.setAutoRange(false);
        this.yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.yAxis.setNumberFormatOverride(NumberFormat.getIntegerInstance());
        this.yAxis.setAutoRangeIncludesZero(true);
        this.yAxis.setAutoRangeStickyZero(true);
    }

    @Override
    public final JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void setTitle(String string) {
        this.currentTitle = string != null ? string : "Message Volume";
        this.chart.setTitle(this.currentTitle);
    }

    @Override
    public void setIntervalMinutes(int n) {
        this.minutes = Math.max(1, n);
        this.updateXAxisFormat();
    }

    @Override
    public void setWindowRange(long l, long l2) {
        this.winStartMs = l;
        this.winEndMs = l2;
        if (l2 > l) {
            this.xAxis.setRange(new Date(l), new Date(l2));
            this.xAxis.setAutoRange(false);
        }
        this.updateXAxisFormat();
    }

    @Override
    public void setView(MessageTrendsDashboardPanel.View view) {
        boolean[] blArray = new boolean[]{false, false, false, false, false};
        if (view == null) {
            view = MessageTrendsDashboardPanel.View.ALL;
        }
        switch (view) {
            case ALL: {
                blArray = new boolean[]{true, true, true, true, true};
                break;
            }
            case RECEIVED: {
                blArray[0] = true;
                break;
            }
            case SENT: {
                blArray[1] = true;
                break;
            }
            case FILTERED: {
                blArray[2] = true;
                break;
            }
            case QUEUED: {
                blArray[3] = true;
                break;
            }
            case ERRORS: {
                blArray[4] = true;
            }
        }
        for (int i = 0; i < blArray.length; ++i) {
            this.renderer.setSeriesVisible(i, Boolean.valueOf(blArray[i]));
            this.renderer.setSeriesVisibleInLegend(i, Boolean.valueOf(blArray[i]));
        }
    }

    @Override
    public void setSeriesColors(Color color, Color color2, Color color3, Color color4, Color color5) {
        this.renderer.setSeriesPaint(0, (Paint)color);
        this.renderer.setSeriesPaint(1, (Paint)color2);
        this.renderer.setSeriesPaint(2, (Paint)color3);
        this.renderer.setSeriesPaint(3, (Paint)color4);
        this.renderer.setSeriesPaint(4, (Paint)color5);
    }

    @Override
    public void setData(List<MessageStatisticsTimeseries> list) {
        this.clearDataset();
        if (list == null || list.isEmpty()) {
            return;
        }
        RegularTimePeriodFactory regularTimePeriodFactory = new RegularTimePeriodFactory(this.minutes);
        for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
            Date date = messageStatisticsTimeseries.getTs();
            if (date == null) continue;
            long l = (long)messageStatisticsTimeseries.getBucketSizeMinutes().intValue() * 60000L;
            Date date2 = new Date(date.getTime() + l);
            RegularTimePeriod regularTimePeriod = regularTimePeriodFactory.of(date2.getTime());
            this.addPoint(regularTimePeriod, messageStatisticsTimeseries);
        }
        this.yAxis.setAutoRange(true);
    }

    @Override
    public void reset() {
        this.clearDataset();
    }

    protected void updateXAxisFormat() {
        if (this.winStartMs == null || this.winEndMs == null || this.winEndMs <= this.winStartMs) {
            return;
        }
        long l = this.winEndMs - this.winStartMs;
        String string = l <= 86400000L ? "HH:mm" : (l <= 604800000L ? "MMM dd HH:mm" : (l <= 7776000000L ? "MMM dd" : (l <= 94608000000L ? "yyyy-MM" : "yyyy")));
        this.xAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(string));
    }

    protected abstract void clearDataset();

    protected abstract void addPoint(RegularTimePeriod var1, MessageStatisticsTimeseries var2);

    protected static final class RegularTimePeriodFactory {
        private final int minutes;

        public RegularTimePeriodFactory(int n) {
            this.minutes = n;
        }

        public RegularTimePeriod of(Date date) {
            if (this.minutes >= 1440) {
                return new Day(date);
            }
            if (this.minutes >= 60) {
                return new Hour(date);
            }
            return new Minute(date);
        }

        public RegularTimePeriod of(long l) {
            if (this.minutes >= 1440) {
                return new Day(new Date(l));
            }
            if (this.minutes == 60) {
                return new Hour(new Date(l));
            }
            if (this.minutes == 1) {
                return new Minute(new Date(l));
            }
            return new MultiMinute(l, this.minutes, TimeZone.getTimeZone("UTC"));
        }
    }

    static final class MultiMinute
    extends RegularTimePeriod {
        private final long startMs;
        private final long endMs;
        private final int minutes;
        private final TimeZone tz;

        MultiMinute(long l, int n, TimeZone timeZone) {
            this.minutes = n;
            this.tz = timeZone;
            long l2 = (long)n * 60000L;
            this.startMs = l;
            this.endMs = l + l2;
        }

        public long getFirstMillisecond() {
            return this.startMs;
        }

        public long getLastMillisecond() {
            return this.endMs - 1L;
        }

        public long getFirstMillisecond(Calendar calendar) {
            if (calendar == null) {
                throw new IllegalArgumentException("Calendar cannot be null");
            }
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeZone(this.tz);
            calendar2.setTimeInMillis(this.startMs);
            return calendar2.getTimeInMillis();
        }

        public long getLastMillisecond(Calendar calendar) {
            if (calendar == null) {
                throw new IllegalArgumentException("Calendar cannot be null");
            }
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar2.setTimeZone(this.tz);
            calendar2.setTimeInMillis(this.endMs - 1L);
            return calendar2.getTimeInMillis();
        }

        public void peg(Calendar calendar) {
        }

        public RegularTimePeriod previous() {
            return new MultiMinute(this.startMs - (long)this.minutes * 60000L, this.minutes, this.tz);
        }

        public RegularTimePeriod next() {
            return new MultiMinute(this.startMs + (long)this.minutes * 60000L, this.minutes, this.tz);
        }

        public long getSerialIndex() {
            return this.startMs / ((long)this.minutes * 60000L);
        }

        public int compareTo(Object object) {
            if (object == this) {
                return 0;
            }
            if (object instanceof RegularTimePeriod) {
                long l = this.getFirstMillisecond();
                long l2 = ((RegularTimePeriod)object).getFirstMillisecond();
                return Long.compare(l, l2);
            }
            throw new ClassCastException("Cannot compare " + (object == null ? "null" : object.getClass().getName()) + " with MultiMinute");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MultiMinute)) {
                return false;
            }
            MultiMinute multiMinute = (MultiMinute)((Object)object);
            return this.startMs == multiMinute.startMs && this.minutes == multiMinute.minutes;
        }

        public int hashCode() {
            return Objects.hash(this.startMs, this.minutes);
        }
    }
}

