/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.chart;

import com.mirth.connect.plugins.messagetrends.client.chart.AbstractTrendsChart;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class LineTrendsChart
extends AbstractTrendsChart {
    private final TimeSeriesCollection dataset = new TimeSeriesCollection();
    private final TimeSeries received = new TimeSeries((Comparable)((Object)"Received"));
    private final TimeSeries sent = new TimeSeries((Comparable)((Object)"Sent"));
    private final TimeSeries filtered = new TimeSeries((Comparable)((Object)"Filtered"));
    private final TimeSeries queued = new TimeSeries((Comparable)((Object)"Queued"));
    private final TimeSeries error = new TimeSeries((Comparable)((Object)"Error"));
    private final XYLineAndShapeRenderer lineRenderer;

    public LineTrendsChart() {
        this.dataset.addSeries(this.received);
        this.dataset.addSeries(this.sent);
        this.dataset.addSeries(this.filtered);
        this.dataset.addSeries(this.queued);
        this.dataset.addSeries(this.error);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)"Message Volume", (String)"Time", (String)"Count", (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        this.lineRenderer = new XYLineAndShapeRenderer(true, true);
        this.lineRenderer.setAutoPopulateSeriesPaint(false);
        this.lineRenderer.setDefaultShapesVisible(true);
        this.lineRenderer.setDefaultShapesFilled(true);
        this.lineRenderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1} \u2192 {2})", (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"), NumberFormat.getIntegerInstance()));
        xYPlot.setRenderer((XYItemRenderer)this.lineRenderer);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        this.initCommon(jFreeChart, xYPlot, chartPanel, (XYItemRenderer)this.lineRenderer);
    }

    @Override
    protected void clearDataset() {
        this.received.clear();
        this.sent.clear();
        this.filtered.clear();
        this.queued.clear();
        this.error.clear();
    }

    @Override
    protected void addPoint(RegularTimePeriod regularTimePeriod, MessageStatisticsTimeseries messageStatisticsTimeseries) {
        this.received.addOrUpdate(regularTimePeriod, (Number)messageStatisticsTimeseries.getReceived());
        this.sent.addOrUpdate(regularTimePeriod, (Number)messageStatisticsTimeseries.getSent());
        this.filtered.addOrUpdate(regularTimePeriod, (Number)messageStatisticsTimeseries.getFiltered());
        this.queued.addOrUpdate(regularTimePeriod, (Number)messageStatisticsTimeseries.getQueued());
        this.error.addOrUpdate(regularTimePeriod, (Number)messageStatisticsTimeseries.getError());
    }
}

