/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.control;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.plugins.messagetrends.client.panel.MessageTrendsDashboardPanel;
import com.mirth.connect.plugins.messagetrends.shared.model.TimeRangePresets;
import com.mirth.connect.plugins.messagetrends.shared.util.Intervals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class TrendsControlsBar
extends JPanel {
    private static final Color LIVE_FG = new Color(1793568);
    private static final Color LIVE_BG = new Color(15267305);
    private static final Color PAUSED_FG = new Color(0x424242);
    private static final Color PAUSED_BG = new Color(0xFFCCCC);
    private static final int MAX_POINTS = 90;
    private static final int MIN_POINTS = 7;
    private final Map<String, List<String>> allowedByPreset = new LinkedHashMap<String, List<String>>();
    private List<String> visiblePresets = Collections.emptyList();
    private final JComboBox<String> timeRangeCombo;
    private final JComboBox<String> intervalCombo;
    private final JButton prevButton;
    private final JButton jumpButton;
    private final JButton nextButton;
    private final JComboBox<MessageTrendsDashboardPanel.View> viewCombo;
    private final JComboBox<String> chartCombo;
    private final JButton refreshButton;
    private final JLabel liveStatusLabel;

    public TrendsControlsBar() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 8));
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new FlowLayout(0, 8, 0));
        jPanel.setOpaque(false);
        this.timeRangeCombo = new JComboBox();
        this.timeRangeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                String string = (String)object;
                String string2 = TimeRangePresets.PRESET_TO_LABEL.getOrDefault(string, string);
                return super.getListCellRendererComponent(jList, string2, n, bl, bl2);
            }
        });
        this.timeRangeCombo.setSelectedItem("last_1h");
        jPanel.add(this.labelled(this.timeRangeCombo, "Time Range: "));
        this.intervalCombo = new JComboBox<String>(Intervals.canonicalCodes().toArray(new String[0]));
        this.intervalCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                String string = String.valueOf(object);
                String string2 = TrendsControlsBar.humanLabelForInterval(string);
                return super.getListCellRendererComponent(jList, string2, n, bl, bl2);
            }
        });
        if (this.intervalCombo.getItemCount() > 0) {
            this.intervalCombo.setSelectedIndex(0);
        }
        jPanel.add(this.labelled(this.intervalCombo, "Interval: "));
        this.prevButton = new JButton("");
        this.prevButton.setIcon(new ImageIcon(Frame.class.getResource("images/book_previous.png")));
        this.prevButton.setToolTipText("Previous (shift left)");
        jPanel.add(this.prevButton);
        this.jumpButton = new JButton("");
        this.jumpButton.setIcon(new ImageIcon(Frame.class.getResource("images/calendar_view_month.png")));
        this.jumpButton.setToolTipText("Jump to specific time");
        jPanel.add(this.jumpButton);
        this.nextButton = new JButton("");
        this.nextButton.setIcon(new ImageIcon(Frame.class.getResource("images/book_next.png")));
        this.nextButton.setToolTipText("Next (shift right)");
        jPanel.add(this.nextButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 8, 0));
        jPanel2.setOpaque(false);
        this.viewCombo = new JComboBox<MessageTrendsDashboardPanel.View>(MessageTrendsDashboardPanel.View.values());
        jPanel2.add(this.labelled(this.viewCombo, "View: "));
        this.chartCombo = new JComboBox<String>(new String[]{"Line", "Stacked"});
        jPanel2.add(this.labelled(this.chartCombo, "Chart: "));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setToolTipText("Refresh current window");
        jPanel2.add(this.refreshButton);
        this.liveStatusLabel = new JLabel("Live");
        this.liveStatusLabel.setOpaque(true);
        this.liveStatusLabel.setForeground(LIVE_FG);
        this.liveStatusLabel.setBackground(LIVE_BG);
        this.liveStatusLabel.setBorder(new CompoundBorder(new LineBorder(LIVE_FG, 1, true), new EmptyBorder(2, 8, 2, 8)));
        this.liveStatusLabel.setFont(this.liveStatusLabel.getFont().deriveFont(1));
        jPanel2.add(this.liveStatusLabel);
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "East");
        this.rebuildIntervalCache();
        this.timeRangeCombo.setModel(new DefaultComboBoxModel<String>(this.visiblePresets.toArray(new String[0])));
        this.updateIntervalsForSelectedRange();
        this.timeRangeCombo.addActionListener(actionEvent -> this.updateIntervalsForSelectedRange());
    }

    private JPanel labelled(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 4, 0));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(jComponent);
        jPanel.add(jLabel);
        jPanel.add(jComponent);
        return jPanel;
    }

    public void setNextEnabled(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    public void setControlsEnabled(boolean bl) {
        this.timeRangeCombo.setEnabled(bl);
        this.intervalCombo.setEnabled(bl);
        this.prevButton.setEnabled(bl);
        this.jumpButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        this.viewCombo.setEnabled(bl);
        this.chartCombo.setEnabled(bl);
        this.refreshButton.setEnabled(bl);
    }

    public JComboBox<String> getTimeRangeCombo() {
        return this.timeRangeCombo;
    }

    public JComboBox<String> getIntervalCombo() {
        return this.intervalCombo;
    }

    public JButton getPrevButton() {
        return this.prevButton;
    }

    public JButton getJumpButton() {
        return this.jumpButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JComboBox<MessageTrendsDashboardPanel.View> getViewCombo() {
        return this.viewCombo;
    }

    public JComboBox<String> getChartCombo() {
        return this.chartCombo;
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public JLabel getLiveStatusLabel() {
        return this.liveStatusLabel;
    }

    public void setLive(boolean bl) {
        this.liveStatusLabel.setText(bl ? "Live" : "Paused");
        this.liveStatusLabel.setOpaque(true);
        this.liveStatusLabel.setForeground(bl ? LIVE_FG : PAUSED_FG);
        this.liveStatusLabel.setBackground(bl ? LIVE_BG : PAUSED_BG);
        this.liveStatusLabel.setBorder(new CompoundBorder(new LineBorder(bl ? LIVE_FG : PAUSED_FG, 1, true), new EmptyBorder(2, 8, 2, 8)));
        this.liveStatusLabel.setFont(this.liveStatusLabel.getFont().deriveFont(bl ? 1 : 0));
        this.liveStatusLabel.setToolTipText(bl ? "Following real-time data" : "Paused view; use Next or Refresh to catch up");
    }

    private void updateIntervalsForSelectedRange() {
        int n;
        int n2;
        String string = (String)this.timeRangeCombo.getSelectedItem();
        if (string == null) {
            this.intervalCombo.setModel(new DefaultComboBoxModel());
            return;
        }
        List<String> list = this.allowedByPreset.getOrDefault(string, Collections.emptyList());
        if (list.isEmpty()) {
            this.intervalCombo.setModel(new DefaultComboBoxModel());
            return;
        }
        String string2 = (String)this.intervalCombo.getSelectedItem();
        this.intervalCombo.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
        if (string2 != null && list.contains(string2) && (n2 = TrendsControlsBar.pointsForRange(n = TrendsControlsBar.presetToMinutes(string), Intervals.minutesOf((String)string2))) <= 90 && n2 >= 7) {
            this.intervalCombo.setSelectedItem(string2);
            return;
        }
        this.intervalCombo.setSelectedIndex(0);
    }

    private void rebuildIntervalCache() {
        this.allowedByPreset.clear();
        List list = TimeRangePresets.PRESETS;
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            List<String> list2 = this.computeAllowedIntervalsForPreset(string);
            if (list2.isEmpty()) continue;
            this.allowedByPreset.put(string, list2);
            arrayList.add(string);
        }
        this.visiblePresets = Collections.unmodifiableList(arrayList);
    }

    private List<String> computeAllowedIntervalsForPreset(String string) {
        int n = TrendsControlsBar.presetToMinutes(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : Intervals.canonicalCodes()) {
            int n2 = Intervals.minutesOf((String)string2);
            int n3 = TrendsControlsBar.pointsForRange(n, n2);
            if (n3 > 90 || n3 < 7) continue;
            arrayList.add(string2);
        }
        arrayList.sort(Comparator.comparingInt(Intervals::minutesOf));
        return arrayList;
    }

    private static int presetToMinutes(String string) {
        Duration duration = TimeRangePresets.toDuration((String)string);
        return duration == null ? 60 : (int)duration.toMinutes();
    }

    private static String humanLabelForInterval(String string) {
        switch (string) {
            case "1minute": {
                return "1 Minute";
            }
            case "5minute": {
                return "5 Minutes";
            }
            case "15minute": {
                return "15 Minutes";
            }
            case "60minute": {
                return "1 Hour";
            }
            case "daily": {
                return "1 Day";
            }
        }
        return string;
    }

    private static int pointsForRange(int n, int n2) {
        return (int)Math.ceil((double)n / (double)n2);
    }
}

