/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.client.plugin;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.messagetrends.client.panel.MessageTrendsDashboardPanel;
import java.util.List;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageTrendsDashboardTabPlugin
extends DashboardTabPlugin {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private MessageTrendsDashboardPanel panel = new MessageTrendsDashboardPanel(this);

    public MessageTrendsDashboardTabPlugin(String string) {
        super(string);
    }

    public void update() {
        this.update(null);
    }

    public void update(List<DashboardStatus> list) {
        if (list == null || list.isEmpty()) {
            this.panel.blockSelection(MessageTrendsDashboardPanel.SelectionBlockReason.NO_SELECTION);
            return;
        }
        if (list.size() != 1) {
            this.panel.blockSelection(MessageTrendsDashboardPanel.SelectionBlockReason.MULTI_SELECTED);
            return;
        }
        DashboardStatus dashboardStatus = list.get(0);
        String string = dashboardStatus.getChannelId();
        switch (dashboardStatus.getStatusType()) {
            case CHANNEL: {
                this.panel.unblockSelection();
                this.panel.setSelection(string, dashboardStatus.getName(), null, null);
                break;
            }
            case SOURCE_CONNECTOR: 
            case DESTINATION_CONNECTOR: {
                String string2 = (String)PlatformUI.MIRTH_FRAME.channelPanel.getCachedChannelIdsAndNames().get(string);
                this.panel.unblockSelection();
                this.panel.setSelection(string, string2, dashboardStatus.getMetaDataId(), dashboardStatus.getName());
                break;
            }
            default: {
                this.panel.blockSelection(MessageTrendsDashboardPanel.SelectionBlockReason.NO_SELECTION);
            }
        }
    }

    public JComponent getTabComponent() {
        return this.panel;
    }

    public String getPluginPointName() {
        return "Message Trends";
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }
}

