/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.net.URL;

public class AboutBox
implements PlugIn {
    static final int SMALL_FONT = 14;
    static final int LARGE_FONT = 30;

    public void run(String arg) {
        System.gc();
        int lines = 7;
        String[] text = new String[lines];
        text[0] = "ImageJ 1.42q";
        text[1] = "Wayne Rasband";
        text[2] = "National Institutes of Health, USA";
        text[3] = "http://rsb.info.nih.gov/ij";
        text[4] = "Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " (64-bit)" : " (32-bit)");
        text[5] = IJ.freeMemory();
        text[6] = "ImageJ is in the public domain";
        ImageProcessor ip = null;
        ImageJ ij = IJ.getInstance();
        URL url = ij.getClass().getResource("/about.jpg");
        if (url != null) {
            Image img = null;
            try {
                img = ij.createImage((ImageProducer)url.getContent());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (img != null) {
                ImagePlus imp = new ImagePlus("", img);
                ip = imp.getProcessor();
            }
        }
        if (ip == null) {
            ip = new ColorProcessor(55, 45);
        }
        ip = ip.resize(ip.getWidth() * 4, ip.getHeight() * 4);
        ip.setFont(new Font("SansSerif", 0, 30));
        ip.setAntialiasedText(true);
        int[] widths = new int[lines];
        widths[0] = ip.getStringWidth(text[0]);
        ip.setFont(new Font("SansSerif", 0, 14));
        for (int i = 1; i < lines - 1; ++i) {
            widths[i] = ip.getStringWidth(text[i]);
        }
        int max = 0;
        for (int i = 0; i < lines - 1; ++i) {
            if (widths[i] <= max) continue;
            max = widths[i];
        }
        ip.setColor(new Color(255, 255, 140));
        ip.setFont(new Font("SansSerif", 0, 30));
        int y = 45;
        ip.drawString(text[0], this.x(text[0], ip, max), y);
        ip.setFont(new Font("SansSerif", 0, 14));
        ip.drawString(text[1], this.x(text[1], ip, max), y += 30);
        ip.drawString(text[2], this.x(text[2], ip, max), y += 18);
        ip.drawString(text[3], this.x(text[3], ip, max), y += 18);
        ip.drawString(text[4], this.x(text[4], ip, max), y += 18);
        if (IJ.maxMemory() > 0L) {
            ip.drawString(text[5], this.x(text[5], ip, max), y += 18);
        }
        ip.drawString(text[6], ip.getWidth() - ip.getStringWidth(text[6]) - 10, ip.getHeight() - 3);
        ImageWindow.centerNextImage();
        new ImagePlus("About ImageJ", ip).show();
    }

    int x(String text, ImageProcessor ip, int max) {
        return ip.getWidth() - max + (max - ip.getStringWidth(text)) / 2 - 10;
    }
}

