/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;

public class MaximumFinder
implements ExtendedPlugInFilter,
DialogListener {
    private static double tolerance = 10.0;
    private static int outputType;
    private static int dialogOutputType;
    public static final int SINGLE_POINTS = 0;
    public static final int IN_TOLERANCE = 1;
    public static final int SEGMENTED = 2;
    public static final int POINT_SELECTION = 3;
    public static final int COUNT = 4;
    static final String[] outputTypeNames;
    private static boolean excludeOnEdges;
    private static boolean useMinThreshold;
    private static boolean lightBackground;
    private ImagePlus imp;
    private int flags = 415;
    private boolean thresholded;
    private boolean roiSaved;
    private boolean previewing;
    private Vector checkboxes;
    private boolean thresholdWarningShown = false;
    private Label messageArea;
    private boolean noPointLabels;
    private double progressDone;
    private int nPasses = 0;
    private int width;
    private int height;
    private int[] dirOffset;
    private int[] dirXoffset;
    private int[] dirYoffset;
    private int intEncodeXMask;
    private int intEncodeYMask;
    private int intEncodeShift;
    static final int IS_LINE = 1;
    static final int IS_DOT = 2;
    static final byte MAXIMUM = 1;
    static final byte LISTED = 2;
    static final byte PROCESSED = 4;
    static final byte MAX_AREA = 8;
    static final byte EQUAL = 16;
    static final byte MAX_POINT = 32;
    static final byte ELIMINATED = 64;
    static final byte[] outputTypeMasks;
    static final float SQRT2 = 1.4142135f;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.noPointLabels = Prefs.noPointLabels;
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        ip.resetBinaryThreshold();
        this.thresholded = ip.getMinThreshold() != -808080.0;
        GenericDialog gd = new GenericDialog(command);
        int digits = ip instanceof FloatProcessor ? 2 : 0;
        String unit = imp.getCalibration() != null ? imp.getCalibration().getValueUnit() : null;
        unit = unit == null || unit.equals("Gray Value") ? ":" : " (" + unit + "):";
        gd.addNumericField("Noise Tolerance" + unit, tolerance, digits);
        gd.addChoice("Output type:", outputTypeNames, outputTypeNames[dialogOutputType]);
        gd.addCheckbox("Exclude Edge Maxima", excludeOnEdges);
        if (this.thresholded) {
            gd.addCheckbox("Above Lower Threshold", useMinThreshold);
        }
        gd.addCheckbox("Light Background", lightBackground);
        gd.addPreviewCheckbox(pfr, "Preview Point Selection");
        gd.addMessage("                        ");
        this.messageArea = (Label)gd.getMessage();
        gd.addDialogListener(this);
        this.checkboxes = gd.getCheckboxes();
        this.previewing = true;
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.previewing = false;
        if (!this.dialogItemChanged(gd, null)) {
            return 4096;
        }
        IJ.register(this.getClass());
        return this.flags;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        tolerance = gd.getNextNumber();
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        dialogOutputType = gd.getNextChoiceIndex();
        outputType = this.previewing ? 3 : dialogOutputType;
        excludeOnEdges = gd.getNextBoolean();
        useMinThreshold = this.thresholded ? gd.getNextBoolean() : false;
        lightBackground = gd.getNextBoolean();
        boolean invertedLut = this.imp.isInvertedLut();
        if (useMinThreshold && (invertedLut && !lightBackground || !invertedLut && lightBackground)) {
            if (!(this.thresholdWarningShown || IJ.showMessageWithCancel("Find Maxima", "\"Above Lower Threshold\" option cannot be used\nwhen finding minima (image with light background\nor image with dark background and inverting LUT).") || this.previewing)) {
                return false;
            }
            this.thresholdWarningShown = true;
            useMinThreshold = false;
            ((Checkbox)this.checkboxes.elementAt(1)).setState(false);
        }
        if (!gd.getPreviewCheckbox().getState()) {
            this.messageArea.setText("");
        }
        return !gd.invalidNumber();
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
    }

    public void run(ImageProcessor ip) {
        double threshold;
        Prefs.noPointLabels = true;
        Roi roi = this.imp.getRoi();
        if (outputType == 3 && !this.roiSaved) {
            this.imp.saveRoi();
            this.roiSaved = true;
        }
        if (!(roi == null || roi.isArea() && outputType != 2)) {
            this.imp.killRoi();
            roi = null;
        }
        boolean invertedLut = this.imp.isInvertedLut();
        double d = threshold = useMinThreshold ? ip.getMinThreshold() : -808080.0;
        if (invertedLut && !lightBackground || !invertedLut && lightBackground) {
            threshold = -808080.0;
            float[] cTable = ip.getCalibrationTable();
            ip = ip.duplicate();
            if (cTable == null) {
                ip.invert();
            } else {
                float[] invertedCTable = new float[cTable.length];
                for (int i = cTable.length - 1; i >= 0; --i) {
                    invertedCTable[i] = -cTable[i];
                }
                ip.setCalibrationTable(invertedCTable);
            }
            ip.setRoi(roi);
        }
        ByteProcessor outIp = null;
        outIp = this.findMaxima(ip, tolerance, threshold, outputType, excludeOnEdges, false);
        if (!this.previewing) {
            Prefs.noPointLabels = this.noPointLabels;
        }
        if (outIp == null) {
            return;
        }
        if (!Prefs.blackBackground) {
            outIp.invertLut();
        }
        String resultName = outputType == 2 ? " Segmented" : " Maxima";
        String outname = this.imp.getTitle();
        if (this.imp.getNSlices() > 1) {
            outname = outname + "(" + this.imp.getCurrentSlice() + ")";
        }
        if (WindowManager.getImage(outname = outname + resultName) != null) {
            outname = WindowManager.getUniqueName(outname);
        }
        ImagePlus maxImp = new ImagePlus(outname, outIp);
        Calibration cal = this.imp.getCalibration().copy();
        cal.disableDensityCalibration();
        maxImp.setCalibration(cal);
        maxImp.show();
    }

    public ByteProcessor findMaxima(ImageProcessor ip, double tolerance, double threshold, int outputType, boolean excludeOnEdges, boolean isEDM) {
        ByteProcessor outIp;
        boolean excludeEdgesNow;
        if (this.dirOffset == null) {
            this.makeDirectionOffsets(ip);
        }
        Rectangle roi = ip.getRoi();
        byte[] mask = ip.getMaskArray();
        if (threshold != -808080.0 && ip.getCalibrationTable() != null && threshold > 0.0 && threshold < (double)ip.getCalibrationTable().length) {
            threshold = ip.getCalibrationTable()[(int)threshold];
        }
        ByteProcessor typeP = new ByteProcessor(this.width, this.height);
        byte[] types = (byte[])typeP.getPixels();
        float globalMin = Float.MAX_VALUE;
        float globalMax = -3.4028235E38f;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            for (int x = roi.x; x < roi.x + roi.width; ++x) {
                float v = ip.getPixelValue(x, y);
                if (globalMin > v) {
                    globalMin = v;
                }
                if (!(globalMax < v)) continue;
                globalMax = v;
            }
        }
        if (threshold != -808080.0) {
            threshold -= (double)(globalMax - globalMin) * 1.0E-6;
        }
        boolean bl = excludeEdgesNow = excludeOnEdges && outputType != 2;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Getting sorted maxima...");
        MaxPoint[] maxPoints = this.getSortedMaxPoints(ip, typeP, excludeEdgesNow, isEDM, globalMin, threshold);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Analyzing  maxima...");
        this.analyzeAndMarkMaxima(ip, typeP, maxPoints, excludeEdgesNow, isEDM, globalMin, tolerance);
        if (outputType == 4 || outputType == 3) {
            return null;
        }
        if (outputType == 2) {
            outIp = this.make8bit(ip, typeP, isEDM, globalMin, globalMax, threshold);
            this.cleanupMaxima(outIp, typeP, maxPoints);
            if (!this.watershedSegment(outIp)) {
                return null;
            }
            if (!isEDM) {
                this.cleanupExtraLines(outIp);
            }
            this.watershedPostProcess(outIp);
            if (excludeOnEdges) {
                this.deleteEdgeParticles(outIp, typeP);
            }
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                types[i] = (byte)((types[i] & outputTypeMasks[outputType]) != 0 ? 255 : 0);
            }
            outIp = typeP;
        }
        byte[] outPixels = (byte[])outIp.getPixels();
        if (roi != null) {
            int i = 0;
            for (int y = 0; y < outIp.getHeight(); ++y) {
                int x = 0;
                while (x < outIp.getWidth()) {
                    if (x < roi.x || x >= roi.x + roi.width || y < roi.y || y >= roi.y + roi.height) {
                        outPixels[i] = 0;
                    } else if (mask != null && mask[x - roi.x + roi.width * (y - roi.y)] == 0) {
                        outPixels[i] = 0;
                    }
                    ++x;
                    ++i;
                }
            }
        }
        return outIp;
    }

    MaxPoint[] getSortedMaxPoints(ImageProcessor ip, ByteProcessor typeP, boolean excludeEdgesNow, boolean isEDM, float globalMin, double threshold) {
        Rectangle roi = ip.getRoi();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = 0;
        boolean checkThreshold = threshold != -808080.0;
        Thread thread = Thread.currentThread();
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            if (y % 50 == 0 && thread.isInterrupted()) {
                return null;
            }
            int x = roi.x;
            int i = x + y * this.width;
            while (x < roi.x + roi.width) {
                float vTrue;
                float v = ip.getPixelValue(x, y);
                float f = vTrue = isEDM ? this.trueEdmHeight(x, y, ip) : v;
                if (!(v == globalMin || excludeEdgesNow && (x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1) || checkThreshold && (double)v < threshold)) {
                    boolean isMax = true;
                    for (int d = 0; d < 8; ++d) {
                        float vNeighborTrue;
                        if (!this.isWithin(x, y, d)) continue;
                        float vNeighbor = ip.getPixelValue(x + this.dirXoffset[d], y + this.dirYoffset[d]);
                        float f2 = vNeighborTrue = isEDM ? this.trueEdmHeight(x + this.dirXoffset[d], y + this.dirYoffset[d], ip) : vNeighbor;
                        if (!(vNeighbor > v) || !(vNeighborTrue > vTrue)) continue;
                        isMax = false;
                        break;
                    }
                    if (isMax) {
                        types[i] = 1;
                        ++nMax;
                    }
                }
                ++x;
                ++i;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Object[] maxPoints = new MaxPoint[nMax];
        int iMax = 0;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            int x = roi.x;
            int i = x + y * this.width;
            while (x < roi.x + roi.width) {
                if (types[i] == 1) {
                    maxPoints[iMax] = new MaxPoint(i, isEDM ? this.trueEdmHeight(x, y, ip) : ip.getPixelValue(x, y));
                    ++iMax;
                }
                ++x;
                ++i;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    void analyzeAndMarkMaxima(ImageProcessor ip, ByteProcessor typeP, MaxPoint[] maxPoints, boolean excludeEdgesNow, boolean isEDM, float globalMin, double tolerance) {
        byte[] types = (byte[])typeP.getPixels();
        int nMax = maxPoints.length;
        int[] pList = new int[this.width * this.height];
        Vector<int[]> xyVector = null;
        Roi roi = null;
        boolean displayOrCount = this.imp != null && (outputType == 3 || outputType == 4);
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            int y;
            int x;
            int offset;
            if (iMax % 100 == 0 && Thread.currentThread().isInterrupted()) {
                return;
            }
            float v = maxPoints[iMax].value;
            if (v == globalMin) break;
            int offset0 = maxPoints[iMax].offset;
            if ((types[offset0] & 4) != 0) continue;
            pList[0] = offset0;
            int n = offset0;
            types[n] = (byte)(types[n] | 0x12);
            int listLen = 1;
            int listI = 0;
            int x0 = offset0 % this.width;
            int y0 = offset0 / this.width;
            boolean isEdgeMaximum = x0 == 0 || x0 == this.width - 1 || y0 == 0 || y0 == this.height - 1;
            boolean maxPossible = true;
            double xEqual = x0;
            double yEqual = y0;
            int nEqual = 1;
            block1: do {
                int offset2 = pList[listI];
                int x2 = offset2 % this.width;
                int y2 = offset2 / this.width;
                for (int d = 0; d < 8; ++d) {
                    int offset22 = offset2 + this.dirOffset[d];
                    if (!this.isWithin(x2, y2, d) || (types[offset22] & 2) != 0) continue;
                    if ((types[offset22] & 4) != 0) {
                        maxPossible = false;
                        continue block1;
                    }
                    int x22 = x2 + this.dirXoffset[d];
                    int y22 = y2 + this.dirYoffset[d];
                    float v2 = ip.getPixelValue(x22, y22);
                    if (isEDM && v2 <= v - (float)tolerance) {
                        v2 = this.trueEdmHeight(x22, y22, ip);
                    }
                    if (v2 > v) {
                        maxPossible = false;
                        continue block1;
                    }
                    if (!(v2 >= v - (float)tolerance)) continue;
                    pList[listLen] = offset22;
                    ++listLen;
                    int n2 = offset22;
                    types[n2] = (byte)(types[n2] | 2);
                    if (x22 == 0 || x22 == this.width - 1 || y22 == 0 || y22 == this.height - 1) {
                        isEdgeMaximum = true;
                        if (excludeEdgesNow) {
                            maxPossible = false;
                            continue block1;
                        }
                    }
                    if (v2 != v) continue;
                    int n3 = offset22;
                    types[n3] = (byte)(types[n3] | 0x10);
                    xEqual += (double)x22;
                    yEqual += (double)y22;
                    ++nEqual;
                }
            } while (++listI < listLen);
            byte resetMask = (byte)(~(maxPossible ? 2 : 18));
            xEqual /= (double)nEqual;
            yEqual /= (double)nEqual;
            double minDist2 = 1.0E20;
            int nearestI = 0;
            for (listI = 0; listI < listLen; ++listI) {
                double dist2;
                offset = pList[listI];
                x = offset % this.width;
                y = offset / this.width;
                int n4 = offset;
                types[n4] = (byte)(types[n4] & resetMask);
                int n5 = offset;
                types[n5] = (byte)(types[n5] | 4);
                if (!maxPossible) continue;
                int n6 = offset;
                types[n6] = (byte)(types[n6] | 8);
                if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)x) * (xEqual - (double)x) + (yEqual - (double)y) * (yEqual - (double)y)) < minDist2)) continue;
                minDist2 = dist2;
                nearestI = listI;
            }
            if (!maxPossible) continue;
            int n7 = offset = pList[nearestI];
            types[n7] = (byte)(types[n7] | 0x20);
            if (!displayOrCount) continue;
            if (excludeOnEdges && isEdgeMaximum) continue;
            if (xyVector == null) {
                xyVector = new Vector<int[]>();
                roi = this.imp.getRoi();
            }
            x = offset % this.width;
            y = offset / this.width;
            if (roi != null && !roi.contains(x, y)) continue;
            xyVector.addElement(new int[]{x, y});
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (displayOrCount && xyVector != null) {
            int npoints = xyVector.size();
            if (outputType == 3) {
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                for (int i = 0; i < npoints; ++i) {
                    int[] xy = (int[])xyVector.elementAt(i);
                    xpoints[i] = xy[0];
                    ypoints[i] = xy[1];
                }
                this.imp.setRoi(new PointRoi(xpoints, ypoints, npoints));
            }
            if (outputType == 4) {
                ResultsTable rt = ResultsTable.getResultsTable();
                rt.incrementCounter();
                rt.setValue("Count", rt.getCounter() - 1, (double)npoints);
                rt.show("Results");
            }
        }
        if (this.previewing) {
            this.messageArea.setText((xyVector == null ? 0 : xyVector.size()) + " Maxima");
        }
    }

    ByteProcessor make8bit(ImageProcessor ip, ByteProcessor typeP, boolean isEDM, float globalMin, float globalMax, double threshold) {
        int y;
        byte[] types = (byte[])typeP.getPixels();
        double minValue = threshold == -808080.0 ? (double)globalMin : threshold;
        double offset = minValue - ((double)globalMax - minValue) * 0.001975284584980237;
        double factor = 253.0 / ((double)globalMax - minValue);
        if (isEDM && factor > 1.0) {
            factor = 1.0;
        }
        ByteProcessor outIp = new ByteProcessor(this.width, this.height);
        byte[] pixels = (byte[])outIp.getPixels();
        int i = 0;
        for (y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                long v = Math.round(((double)ip.getPixelValue(x, y) - offset) * factor);
                pixels[i] = v < 0L ? 0 : (v <= 255L ? (int)((int)(v & 0xFFL)) : -1);
                ++x;
                ++i;
            }
        }
        pixels = (byte[])outIp.getPixels();
        if (threshold != -808080.0) {
            for (y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (!((double)ip.getPixelValue(x, y) < threshold)) continue;
                    pixels[x + y * this.width] = 0;
                }
            }
        }
        for (int i2 = 0; i2 < this.width * this.height; ++i2) {
            if ((pixels[i2] & 0xFF) == 255) {
                int n = i2;
                pixels[n] = (byte)(pixels[n] - 1);
            }
            if ((types[i2] & 8) == 0) continue;
            pixels[i2] = -1;
        }
        return outIp;
    }

    float trueEdmHeight(int x, int y, ImageProcessor ip) {
        int xmax = this.width - 1;
        int ymax = ip.getHeight() - 1;
        float[] pixels = (float[])ip.getPixels();
        int offset = x + y * this.width;
        float v = pixels[offset];
        if (x == 0 || y == 0 || x == xmax || y == ymax || v == 0.0f) {
            return v;
        }
        float trueH = v + 0.70710677f;
        boolean ridgeOrMax = false;
        for (int d = 0; d < 4; ++d) {
            float h;
            int d2 = (d + 4) % 8;
            float v1 = pixels[offset + this.dirOffset[d]];
            float v2 = pixels[offset + this.dirOffset[d2]];
            if (v >= v1 && v >= v2) {
                ridgeOrMax = true;
                h = (v1 + v2) / 2.0f;
            } else {
                h = Math.min(v1, v2);
            }
            h += d % 2 == 0 ? 1.0f : 1.4142135f;
            if (!(trueH > h)) continue;
            trueH = h;
        }
        if (!ridgeOrMax) {
            trueH = v;
        }
        return trueH;
    }

    void cleanupMaxima(ByteProcessor outIp, ByteProcessor typeP, MaxPoint[] maxPoints) {
        byte[] pixels = (byte[])outIp.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = maxPoints.length;
        int[] pList = new int[this.width * this.height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            int offset;
            int offset0 = maxPoints[iMax].offset;
            if ((types[offset0] & 0x48) != 0) continue;
            int level = pixels[offset0] & 0xFF;
            int loLevel = level + 1;
            pList[0] = offset0;
            int n = offset0;
            types[n] = (byte)(types[n] | 2);
            int listLen = 1;
            int lastLen = 1;
            int listI = 0;
            boolean saddleFound = false;
            while (!saddleFound && loLevel > 0) {
                --loLevel;
                lastLen = listLen;
                listI = 0;
                block2: do {
                    offset = pList[listI];
                    int x = offset % this.width;
                    int y = offset / this.width;
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!this.isWithin(x, y, d) || (types[offset2] & 2) != 0) continue;
                        if ((types[offset2] & 8) != 0 || (types[offset2] & 0x40) != 0 && (pixels[offset2] & 0xFF) >= loLevel) {
                            saddleFound = true;
                            continue block2;
                        }
                        if ((pixels[offset2] & 0xFF) < loLevel || (types[offset2] & 0x40) != 0) continue;
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                    }
                } while (!saddleFound && ++listI < listLen);
            }
            for (listI = 0; listI < listLen; ++listI) {
                int n3 = pList[listI];
                types[n3] = (byte)(types[n3] & 0xFFFFFFFD);
            }
            for (listI = 0; listI < lastLen; ++listI) {
                offset = pList[listI];
                pixels[offset] = (byte)loLevel;
                int n4 = offset;
                types[n4] = (byte)(types[n4] | 0x40);
            }
        }
    }

    void cleanupExtraLines(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int v = pixels[i] & 0xFF;
                if (v < 255 && v > 0) {
                    int type = this.isLineOrDot(ip, x, y);
                    if (type == 2) {
                        pixels[i] = -1;
                    } else if (type == 1) {
                        int xEnd = x;
                        int yEnd = y;
                        boolean endFound = true;
                        block2: while (endFound) {
                            pixels[xEnd + this.width * yEnd] = -1;
                            endFound = false;
                            for (int d = 0; d < 8; ++d) {
                                if (!this.isWithin(xEnd, yEnd, d) || (v = pixels[xEnd + this.width * yEnd + this.dirOffset[d]] & 0xFF) >= 255 || v <= 0 || this.isLineOrDot(ip, xEnd + this.dirXoffset[d], yEnd + this.dirYoffset[d]) != 1) continue;
                                xEnd += this.dirXoffset[d];
                                yEnd += this.dirYoffset[d];
                                endFound = true;
                                continue block2;
                            }
                        }
                    }
                }
                ++x;
                ++i;
            }
        }
    }

    int isLineOrDot(ImageProcessor ip, int x, int y) {
        int result = 0;
        byte[] pixels = (byte[])ip.getPixels();
        int offset = x + y * this.width;
        int whiteNeighbors = 0;
        int countTransitions = 0;
        boolean prevPixelSet = true;
        boolean firstPixelSet = true;
        for (int d = 0; d < 8; ++d) {
            boolean pixelSet;
            if (this.isWithin(x, y, d)) {
                boolean bl = pixelSet = pixels[offset + this.dirOffset[d]] != -1;
                if (!pixelSet) {
                    ++whiteNeighbors;
                }
            } else {
                pixelSet = true;
            }
            if (pixelSet && !prevPixelSet) {
                ++countTransitions;
            }
            prevPixelSet = pixelSet;
            if (d != 0) continue;
            firstPixelSet = pixelSet;
        }
        if (firstPixelSet && !prevPixelSet) {
            ++countTransitions;
        }
        if (countTransitions == 1 && whiteNeighbors >= 5) {
            result = 1;
        } else if (whiteNeighbors == 8) {
            result = 2;
        }
        return result;
    }

    private void watershedPostProcess(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int size = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < size; ++i) {
            if ((pixels[i] & 0xFF) >= 255) continue;
            pixels[i] = 0;
        }
    }

    void deleteEdgeParticles(ByteProcessor ip, ByteProcessor typeP) {
        byte[] pixels = (byte[])ip.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        ip.setValue(0.0);
        Wand wand = new Wand(ip);
        for (int x = 0; x < this.width; ++x) {
            int y = 0;
            if ((types[x + y * this.width] & 8) != 0 && pixels[x + y * this.width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[x + (y = this.height - 1) * this.width] & 8) == 0 || pixels[x + y * this.width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
        for (int y = 1; y < this.height - 1; ++y) {
            int x = 0;
            if ((types[x + y * this.width] & 8) != 0 && pixels[x + y * this.width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[(x = this.width - 1) + y * this.width] & 8) == 0 || pixels[x + y * this.width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
    }

    void deleteParticle(int x, int y, ByteProcessor ip, Wand wand) {
        wand.autoOutline(x, y, 255, 255);
        if (wand.npoints == 0) {
            IJ.log("wand error selecting edge particle at x, y = " + x + ", " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 4);
        ip.snapshot();
        ip.setRoi(roi);
        ip.fill();
        ip.reset(ip.getMask());
    }

    private boolean watershedSegment(ByteProcessor ip) {
        boolean debug = IJ.debugMode;
        ImageStack movie = null;
        if (debug) {
            movie = new ImageStack(ip.getWidth(), ip.getHeight());
            movie.addSlice("pre-watershed EDM", ip.duplicate());
        }
        byte[] pixels = (byte[])ip.getPixels();
        int[] histogram = ip.getHistogram();
        int arraySize = this.width * this.height - histogram[0] - histogram[255];
        int[] coordinates = new int[arraySize];
        int highestValue = 0;
        int offset = 0;
        int[] levelStart = new int[256];
        for (int v = 1; v < 255; ++v) {
            levelStart[v] = offset;
            offset += histogram[v];
            if (histogram[v] <= 0) continue;
            highestValue = v;
        }
        int[] levelOffset = new int[highestValue + 1];
        int i = 0;
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                int v = pixels[i] & 0xFF;
                if (v > 0 && v < 255) {
                    offset = levelStart[v] + levelOffset[v];
                    coordinates[offset] = x | y << this.intEncodeShift;
                    int n = v;
                    levelOffset[n] = levelOffset[n] + 1;
                }
                ++x;
                ++i;
            }
        }
        int[] table = this.makeFateTable();
        IJ.showStatus("Segmenting (Esc to cancel)");
        ImageProcessor ip2 = ip.duplicate();
        for (int level = highestValue; level >= 1; --level) {
            this.addProgress(1.0 / (double)highestValue);
            int idle = 0;
            do {
                if (this.processLevel(7, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(3, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(1, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(5, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(0, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(4, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(2, ip, ip2, table, levelStart[level], histogram[level], coordinates)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (!this.processLevel(6, ip, ip2, table, levelStart[level], histogram[level], coordinates)) continue;
                idle = 0;
            } while (idle++ < 8);
            if (IJ.escapePressed()) {
                IJ.beep();
                IJ.showProgress(1.0);
                return false;
            }
            if (!debug || level <= 245 && level >= 30) continue;
            movie.addSlice("level " + level, ip.duplicate());
        }
        if (debug) {
            new ImagePlus("Segmentation Movie", movie).show();
        }
        return true;
    }

    private int[] makeFateTable() {
        int[] table = new int[256];
        boolean[] isSet = new boolean[8];
        for (int item = 0; item < 256; ++item) {
            int i;
            int mask = 1;
            for (i = 0; i < 8; ++i) {
                isSet[i] = (item & mask) == mask;
                mask *= 2;
            }
            mask = 1;
            for (i = 0; i < 8; ++i) {
                if (isSet[(i + 4) % 8]) {
                    int n = item;
                    table[n] = table[n] | mask;
                }
                mask *= 2;
            }
            for (i = 0; i < 8; i += 2) {
                if (!isSet[i]) continue;
                isSet[(i + 1) % 8] = true;
                isSet[(i + 7) % 8] = true;
            }
            int transitions = 0;
            boolean mask2 = true;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (isSet[i2] == isSet[(i2 + 1) % 8]) continue;
                ++transitions;
            }
            if (transitions < 4) continue;
            table[item] = 0;
        }
        return table;
    }

    private boolean processLevel(int pass, ImageProcessor ip1, ImageProcessor ip2, int[] table, int levelStart, int levelNPoints, int[] coordinates) {
        int xmax = this.width - 1;
        int ymax = ip1.getHeight() - 1;
        byte[] pixels1 = (byte[])ip1.getPixels();
        byte[] pixels2 = (byte[])ip2.getPixels();
        boolean changed = false;
        int i = 0;
        int p = levelStart;
        while (i < levelNPoints) {
            int xy = coordinates[p];
            int x = xy & this.intEncodeXMask;
            int y = (xy & this.intEncodeYMask) >> this.intEncodeShift;
            int offset = x + y * this.width;
            if ((pixels2[offset] & 0xFF) != 255) {
                int index = 0;
                if (y > 0 && (pixels2[offset - this.width] & 0xFF) == 255) {
                    index ^= 1;
                }
                if (x < xmax && y > 0 && (pixels2[offset - this.width + 1] & 0xFF) == 255) {
                    index ^= 2;
                }
                if (x < xmax && (pixels2[offset + 1] & 0xFF) == 255) {
                    index ^= 4;
                }
                if (x < xmax && y < ymax && (pixels2[offset + this.width + 1] & 0xFF) == 255) {
                    index ^= 8;
                }
                if (y < ymax && (pixels2[offset + this.width] & 0xFF) == 255) {
                    index ^= 0x10;
                }
                if (x > 0 && y < ymax && (pixels2[offset + this.width - 1] & 0xFF) == 255) {
                    index ^= 0x20;
                }
                if (x > 0 && (pixels2[offset - 1] & 0xFF) == 255) {
                    index ^= 0x40;
                }
                if (x > 0 && y > 0 && (pixels2[offset - this.width - 1] & 0xFF) == 255) {
                    index ^= 0x80;
                }
                switch (pass) {
                    case 0: {
                        if ((table[index] & 1) != 1) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 1: {
                        if ((table[index] & 2) != 2) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 2: {
                        if ((table[index] & 4) != 4) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 3: {
                        if ((table[index] & 8) != 8) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 4: {
                        if ((table[index] & 0x10) != 16) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 5: {
                        if ((table[index] & 0x20) != 32) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 6: {
                        if ((table[index] & 0x40) != 64) break;
                        pixels1[offset] = -1;
                        changed = true;
                        break;
                    }
                    case 7: {
                        if ((table[index] & 0x80) != 128) break;
                        pixels1[offset] = -1;
                        changed = true;
                    }
                }
            }
            ++i;
            ++p;
        }
        if (changed) {
            System.arraycopy(pixels1, 0, pixels2, 0, this.width * this.height);
        }
        return changed;
    }

    void makeDirectionOffsets(ImageProcessor ip) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        int shift = 0;
        int mult = 1;
        do {
            ++shift;
        } while ((mult *= 2) < this.width);
        this.intEncodeXMask = mult - 1;
        this.intEncodeYMask = ~this.intEncodeXMask;
        this.intEncodeShift = shift;
        this.dirXoffset = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        this.dirYoffset = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
        this.dirOffset = new int[]{-this.width, -this.width + 1, 1, this.width + 1, this.width, this.width - 1, -1, -this.width - 1};
    }

    boolean isWithin(int x, int y, int direction) {
        int xmax = this.width - 1;
        int ymax = this.height - 1;
        switch (direction) {
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: {
                return x > 0 && y > 0;
            }
        }
        return false;
    }

    private void addProgress(double deltaProgress) {
        if (this.nPasses == 0) {
            return;
        }
        this.progressDone += deltaProgress;
        IJ.showProgress(this.progressDone / (double)this.nPasses);
    }

    static {
        outputTypeNames = new String[]{"Single Points", "Maxima Within Tolerance", "Segmented Particles", "Point Selection", "Count"};
        outputTypeMasks = new byte[]{32, 8, 8, 32};
    }

    class MaxPoint
    implements Comparable {
        float value;
        int offset;

        MaxPoint(int offset, float value) {
            this.offset = offset;
            this.value = value;
        }

        public int compareTo(Object o) {
            float diff = this.value - ((MaxPoint)o).value;
            if (diff > 0.0f) {
                return 1;
            }
            if (diff == 0.0f) {
                return 0;
            }
            return -1;
        }
    }
}

