/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthVariableList;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.util.SQLParserUtil;
import com.mirth.connect.connectors.jdbc.DatabaseConnectionInfo;
import com.mirth.connect.connectors.jdbc.DatabaseDriversDialog;
import com.mirth.connect.connectors.jdbc.DatabaseMetadataDialog;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilderFactory;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.w3c.dom.Element;

public class DatabaseReader
extends ConnectorSettingsPanel {
    private List<DriverInfo> drivers;
    private Frame parent;
    private Timer timer;
    private AtomicBoolean driverAdjusting = new AtomicBoolean(false);
    private JLabel driverLabel;
    private MirthComboBox<DriverInfo> driverComboBox;
    private MirthTextField driverField;
    private JButton manageDriversButton;
    private JLabel urlLabel;
    private MirthTextField urlField;
    private JButton insertURLTemplateButton;
    private JLabel usernameLabel;
    private MirthTextField usernameField;
    private JLabel passwordLabel;
    private MirthPasswordField passwordField;
    private JLabel useJavaScriptLabel;
    private MirthRadioButton useJavaScriptYesRadio;
    private MirthRadioButton useJavaScriptNoRadio;
    private JLabel keepConnectionOpenLabel;
    private MirthRadioButton keepConnectionOpenYesRadio;
    private MirthRadioButton keepConnectionOpenNoRadio;
    private JLabel aggregateResultsLabel;
    private JRadioButton aggregateResultsYesRadio;
    private JRadioButton aggregateResultsNoRadio;
    private JLabel cacheResultsLabel;
    private MirthRadioButton cacheResultsYesRadio;
    private MirthRadioButton cacheResultsNoRadio;
    private JLabel fetchSizeLabel;
    private MirthTextField fetchSizeField;
    private JLabel retryCountLabel;
    private MirthTextField retryCountField;
    private JLabel retryIntervalLabel;
    private MirthTextField retryIntervalField;
    private JLabel encodingLabel;
    private MirthComboBox encodingComboBox;
    private JLabel generateLabel;
    private JButton generateConnectionButton;
    private JButton generateSelectButton;
    private JLabel selectSQLLabel;
    private MirthRTextScrollPane selectSQLTextPane;
    private JLabel runPostProcessSQLLabel;
    private MirthRadioButton runPostProcessSQLNeverRadio;
    private MirthRadioButton runPostProcessSQLEachRadio;
    private MirthRadioButton runPostProcessSQLOnceRadio;
    private JLabel generatePostProcessSQLLabel;
    private JButton generatePostProcessSQLConnectionButton;
    private JButton generatePostProcessSQLUpdateButton;
    private JLabel postProcessSQLLabel;
    private MirthRTextScrollPane postProcessSQLTextPane;
    private MirthVariableList dbVarList;
    private JScrollPane dbVarScrollPane;

    public DatabaseReader() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    public String getConnectorName() {
        return new DatabaseReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        DatabaseReceiverProperties properties = new DatabaseReceiverProperties();
        properties.setDriver(this.driverField.getText());
        properties.setUrl(this.urlField.getText());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setKeepConnectionOpen(this.keepConnectionOpenYesRadio.isSelected());
        properties.setAggregateResults(this.aggregateResultsYesRadio.isSelected());
        properties.setCacheResults(this.cacheResultsYesRadio.isSelected());
        properties.setFetchSize(this.fetchSizeField.getText());
        properties.setRetryCount(this.retryCountField.getText());
        properties.setRetryInterval(this.retryIntervalField.getText());
        properties.setUseScript(this.useJavaScriptYesRadio.isSelected());
        properties.setSelect(this.selectSQLTextPane.getText());
        properties.setUpdate(this.postProcessSQLTextPane.getText());
        if (this.runPostProcessSQLOnceRadio.isSelected()) {
            properties.setUpdateMode(2);
        } else if (this.runPostProcessSQLEachRadio.isSelected()) {
            properties.setUpdateMode(3);
        } else {
            properties.setUpdateMode(1);
        }
        properties.setEncoding(this.parent.getSelectedEncodingForConnector((JComboBox)this.encodingComboBox));
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(ConnectorProperties properties) {
        DatabaseReceiverProperties props = (DatabaseReceiverProperties)properties;
        boolean enabled = this.parent.isSaveEnabled();
        if (StringUtils.equals((CharSequence)props.getDriver(), (CharSequence)"Please Select One")) {
            this.driverField.setText("");
        } else {
            this.driverField.setText(props.getDriver());
        }
        this.driverAdjusting.set(true);
        try {
            this.updateDriverComboBoxFromField();
        }
        finally {
            this.driverAdjusting.set(false);
        }
        this.retrieveDatabaseDrivers(props.getDriver());
        this.parent.setSaveEnabled(enabled);
        this.urlField.setText(props.getUrl());
        this.usernameField.setText(props.getUsername());
        this.passwordField.setText(props.getPassword());
        if (props.isKeepConnectionOpen()) {
            this.keepConnectionOpenYesRadio.setSelected(true);
            this.keepConnectionOpenNoRadio.setSelected(false);
        } else {
            this.keepConnectionOpenYesRadio.setSelected(false);
            this.keepConnectionOpenNoRadio.setSelected(true);
        }
        if (props.isCacheResults()) {
            this.cacheResultsYesRadio.setSelected(true);
            this.cacheResultsYesButtonActionPerformed();
        } else {
            this.cacheResultsNoRadio.setSelected(true);
            this.cacheResultsNoButtonActionPerformed();
        }
        if (props.isAggregateResults()) {
            this.aggregateResultsYesRadio.setSelected(true);
            this.aggregateResultsActionPerformed(true);
        } else {
            this.aggregateResultsNoRadio.setSelected(true);
            this.aggregateResultsActionPerformed(false);
        }
        this.fetchSizeField.setText(props.getFetchSize());
        this.retryCountField.setText(props.getRetryCount());
        this.retryIntervalField.setText(props.getRetryInterval());
        this.parent.setPreviousSelectedEncodingForConnector((JComboBox)this.encodingComboBox, props.getEncoding());
        if (props.isUseScript()) {
            this.useJavaScriptYesRadio.setSelected(true);
            this.useScriptYesActionPerformed();
        } else {
            this.useJavaScriptNoRadio.setSelected(true);
            this.useScriptNoActionPerformed();
        }
        this.selectSQLTextPane.setText(props.getSelect());
        this.postProcessSQLTextPane.setText(props.getUpdate());
        switch (props.getUpdateMode()) {
            case 3: {
                this.runPostProcessSQLEachRadio.setSelected(true);
                this.updateEachActionPerformed();
                break;
            }
            case 2: {
                this.runPostProcessSQLOnceRadio.setSelected(true);
                this.updateOnceActionPerformed();
                break;
            }
            default: {
                this.runPostProcessSQLNeverRadio.setSelected(true);
                this.updateNeverActionPerformed();
            }
        }
    }

    public ConnectorProperties getDefaults() {
        return new DatabaseReceiverProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        DatabaseReceiverProperties props = (DatabaseReceiverProperties)properties;
        boolean valid = true;
        if (!props.isUseScript() && props.getUrl().length() == 0) {
            valid = false;
            if (highlight) {
                this.urlField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getSelect().length() == 0) {
            valid = false;
            if (highlight) {
                this.selectSQLTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getUpdateMode() != 1 && props.getUpdate().length() == 0) {
            valid = false;
            if (highlight) {
                this.postProcessSQLTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getDriver()) || props.getDriver().equals("Please Select One")) {
            valid = false;
            if (highlight) {
                this.driverComboBox.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.urlField.setBackground(null);
        this.fetchSizeField.setBackground(null);
        this.selectSQLTextPane.setBackground(null);
        this.postProcessSQLTextPane.setBackground(null);
        this.driverComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.selectSQLTextPane.updateDisplayOptions();
        this.postProcessSQLTextPane.updateDisplayOptions();
    }

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        DatabaseReceiverProperties props = (DatabaseReceiverProperties)properties;
        StringBuilder error = new StringBuilder();
        if (props.isUseScript()) {
            String onUpdateScript;
            String script = props.getSelect();
            if (script.length() != 0) {
                Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
                try {
                    context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
                }
                catch (EvaluatorException e) {
                    error.append("Error in connector \"" + this.getConnectorName() + "\" at Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n");
                }
                catch (Exception e) {
                    error.append("Error in connector \"" + this.getConnectorName() + "\" at Javascript:\nUnknown error occurred during validation.");
                }
                Context.exit();
            }
            if (props.getUpdateMode() != 1 && (onUpdateScript = props.getUpdate()).length() != 0) {
                Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
                try {
                    context.compileString("function rhinoWrapper() {" + onUpdateScript + "\n}", UUID.randomUUID().toString(), 1, null);
                }
                catch (EvaluatorException e) {
                    error.append("Error in connector \"" + this.getConnectorName() + "\" at On-Update Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n");
                }
                catch (Exception e) {
                    error.append("Error in connector \"" + this.getConnectorName() + "\" at Javascript:\nUnknown error occurred during validation.");
                }
                Context.exit();
            }
        }
        return error.length() == 0 ? null : error.toString();
    }

    public String getRequiredInboundDataType() {
        return "XML";
    }

    private void update() {
        if (this.timer == null) {
            this.timer = new Timer(1000, new UpdateSQLActionListener());
            this.timer.setRepeats(false);
            this.timer.start();
        } else {
            this.timer.restart();
        }
    }

    private String[] parseData(String sqlStatement) {
        if (StringUtils.isNotEmpty((CharSequence)sqlStatement)) {
            SQLParserUtil spu = new SQLParserUtil(sqlStatement);
            return spu.Parse();
        }
        return new String[0];
    }

    private void updateIncomingData(String[] data) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            org.w3c.dom.Document document = dbf.newDocumentBuilder().newDocument();
            Element resultElement = document.createElement("result");
            for (int i = 0; i < data.length; ++i) {
                Element columnElement = document.createElement(data[i]);
                columnElement.setTextContent("value");
                resultElement.appendChild(columnElement);
            }
            document.appendChild(resultElement);
            DocumentSerializer docSerializer = new DocumentSerializer();
            String xml = docSerializer.toXML(document);
            this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().setInboundTemplate(xml);
            if (this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundDataType().equals("XML") && this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundTemplate() != null && this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundTemplate().length() == 0) {
                List list = this.parent.channelEditPanel.currentChannel.getDestinationConnectors();
                for (Connector c : list) {
                    c.getTransformer().setInboundTemplate(xml);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.driverLabel = new JLabel("Driver:");
        this.driverComboBox = new MirthComboBox();
        this.driverComboBox.addActionListener(evt -> {
            if (!this.driverAdjusting.getAndSet(true)) {
                try {
                    this.updateDriverFieldFromComboBox();
                }
                finally {
                    this.driverAdjusting.set(false);
                }
            }
        });
        this.driverComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DriverInfo) {
                    this.setText(((DriverInfo)value).getName());
                }
                return component;
            }
        });
        this.driverField = new MirthTextField();
        this.driverField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.update();
            }

            private void update() {
                if (!DatabaseReader.this.driverAdjusting.getAndSet(true)) {
                    try {
                        DatabaseReader.this.updateDriverComboBoxFromField();
                    }
                    finally {
                        DatabaseReader.this.driverAdjusting.set(false);
                    }
                }
            }
        });
        this.updateDriversComboBox();
        this.manageDriversButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.manageDriversButton.setToolTipText("<html>Click here to view and manage the list of database JDBC drivers.<br/>Any changes will require re-saving and redeploying the channel.</html>");
        this.manageDriversButton.addActionListener(evt -> {
            DatabaseDriversDialog dialog = new DatabaseDriversDialog((Window)this.parent, this.drivers);
            if (dialog.wasSaved()) {
                this.drivers = dialog.getDrivers();
                this.updateDriversComboBox();
            }
        });
        this.urlLabel = new JLabel("URL:");
        this.urlField = new MirthTextField();
        this.insertURLTemplateButton = new JButton("Insert URL Template");
        this.insertURLTemplateButton.addActionListener(evt -> this.insertURLTemplateButtonActionPerformed());
        this.usernameLabel = new JLabel("Username:");
        this.usernameField = new MirthTextField();
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.useJavaScriptLabel = new JLabel("Use JavaScript:");
        ButtonGroup useJavaScriptButtonGroup = new ButtonGroup();
        this.useJavaScriptYesRadio = new MirthRadioButton("Yes");
        this.useJavaScriptYesRadio.setBackground(this.getBackground());
        this.useJavaScriptYesRadio.addActionListener(evt -> this.useScriptYesActionPerformed());
        useJavaScriptButtonGroup.add((AbstractButton)this.useJavaScriptYesRadio);
        this.useJavaScriptNoRadio = new MirthRadioButton("No");
        this.useJavaScriptNoRadio.setBackground(this.getBackground());
        this.useJavaScriptNoRadio.addActionListener(evt -> this.useScriptNoActionPerformed());
        useJavaScriptButtonGroup.add((AbstractButton)this.useJavaScriptNoRadio);
        this.keepConnectionOpenLabel = new JLabel("Keep Connection Open:");
        ButtonGroup keepConnectionOpenButtonGroup = new ButtonGroup();
        this.keepConnectionOpenYesRadio = new MirthRadioButton("Yes");
        this.keepConnectionOpenYesRadio.setBackground(this.getBackground());
        keepConnectionOpenButtonGroup.add((AbstractButton)this.keepConnectionOpenYesRadio);
        this.keepConnectionOpenNoRadio = new MirthRadioButton("No");
        this.keepConnectionOpenNoRadio.setBackground(this.getBackground());
        keepConnectionOpenButtonGroup.add((AbstractButton)this.keepConnectionOpenNoRadio);
        this.aggregateResultsLabel = new JLabel("Aggregate Results:");
        ButtonGroup aggregateResultsButtonGroup = new ButtonGroup();
        this.aggregateResultsYesRadio = new MirthRadioButton("Yes");
        this.aggregateResultsYesRadio.setBackground(this.getBackground());
        this.aggregateResultsYesRadio.addActionListener(evt -> {
            if (!this.parent.alertOption((Component)this.parent, "<html><b>Warning:</b> All rows returned by the query below will be aggregated<br/>into a single message. This could cause memory issues if you are<br/>reading in large amounts of data. Consider using LIMIT to limit<br/>the number of rows to return. Are you sure you wish to continue?</html>")) {
                this.aggregateResultsNoRadio.setSelected(true);
            } else {
                this.aggregateResultsActionPerformed(true);
            }
        });
        aggregateResultsButtonGroup.add(this.aggregateResultsYesRadio);
        this.aggregateResultsNoRadio = new MirthRadioButton("No");
        this.aggregateResultsNoRadio.setBackground(this.getBackground());
        this.aggregateResultsNoRadio.addActionListener(evt -> this.aggregateResultsActionPerformed(false));
        aggregateResultsButtonGroup.add(this.aggregateResultsNoRadio);
        this.cacheResultsLabel = new JLabel("Cache Results:");
        ButtonGroup cacheResultsButtonGroup = new ButtonGroup();
        this.cacheResultsYesRadio = new MirthRadioButton("Yes");
        this.cacheResultsYesRadio.setBackground(this.getBackground());
        this.cacheResultsYesRadio.addActionListener(evt -> this.cacheResultsYesButtonActionPerformed());
        cacheResultsButtonGroup.add((AbstractButton)this.cacheResultsYesRadio);
        this.cacheResultsNoRadio = new MirthRadioButton("No");
        this.cacheResultsNoRadio.setBackground(this.getBackground());
        this.cacheResultsNoRadio.addActionListener(evt -> this.cacheResultsNoButtonActionPerformed());
        cacheResultsButtonGroup.add((AbstractButton)this.cacheResultsNoRadio);
        this.fetchSizeLabel = new JLabel("Fetch Size:");
        this.fetchSizeField = new MirthTextField();
        this.fetchSizeField.setDocument((Document)new MirthFieldConstraints(9, false, false, true));
        this.retryCountLabel = new JLabel("# of Retries on Error:");
        this.retryCountField = new MirthTextField();
        this.retryCountField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.retryIntervalLabel = new JLabel("Retry Interval (ms):");
        this.retryIntervalField = new MirthTextField();
        this.retryIntervalField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.encodingLabel = new JLabel("Encoding:");
        this.encodingComboBox = new MirthComboBox();
        this.parent.setupCharsetEncodingForConnector((JComboBox)this.encodingComboBox);
        this.generateLabel = new JLabel("Generate:");
        this.generateConnectionButton = new JButton("Connection");
        this.generateConnectionButton.addActionListener(evt -> this.generateConnectionActionPerformed());
        this.generateSelectButton = new JButton("Select");
        this.generateSelectButton.addActionListener(evt -> this.generateSelectActionPerformed());
        this.selectSQLLabel = new JLabel("JavaScript:");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DatabaseReader.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DatabaseReader.this.update();
            }
        };
        this.selectSQLTextPane = new MirthRTextScrollPane(ContextType.SOURCE_RECEIVER, true);
        this.selectSQLTextPane.setSyntaxEditingStyle("text/sql");
        this.selectSQLTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.selectSQLTextPane.getDocument().addDocumentListener(documentListener);
        this.runPostProcessSQLLabel = new JLabel("Run Post-Process Script:");
        ButtonGroup postProcessSQLButtonGroup = new ButtonGroup();
        this.runPostProcessSQLNeverRadio = new MirthRadioButton("Never");
        this.runPostProcessSQLNeverRadio.setBackground(this.getBackground());
        this.runPostProcessSQLNeverRadio.addActionListener(evt -> this.updateNeverActionPerformed());
        postProcessSQLButtonGroup.add((AbstractButton)this.runPostProcessSQLNeverRadio);
        this.runPostProcessSQLEachRadio = new MirthRadioButton("After each message");
        this.runPostProcessSQLEachRadio.setBackground(this.getBackground());
        this.runPostProcessSQLEachRadio.addActionListener(evt -> this.updateEachActionPerformed());
        postProcessSQLButtonGroup.add((AbstractButton)this.runPostProcessSQLEachRadio);
        this.runPostProcessSQLOnceRadio = new MirthRadioButton("Once after all messages");
        this.runPostProcessSQLOnceRadio.setBackground(this.getBackground());
        this.runPostProcessSQLOnceRadio.addActionListener(evt -> this.updateOnceActionPerformed());
        postProcessSQLButtonGroup.add((AbstractButton)this.runPostProcessSQLOnceRadio);
        this.generatePostProcessSQLLabel = new JLabel("Generate:");
        this.generatePostProcessSQLConnectionButton = new JButton("Connection");
        this.generatePostProcessSQLConnectionButton.addActionListener(evt -> this.generateUpdateConnectionActionPerformed());
        this.generatePostProcessSQLUpdateButton = new JButton("Update");
        this.generatePostProcessSQLUpdateButton.addActionListener(evt -> this.generateUpdateUpdateActionPerformed());
        this.postProcessSQLLabel = new JLabel("JavaScript:");
        this.postProcessSQLTextPane = new MirthRTextScrollPane(ContextType.SOURCE_RECEIVER, true);
        this.postProcessSQLTextPane.setSyntaxEditingStyle("text/sql");
        this.postProcessSQLTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.postProcessSQLTextPane.getDocument().addDocumentListener(documentListener);
        this.dbVarList = new MirthVariableList();
        this.dbVarScrollPane = new JScrollPane((Component)this.dbVarList);
    }

    private void initToolTips() {
        this.driverComboBox.setToolTipText("Specifies the type of database driver to use to connect to the database.");
        this.driverField.setToolTipText("The fully-qualified class name of the JDBC driver to use to connect to the database.");
        this.urlField.setToolTipText("<html>The JDBC URL to connect to the database. This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.usernameField.setToolTipText("<html>The user name to connect to the database. This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.passwordField.setToolTipText("<html>The password to connect to the database. This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.useJavaScriptYesRadio.setToolTipText("<html>Implement JavaScript code using JDBC to get the messages to be processed and mark messages in the database as processed.</html>");
        this.useJavaScriptNoRadio.setToolTipText("<html>Specify the SQL statements to get messages to be processed and mark messages in the database as processed.</html>");
        this.keepConnectionOpenYesRadio.setToolTipText("<html>Re-use the same database connection each time the select query is executed.</html>");
        this.keepConnectionOpenNoRadio.setToolTipText("<html>Close the database connection after selected messages have finished processing.</html>");
        String toolTipText = "<html>If enabled, all rows returned in the query will be<br/>aggregated into a single XML message. Note that all rows<br/>will be read into memory at once, so use this with caution.</html>";
        this.aggregateResultsYesRadio.setToolTipText(toolTipText);
        this.aggregateResultsNoRadio.setToolTipText(toolTipText);
        this.cacheResultsYesRadio.setToolTipText("<html>Cache the entire result set in memory prior to processing messages.</html>");
        this.cacheResultsNoRadio.setToolTipText("<html>Do not cache the entire result set in memory prior to processing messages.</html>");
        this.fetchSizeField.setToolTipText("<html>The JDBC ResultSet fetch size to be used when fetching results from the current cursor position.</html>");
        this.retryCountField.setToolTipText("<html>The number of times to retry executing the statement or script if an error occurs.</html>");
        this.retryIntervalField.setToolTipText("<html>The amount of time that should elapse between retry attempts.</html>");
        this.encodingComboBox.setToolTipText("<html>Select the character set encoding used by the source database,<br/>or select Default to use the default character set encoding for the JVM running BridgeLink.</html>");
        this.generateConnectionButton.setToolTipText("<html>If \"Yes\" is selected for Use JavaScript, this button is enabled.<br>When clicked, it inserts boilerplate Connection construction code into the JavaScript control at the current caret location.</html>");
        this.generateSelectButton.setToolTipText("<html>Opens a window to assist in building a select query to select records from the database specified in the URL above.</html>");
        this.runPostProcessSQLLabel.setToolTipText("<html>When using a database reader, it is usually necessary to execute a separate SQL statement<br>to mark the message that was just fetched as processed, so it will not be fetched again the next time a poll occurs.</html>");
        this.runPostProcessSQLNeverRadio.setToolTipText("<html>Do not run the post-process statement/script.</html>");
        this.runPostProcessSQLEachRadio.setToolTipText("<html>Run the post-process statement/script after each message finishes processing.</html>");
        this.runPostProcessSQLOnceRadio.setToolTipText("<html>Run the post-process statement/script only after all messages have finished processing.</html>");
        this.generatePostProcessSQLConnectionButton.setToolTipText("<html>This button is enabled when using JavaScript and a post-process script.<br>When clicked, it inserts boilerplate Connection construction code into the post-process JavaScript control at the current caret location.</html>");
        this.generatePostProcessSQLUpdateButton.setToolTipText("<html>Opens a window to assist in building an update query to update records in the database specified in the URL above.<br/>(Only enabled if a post-process statement/script is enabled)</html>");
        this.dbVarList.setToolTipText("<html>This list is populated with mappings based on the select statement in the JavaScript or SQL editor.<br>These mappings can dragged into the post-process JavaScript or SQL editors.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6", "[]12[grow]", "[][][][][][][][][][][][][sgy][][sgy]"));
        this.add(this.driverLabel, "right");
        this.add((Component)this.driverComboBox, "split 3");
        this.add((Component)this.driverField, "w 200!");
        this.add(this.manageDriversButton, "h 22!, w 22!");
        this.add(this.urlLabel, "newline, right");
        this.add((Component)this.urlField, "w 318!, split 2");
        this.add(this.insertURLTemplateButton);
        this.add(this.usernameLabel, "newline, right");
        this.add((Component)this.usernameField, "w 121!");
        this.add(this.passwordLabel, "newline, right");
        this.add((Component)this.passwordField, "w 121!");
        this.add(this.useJavaScriptLabel, "newline, right");
        this.add((Component)this.useJavaScriptYesRadio, "split");
        this.add((Component)this.useJavaScriptNoRadio);
        this.add(this.keepConnectionOpenLabel, "newline, right");
        this.add((Component)this.keepConnectionOpenYesRadio, "split");
        this.add((Component)this.keepConnectionOpenNoRadio);
        this.add(this.aggregateResultsLabel, "newline, right");
        this.add(this.aggregateResultsYesRadio, "split");
        this.add(this.aggregateResultsNoRadio);
        this.add(this.cacheResultsLabel, "newline, right");
        this.add((Component)this.cacheResultsYesRadio, "split");
        this.add((Component)this.cacheResultsNoRadio);
        this.add(this.fetchSizeLabel, "newline, right");
        this.add((Component)this.fetchSizeField, "w 121!");
        this.add(this.retryCountLabel, "newline, right");
        this.add((Component)this.retryCountField, "w 121!");
        this.add(this.retryIntervalLabel, "newline, right");
        this.add((Component)this.retryIntervalField, "w 121!");
        this.add(this.encodingLabel, "newline, right");
        this.add((Component)this.encodingComboBox, "split 1, left");
        this.add(this.generateLabel, "split 3, sx, right, gapafter 12");
        this.add(this.generateConnectionButton, "w 67!");
        this.add(this.generateSelectButton, "w 67!");
        this.add(this.selectSQLLabel, "newline, top, right");
        this.add((Component)this.selectSQLTextPane, "sx, grow, pushy, w :400, h :100");
        this.add(this.runPostProcessSQLLabel, "newline, right");
        this.add((Component)this.runPostProcessSQLNeverRadio, "split 3");
        this.add((Component)this.runPostProcessSQLEachRadio);
        this.add((Component)this.runPostProcessSQLOnceRadio);
        this.add(this.generatePostProcessSQLLabel, "sx, split 3, right, gapafter 12");
        this.add(this.generatePostProcessSQLConnectionButton, "w 67!");
        this.add(this.generatePostProcessSQLUpdateButton, "w 67!");
        this.add(this.postProcessSQLLabel, "newline, top, right");
        this.add((Component)this.postProcessSQLTextPane, "grow, split, sx, pushy, w :400, h :100");
        this.add(this.dbVarScrollPane, "growy, right, w 195!");
    }

    private void retrieveDatabaseDrivers(String selectedDriver) {
        final String workingId = this.parent.startWorking("Retrieving database drivers...");
        SwingWorker<List<DriverInfo>, Void> worker = new SwingWorker<List<DriverInfo>, Void>(){

            @Override
            protected List<DriverInfo> doInBackground() throws Exception {
                return DatabaseReader.this.parent.mirthClient.getDatabaseDrivers();
            }

            @Override
            protected void done() {
                try {
                    DatabaseReader.this.drivers = (List)this.get();
                    boolean enabled = DatabaseReader.this.parent.isSaveEnabled();
                    DatabaseReader.this.updateDriversComboBox();
                    DatabaseReader.this.parent.setSaveEnabled(enabled);
                    DatabaseReader.this.parent.stopWorking(workingId);
                }
                catch (Exception e) {
                    DatabaseReader.this.parent.stopWorking(workingId);
                    DatabaseReader.this.parent.alertThrowable((Component)DatabaseReader.this.parent, (Throwable)e, false);
                }
            }
        };
        worker.execute();
    }

    private DriverInfo getSelectedDriver() {
        DriverInfo selectedDriver = (DriverInfo)this.driverComboBox.getSelectedItem();
        if (selectedDriver == null) {
            selectedDriver = this.getSelectOneDriver();
        }
        return selectedDriver;
    }

    private DriverInfo getSelectOneDriver() {
        return new DriverInfo("Please Select One", "", "", "");
    }

    private DriverInfo getCustomDriver() {
        return new DriverInfo("Custom", "", "", "");
    }

    private void fixDriversList() {
        if (CollectionUtils.isEmpty(this.drivers)) {
            this.drivers = DriverInfo.getDefaultDrivers();
        }
        if (!StringUtils.equals((CharSequence)this.drivers.get(0).getName(), (CharSequence)"Please Select One")) {
            this.drivers.add(0, this.getSelectOneDriver());
        }
        if (!StringUtils.equals((CharSequence)this.drivers.get(this.drivers.size() - 1).getName(), (CharSequence)"Custom")) {
            this.drivers.add(this.getCustomDriver());
        }
    }

    private void updateDriversComboBox() {
        this.fixDriversList();
        this.driverAdjusting.set(true);
        try {
            this.driverComboBox.setModel(new DefaultComboBoxModel<DriverInfo>(this.drivers.toArray(new DriverInfo[this.drivers.size()])));
            this.updateDriverComboBoxFromField();
        }
        finally {
            this.driverAdjusting.set(false);
        }
    }

    private void updateDriverFieldFromComboBox() {
        DriverInfo driver = this.getSelectedDriver();
        if (!StringUtils.equals((CharSequence)driver.getName(), (CharSequence)"Custom")) {
            this.driverField.setText(driver.getClassName());
            this.driverField.setCaretPosition(0);
        }
    }

    private void updateDriverComboBoxFromField() {
        String driverClassName = this.driverField.getText();
        DriverInfo foundDriver = null;
        for (int i = 0; i < this.driverComboBox.getModel().getSize(); ++i) {
            DriverInfo driver = (DriverInfo)this.driverComboBox.getModel().getElementAt(i);
            if (StringUtils.equals((CharSequence)driverClassName, (CharSequence)driver.getClassName())) {
                foundDriver = driver;
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)driver.getAlternativeClassNames())) continue;
            for (String alternativeClassName : driver.getAlternativeClassNames()) {
                if (!StringUtils.equals((CharSequence)driverClassName, (CharSequence)alternativeClassName)) continue;
                foundDriver = driver;
                break;
            }
            if (foundDriver != null) break;
        }
        if (foundDriver != null) {
            this.driverComboBox.setSelectedItem(foundDriver);
        } else {
            this.driverComboBox.setSelectedIndex(this.driverComboBox.getItemCount() - 1);
        }
    }

    private void generateUpdateUpdateActionPerformed() {
        this.showDatabaseMetaData(DatabaseMetadataDialog.STATEMENT_TYPE.UPDATE_TYPE);
    }

    private void generateUpdateConnectionActionPerformed() {
        this.postProcessSQLTextPane.setText(this.generateUpdateConnectionString() + "\n\n" + this.postProcessSQLTextPane.getText());
        this.postProcessSQLTextPane.requestFocus();
        this.postProcessSQLTextPane.setCaretPosition(this.postProcessSQLTextPane.getText().lastIndexOf("\n\n", this.postProcessSQLTextPane.getText().length() - 3) + 1);
        this.parent.setSaveEnabled(true);
    }

    private void generateSelectActionPerformed() {
        this.showDatabaseMetaData(DatabaseMetadataDialog.STATEMENT_TYPE.SELECT_TYPE);
    }

    private void useScriptNoActionPerformed() {
        this.selectSQLLabel.setText("SQL:");
        this.postProcessSQLLabel.setText("SQL:");
        this.runPostProcessSQLLabel.setText("Run Post-Process SQL:");
        this.selectSQLTextPane.setSyntaxEditingStyle("text/sql");
        this.postProcessSQLTextPane.setSyntaxEditingStyle("text/sql");
        this.selectSQLTextPane.setText("");
        this.postProcessSQLTextPane.setText("");
        this.keepConnectionOpenLabel.setEnabled(true);
        this.keepConnectionOpenNoRadio.setEnabled(true);
        this.keepConnectionOpenYesRadio.setEnabled(true);
        this.aggregateResultsActionPerformed(this.aggregateResultsYesRadio.isSelected());
        this.update();
        this.generateConnectionButton.setEnabled(false);
        this.generatePostProcessSQLConnectionButton.setEnabled(false);
        this.dbVarList.setTransferMode(VariableListHandler.TransferMode.VELOCITY);
    }

    private void useScriptYesActionPerformed() {
        this.selectSQLLabel.setText("JavaScript:");
        this.postProcessSQLLabel.setText("JavaScript:");
        this.runPostProcessSQLLabel.setText("Run Post-Process Script:");
        this.selectSQLTextPane.setSyntaxEditingStyle("text/javascript");
        this.postProcessSQLTextPane.setSyntaxEditingStyle("text/javascript");
        this.selectSQLTextPane.setText(this.generateConnectionString());
        this.postProcessSQLTextPane.setText(this.generateUpdateConnectionString());
        this.generateConnectionButton.setEnabled(true);
        this.keepConnectionOpenLabel.setEnabled(false);
        this.keepConnectionOpenNoRadio.setEnabled(false);
        this.keepConnectionOpenYesRadio.setEnabled(false);
        this.cacheResultsLabel.setEnabled(false);
        this.cacheResultsNoRadio.setEnabled(false);
        this.cacheResultsYesRadio.setEnabled(false);
        this.fetchSizeField.setEnabled(false);
        this.fetchSizeLabel.setEnabled(false);
        this.update();
        if (!this.runPostProcessSQLNeverRadio.isSelected()) {
            this.generatePostProcessSQLConnectionButton.setEnabled(true);
        }
        this.dbVarList.setTransferMode(VariableListHandler.TransferMode.JAVASCRIPT);
    }

    private void insertURLTemplateButtonActionPerformed() {
        if (!this.urlField.getText().equals("") && !this.parent.alertOption((Component)this.parent, "Are you sure you would like to replace your current connection URL with the template URL?")) {
            return;
        }
        this.urlField.setText(this.getSelectedDriver().getTemplate());
        this.urlField.grabFocus();
        this.parent.setSaveEnabled(true);
    }

    private void cacheResultsYesButtonActionPerformed() {
        this.fetchSizeField.setEnabled(false);
        this.fetchSizeLabel.setEnabled(false);
    }

    private void cacheResultsNoButtonActionPerformed() {
        this.fetchSizeField.setEnabled(this.useJavaScriptNoRadio.isSelected());
        this.fetchSizeLabel.setEnabled(this.useJavaScriptNoRadio.isSelected());
    }

    private void updateNeverActionPerformed() {
        this.postProcessSQLLabel.setEnabled(false);
        this.postProcessSQLTextPane.setEnabled(false);
        this.generatePostProcessSQLConnectionButton.setEnabled(false);
        this.generatePostProcessSQLUpdateButton.setEnabled(false);
        this.generatePostProcessSQLLabel.setEnabled(false);
        this.dbVarList.setEnabled(false);
    }

    private void updateEachActionPerformed() {
        this.postProcessSQLLabel.setEnabled(true);
        this.postProcessSQLTextPane.setEnabled(true);
        if (this.useJavaScriptYesRadio.isSelected()) {
            this.generatePostProcessSQLConnectionButton.setEnabled(true);
            this.dbVarList.setEnabled(true);
        }
        this.generatePostProcessSQLUpdateButton.setEnabled(true);
        this.generatePostProcessSQLLabel.setEnabled(true);
        this.dbVarList.setEnabled(true);
    }

    private void updateOnceActionPerformed() {
        this.postProcessSQLLabel.setEnabled(true);
        this.postProcessSQLTextPane.setEnabled(true);
        if (this.useJavaScriptYesRadio.isSelected()) {
            this.generatePostProcessSQLConnectionButton.setEnabled(true);
            this.dbVarList.setEnabled(false);
        }
        this.generatePostProcessSQLUpdateButton.setEnabled(true);
        this.generatePostProcessSQLLabel.setEnabled(true);
        this.dbVarList.setEnabled(false);
    }

    public void showDatabaseMetaData(DatabaseMetadataDialog.STATEMENT_TYPE type) {
        DatabaseReceiverProperties properties = (DatabaseReceiverProperties)this.getProperties();
        if (properties.getUrl().length() == 0 || properties.getDriver().equals("Please Select One")) {
            this.parent.alertError((Component)this.parent, "A valid Driver and URL are required to perform this operation.");
        } else {
            Connector sourceConnector = PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getSourceConnector();
            Set<String> resourceIds = ((Map)PlatformUI.MIRTH_FRAME.channelEditPanel.resourceIds.get(sourceConnector.getMetaDataId())).keySet();
            new DatabaseMetadataDialog(this, type, new DatabaseConnectionInfo(properties.getDriver(), properties.getUrl(), properties.getUsername(), properties.getPassword(), "", this.getSelectedDriver().getSelectLimit(), resourceIds));
        }
    }

    public void setSelectText(String statement) {
        if (!this.useJavaScriptYesRadio.isSelected()) {
            this.selectSQLTextPane.setText(statement + "\n\n" + this.selectSQLTextPane.getText());
        } else {
            StringBuilder connectionString = new StringBuilder();
            connectionString.append("\tvar result = dbConn.executeCachedQuery(\"");
            connectionString.append(statement.replaceAll("\\n", " "));
            connectionString.append("\");\n");
            this.selectSQLTextPane.setSelectedText("\n" + connectionString.toString());
        }
        this.parent.setSaveEnabled(true);
    }

    public void setUpdateText(List<String> statements) {
        if (!this.useJavaScriptYesRadio.isSelected()) {
            for (String statement : statements) {
                this.postProcessSQLTextPane.setText(statement.replaceAll("\\?", "") + "\n\n" + this.postProcessSQLTextPane.getText());
            }
        } else {
            StringBuilder connectionString = new StringBuilder();
            for (String statement : statements) {
                connectionString.append("\tvar result = dbConn.executeUpdate(\"");
                connectionString.append(statement.replaceAll("\\n", " "));
                connectionString.append("\");\n");
            }
            this.postProcessSQLTextPane.setSelectedText("\n" + connectionString.toString());
        }
        this.parent.setSaveEnabled(true);
    }

    private void generateConnectionActionPerformed() {
        String connString = this.generateConnectionString();
        this.selectSQLTextPane.setText(connString + "\n\n" + this.selectSQLTextPane.getText());
        this.selectSQLTextPane.getTextArea().requestFocus();
        this.selectSQLTextPane.setCaretPosition(this.selectSQLTextPane.getText().lastIndexOf("\n\n", this.selectSQLTextPane.getText().length() - 3) + 1);
        this.parent.setSaveEnabled(true);
    }

    private String generateConnectionString() {
        StringBuilder connectionString = new StringBuilder();
        connectionString.append("var dbConn;\n");
        connectionString.append("\ntry {\n\tdbConn = DatabaseConnectionFactory.createDatabaseConnection('");
        connectionString.append(this.driverField.getText() + "','" + this.urlField.getText() + "','");
        connectionString.append(this.usernameField.getText() + "','" + new String(this.passwordField.getPassword()) + "');\n\n\t// You may access this result below with $('column_name')\n\treturn result;\n} finally {");
        connectionString.append("\n\tif (dbConn) { \n\t\tdbConn.close();\n\t}\n}");
        return connectionString.toString();
    }

    private String generateUpdateConnectionString() {
        StringBuilder connectionString = new StringBuilder();
        if (this.runPostProcessSQLEachRadio.isSelected()) {
            connectionString.append("// This update script will be executed once for every result returned from the above query.\n");
        } else {
            connectionString.append("// This update script will be executed once after all results have been processed.\n");
        }
        if (this.aggregateResultsYesRadio.isSelected()) {
            connectionString.append("// If \"Aggregate Results\" is enabled, you have access to \"results\",\n// a List of Map objects representing all rows returned from the above query.\n");
        }
        connectionString.append("var dbConn;\n");
        connectionString.append("\ntry {\n\tdbConn = DatabaseConnectionFactory.createDatabaseConnection('");
        connectionString.append(this.driverField.getText() + "','" + this.urlField.getText() + "','");
        connectionString.append(this.usernameField.getText() + "','" + new String(this.passwordField.getPassword()) + "');\n\n} finally {");
        connectionString.append("\n\tif (dbConn) { \n\t\tdbConn.close();\n\t}\n}");
        return connectionString.toString();
    }

    private void aggregateResultsActionPerformed(boolean aggregateResults) {
        if (aggregateResults) {
            this.cacheResultsYesRadio.setSelected(true);
            this.cacheResultsYesButtonActionPerformed();
            this.cacheResultsLabel.setEnabled(false);
            this.cacheResultsYesRadio.setEnabled(false);
            this.cacheResultsNoRadio.setEnabled(false);
            this.runPostProcessSQLEachRadio.setText("For each row");
            this.runPostProcessSQLEachRadio.setToolTipText("<html>Run the post-process statement/script for each row in the result set.</html>");
            this.runPostProcessSQLOnceRadio.setText("Once for all rows");
            this.runPostProcessSQLOnceRadio.setToolTipText("<html>Run the post-process statement/script only once.<br/>If JavaScript mode is used, a List of Maps representing all rows<br/>in the result set will be available as the variable \"results\".</html>");
        } else {
            this.cacheResultsLabel.setEnabled(this.useJavaScriptNoRadio.isSelected());
            this.cacheResultsYesRadio.setEnabled(this.useJavaScriptNoRadio.isSelected());
            this.cacheResultsNoRadio.setEnabled(this.useJavaScriptNoRadio.isSelected());
            if (this.cacheResultsYesRadio.isSelected()) {
                this.cacheResultsYesButtonActionPerformed();
            } else {
                this.cacheResultsNoButtonActionPerformed();
            }
            this.runPostProcessSQLEachRadio.setText("After each message");
            this.runPostProcessSQLEachRadio.setToolTipText("<html>Run the post-process statement/script after each message finishes processing.</html>");
            this.runPostProcessSQLOnceRadio.setText("Once after all messages");
            this.runPostProcessSQLOnceRadio.setToolTipText("<html>Run the post-process statement/script only after all messages have finished processing.</html>");
        }
    }

    private class UpdateSQLActionListener
    implements ActionListener {
        private UpdateSQLActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Parsing...");
            final String sqlStatement = DatabaseReader.this.selectSQLTextPane.getText();
            SwingWorker<String[], Void> worker = new SwingWorker<String[], Void>(){

                @Override
                public String[] doInBackground() {
                    return DatabaseReader.this.parseData(sqlStatement);
                }

                @Override
                public void done() {
                    Object[] data;
                    try {
                        data = (String[])this.get();
                    }
                    catch (Exception e) {
                        data = new String[]{};
                    }
                    DatabaseReader.this.dbVarList.setListData(data);
                    DatabaseReader.this.updateIncomingData((String[])data);
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
            };
            worker.execute();
        }
    }
}

