/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableListHandler;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.jdbc.DatabaseConnectionInfo;
import com.mirth.connect.connectors.jdbc.DatabaseDispatcherProperties;
import com.mirth.connect.connectors.jdbc.DatabaseDriversDialog;
import com.mirth.connect.connectors.jdbc.DatabaseMetadataDialog;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class DatabaseWriter
extends ConnectorSettingsPanel {
    private List<DriverInfo> drivers;
    private Frame parent;
    private AtomicBoolean driverAdjusting = new AtomicBoolean(false);
    private JLabel driverLabel;
    private MirthComboBox<DriverInfo> driverComboBox;
    private MirthTextField driverField;
    private JButton manageDriversButton;
    private JLabel urlLabel;
    private MirthTextField urlField;
    private JButton insertURLTemplateButton;
    private JLabel usernameLabel;
    private MirthTextField usernameField;
    private JLabel passwordLabel;
    private MirthPasswordField passwordField;
    private JLabel useJavaScriptLabel;
    private JPanel useJavaScriptRadioPanel;
    private MirthRadioButton useJavaScriptYesRadio;
    private MirthRadioButton useJavaScriptNoRadio;
    private JPanel generatePanel;
    private JLabel generateLabel;
    private JButton generateConnectionButton;
    private JButton generateInsertButton;
    private JLabel sqlLabel;
    private MirthRTextScrollPane sqlTextPane;

    public DatabaseWriter() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    public String getConnectorName() {
        return new DatabaseDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        DatabaseDispatcherProperties properties = new DatabaseDispatcherProperties();
        properties.setDriver(this.driverField.getText());
        properties.setUrl(this.urlField.getText());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setUseScript(this.useJavaScriptYesRadio.isSelected());
        properties.setQuery(this.sqlTextPane.getText());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(ConnectorProperties properties) {
        DatabaseDispatcherProperties props = (DatabaseDispatcherProperties)properties;
        boolean enabled = this.parent.isSaveEnabled();
        if (StringUtils.equals((CharSequence)props.getDriver(), (CharSequence)"Please Select One")) {
            this.driverField.setText("");
        } else {
            this.driverField.setText(props.getDriver());
        }
        this.driverAdjusting.set(true);
        try {
            this.updateDriverComboBoxFromField();
        }
        finally {
            this.driverAdjusting.set(false);
        }
        this.retrieveDatabaseDrivers(props.getDriver());
        this.parent.setSaveEnabled(enabled);
        this.urlField.setText(props.getUrl());
        this.usernameField.setText(props.getUsername());
        this.passwordField.setText(props.getPassword());
        if (props.isUseScript()) {
            this.useJavaScriptYesRadio.setSelected(true);
            this.useJavaScriptYesActionPerformed();
        } else {
            this.useJavaScriptNoRadio.setSelected(true);
            this.useJavaScriptNoActionPerformed();
        }
        this.sqlTextPane.setText(props.getQuery());
    }

    public ConnectorProperties getDefaults() {
        return new DatabaseDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        DatabaseDispatcherProperties props = (DatabaseDispatcherProperties)properties;
        boolean valid = true;
        if (!props.isUseScript() && props.getUrl().length() == 0) {
            valid = false;
            if (highlight) {
                this.urlField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getQuery().length() == 0) {
            valid = false;
            if (highlight) {
                this.sqlTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (StringUtils.isBlank((CharSequence)props.getDriver()) || props.getDriver().equals("Please Select One")) {
            valid = false;
            if (highlight) {
                this.driverComboBox.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return valid;
    }

    public VariableListHandler.TransferMode getTransferMode() {
        return ((DatabaseDispatcherProperties)this.getProperties()).isUseScript() ? VariableListHandler.TransferMode.JAVASCRIPT : VariableListHandler.TransferMode.VELOCITY;
    }

    public void resetInvalidProperties() {
        this.urlField.setBackground(null);
        this.sqlTextPane.setBackground(null);
        this.driverComboBox.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.sqlTextPane.updateDisplayOptions();
    }

    public String doValidate(ConnectorProperties properties, boolean highlight) {
        String script;
        DatabaseDispatcherProperties props = (DatabaseDispatcherProperties)properties;
        Object error = null;
        if (props.isUseScript() && (script = props.getQuery()).length() != 0) {
            Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
            try {
                context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
            }
            catch (EvaluatorException e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getConnectorName() + "\" at Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n";
            }
            catch (Exception e) {
                if (error == null) {
                    error = "";
                }
                error = (String)error + "Error in connector \"" + this.getConnectorName() + "\" at Javascript:\nUnknown error occurred during validation.";
            }
            Context.exit();
        }
        return error;
    }

    public List<String> getScripts(ConnectorProperties properties) {
        DatabaseDispatcherProperties props = (DatabaseDispatcherProperties)properties;
        ArrayList<String> scripts = new ArrayList<String>();
        if (props.isUseScript()) {
            scripts.add(props.getQuery());
        }
        return scripts;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.driverLabel = new JLabel("Driver:");
        this.driverComboBox = new MirthComboBox();
        this.driverComboBox.addActionListener(evt -> {
            if (!this.driverAdjusting.getAndSet(true)) {
                try {
                    this.updateDriverFieldFromComboBox();
                }
                finally {
                    this.driverAdjusting.set(false);
                }
            }
        });
        this.driverComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof DriverInfo) {
                    this.setText(((DriverInfo)value).getName());
                }
                return component;
            }
        });
        this.driverField = new MirthTextField();
        this.driverField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.update();
            }

            private void update() {
                if (!DatabaseWriter.this.driverAdjusting.getAndSet(true)) {
                    try {
                        DatabaseWriter.this.updateDriverComboBoxFromField();
                    }
                    finally {
                        DatabaseWriter.this.driverAdjusting.set(false);
                    }
                }
            }
        });
        this.updateDriversComboBox();
        this.manageDriversButton = new JButton(new ImageIcon(Frame.class.getResource("images/wrench.png")));
        this.manageDriversButton.addActionListener(evt -> {
            DatabaseDriversDialog dialog = new DatabaseDriversDialog((Window)this.parent, this.drivers);
            if (dialog.wasSaved()) {
                this.drivers = dialog.getDrivers();
                this.updateDriversComboBox();
            }
        });
        this.urlLabel = new JLabel("URL:");
        this.urlField = new MirthTextField();
        this.insertURLTemplateButton = new JButton("Insert URL Template");
        this.insertURLTemplateButton.addActionListener(evt -> this.insertURLTemplateButtonActionPerformed());
        this.usernameLabel = new JLabel("Username:");
        this.usernameField = new MirthTextField();
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.useJavaScriptLabel = new JLabel("Use JavaScript:");
        this.useJavaScriptRadioPanel = new JPanel();
        this.useJavaScriptRadioPanel.setBackground(this.getBackground());
        ButtonGroup useJavaScriptButtonGroup = new ButtonGroup();
        this.useJavaScriptYesRadio = new MirthRadioButton("Yes");
        this.useJavaScriptYesRadio.setBackground(this.getBackground());
        this.useJavaScriptYesRadio.addActionListener(evt -> this.useJavaScriptYesActionPerformed());
        useJavaScriptButtonGroup.add((AbstractButton)this.useJavaScriptYesRadio);
        this.useJavaScriptNoRadio = new MirthRadioButton("No");
        this.useJavaScriptNoRadio.setBackground(this.getBackground());
        this.useJavaScriptNoRadio.addActionListener(evt -> this.useJavaScriptNoActionPerformed());
        useJavaScriptButtonGroup.add((AbstractButton)this.useJavaScriptNoRadio);
        this.generateLabel = new JLabel("Generate:");
        this.generatePanel = new JPanel();
        this.generatePanel.setBackground(this.getBackground());
        this.generateConnectionButton = new JButton("Connection");
        this.generateConnectionButton.addActionListener(evt -> this.generateConnectionActionPerformed());
        this.generateInsertButton = new JButton("Insert");
        this.generateInsertButton.addActionListener(evt -> this.generateInsertActionPerformed());
        this.sqlLabel = new JLabel("SQL:");
        this.sqlTextPane = new MirthRTextScrollPane(ContextType.DESTINATION_DISPATCHER, true);
        this.sqlTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.sqlTextPane.setPreferredSize(new Dimension(470, 140));
    }

    private void initToolTips() {
        this.driverComboBox.setToolTipText("Specifies the type of database driver to use to connect to the database.");
        this.driverField.setToolTipText("The fully-qualified class name of the JDBC driver to use to connect to the database.");
        this.manageDriversButton.setToolTipText("<html>Click here to view and manage the list of database JDBC drivers.<br/>Any changes will require re-saving and redeploying the channel.</html>");
        this.urlField.setToolTipText("<html>The JDBC URL to connect to the database.<br>This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.usernameField.setToolTipText("<html>The username to connect to the database.<br>This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.passwordField.setToolTipText("<html>The password to connect to the database.<br>This is not used when \"Use JavaScript\" is checked.<br>However, it is used when the Insert Connection feature is used to generate code.</html>");
        this.useJavaScriptYesRadio.setToolTipText("Implement JavaScript code using JDBC to insert a message into the database.");
        this.useJavaScriptNoRadio.setToolTipText("Specify the SQL statements to insert a message into the database.");
        this.generateConnectionButton.setToolTipText("<html>If \"Yes\" is selected for Use JavaScript, this button is enabled.<br>When clicked, it inserts boilerplate Connection construction code into the JavaScript control at the current caret location.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6", "[]12[grow]", "[][][][][][grow]"));
        this.add(this.driverLabel, "right");
        this.add((Component)this.driverComboBox, "split 3");
        this.add((Component)this.driverField, "w 200!");
        this.add(this.manageDriversButton, "h 22!, w 22!");
        this.add(this.urlLabel, "newline, right");
        this.add((Component)this.urlField, "w 318!, split 2");
        this.add(this.insertURLTemplateButton);
        this.add(this.usernameLabel, "newline, right");
        this.add((Component)this.usernameField, "w 125!");
        this.add(this.passwordLabel, "newline, right");
        this.add((Component)this.passwordField, "w 125!");
        this.add(this.useJavaScriptLabel, "newline, right");
        this.generatePanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6", "[][grow][][][]"));
        this.generatePanel.add((Component)this.useJavaScriptYesRadio, "left");
        this.generatePanel.add((Component)this.useJavaScriptNoRadio, "left");
        this.generatePanel.add((Component)this.generateLabel, "right");
        this.generatePanel.add((Component)this.generateConnectionButton, "right, sg");
        this.generatePanel.add((Component)this.generateInsertButton, "right, sg");
        this.add(this.generatePanel, "growx, pushx, right");
        this.add(this.sqlLabel, "newline, top, right");
        this.add((Component)this.sqlTextPane, "grow");
    }

    private void retrieveDatabaseDrivers(String selectedDriver) {
        final String workingId = this.parent.startWorking("Retrieving database drivers...");
        SwingWorker<List<DriverInfo>, Void> worker = new SwingWorker<List<DriverInfo>, Void>(){

            @Override
            protected List<DriverInfo> doInBackground() throws Exception {
                return DatabaseWriter.this.parent.mirthClient.getDatabaseDrivers();
            }

            @Override
            protected void done() {
                try {
                    DatabaseWriter.this.drivers = (List)this.get();
                    boolean enabled = DatabaseWriter.this.parent.isSaveEnabled();
                    DatabaseWriter.this.updateDriversComboBox();
                    DatabaseWriter.this.parent.setSaveEnabled(enabled);
                    DatabaseWriter.this.parent.stopWorking(workingId);
                }
                catch (Exception e) {
                    DatabaseWriter.this.parent.stopWorking(workingId);
                    DatabaseWriter.this.parent.alertThrowable((Component)DatabaseWriter.this.parent, (Throwable)e, false);
                }
            }
        };
        worker.execute();
    }

    private DriverInfo getSelectedDriver() {
        DriverInfo selectedDriver = (DriverInfo)this.driverComboBox.getSelectedItem();
        if (selectedDriver == null) {
            selectedDriver = this.getSelectOneDriver();
        }
        return selectedDriver;
    }

    private DriverInfo getSelectOneDriver() {
        return new DriverInfo("Please Select One", "", "", "");
    }

    private DriverInfo getCustomDriver() {
        return new DriverInfo("Custom", "", "", "");
    }

    private void fixDriversList() {
        if (CollectionUtils.isEmpty(this.drivers)) {
            this.drivers = DriverInfo.getDefaultDrivers();
        }
        if (!StringUtils.equals((CharSequence)this.drivers.get(0).getName(), (CharSequence)"Please Select One")) {
            this.drivers.add(0, this.getSelectOneDriver());
        }
        if (!StringUtils.equals((CharSequence)this.drivers.get(this.drivers.size() - 1).getName(), (CharSequence)"Custom")) {
            this.drivers.add(this.getCustomDriver());
        }
    }

    private void updateDriversComboBox() {
        this.fixDriversList();
        this.driverAdjusting.set(true);
        try {
            this.driverComboBox.setModel(new DefaultComboBoxModel<DriverInfo>(this.drivers.toArray(new DriverInfo[this.drivers.size()])));
            this.updateDriverComboBoxFromField();
        }
        finally {
            this.driverAdjusting.set(false);
        }
    }

    private void updateDriverFieldFromComboBox() {
        DriverInfo driver = this.getSelectedDriver();
        if (!StringUtils.equals((CharSequence)driver.getName(), (CharSequence)"Custom")) {
            this.driverField.setText(driver.getClassName());
            this.driverField.setCaretPosition(0);
        }
    }

    private void updateDriverComboBoxFromField() {
        String driverClassName = this.driverField.getText();
        DriverInfo foundDriver = null;
        for (int i = 0; i < this.driverComboBox.getModel().getSize(); ++i) {
            DriverInfo driver = (DriverInfo)this.driverComboBox.getModel().getElementAt(i);
            if (StringUtils.equals((CharSequence)driverClassName, (CharSequence)driver.getClassName())) {
                foundDriver = driver;
                break;
            }
            if (!CollectionUtils.isNotEmpty((Collection)driver.getAlternativeClassNames())) continue;
            for (String alternativeClassName : driver.getAlternativeClassNames()) {
                if (!StringUtils.equals((CharSequence)driverClassName, (CharSequence)alternativeClassName)) continue;
                foundDriver = driver;
                break;
            }
            if (foundDriver != null) break;
        }
        if (foundDriver != null) {
            this.driverComboBox.setSelectedItem(foundDriver);
        } else {
            this.driverComboBox.setSelectedIndex(this.driverComboBox.getItemCount() - 1);
        }
    }

    private void generateInsertActionPerformed() {
        this.showDatabaseMetaData(DatabaseMetadataDialog.STATEMENT_TYPE.INSERT_TYPE);
    }

    private void insertURLTemplateButtonActionPerformed() {
        if (!this.urlField.getText().equals("") && !this.parent.alertOption((Component)this.parent, "Are you sure you would like to replace your current connection URL with the template URL?")) {
            return;
        }
        this.urlField.setText(this.getSelectedDriver().getTemplate());
        this.urlField.grabFocus();
        this.parent.setSaveEnabled(true);
    }

    public void showDatabaseMetaData(DatabaseMetadataDialog.STATEMENT_TYPE type) {
        DatabaseDispatcherProperties properties = (DatabaseDispatcherProperties)this.getProperties();
        if (properties.getUrl().length() == 0 || properties.getDriver().equals("Please Select One")) {
            this.parent.alertError((Component)this.parent, "A valid Driver and URL are required to perform this operation.");
        } else {
            Connector destinationConnector = (Connector)PlatformUI.MIRTH_FRAME.channelEditPanel.currentChannel.getDestinationConnectors().get(PlatformUI.MIRTH_FRAME.channelEditPanel.lastModelIndex);
            Set<String> resourceIds = ((Map)PlatformUI.MIRTH_FRAME.channelEditPanel.resourceIds.get(destinationConnector.getMetaDataId())).keySet();
            new DatabaseMetadataDialog(this, type, new DatabaseConnectionInfo(properties.getDriver(), properties.getUrl(), properties.getUsername(), properties.getPassword(), "", this.getSelectedDriver().getSelectLimit(), resourceIds));
        }
    }

    public void setInsertText(List<String> statements) {
        if (!this.useJavaScriptYesRadio.isSelected()) {
            for (String statement : statements) {
                this.sqlTextPane.setText(statement.replaceAll("\\?", "") + "\n\n" + this.sqlTextPane.getText());
            }
        } else {
            StringBuilder connectionString = new StringBuilder();
            for (String statement : statements) {
                connectionString.append("\tvar result = dbConn.executeUpdate(\"");
                connectionString.append(statement.replaceAll("\\n", " "));
                connectionString.append("\");\n");
            }
            this.sqlTextPane.setSelectedText("\n" + connectionString.toString());
        }
        this.parent.setSaveEnabled(true);
    }

    private String generateConnectionString() {
        StringBuilder connectionString = new StringBuilder();
        connectionString.append("var dbConn;\n");
        connectionString.append("\ntry {\n\tdbConn = DatabaseConnectionFactory.createDatabaseConnection('");
        connectionString.append(this.driverField.getText() + "','" + this.urlField.getText() + "','");
        connectionString.append(this.usernameField.getText() + "','" + new String(this.passwordField.getPassword()) + "');\n\n} finally {");
        connectionString.append("\n\tif (dbConn) { \n\t\tdbConn.close();\n\t}\n}");
        return connectionString.toString();
    }

    private void generateConnectionActionPerformed() {
        this.sqlTextPane.setText(this.generateConnectionString() + "\n\n" + this.sqlTextPane.getText());
        this.sqlTextPane.getTextArea().requestFocus();
        this.sqlTextPane.setCaretPosition(this.sqlTextPane.getText().lastIndexOf("\n\n", this.sqlTextPane.getText().length() - 3) + 1);
        this.parent.setSaveEnabled(true);
    }

    private void useJavaScriptYesActionPerformed() {
        this.sqlLabel.setText("JavaScript:");
        this.sqlTextPane.setSyntaxEditingStyle("text/javascript");
        this.sqlTextPane.setText(this.generateConnectionString());
        this.generateConnectionButton.setEnabled(true);
        this.parent.channelEditPanel.destinationVariableList.setTransferMode(VariableListHandler.TransferMode.JAVASCRIPT);
    }

    private void useJavaScriptNoActionPerformed() {
        this.sqlLabel.setText("SQL:");
        this.sqlTextPane.setSyntaxEditingStyle("text/sql");
        this.sqlTextPane.setText("");
        this.generateConnectionButton.setEnabled(false);
        this.parent.channelEditPanel.destinationVariableList.setTransferMode(VariableListHandler.TransferMode.VELOCITY);
    }
}

