/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.doc;

import com.mirth.connect.connectors.doc.Unit;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DocumentDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    private String host;
    private String outputPattern;
    private String documentType;
    private boolean encrypt;
    private String output;
    private String password;
    private String pageWidth;
    private String pageHeight;
    private Unit pageUnit;
    private String template;
    public static final String DOCUMENT_TYPE_PDF = "pdf";
    public static final String DOCUMENT_TYPE_RTF = "rtf";
    public static final String OUTPUT_TYPE = "FILE";

    public DocumentDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties();
        this.host = "";
        this.outputPattern = "";
        this.documentType = DOCUMENT_TYPE_PDF;
        this.encrypt = false;
        this.password = "";
        this.pageWidth = "8.5";
        this.pageHeight = "11";
        this.pageUnit = Unit.INCHES;
        this.template = "";
        this.output = OUTPUT_TYPE;
    }

    public DocumentDispatcherProperties(DocumentDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.host = props.getHost();
        this.outputPattern = props.getOutputPattern();
        this.documentType = props.getDocumentType();
        this.encrypt = props.isEncrypt();
        this.password = props.getPassword();
        this.pageWidth = props.getPageWidth();
        this.pageHeight = props.getPageHeight();
        this.pageUnit = props.getPageUnit();
        this.template = props.getTemplate();
        this.output = props.getOutput();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
    }

    public Unit getPageUnit() {
        return this.pageUnit;
    }

    public void setPageUnit(Unit pageUnit) {
        this.pageUnit = pageUnit;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getProtocol() {
        return "doc";
    }

    public String getName() {
        return "Document Writer";
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        if (StringUtils.isNotBlank((CharSequence)this.output)) {
            builder.append("OUTPUT: ");
            if (this.output.equalsIgnoreCase("file")) {
                builder.append("File");
            } else if (this.output.equalsIgnoreCase("attachment")) {
                builder.append("Attachment");
            } else if (this.output.equalsIgnoreCase("both")) {
                builder.append("File and Attachment");
            }
            builder.append(newLine);
        }
        if (StringUtils.isBlank((CharSequence)this.output) || !this.output.equalsIgnoreCase("attachment")) {
            builder.append("URI: ");
            this.appendURIString(builder);
            builder.append(newLine);
        }
        builder.append("DOCUMENT TYPE: ");
        builder.append(this.documentType);
        builder.append(newLine);
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.template);
        return builder.toString();
    }

    public String toURIString() {
        StringBuilder builder = new StringBuilder();
        this.appendURIString(builder);
        return builder.toString();
    }

    private void appendURIString(StringBuilder builder) {
        builder.append(this.host);
        if (this.host.charAt(this.host.length() - 1) != '/') {
            builder.append("/");
        }
        builder.append(this.outputPattern);
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new DocumentDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return false;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
        if (element.getChildElement("documentType").getTextContent().equals(DOCUMENT_TYPE_RTF)) {
            element.addChildElement("pageWidth", "210");
            element.addChildElement("pageHeight", "297");
            element.addChildElement("pageUnit", "MM");
        } else {
            element.addChildElement("pageWidth", "8.5");
            element.addChildElement("pageHeight", "11");
            element.addChildElement("pageUnit", "INCHES");
        }
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("documentType", this.documentType);
        purgedProperties.put("encrypt", this.encrypt);
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        return purgedProperties;
    }
}

