/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.client.ui.AbstractConnectorPropertiesPanel;
import com.mirth.connect.client.ui.CharsetEncodingInformation;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.tcp.TcpReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.plugins.BasicModeClientProvider;
import com.mirth.connect.plugins.ConnectorPropertiesPlugin;
import com.mirth.connect.plugins.TransmissionModeClientProvider;
import com.mirth.connect.plugins.TransmissionModePlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class TcpListener
extends ConnectorSettingsPanel
implements ActionListener {
    public static final String NEW_CONNECTION_PLUGIN_PROPS = "tcpListenerNewConnectionPluginProperties";
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private TransmissionModeClientProvider defaultProvider;
    private TransmissionModeClientProvider transmissionModeProvider;
    private String selectedMode;
    private boolean modeLock = false;
    private JLabel transmissionModeLabel;
    private MirthComboBox<String> transmissionModeComboBox;
    private JPanel settingsPlaceHolder;
    private JLabel sampleLabel;
    private JLabel sampleValue;
    private JLabel modeLabel;
    public MirthRadioButton modeServerRadio;
    public MirthRadioButton modeClientRadio;
    private JLabel remoteAddressLabel;
    private MirthTextField remoteAddressField;
    private JLabel remotePortLabel;
    private MirthTextField remotePortField;
    private JLabel overrideLocalBindingLabel;
    private MirthRadioButton overrideLocalBindingYesRadio;
    private MirthRadioButton overrideLocalBindingNoRadio;
    private JLabel reconnectIntervalLabel;
    private MirthTextField reconnectIntervalField;
    private JLabel maxConnectionsLabel;
    private MirthTextField maxConnectionsField;
    private JLabel receiveTimeoutLabel;
    private MirthTextField receiveTimeoutField;
    private JLabel bufferSizeLabel;
    private MirthTextField bufferSizeField;
    private JLabel keepConnectionOpenLabel;
    private MirthRadioButton keepConnectionOpenYesRadio;
    private MirthRadioButton keepConnectionOpenNoRadio;
    private JLabel dataTypeLabel;
    private MirthRadioButton dataTypeBinaryRadio;
    private MirthRadioButton dataTypeTextRadio;
    private JLabel charsetEncodingLabel;
    private MirthComboBox<CharsetEncodingInformation> charsetEncodingComboBox;
    private JLabel respondOnNewConnectionLabel;
    private MirthRadioButton respondOnNewConnectionYesRadio;
    private MirthRadioButton respondOnNewConnectionNoRadio;
    private MirthRadioButton respondOnNewConnectionRecoveryRadio;
    private JLabel responseAddressLabel;
    private MirthTextField responseAddressField;
    private JLabel responsePortLabel;
    private MirthTextField responsePortField;
    private AbstractConnectorPropertiesPanel responseConnectorPropertiesPanel;

    public TcpListener() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.reconnectIntervalField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.receiveTimeoutField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.bufferSizeField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        this.maxConnectionsField.setDocument((Document)new MirthFieldConstraints(0, false, false, true));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("Basic TCP");
        this.selectedMode = "Basic TCP";
        for (String pluginPointName : LoadedExtensions.getInstance().getTransmissionModePlugins().keySet()) {
            model.addElement(pluginPointName);
            if (!pluginPointName.equals("MLLP")) continue;
            this.defaultProvider = ((TransmissionModePlugin)LoadedExtensions.getInstance().getTransmissionModePlugins().get(pluginPointName)).createProvider();
        }
        this.transmissionModeComboBox.setModel(model);
        this.parent.setupCharsetEncodingForConnector(this.charsetEncodingComboBox);
    }

    public String getConnectorName() {
        return new TcpReceiverProperties().getName();
    }

    public ConnectorProperties getProperties() {
        TcpReceiverProperties properties = new TcpReceiverProperties();
        if (this.transmissionModeProvider != null) {
            properties.setTransmissionModeProperties(this.transmissionModeProvider.getProperties());
        }
        properties.setServerMode(this.modeServerRadio.isSelected());
        properties.setRemoteAddress(this.remoteAddressField.getText());
        properties.setRemotePort(this.remotePortField.getText());
        properties.setOverrideLocalBinding(this.overrideLocalBindingYesRadio.isSelected());
        properties.setReconnectInterval(this.reconnectIntervalField.getText());
        properties.setReceiveTimeout(this.receiveTimeoutField.getText());
        properties.setBufferSize(this.bufferSizeField.getText());
        properties.setMaxConnections(this.maxConnectionsField.getText());
        properties.setKeepConnectionOpen(this.keepConnectionOpenYesRadio.isSelected());
        properties.setCharsetEncoding(this.parent.getSelectedEncodingForConnector(this.charsetEncodingComboBox));
        properties.setDataTypeBinary(this.dataTypeBinaryRadio.isSelected());
        if (this.respondOnNewConnectionYesRadio.isSelected()) {
            properties.setRespondOnNewConnection(1);
        } else if (this.respondOnNewConnectionNoRadio.isSelected()) {
            properties.setRespondOnNewConnection(0);
        } else if (this.respondOnNewConnectionRecoveryRadio.isSelected()) {
            properties.setRespondOnNewConnection(2);
        }
        properties.setResponseAddress(this.responseAddressField.getText());
        properties.setResponsePort(this.responsePortField.getText());
        if (this.responseConnectorPropertiesPanel != null) {
            HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
            connectorPluginProperties.add(this.responseConnectorPropertiesPanel.getProperties());
            properties.setResponseConnectorPluginProperties(connectorPluginProperties);
        }
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        TcpReceiverProperties props = (TcpReceiverProperties)properties;
        TransmissionModeProperties modeProps = props.getTransmissionModeProperties();
        String name = "Basic TCP";
        if (modeProps != null && LoadedExtensions.getInstance().getTransmissionModePlugins().containsKey(modeProps.getPluginPointName())) {
            name = modeProps.getPluginPointName();
        }
        this.modeLock = true;
        this.transmissionModeComboBox.setSelectedItem((Object)name);
        this.transmissionModeComboBoxActionPerformed();
        this.modeLock = false;
        this.selectedMode = name;
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.setProperties(modeProps);
        }
        if (props.isServerMode()) {
            this.modeServerRadio.setSelected(true);
            this.modeServerRadioActionPerformed();
        } else {
            this.modeClientRadio.setSelected(true);
            this.modeClientRadioActionPerformed();
        }
        this.remoteAddressField.setText(props.getRemoteAddress());
        this.remotePortField.setText(props.getRemotePort());
        if (props.isOverrideLocalBinding()) {
            this.overrideLocalBindingYesRadio.setSelected(true);
        } else {
            this.overrideLocalBindingNoRadio.setSelected(true);
        }
        this.reconnectIntervalField.setText(props.getReconnectInterval());
        this.receiveTimeoutField.setText(props.getReceiveTimeout());
        this.bufferSizeField.setText(props.getBufferSize());
        this.maxConnectionsField.setText(props.getMaxConnections());
        if (props.isKeepConnectionOpen()) {
            this.keepConnectionOpenYesRadio.setSelected(true);
        } else {
            this.keepConnectionOpenNoRadio.setSelected(true);
        }
        if (props.isDataTypeBinary()) {
            this.dataTypeBinaryRadio.setSelected(true);
            this.dataTypeBinaryRadioActionPerformed();
        } else {
            this.dataTypeTextRadio.setSelected(true);
            this.dataTypeASCIIRadioActionPerformed();
        }
        this.parent.setPreviousSelectedEncodingForConnector(this.charsetEncodingComboBox, props.getCharsetEncoding());
        if (this.responseConnectorPropertiesPanel != null) {
            ConnectorPluginProperties pluginProperties;
            HashSet<ConnectorPluginProperties> connectorPluginProperties = props.getResponseConnectorPluginProperties();
            if (CollectionUtils.isEmpty((Collection)connectorPluginProperties)) {
                connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
                connectorPluginProperties.add(this.responseConnectorPropertiesPanel.getDefaults());
            }
            if (!((pluginProperties = (ConnectorPluginProperties)connectorPluginProperties.iterator().next()) instanceof InvalidConnectorPluginProperties)) {
                this.responseConnectorPropertiesPanel.setProperties(properties, pluginProperties, Connector.Mode.DESTINATION, props.getName());
            }
        }
        switch (props.getRespondOnNewConnection()) {
            case 1: {
                this.respondOnNewConnectionYesRadio.setSelected(true);
                this.respondOnNewConnectionYesRadioActionPerformed();
                break;
            }
            case 0: {
                this.respondOnNewConnectionNoRadio.setSelected(true);
                this.respondOnNewConnectionNoRadioActionPerformed();
                break;
            }
            case 2: {
                this.respondOnNewConnectionRecoveryRadio.setSelected(true);
                this.respondOnNewConnectionRecoveryRadioActionPerformed();
            }
        }
        this.responseAddressField.setText(props.getResponseAddress());
        this.responsePortField.setText(props.getResponsePort());
    }

    public ConnectorProperties getDefaults() {
        TcpReceiverProperties props = new TcpReceiverProperties();
        if (this.defaultProvider != null) {
            props.setTransmissionModeProperties(this.defaultProvider.getDefaultProperties());
        }
        if (this.responseConnectorPropertiesPanel != null) {
            HashSet<ConnectorPluginProperties> connectorPluginProperties = new HashSet<ConnectorPluginProperties>();
            connectorPluginProperties.add(this.responseConnectorPropertiesPanel.getDefaults());
            props.setResponseConnectorPluginProperties(connectorPluginProperties);
        }
        return props;
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        TcpReceiverProperties props = (TcpReceiverProperties)properties;
        boolean valid = true;
        if (this.transmissionModeProvider != null && !this.transmissionModeProvider.checkProperties(this.transmissionModeProvider.getProperties(), highlight)) {
            valid = false;
        }
        if (!props.isServerMode()) {
            if (props.getRemoteAddress().length() == 0) {
                valid = false;
                if (highlight) {
                    this.remoteAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getRemotePort().length() == 0) {
                valid = false;
                if (highlight) {
                    this.remotePortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getReconnectInterval().length() == 0) {
                valid = false;
                if (highlight) {
                    this.reconnectIntervalField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.getReceiveTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.receiveTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getBufferSize().length() == 0) {
            valid = false;
            if (highlight) {
                this.bufferSizeField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getMaxConnections().length() == 0 || NumberUtils.toInt((String)props.getMaxConnections()) <= 0) {
            valid = false;
            if (highlight) {
                this.maxConnectionsField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getRespondOnNewConnection() == 1 || props.getRespondOnNewConnection() == 2) {
            if (props.getResponseAddress().length() <= 3) {
                valid = false;
                if (highlight) {
                    this.responseAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getResponsePort().length() == 0) {
                valid = false;
                if (highlight) {
                    this.responsePortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (this.responseConnectorPropertiesPanel != null && props.getResponseConnectorPluginProperties() != null) {
            for (ConnectorPluginProperties pluginProperties : props.getResponseConnectorPluginProperties()) {
                if (pluginProperties instanceof InvalidConnectorPluginProperties) continue;
                this.responseConnectorPropertiesPanel.checkProperties((ConnectorProperties)props, pluginProperties, Connector.Mode.DESTINATION, props.getName(), highlight);
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.resetInvalidProperties();
        }
        this.remoteAddressField.setBackground(null);
        this.remotePortField.setBackground(null);
        this.reconnectIntervalField.setBackground(null);
        this.receiveTimeoutField.setBackground(null);
        this.bufferSizeField.setBackground(null);
        this.maxConnectionsField.setBackground(null);
        this.responseAddressField.setBackground(null);
        this.responsePortField.setBackground(null);
        if (this.responseConnectorPropertiesPanel != null) {
            this.responseConnectorPropertiesPanel.resetInvalidProperties();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.transmissionModeProvider)) {
            if (evt.getActionCommand().equals("changesamplelabel")) {
                this.sampleLabel.setText(this.transmissionModeProvider.getSampleLabel());
            } else if (evt.getActionCommand().equals("changesamplevalue")) {
                this.sampleValue.setText(this.transmissionModeProvider.getSampleValue());
            }
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.transmissionModeLabel = new JLabel("Transmission Mode:");
        this.transmissionModeComboBox = new MirthComboBox();
        this.transmissionModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.transmissionModeComboBoxActionPerformed();
            }
        });
        this.settingsPlaceHolder = new JPanel();
        this.sampleLabel = new JLabel("Sample Frame:");
        this.sampleValue = new JLabel("<html><b>&lt;VT&gt;</b> <i>&lt;Message Data&gt;</i> <b>&lt;FS&gt;&lt;CR&gt;</b></html>");
        this.sampleValue.setForeground(new Color(153, 153, 153));
        this.sampleValue.setEnabled(false);
        this.modeLabel = new JLabel("Mode:");
        ButtonGroup modeButtonGroup = new ButtonGroup();
        this.modeServerRadio = new MirthRadioButton("Server");
        this.modeServerRadio.setBackground(this.getBackground());
        this.modeServerRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.modeServerRadioActionPerformed();
            }
        });
        modeButtonGroup.add((AbstractButton)this.modeServerRadio);
        this.modeClientRadio = new MirthRadioButton("Client");
        this.modeClientRadio.setBackground(this.getBackground());
        this.modeClientRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.modeClientRadioActionPerformed();
            }
        });
        modeButtonGroup.add((AbstractButton)this.modeClientRadio);
        this.remoteAddressLabel = new JLabel("Remote Address:");
        this.remoteAddressField = new MirthTextField();
        this.remotePortLabel = new JLabel("Remote Port:");
        this.remotePortField = new MirthTextField();
        this.overrideLocalBindingLabel = new JLabel("Override Local Binding:");
        ButtonGroup overrideLocalBindingButtonGroup = new ButtonGroup();
        this.overrideLocalBindingYesRadio = new MirthRadioButton("Yes");
        this.overrideLocalBindingYesRadio.setBackground(this.getBackground());
        overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingYesRadio);
        this.overrideLocalBindingNoRadio = new MirthRadioButton("No");
        this.overrideLocalBindingNoRadio.setBackground(this.getBackground());
        overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingNoRadio);
        this.reconnectIntervalLabel = new JLabel("Reconnect Interval (ms):");
        this.reconnectIntervalField = new MirthTextField();
        this.maxConnectionsLabel = new JLabel("Max Connections:");
        this.maxConnectionsField = new MirthTextField();
        this.receiveTimeoutLabel = new JLabel("Receive Timeout (ms):");
        this.receiveTimeoutField = new MirthTextField();
        this.bufferSizeLabel = new JLabel("Buffer Size (bytes):");
        this.bufferSizeField = new MirthTextField();
        this.keepConnectionOpenLabel = new JLabel("Keep Connection Open:");
        ButtonGroup keepConnectionOpenGroup = new ButtonGroup();
        this.keepConnectionOpenYesRadio = new MirthRadioButton("Yes");
        this.keepConnectionOpenYesRadio.setBackground(this.getBackground());
        keepConnectionOpenGroup.add((AbstractButton)this.keepConnectionOpenYesRadio);
        this.keepConnectionOpenNoRadio = new MirthRadioButton("No");
        this.keepConnectionOpenNoRadio.setBackground(this.getBackground());
        keepConnectionOpenGroup.add((AbstractButton)this.keepConnectionOpenNoRadio);
        this.dataTypeLabel = new JLabel("Data Type:");
        ButtonGroup dataTypeButtonGroup = new ButtonGroup();
        this.dataTypeBinaryRadio = new MirthRadioButton("Binary");
        this.dataTypeBinaryRadio.setBackground(this.getBackground());
        this.dataTypeBinaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.dataTypeBinaryRadioActionPerformed();
            }
        });
        dataTypeButtonGroup.add((AbstractButton)this.dataTypeBinaryRadio);
        this.dataTypeTextRadio = new MirthRadioButton("Text");
        this.dataTypeTextRadio.setBackground(this.getBackground());
        this.dataTypeTextRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.dataTypeASCIIRadioActionPerformed();
            }
        });
        dataTypeButtonGroup.add((AbstractButton)this.dataTypeTextRadio);
        this.charsetEncodingLabel = new JLabel("Encoding:");
        this.charsetEncodingComboBox = new MirthComboBox();
        this.respondOnNewConnectionLabel = new JLabel("Respond on New Connection:");
        ButtonGroup respondOnNewConnectionButtonGroup = new ButtonGroup();
        this.respondOnNewConnectionYesRadio = new MirthRadioButton("Yes");
        this.respondOnNewConnectionYesRadio.setBackground(this.getBackground());
        this.respondOnNewConnectionYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.respondOnNewConnectionYesRadioActionPerformed();
            }
        });
        respondOnNewConnectionButtonGroup.add((AbstractButton)this.respondOnNewConnectionYesRadio);
        this.respondOnNewConnectionNoRadio = new MirthRadioButton("No");
        this.respondOnNewConnectionNoRadio.setBackground(this.getBackground());
        this.respondOnNewConnectionNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.respondOnNewConnectionNoRadioActionPerformed();
            }
        });
        respondOnNewConnectionButtonGroup.add((AbstractButton)this.respondOnNewConnectionNoRadio);
        this.respondOnNewConnectionRecoveryRadio = new MirthRadioButton("Message Recovery");
        this.respondOnNewConnectionRecoveryRadio.setBackground(this.getBackground());
        this.respondOnNewConnectionRecoveryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TcpListener.this.respondOnNewConnectionRecoveryRadioActionPerformed();
            }
        });
        respondOnNewConnectionButtonGroup.add((AbstractButton)this.respondOnNewConnectionRecoveryRadio);
        this.responseAddressLabel = new JLabel("Response Address:");
        this.responseAddressField = new MirthTextField();
        this.responsePortLabel = new JLabel("Response Port:");
        this.responsePortField = new MirthTextField();
    }

    private void initToolTips() {
        String toolTipText = "<html>Select the transmission mode to use for sending and receiving data.<br/></html>";
        this.transmissionModeLabel.setToolTipText(toolTipText);
        this.transmissionModeComboBox.setToolTipText(toolTipText);
        toolTipText = "<html>Select Server to listen for connections from clients, or Client to connect to a TCP Server.<br/>In Client mode, the listener settings will only be used if Override Local Binding is enabled.</html>";
        this.modeServerRadio.setToolTipText(toolTipText);
        this.modeClientRadio.setToolTipText(toolTipText);
        this.remoteAddressField.setToolTipText("<html>The DNS domain name or IP address on which to connect.</html>");
        this.remotePortField.setToolTipText("<html>The port on which to connect.</html>");
        toolTipText = "<html>Select Yes to override the local address and port that the client socket will be bound to.<br/>Select No to use the default values of 0.0.0.0:0.<br/>A local port of zero (0) indicates that the OS should assign an ephemeral port automatically.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>";
        this.overrideLocalBindingYesRadio.setToolTipText(toolTipText);
        this.overrideLocalBindingNoRadio.setToolTipText(toolTipText);
        this.reconnectIntervalField.setToolTipText("<html>If Client mode is selected, enter the time (in milliseconds) to wait<br/>between disconnecting from the TCP server and connecting to it again.</html>");
        this.maxConnectionsField.setToolTipText("<html>The maximum number of client connections to accept.<br/>After this number has been reached, subsequent socket requests will result in a rejection.</html>");
        this.receiveTimeoutField.setToolTipText("The amount of time, in milliseconds, to wait without receiving a message before closing a connection.");
        this.bufferSizeField.setToolTipText("<html>Use larger values for larger messages, and smaller values <br>for smaller messages. Generally, the default value is fine.</html>");
        toolTipText = "<html>Select No to close the listening socket after a received message has finished processing.<br/>Otherwise the socket will remain open until the sending system closes it. In that case,<br/>messages will only be processed if data is received and either the receive timeout is reached,<br/>the client closes the socket, or an end of message byte sequence has been detected.</html>";
        this.keepConnectionOpenYesRadio.setToolTipText(toolTipText);
        this.keepConnectionOpenNoRadio.setToolTipText(toolTipText);
        toolTipText = "<html>Select Binary if the inbound messages are raw byte streams; the payload will be Base64 encoded.<br>Select Text if the inbound messages are text streams; the payload will be encoded with the specified character set encoding.</html>";
        this.dataTypeBinaryRadio.setToolTipText(toolTipText);
        this.dataTypeTextRadio.setToolTipText(toolTipText);
        this.charsetEncodingComboBox.setToolTipText("<html>Select the character set encoding used by the message sender,<br/>or Select Default to use the default character set encoding for the JVM running BridgeLink.</html>");
        toolTipText = "<html>Select No to send responses only via the same connection the inbound message was received on.<br/>Select Yes to always send responses on a new connection (during normal processing as well as recovery).<br/>Select Message Recovery to only send responses on a new connection during message recovery.<br/>Connections will be bound locally on the same interface chosen in the Listener Settings with an ephemeral port.</html>";
        this.respondOnNewConnectionYesRadio.setToolTipText(toolTipText);
        this.respondOnNewConnectionNoRadio.setToolTipText(toolTipText);
        this.respondOnNewConnectionRecoveryRadio.setToolTipText(toolTipText);
        this.responseAddressField.setToolTipText("<html>Enter the DNS domain name or IP address to send message responses to.</html>");
        this.responsePortField.setToolTipText("<html>Enter the port to send message responses to.</html>");
        for (ConnectorPropertiesPlugin connectorPropertiesPlugin : LoadedExtensions.getInstance().getConnectorPropertiesPlugins().values()) {
            if (!connectorPropertiesPlugin.isConnectorPropertiesPluginSupported(NEW_CONNECTION_PLUGIN_PROPS)) continue;
            this.responseConnectorPropertiesPanel = connectorPropertiesPlugin.getConnectorPropertiesPanel();
        }
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, gap 12 6", "", "[][]4[]4[][]4[]4[][][][]4[]4[]4[]4[]4[][]"));
        this.add(this.transmissionModeLabel, "right");
        this.add((Component)this.transmissionModeComboBox, "h 22!, split 2");
        this.settingsPlaceHolder.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.add(this.settingsPlaceHolder, "gapbefore 6, h 22!");
        this.add(this.sampleLabel, "newline, right");
        this.add(this.sampleValue, "growx, sx");
        this.add(this.modeLabel, "newline, right");
        this.add((Component)this.modeServerRadio, "split 2");
        this.add((Component)this.modeClientRadio);
        this.add(this.remoteAddressLabel, "newline, right");
        this.add((Component)this.remoteAddressField, "w 200!, sx");
        this.add(this.remotePortLabel, "newline, right");
        this.add((Component)this.remotePortField, "w 50!, sx");
        this.add(this.overrideLocalBindingLabel, "newline, right");
        this.add((Component)this.overrideLocalBindingYesRadio, "split 2");
        this.add((Component)this.overrideLocalBindingNoRadio);
        this.add(this.reconnectIntervalLabel, "newline, right");
        this.add((Component)this.reconnectIntervalField, "w 75!, sx");
        this.add(this.maxConnectionsLabel, "newline, right");
        this.add((Component)this.maxConnectionsField, "w 75!, sx");
        this.add(this.receiveTimeoutLabel, "newline, right");
        this.add((Component)this.receiveTimeoutField, "w 75!, sx");
        this.add(this.bufferSizeLabel, "newline, right");
        this.add((Component)this.bufferSizeField, "w 75!, sx");
        this.add(this.keepConnectionOpenLabel, "newline, right");
        this.add((Component)this.keepConnectionOpenYesRadio, "split 2");
        this.add((Component)this.keepConnectionOpenNoRadio);
        this.add(this.dataTypeLabel, "newline, right");
        this.add((Component)this.dataTypeBinaryRadio, "split 2");
        this.add((Component)this.dataTypeTextRadio);
        this.add(this.charsetEncodingLabel, "newline, right");
        this.add((Component)this.charsetEncodingComboBox);
        this.add(this.respondOnNewConnectionLabel, "newline, right");
        this.add((Component)this.respondOnNewConnectionYesRadio, "split 3");
        this.add((Component)this.respondOnNewConnectionNoRadio);
        this.add((Component)this.respondOnNewConnectionRecoveryRadio);
        this.add(this.responseAddressLabel, "newline, right");
        this.add((Component)this.responseAddressField, "w 200!, sx");
        this.add(this.responsePortLabel, "newline, right");
        this.add((Component)this.responsePortField, "w 50!, sx");
        if (this.responseConnectorPropertiesPanel != null && this.responseConnectorPropertiesPanel.getLayoutComponents() != null) {
            Component[][] components = this.responseConnectorPropertiesPanel.getLayoutComponents();
            for (int row = 0; row < components.length; ++row) {
                Component[] componentRow = components[row];
                for (int column = 0; column < componentRow.length; ++column) {
                    if (column == 0) {
                        if (row == 0) {
                            this.add(componentRow[column], "newline, right, gaptop 4");
                            continue;
                        }
                        this.add(componentRow[column], "newline, right");
                        continue;
                    }
                    this.add(componentRow[column]);
                }
            }
        }
    }

    private void dataTypeBinaryRadioActionPerformed() {
        this.charsetEncodingLabel.setEnabled(false);
        this.charsetEncodingComboBox.setEnabled(false);
        this.charsetEncodingComboBox.setSelectedIndex(0);
    }

    private void dataTypeASCIIRadioActionPerformed() {
        this.charsetEncodingLabel.setEnabled(true);
        this.charsetEncodingComboBox.setEnabled(true);
    }

    private void modeClientRadioActionPerformed() {
        this.remoteAddressLabel.setEnabled(true);
        this.remoteAddressField.setEnabled(true);
        this.remotePortLabel.setEnabled(true);
        this.remotePortField.setEnabled(true);
        this.overrideLocalBindingLabel.setEnabled(true);
        this.overrideLocalBindingYesRadio.setEnabled(true);
        this.overrideLocalBindingNoRadio.setEnabled(true);
        this.reconnectIntervalLabel.setEnabled(true);
        this.reconnectIntervalField.setEnabled(true);
        this.maxConnectionsLabel.setEnabled(false);
        this.maxConnectionsField.setEnabled(false);
    }

    private void modeServerRadioActionPerformed() {
        this.remoteAddressLabel.setEnabled(false);
        this.remoteAddressField.setEnabled(false);
        this.remotePortLabel.setEnabled(false);
        this.remotePortField.setEnabled(false);
        this.overrideLocalBindingLabel.setEnabled(false);
        this.overrideLocalBindingYesRadio.setEnabled(false);
        this.overrideLocalBindingNoRadio.setEnabled(false);
        this.reconnectIntervalLabel.setEnabled(false);
        this.reconnectIntervalField.setEnabled(false);
        this.maxConnectionsLabel.setEnabled(true);
        this.maxConnectionsField.setEnabled(true);
    }

    private void transmissionModeComboBoxActionPerformed() {
        String name = (String)this.transmissionModeComboBox.getSelectedItem();
        if (!this.modeLock && this.transmissionModeProvider != null && !this.transmissionModeProvider.getDefaultProperties().equals((Object)this.transmissionModeProvider.getProperties()) && JOptionPane.showConfirmDialog((Component)this.parent, "Are you sure you would like to change the transmission mode and lose all of the current transmission properties?", "Select an Option", 0) != 0) {
            this.modeLock = true;
            this.transmissionModeComboBox.setSelectedItem((Object)this.selectedMode);
            this.modeLock = false;
            return;
        }
        this.selectedMode = name;
        if (name.equals("Basic TCP")) {
            this.transmissionModeProvider = new BasicModeClientProvider();
        } else {
            for (TransmissionModePlugin plugin : LoadedExtensions.getInstance().getTransmissionModePlugins().values()) {
                if (!plugin.getPluginPointName().equals(name)) continue;
                this.transmissionModeProvider = plugin.createProvider();
            }
        }
        if (this.transmissionModeProvider != null) {
            this.transmissionModeProvider.initialize((ActionListener)this);
            this.settingsPlaceHolder.removeAll();
            this.settingsPlaceHolder.add(this.transmissionModeProvider.getSettingsComponent());
        }
    }

    private void respondOnNewConnectionRecoveryRadioActionPerformed() {
        this.responseAddressField.setEnabled(true);
        this.responsePortField.setEnabled(true);
        this.responseAddressLabel.setEnabled(true);
        this.responsePortLabel.setEnabled(true);
        if (this.responseConnectorPropertiesPanel != null) {
            this.responseConnectorPropertiesPanel.setLayoutComponentsEnabled(true);
        }
    }

    private void respondOnNewConnectionNoRadioActionPerformed() {
        this.responseAddressField.setEnabled(false);
        this.responsePortField.setEnabled(false);
        this.responseAddressLabel.setEnabled(false);
        this.responsePortLabel.setEnabled(false);
        if (this.responseConnectorPropertiesPanel != null) {
            this.responseConnectorPropertiesPanel.setLayoutComponentsEnabled(false);
        }
    }

    private void respondOnNewConnectionYesRadioActionPerformed() {
        this.responseAddressField.setEnabled(true);
        this.responsePortField.setEnabled(true);
        this.responseAddressLabel.setEnabled(true);
        this.responsePortLabel.setEnabled(true);
        if (this.responseConnectorPropertiesPanel != null) {
            this.responseConnectorPropertiesPanel.setLayoutComponentsEnabled(true);
        }
    }
}

