/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datapruner;

import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.datapruner.DataPrunerController;
import com.mirth.connect.plugins.datapruner.DataPrunerException;
import com.mirth.connect.plugins.datapruner.DataPrunerServletInterface;
import com.mirth.connect.util.messagewriter.MessageWriterOptions;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataPrunerService
implements ServicePlugin {
    public static final String PLUGINPOINT = "Data Pruner";
    private DataPrunerController dataPrunerController = DataPrunerController.getInstance();
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
    private Logger logger = LogManager.getLogger(this.getClass());

    public String getPluginPointName() {
        return PLUGINPOINT;
    }

    public void start() {
        try {
            this.dataPrunerController.start();
        }
        catch (DataPrunerException e) {
            this.logger.error("Failed to start data pruner service.", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.dataPrunerController.stop(false);
        }
        catch (DataPrunerException e) {
            this.logger.error("Failed to stop data pruner service.", (Throwable)e);
        }
    }

    public void init(Properties properties) {
        try {
            this.dataPrunerController.init(properties);
        }
        catch (DataPrunerException e) {
            this.logger.error("Failed to initialize data pruner service.", (Throwable)e);
        }
    }

    public void update(Properties properties) {
        try {
            this.dataPrunerController.update(properties);
        }
        catch (DataPrunerException e) {
            this.logger.error("Failed to reschedule the data pruner.", (Throwable)e);
        }
    }

    public Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put("enabled", "false");
        PollConnectorProperties defaultProperties = new PollConnectorProperties();
        defaultProperties.setPollingFrequency(3600000);
        properties.put("pollingProperties", this.serializer.serialize((Object)defaultProperties));
        properties.put("pruningBlockSize", String.valueOf(1000));
        properties.put("archiveEnabled", this.serializer.serialize((Object)false));
        properties.put("archiverBlockSize", String.valueOf(50));
        properties.put("includeAttachments", this.serializer.serialize((Object)false));
        properties.put("archiverOptions", this.serializer.serialize((Object)new MessageWriterOptions()));
        properties.put("pruneEvents", Boolean.toString(false));
        properties.put("maxEventAge", "");
        return properties;
    }

    public ExtensionPermission[] getExtensionPermissions() {
        ExtensionPermission viewPermission = new ExtensionPermission(PLUGINPOINT, "View Settings", "Displays the Data Pruner settings.", OperationUtil.getOperationNamesForPermission((String)"View Settings", DataPrunerServletInterface.class, (String[])new String[]{"getPluginProperties"}), new String[]{"doRefresh"});
        ExtensionPermission savePermission = new ExtensionPermission(PLUGINPOINT, "Save Settings", "Allows changing the Data Pruner settings.", OperationUtil.getOperationNamesForPermission((String)"Save Settings", DataPrunerServletInterface.class, (String[])new String[]{"setPluginProperties"}), new String[]{"doSave"});
        ExtensionPermission startStopPermission = new ExtensionPermission(PLUGINPOINT, "Start / Stop", "Allows starting or stopping the Data Pruner on-demand.", OperationUtil.getOperationNamesForPermission((String)"Start / Stop", DataPrunerServletInterface.class, (String[])new String[0]), new String[]{"doStart", "doStop"});
        return new ExtensionPermission[]{viewPermission, savePermission, startStopPermission};
    }
}

