/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.connectors.ws.WebServiceReceiver;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    private Logger logger = LogManager.getLogger(this.getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private WebServiceReceiver webServiceReceiver;

    public LoggingSOAPHandler(WebServiceReceiver webServiceReceiver) {
        this.webServiceReceiver = webServiceReceiver;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext mc) {
        this.logger.debug("Web Service connection closed.");
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.webServiceReceiver.getChannelId(), Integer.valueOf(this.webServiceReceiver.getMetaDataId()), this.webServiceReceiver.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public boolean handleFault(SOAPMessageContext smc) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        try {
            Boolean outbound = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
            if (!outbound.booleanValue()) {
                this.logger.debug("Web Service message received.");
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.webServiceReceiver.getChannelId(), Integer.valueOf(this.webServiceReceiver.getMetaDataId()), this.webServiceReceiver.getSourceName(), ConnectionStatusEventType.CONNECTED));
            } else {
                this.logger.debug("Web Service returning response.");
            }
            smc.getMessage();
        }
        catch (Exception e) {
            this.logger.error("Error handling SOAP message", (Throwable)e);
            return false;
        }
        return true;
    }
}

