/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.ws;

import com.mirth.connect.connectors.ws.AcceptMessage;
import com.mirth.connect.connectors.ws.DefaultAcceptMessage;
import com.mirth.connect.connectors.ws.DefaultWebServiceConfiguration;
import com.mirth.connect.connectors.ws.LoggingSOAPHandler;
import com.mirth.connect.connectors.ws.WebServiceConfiguration;
import com.mirth.connect.connectors.ws.WebServiceReceiverProperties;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.server.message.batch.SimpleResponseHandler;
import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.AuthenticatorProviderFactory;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;

public class WebServiceReceiver
extends SourceConnector {
    private static final int DEFAULT_BACKLOG = 256;
    private org.apache.logging.log4j.Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private ExecutorService executor;
    private Endpoint webServiceEndpoint;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private WebServiceConfiguration configuration;
    private HttpServer server;
    private WebServiceReceiverProperties connectorProperties;
    private HttpAuthConnectorPluginProperties authProps;
    private AuthenticatorProvider authenticatorProvider;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (WebServiceReceiverProperties)this.getConnectorProperties();
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (WebServiceConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultWebServiceConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        if (this.connectorProperties.getPluginProperties() != null) {
            for (ConnectorPluginProperties pluginProperties : this.connectorProperties.getPluginProperties()) {
                if (!(pluginProperties instanceof HttpAuthConnectorPluginProperties)) continue;
                this.authProps = (HttpAuthConnectorPluginProperties)pluginProperties;
            }
        }
        if (this.authProps != null && this.authProps.getAuthType() != HttpAuthConnectorPluginProperties.AuthType.NONE) {
            try {
                this.authenticatorProvider = AuthenticatorProviderFactory.getAuthenticatorProvider((Connector)this, (HttpAuthConnectorPluginProperties)this.authProps);
            }
            catch (Exception e) {
                throw new ConnectorTaskException("Error creating authenticator provider.", (Throwable)e);
            }
        }
    }

    public void onUndeploy() throws ConnectorTaskException {
        this.configuration.configureConnectorUndeploy((Connector)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() throws ConnectorTaskException {
        String channelId = this.getChannelId();
        String channelName = this.getChannel().getName();
        String host = this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getHost(), channelId, channelName);
        int port = NumberUtils.toInt((String)this.replacer.replaceValues(this.connectorProperties.getListenerConnectorProperties().getPort(), channelId, channelName));
        this.logger.debug("starting Web Service HTTP server on port: " + port);
        Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server").setLevel(Level.OFF);
        try {
            try {
                if (System.getProperty("sun.net.httpserver.maxReqTime") == null) {
                    System.setProperty("sun.net.httpserver.maxReqTime", "60");
                }
                if (System.getProperty("sun.net.httpserver.maxRspTime") == null) {
                    System.setProperty("sun.net.httpserver.maxRspTime", "60");
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to set properties sun.net.httpserver.maxReqTime and sun.net.httpserver.maxRspTime", (Throwable)e);
            }
            this.configuration.configureReceiver(this);
            this.server.bind(new InetSocketAddress(host, port), 256);
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error creating HTTP Server.", (Throwable)e);
        }
        int processingThreads = this.connectorProperties.getSourceConnectorProperties().getProcessingThreads();
        if (processingThreads < 1) {
            processingThreads = 1;
        }
        this.executor = Executors.newFixedThreadPool(processingThreads + 4);
        this.server.setExecutor(this.executor);
        this.server.start();
        AcceptMessage acceptMessageWebService = null;
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(this.getResourceIds());
                Thread.currentThread().setContextClassLoader(contextFactory.getApplicationClassLoader());
                Class<?> clazz = Class.forName(this.replacer.replaceValues(this.connectorProperties.getClassName(), channelId, channelName), true, contextFactory.getApplicationClassLoader());
                if (clazz.getSuperclass().equals(AcceptMessage.class)) {
                    Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        Class<?>[] parameters = constructors[i].getParameterTypes();
                        if (parameters.length != 1 || !parameters[0].equals(((Object)((Object)this)).getClass())) continue;
                        acceptMessageWebService = (AcceptMessage)constructors[i].newInstance(new Object[]{this});
                    }
                    if (acceptMessageWebService == null) {
                        this.logger.error("Custom web service class must implement the constructor: public AcceptMessage(WebServiceReceiver webServiceReceiver)");
                    }
                } else {
                    this.logger.error("Custom web service class must extend com.mirth.connect.connectors.ws.AcceptMessage");
                }
            }
            catch (Exception e) {
                this.logger.error("Custom web service class initialization failed", (Throwable)e);
            }
            if (acceptMessageWebService == null) {
                this.logger.error("Custom web service class initialization failed, using DefaultAcceptMessage");
                acceptMessageWebService = new DefaultAcceptMessage(this);
            }
            this.webServiceEndpoint = Endpoint.create((String)this.connectorProperties.getSoapBinding().getValue(), acceptMessageWebService);
            Binding binding = this.webServiceEndpoint.getBinding();
            LinkedList<LoggingSOAPHandler> handlerChain = new LinkedList<LoggingSOAPHandler>();
            handlerChain.add(new LoggingSOAPHandler(this));
            binding.setHandlerChain(handlerChain);
            String serviceName = this.replacer.replaceValues(this.connectorProperties.getServiceName(), channelId, channelName);
            HttpContext context = this.server.createContext("/services/" + serviceName);
            if (this.authenticatorProvider != null) {
                context.setAuthenticator(this.createAuthenticator());
            }
            this.webServiceEndpoint.publish((Object)context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onStop() throws ConnectorTaskException {
        ConnectorTaskException firstCause = null;
        try {
            this.logger.debug("stopping Web Service HTTP server");
            if (this.webServiceEndpoint != null) {
                this.webServiceEndpoint.stop();
            }
            if (this.server != null) {
                this.server.stop(1);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        catch (Exception e) {
            firstCause = new ConnectorTaskException("Failed to stop Web Service Listener", (Throwable)e);
        }
        if (this.authenticatorProvider != null) {
            this.authenticatorProvider.shutdown();
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.connectorProperties.getProtocol(), "wsConfigurationClass");
    }

    public String processData(String message) {
        return this.processData(new RawMessage(message));
    }

    public String processData(RawMessage rawMessage) {
        DispatchResult dispatchResult = this.processDataAndGetDispatchResult(rawMessage);
        if (dispatchResult != null && dispatchResult.getSelectedResponse() != null) {
            return dispatchResult.getSelectedResponse().getMessage();
        }
        return null;
    }

    public DispatchResult processDataAndGetDispatchResult(String message) {
        return this.processDataAndGetDispatchResult(new RawMessage(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DispatchResult processDataAndGetDispatchResult(RawMessage rawMessage) {
        DispatchResult dispatchResult = null;
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.RECEIVING));
        String originalThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("Web Service Receiver Thread on " + this.getChannel().getName() + " (" + this.getChannelId() + ") < " + originalThreadName);
            if (this.isProcessBatch()) {
                try {
                    if (rawMessage.isBinary().booleanValue()) {
                        throw new BatchMessageException("Batch processing is not supported for binary data.");
                    }
                    BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(rawMessage.getRawData()), rawMessage.getSourceMap());
                    SimpleResponseHandler responseHandler = new SimpleResponseHandler();
                    this.dispatchBatchMessage(batchRawMessage, (ResponseHandler)responseHandler);
                    dispatchResult = responseHandler.getResultForResponse();
                    return dispatchResult;
                }
                catch (BatchMessageException e) {
                    this.logger.error("Error processing batch message", (Throwable)e);
                    this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), rawMessage.getOriginalMessageId(), ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), "Error processing batch message", (Throwable)e));
                    return dispatchResult;
                }
            }
            try {
                dispatchResult = this.dispatchRawMessage(rawMessage);
                dispatchResult.setAttemptedResponse(true);
                return dispatchResult;
            }
            catch (ChannelException channelException) {
                return dispatchResult;
            }
            finally {
                this.finishDispatch(dispatchResult);
            }
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public void setServer(HttpServer server) {
        this.server = server;
    }

    private com.sun.net.httpserver.Authenticator createAuthenticator() throws ConnectorTaskException {
        Authenticator authenticator;
        try {
            authenticator = this.authenticatorProvider.getAuthenticator();
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Unable to create authenticator.", (Throwable)e);
        }
        return new com.sun.net.httpserver.Authenticator(){

            @Override
            public Authenticator.Result authenticate(final HttpExchange exch) {
                String remoteAddress = StringUtils.trimToEmpty((String)exch.getRemoteAddress().getAddress().getHostAddress());
                int remotePort = exch.getRemoteAddress().getPort();
                String localAddress = StringUtils.trimToEmpty((String)exch.getLocalAddress().getAddress().getHostAddress());
                int localPort = exch.getLocalAddress().getPort();
                String protocol = StringUtils.trimToEmpty((String)exch.getProtocol());
                String method = StringUtils.trimToEmpty((String)exch.getRequestMethod());
                String requestURI = StringUtils.trimToEmpty((String)exch.getRequestURI().toString());
                Headers headers = exch.getRequestHeaders();
                LinkedHashMap<String, ArrayList<String>> queryParameters = new LinkedHashMap<String, ArrayList<String>>();
                for (NameValuePair nvp : URLEncodedUtils.parse((URI)exch.getRequestURI(), (String)"UTF-8")) {
                    ArrayList<String> list = (ArrayList<String>)queryParameters.get(nvp.getName());
                    if (list == null) {
                        list = new ArrayList<String>();
                        queryParameters.put(nvp.getName(), list);
                    }
                    list.add(nvp.getValue());
                }
                RequestInfo.EntityProvider entityProvider = new RequestInfo.EntityProvider(){

                    public byte[] getEntity() throws IOException {
                        byte[] entity = (byte[])exch.getAttribute("Cached Entity");
                        if (entity == null) {
                            entity = IOUtils.toByteArray((InputStream)exch.getRequestBody());
                            exch.setAttribute("Cached Entity", entity);
                            exch.setStreams(new ByteArrayInputStream(entity), exch.getResponseBody());
                        }
                        return entity;
                    }
                };
                RequestInfo requestInfo = new RequestInfo(remoteAddress, remotePort, localAddress, localPort, protocol, method, requestURI, (Map)headers, queryParameters, entityProvider);
                try {
                    AuthenticationResult result = authenticator.authenticate(requestInfo);
                    for (Map.Entry entry : result.getResponseHeaders().entrySet()) {
                        if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || entry.getValue() == null) continue;
                        for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                            if (i == 0) {
                                exch.getResponseHeaders().set((String)entry.getKey(), (String)((List)entry.getValue()).get(i));
                                continue;
                            }
                            exch.getResponseHeaders().add((String)entry.getKey(), (String)((List)entry.getValue()).get(i));
                        }
                    }
                    switch (result.getStatus()) {
                        case CHALLENGED: {
                            return new Authenticator.Retry(401);
                        }
                        case SUCCESS: {
                            String username = StringUtils.trimToEmpty((String)result.getUsername());
                            String realm = StringUtils.trimToEmpty((String)result.getRealm());
                            return new Authenticator.Success(new HttpPrincipal(username, realm));
                        }
                    }
                    return new Authenticator.Failure(401);
                }
                catch (Throwable t) {
                    WebServiceReceiver.this.logger.error("Error in HTTP authentication for " + WebServiceReceiver.this.connectorProperties.getName() + " (" + WebServiceReceiver.this.connectorProperties.getName() + " \"Source\" on channel " + WebServiceReceiver.this.getChannelId() + ").", t);
                    WebServiceReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(WebServiceReceiver.this.getChannelId(), Integer.valueOf(WebServiceReceiver.this.getMetaDataId()), null, ErrorEventType.DESTINATION_CONNECTOR, "Source", WebServiceReceiver.this.connectorProperties.getName(), "Error in HTTP authentication for " + WebServiceReceiver.this.connectorProperties.getName(), t));
                    return new Authenticator.Failure(500);
                }
            }
        };
    }
}

