/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/extensions/dashboardstatus")
@Tag(name="Extension Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface DashboardConnectorStatusServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "Dashboard Connector Status Service";
    public static final String PERMISSION_VIEW = "View Connection Status";

    @GET
    @Path(value="/connectorStates")
    @Operation(summary="Retrieves all dashboard connector states.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboardConnectorStateMap", ref="../apiexamples/dashboard_connector_state_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboardConnectorStateMap", ref="../apiexamples/dashboard_connector_state_map_json")})})
    @MirthOperation(name="getStates", display="Get dashboard connector states", permission="View Connection Status", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, Object[]> getConnectorStateMap(@Param(value="serverId") @Parameter(description="The server ID to retrieve connector statuses for. Connector Statuses across all servers are retrieved is this parameter is not specified.") @QueryParam(value="serverId") String var1) throws ClientException;

    @GET
    @Path(value="/channelStates")
    @Operation(summary="Retrieves all dashboard channel states.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="dashboardChannelStateMap", ref="../apiexamples/dashboard_channel_state_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="dashboardChannelStateMap", ref="../apiexamples/dashboard_channel_state_map_json")})})
    @MirthOperation(name="getChannelStates", display="Get dashboard channel states", permission="View Connection Status", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, String> getChannelStates() throws ClientException;

    @GET
    @Path(value="/channelStates/{channelId}")
    @Produces(value={"text/plain"})
    @Operation(summary="Retrieves a single dashboard channel state.")
    @MirthOperation(name="getChannelState", display="Get dashboard channel state", permission="View Connection Status", type=Operation.ExecuteType.ASYNC, auditable=false)
    public String getChannelState(@Param(value="channelId") @Parameter(description="The channel ID to return a dashboard status for.") @PathParam(value="channelId") String var1) throws ClientException;

    @GET
    @Path(value="/connectionLogs")
    @Operation(summary="Retrieves connection logs for all channels.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connectionLogItemLinkedList", ref="../apiexamples/connection_log_item_linked_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connectionLogItemLinkedList", ref="../apiexamples/connection_log_item_linked_list_json")})})
    @MirthOperation(name="getConnectionInfoLogs", display="Get channel connection logs", permission="View Connection Status", type=Operation.ExecuteType.ASYNC, auditable=false)
    public LinkedList<ConnectionLogItem> getAllChannelLogs(@Param(value="serverId") @Parameter(description="The server ID to retrieve logs for. Logs for all servers are retrieved is this parameter is not specified.") @QueryParam(value="serverId") String var1, @Param(value="fetchSize") @Parameter(description="Specifies the maximum number of log items to return.", required=true, schema=@Schema(defaultValue="100")) @QueryParam(value="fetchSize") int var2, @Param(value="lastLogId") @Parameter(description="The last log ID the client retrieved. Only log items with a greater ID will be returned.") @QueryParam(value="lastLogId") Long var3) throws ClientException;

    @GET
    @Path(value="/connectionLogs/{channelId}")
    @Operation(summary="Retrieves connection logs for a specific channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="connectionLogItemLinkedList", ref="../apiexamples/connection_log_item_linked_list_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="connectionLogItemLinkedList", ref="../apiexamples/connection_log_item_linked_list_json")})})
    @MirthOperation(name="getConnectionInfoLogs", display="Get channel connection logs", permission="View Connection Status", type=Operation.ExecuteType.ASYNC, auditable=false)
    public LinkedList<ConnectionLogItem> getChannelLog(@Param(value="serverId") @Parameter(description="The server ID to retrieve logs for. Logs for all servers are retrieved is this parameter is not specified.") @QueryParam(value="serverId") String var1, @Param(value="channelId") @Parameter(description="The channel ID to retrieve logs for.", required=true) @PathParam(value="channelId") String var2, @Param(value="fetchSize") @Parameter(description="Specifies the maximum number of log items to return.", required=true, schema=@Schema(defaultValue="100")) @QueryParam(value="fetchSize") int var3, @Param(value="lastLogId") @Parameter(description="The last log ID the client retrieved. Only log items with a greater ID will be returned.") @QueryParam(value="lastLogId") Long var4) throws ClientException;
}

