/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class FileDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    public static final String NAME = "File Writer";
    private DestinationConnectorProperties destinationConnectorProperties;
    private FileScheme scheme;
    private SchemeProperties schemeProperties;
    private String host;
    private String outputPattern;
    private boolean anonymous;
    private String username;
    private String password;
    private String timeout;
    private boolean keepConnectionOpen;
    private String maxIdleTime;
    private boolean secure;
    private boolean passive;
    private boolean validateConnection;
    private boolean outputAppend;
    private boolean errorOnExists;
    private boolean temporary;
    private boolean binary;
    private String charsetEncoding;
    private String template;

    public FileDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties();
        this.scheme = FileScheme.FILE;
        this.schemeProperties = null;
        this.host = "";
        this.outputPattern = "";
        this.anonymous = true;
        this.username = "anonymous";
        this.password = "anonymous";
        this.timeout = "10000";
        this.keepConnectionOpen = true;
        this.maxIdleTime = "0";
        this.secure = true;
        this.passive = true;
        this.validateConnection = true;
        this.outputAppend = true;
        this.errorOnExists = false;
        this.temporary = false;
        this.binary = false;
        this.charsetEncoding = "DEFAULT_ENCODING";
        this.template = "";
    }

    public FileDispatcherProperties(FileDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.scheme = props.getScheme();
        SchemeProperties properties = props.getSchemeProperties();
        if (properties != null) {
            this.schemeProperties = properties.clone();
        }
        this.host = props.getHost();
        this.outputPattern = props.getOutputPattern();
        this.anonymous = props.isAnonymous();
        this.username = props.getUsername();
        this.password = props.getPassword();
        this.timeout = props.getTimeout();
        this.keepConnectionOpen = props.isKeepConnectionOpen();
        this.maxIdleTime = props.getMaxIdleTime();
        this.secure = props.isSecure();
        this.passive = props.isPassive();
        this.validateConnection = props.isValidateConnection();
        this.outputAppend = props.isOutputAppend();
        this.errorOnExists = props.isErrorOnExists();
        this.temporary = props.isTemporary();
        this.binary = props.isBinary();
        this.charsetEncoding = props.getCharsetEncoding();
        this.template = props.getTemplate();
    }

    public FileScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(FileScheme scheme) {
        this.scheme = scheme;
    }

    public SchemeProperties getSchemeProperties() {
        return this.schemeProperties;
    }

    public void setSchemeProperties(SchemeProperties schemeProperties) {
        this.schemeProperties = schemeProperties;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public boolean isKeepConnectionOpen() {
        return this.keepConnectionOpen;
    }

    public void setKeepConnectionOpen(boolean keepConnectionOpen) {
        this.keepConnectionOpen = keepConnectionOpen;
    }

    public String getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(String maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean isOutputAppend() {
        return this.outputAppend;
    }

    public void setOutputAppend(boolean outputAppend) {
        this.outputAppend = outputAppend;
    }

    public boolean isErrorOnExists() {
        return this.errorOnExists;
    }

    public void setErrorOnExists(boolean errorOnExists) {
        this.errorOnExists = errorOnExists;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public String getProtocol() {
        return "File";
    }

    public String getName() {
        return NAME;
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("URI: ");
        this.appendURIString(builder);
        builder.append(newLine);
        if (!this.anonymous) {
            builder.append("USERNAME: ");
            builder.append(this.username);
            builder.append(newLine);
        }
        if (this.schemeProperties != null) {
            builder.append(this.schemeProperties.toFormattedString());
        }
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.template);
        return builder.toString();
    }

    public String toURIString() {
        StringBuilder builder = new StringBuilder();
        this.appendURIString(builder);
        return builder.toString();
    }

    private void appendURIString(StringBuilder builder) {
        if (this.scheme == FileScheme.FTP) {
            builder.append("ftp://");
        } else if (this.scheme == FileScheme.SFTP) {
            builder.append("sftp://");
        } else if (this.scheme == FileScheme.S3) {
            builder.append("s3://");
        } else if (this.scheme == FileScheme.SMB) {
            builder.append("smb://");
        } else if (this.scheme == FileScheme.WEBDAV) {
            if (this.secure) {
                builder.append("https://");
            } else {
                builder.append("http://");
            }
        }
        builder.append(this.host);
        if (this.host.charAt(this.host.length() - 1) != '/') {
            builder.append("/");
        }
        builder.append(this.outputPattern);
    }

    public ConnectorProperties clone() {
        return new FileDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return false;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
        DonkeyElement schemeProperties;
        if (element.getChildElement("scheme").getTextContent().equalsIgnoreCase("sftp") && (schemeProperties = element.addChildElementIfNotExists("schemeProperties")) != null) {
            schemeProperties.setAttribute("class", "com.mirth.connect.connectors.file.SftpSchemeProperties");
            schemeProperties.addChildElementIfNotExists("passwordAuth", "true");
            schemeProperties.addChildElementIfNotExists("keyAuth", "false");
            schemeProperties.addChildElementIfNotExists("keyFile");
            schemeProperties.addChildElementIfNotExists("passPhrase");
            schemeProperties.addChildElementIfNotExists("hostKeyChecking", "ask");
            schemeProperties.addChildElementIfNotExists("knownHostsFile");
            schemeProperties.addChildElementIfNotExists("configurationSettings");
        }
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
        element.addChildElementIfNotExists("keepConnectionOpen", "true");
        element.addChildElementIfNotExists("maxIdleTime", "0");
    }

    public void migrate3_9_0(DonkeyElement element) {
        DonkeyElement schemeProperties;
        if (element.getChildElement("scheme").getTextContent().equalsIgnoreCase("smb") && (schemeProperties = element.addChildElementIfNotExists("schemeProperties")) != null) {
            schemeProperties.setAttribute("class", "com.mirth.connect.connectors.file.SmbSchemeProperties");
            schemeProperties.addChildElementIfNotExists("smbMinVersion", "SMB1");
            schemeProperties.addChildElementIfNotExists("smbMaxVersion", "SMB311");
        }
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("scheme", this.scheme);
        purgedProperties.put("schemePurgedProperties", this.schemeProperties.getPurgedProperties());
        purgedProperties.put("timeout", PurgeUtil.getNumericValue((String)this.timeout));
        purgedProperties.put("keepConnectionOpen", this.keepConnectionOpen);
        purgedProperties.put("maxIdleTime", PurgeUtil.getNumericValue((String)this.maxIdleTime));
        purgedProperties.put("secure", this.secure);
        purgedProperties.put("passive", this.passive);
        purgedProperties.put("validateConnection", this.validateConnection);
        purgedProperties.put("outputAppend", this.outputAppend);
        purgedProperties.put("errorOnExists", this.errorOnExists);
        purgedProperties.put("temporary", this.temporary);
        purgedProperties.put("binary", this.binary);
        purgedProperties.put("charsetEncoding", this.charsetEncoding);
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        return purgedProperties;
    }
}

