/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SmbDialectVersion;
import java.util.HashMap;
import java.util.Map;
import jcifs.DialectVersion;

public class SmbSchemeProperties
extends SchemeProperties {
    private static final String DEFAULT_SMB_MIN_VERSION = DialectVersion.SMB202.toString();
    private static final String DEFAULT_SMB_MAX_VERSION = DialectVersion.SMB311.toString();
    private String smbMinVersion;
    private String smbMaxVersion;
    private static final SmbDialectVersion[] supportedVersions = new SmbDialectVersion[]{new SmbDialectVersion(DialectVersion.SMB1.toString(), "SMB v1"), new SmbDialectVersion(DialectVersion.SMB202.toString(), "SMB v2.0.2"), new SmbDialectVersion(DialectVersion.SMB210.toString(), "SMB v2.1"), new SmbDialectVersion(DialectVersion.SMB300.toString(), "SMB v3.0"), new SmbDialectVersion(DialectVersion.SMB302.toString(), "SMB v3.0.2"), new SmbDialectVersion(DialectVersion.SMB311.toString(), "SMB v3.1.1")};

    public SmbSchemeProperties() {
        this.smbMinVersion = DEFAULT_SMB_MIN_VERSION;
        this.smbMaxVersion = DEFAULT_SMB_MAX_VERSION;
    }

    public SmbSchemeProperties(SmbSchemeProperties props) {
        this.smbMinVersion = props.getSmbMinVersion();
        this.smbMaxVersion = props.getSmbMaxVersion();
    }

    public static SmbDialectVersion[] getSupportedVersions() {
        return supportedVersions;
    }

    public static String getReadableVersion(String dialectVersion) {
        for (SmbDialectVersion smbDialectVersion : supportedVersions) {
            if (!smbDialectVersion.getVersion().equals(dialectVersion)) continue;
            return smbDialectVersion.getReadableVersion();
        }
        return null;
    }

    public static SmbDialectVersion getSmbDialectVersion(String dialectVersion) {
        for (SmbDialectVersion smbDialectVersion : supportedVersions) {
            if (!smbDialectVersion.getVersion().equals(dialectVersion)) continue;
            return smbDialectVersion;
        }
        return null;
    }

    public String getSmbMinVersion() {
        return this.smbMinVersion;
    }

    public void setSmbMinVersion(String smbMinVersion) {
        this.smbMinVersion = smbMinVersion;
    }

    public String getSmbMaxVersion() {
        return this.smbMaxVersion;
    }

    public void setSmbMaxVersion(String smbMaxVersion) {
        this.smbMaxVersion = smbMaxVersion;
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("smbMinVersion", this.smbMinVersion);
        purgedProperties.put("smbMaxVersion", this.smbMaxVersion);
        return purgedProperties;
    }

    @Override
    public SchemeProperties getFileSchemeProperties() {
        return this;
    }

    @Override
    public String getSummaryText() {
        return "Using " + SmbSchemeProperties.getReadableVersion(this.smbMinVersion) + " - " + SmbSchemeProperties.getReadableVersion(this.smbMaxVersion);
    }

    @Override
    public String toFormattedString() {
        return "SMB: " + SmbSchemeProperties.getReadableVersion(this.smbMinVersion) + "-" + SmbSchemeProperties.getReadableVersion(this.smbMaxVersion);
    }

    @Override
    public SchemeProperties clone() {
        return new SmbSchemeProperties(this);
    }
}

