/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.smtp;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.CharsetEncodingInformation;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthIconTextField;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.smtp.Attachment;
import com.mirth.connect.connectors.smtp.SmtpConnectorServletInterface;
import com.mirth.connect.connectors.smtp.SmtpDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SmtpSender
extends ConnectorSettingsPanel {
    private final int HEADERS_NAME_COLUMN = 0;
    private final int HEADERS_VALUE_COLUMN = 1;
    private final String HEADERS_NAME_COLUMN_NAME = "Name";
    private final String HEADERS_VALUE_COLUMN_NAME = "Value";
    private final int ATTACHMENTS_NAME_COLUMN = 0;
    private final int ATTACHMENTS_CONTENT_COLUMN = 1;
    private final int ATTACHMENTS_MIME_TYPE_COLUMN = 2;
    private final String ATTACHMENTS_NAME_COLUMN_NAME = "Name";
    private final String ATTACHMENTS_CONTENT_COLUMN_NAME = "Content";
    private final String ATTACHMENTS_MIME_TYPE_COLUMN_NAME = "MIME type";
    private int headersLastIndex = -1;
    private int attachmentsLastIndex = -1;
    private String errors;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JLabel smtpHostLabel;
    private MirthIconTextField smtpHostField;
    private JButton sendTestEmailButton;
    private JLabel smtpPortLabel;
    private MirthTextField smtpPortField;
    private JLabel overrideLocalBindingLabel;
    private MirthRadioButton overrideLocalBindingYesRadio;
    private MirthRadioButton overrideLocalBindingNoRadio;
    private JLabel localAddressLabel;
    private MirthTextField localAddressField;
    private JLabel localPortLabel;
    private MirthTextField localPortField;
    private JLabel sendTimeoutLabel;
    private MirthTextField sendTimeoutField;
    public JLabel encryptionLabel;
    public MirthRadioButton encryptionNone;
    public MirthRadioButton encryptionTls;
    public MirthRadioButton encryptionSsl;
    private JLabel useAuthenticationLabel;
    private MirthRadioButton useAuthenticationYes;
    private MirthRadioButton useAuthenticationNo;
    private JLabel usernameLabel;
    private MirthTextField usernameField;
    private JLabel passwordLabel;
    private MirthPasswordField passwordField;
    private JLabel toLabel;
    private MirthTextField toField;
    private JLabel fromLabel;
    private MirthTextField fromField;
    private JLabel subjectLabel;
    private MirthTextField subjectField;
    private JLabel charsetEncodingLabel;
    private MirthComboBox<CharsetEncodingInformation> charsetEncodingComboBox;
    private JLabel htmlLabel;
    private MirthRadioButton htmlYes;
    private MirthRadioButton htmlNo;
    private JLabel bodyLabel;
    private MirthSyntaxTextArea bodyTextPane;
    private JLabel headersLabel;
    private MirthTable headersTable;
    private JScrollPane headersPane;
    private JButton newHeaderButton;
    private JButton deleteHeaderButton;
    private MirthRadioButton useHeadersTableRadio;
    private MirthRadioButton useHeadersVariableRadio;
    private MirthTextField headersVariableField;
    private JLabel attachmentsLabel;
    private MirthTable attachmentsTable;
    private JScrollPane attachmentsPane;
    private JButton newAttachmentButton;
    private JButton deleteAttachmentButton;
    private MirthRadioButton useAttachmentsListRadio;
    private MirthRadioButton useAttachmentsVariableRadio;
    private MirthTextField attachmentsVariableField;

    public SmtpSender() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.parent.setupCharsetEncodingForConnector(this.charsetEncodingComboBox);
    }

    public String getConnectorName() {
        return new SmtpDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        SmtpDispatcherProperties properties = new SmtpDispatcherProperties();
        properties.setSmtpHost(this.smtpHostField.getText());
        properties.setSmtpPort(this.smtpPortField.getText());
        properties.setOverrideLocalBinding(this.overrideLocalBindingYesRadio.isSelected());
        properties.setLocalAddress(this.localAddressField.getText());
        properties.setLocalPort(this.localPortField.getText());
        properties.setTimeout(this.sendTimeoutField.getText());
        if (this.encryptionTls.isSelected()) {
            properties.setEncryption("TLS");
        } else if (this.encryptionSsl.isSelected()) {
            properties.setEncryption("SSL");
        } else {
            properties.setEncryption("none");
        }
        properties.setAuthentication(this.useAuthenticationYes.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setTo(this.toField.getText());
        properties.setFrom(this.fromField.getText());
        properties.setSubject(this.subjectField.getText());
        properties.setCharsetEncoding(this.parent.getSelectedEncodingForConnector(this.charsetEncodingComboBox));
        properties.setHtml(this.htmlYes.isSelected());
        properties.setBody(this.bodyTextPane.getText());
        properties.setUseHeadersVariable(this.useHeadersVariableRadio.isSelected());
        properties.setHeadersMap(this.getHeaders());
        properties.setHeadersVariable(this.headersVariableField.getText());
        properties.setUseAttachmentsVariable(this.useAttachmentsVariableRadio.isSelected());
        properties.setAttachmentsList(this.getAttachments());
        properties.setAttachmentsVariable(this.attachmentsVariableField.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        SmtpDispatcherProperties props = (SmtpDispatcherProperties)properties;
        this.smtpHostField.setText(props.getSmtpHost());
        this.smtpPortField.setText(props.getSmtpPort());
        if (props.isOverrideLocalBinding()) {
            this.overrideLocalBindingYesRadio.setSelected(true);
            this.overrideLocalBindingFieldsEnabled(true);
        } else {
            this.overrideLocalBindingNoRadio.setSelected(true);
            this.overrideLocalBindingFieldsEnabled(false);
        }
        if (props.isUseHeadersVariable()) {
            this.useHeadersVariableRadio.setSelected(true);
        } else {
            this.useHeadersTableRadio.setSelected(true);
        }
        this.headersVariableField.setText(props.getHeadersVariable());
        this.useHeadersVariableFieldsEnabled(props.isUseHeadersVariable());
        if (props.isUseAttachmentsVariable()) {
            this.useAttachmentsVariableRadio.setSelected(true);
        } else {
            this.useAttachmentsListRadio.setSelected(true);
        }
        this.attachmentsVariableField.setText(props.getAttachmentsVariable());
        this.useAttachmentsVariableFieldsEnabled(props.isUseAttachmentsVariable());
        this.localAddressField.setText(props.getLocalAddress());
        this.localPortField.setText(props.getLocalPort());
        this.sendTimeoutField.setText(props.getTimeout());
        if (props.getEncryption().equalsIgnoreCase("TLS")) {
            this.encryptionTls.setSelected(true);
        } else if (props.getEncryption().equalsIgnoreCase("SSL")) {
            this.encryptionSsl.setSelected(true);
        } else {
            this.encryptionNone.setSelected(true);
        }
        if (props.isAuthentication()) {
            this.setAuthenticationFieldsEnabled(true);
            this.useAuthenticationYes.setSelected(true);
        } else {
            this.setAuthenticationFieldsEnabled(false);
            this.useAuthenticationNo.setSelected(true);
        }
        this.usernameField.setText(props.getUsername());
        this.passwordField.setText(props.getPassword());
        this.toField.setText(props.getTo());
        this.fromField.setText(props.getFrom());
        this.subjectField.setText(props.getSubject());
        this.parent.setPreviousSelectedEncodingForConnector(this.charsetEncodingComboBox, props.getCharsetEncoding());
        if (props.isHtml()) {
            this.htmlYes.setSelected(true);
        } else {
            this.htmlNo.setSelected(true);
        }
        this.bodyTextPane.setText(props.getBody());
        this.setHeaders(props.getHeadersMap());
        this.setAttachments(props.getAttachmentsList());
    }

    public ConnectorProperties getDefaults() {
        return new SmtpDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        SmtpDispatcherProperties props = (SmtpDispatcherProperties)properties;
        boolean valid = true;
        StringBuilder errors = new StringBuilder();
        if (props.getSmtpHost().length() == 0) {
            valid = false;
            if (highlight) {
                this.smtpHostField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("\"SMTP Host\" is required\n");
        }
        if (props.getSmtpPort().length() == 0) {
            valid = false;
            if (highlight) {
                this.smtpPortField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("\"SMTP Port\" is required\n");
        }
        if (props.isOverrideLocalBinding()) {
            if (props.getLocalAddress().length() <= 3) {
                valid = false;
                if (highlight) {
                    this.localAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (props.getLocalPort().length() == 0) {
                valid = false;
                if (highlight) {
                    this.localPortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.getTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.sendTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("\"Send Timeout\" is required\n");
        }
        if (props.getTo().length() == 0) {
            valid = false;
            if (highlight) {
                this.toField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("\"To\" is required\n");
        }
        if (props.getFrom().length() == 0) {
            valid = false;
            if (highlight) {
                this.fromField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("\"From\" is required\n");
        }
        if (props.isUseHeadersVariable() && StringUtils.isBlank((CharSequence)props.getHeadersVariable())) {
            valid = false;
            if (highlight) {
                this.headersVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("Headers map variable required when Use Map mode is selected\n");
        }
        if (props.isUseAttachmentsVariable() && StringUtils.isBlank((CharSequence)props.getAttachmentsVariable())) {
            valid = false;
            if (highlight) {
                this.attachmentsVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
            errors.append("Attachments list variable required when Use List mode is selected\n");
        }
        this.errors = errors.toString();
        return valid;
    }

    public void resetInvalidProperties() {
        this.smtpHostField.setBackground(null);
        this.decorateConnectorType();
        this.smtpPortField.setBackground(null);
        this.sendTimeoutField.setBackground(null);
        this.toField.setBackground(null);
        this.fromField.setBackground(null);
        this.headersVariableField.setBackground(null);
        this.attachmentsVariableField.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (connectorTypeDecoration != null) {
            this.smtpHostField.setIcon((Icon)connectorTypeDecoration.getIcon());
            this.smtpHostField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
            this.smtpHostField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
            this.smtpHostField.setBackground(connectorTypeDecoration.getHighlightColor());
        }
    }

    private void setHeaders(Map<String, String> headers) {
        Object[][] tableData = new Object[headers.size()][2];
        this.headersTable = new MirthTable();
        int i = 0;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            tableData[i][0] = entry.getKey();
            tableData[i][1] = entry.getValue();
            ++i;
        }
        this.headersTable.setModel((TableModel)new DefaultTableModel(tableData, new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (SmtpSender.this.getSelectedRow(SmtpSender.this.headersTable) != -1) {
                    SmtpSender.this.headersLastIndex = SmtpSender.this.getSelectedRow(SmtpSender.this.headersTable);
                    SmtpSender.this.deleteHeaderButton.setEnabled(true);
                } else {
                    SmtpSender.this.deleteHeaderButton.setEnabled(false);
                }
            }
        });
        class HeadersTableCellEditor
        extends TextFieldCellEditor {
            boolean checkHeaders;

            public HeadersTableCellEditor(boolean checkHeaders) {
                this.checkHeaders = checkHeaders;
            }

            public boolean checkUniqueHeader(String headerName) {
                boolean exists = false;
                for (int i = 0; i < SmtpSender.this.headersTable.getRowCount(); ++i) {
                    if (SmtpSender.this.headersTable.getValueAt(i, 0) == null || !((String)SmtpSender.this.headersTable.getValueAt(i, 0)).equalsIgnoreCase(headerName)) continue;
                    exists = true;
                }
                return exists;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    SmtpSender.this.deleteHeaderButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                SmtpSender.this.deleteHeaderButton.setEnabled(true);
                if (this.checkHeaders && (value.length() == 0 || this.checkUniqueHeader(value))) {
                    return false;
                }
                SmtpSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new HeadersTableCellEditor(true)));
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new HeadersTableCellEditor(false)));
        this.headersTable.setCustomEditorControls(true);
        this.headersTable.setSelectionMode(0);
        this.headersTable.setRowSelectionAllowed(true);
        this.headersTable.setRowHeight(20);
        this.headersTable.setDragEnabled(false);
        this.headersTable.setOpaque(true);
        this.headersTable.setSortable(false);
        this.headersTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.headersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.headersPane.setViewportView((Component)this.headersTable);
    }

    private Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.headersTable.getRowCount(); ++i) {
            if (((String)this.headersTable.getValueAt(i, 0)).length() <= 0) continue;
            headers.put((String)this.headersTable.getValueAt(i, 0), (String)this.headersTable.getValueAt(i, 1));
        }
        return headers;
    }

    private void setAttachments(List<Attachment> attachments) {
        Object[][] tableData = new Object[attachments.size()][3];
        this.attachmentsTable = new MirthTable();
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment entry = attachments.get(i);
            tableData[i][0] = entry.getName();
            tableData[i][1] = entry.getContent();
            tableData[i][2] = entry.getMimeType();
        }
        this.attachmentsTable.setModel((TableModel)new DefaultTableModel(tableData, new String[]{"Name", "Content", "MIME type"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.attachmentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (SmtpSender.this.getSelectedRow(SmtpSender.this.attachmentsTable) != -1) {
                    SmtpSender.this.attachmentsLastIndex = SmtpSender.this.getSelectedRow(SmtpSender.this.attachmentsTable);
                    SmtpSender.this.deleteAttachmentButton.setEnabled(true);
                } else {
                    SmtpSender.this.deleteAttachmentButton.setEnabled(false);
                }
            }
        });
        class AttachmentsTableCellEditor
        extends TextFieldCellEditor {
            boolean checkAttachments;

            public AttachmentsTableCellEditor(boolean checkAttachments) {
                this.checkAttachments = checkAttachments;
            }

            public boolean checkUniqueAttachment(String attachmentName) {
                boolean exists = false;
                for (int i = 0; i < SmtpSender.this.attachmentsTable.getRowCount(); ++i) {
                    if (SmtpSender.this.attachmentsTable.getValueAt(i, 0) == null || !((String)SmtpSender.this.attachmentsTable.getValueAt(i, 0)).equalsIgnoreCase(attachmentName)) continue;
                    exists = true;
                }
                return exists;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    SmtpSender.this.deleteAttachmentButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                SmtpSender.this.deleteAttachmentButton.setEnabled(true);
                if (this.checkAttachments && (value.length() == 0 || this.checkUniqueAttachment(value))) {
                    return false;
                }
                SmtpSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(true)));
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModel().getColumnIndex("Content")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(false)));
        this.attachmentsTable.getColumnModel().getColumn(this.attachmentsTable.getColumnModel().getColumnIndex("MIME type")).setCellEditor((TableCellEditor)((Object)new AttachmentsTableCellEditor(false)));
        this.attachmentsTable.setCustomEditorControls(true);
        this.attachmentsTable.setSelectionMode(0);
        this.attachmentsTable.setRowSelectionAllowed(true);
        this.attachmentsTable.setRowHeight(20);
        this.attachmentsTable.setDragEnabled(false);
        this.attachmentsTable.setOpaque(true);
        this.attachmentsTable.setSortable(false);
        this.attachmentsTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.attachmentsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.attachmentsPane.setViewportView((Component)this.attachmentsTable);
    }

    private List<Attachment> getAttachments() {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (int i = 0; i < this.attachmentsTable.getRowCount(); ++i) {
            if (((String)this.attachmentsTable.getValueAt(i, 0)).length() <= 0) continue;
            Attachment attachment = new Attachment();
            attachment.setName((String)this.attachmentsTable.getValueAt(i, 0));
            attachment.setContent((String)this.attachmentsTable.getValueAt(i, 1));
            attachment.setMimeType((String)this.attachmentsTable.getValueAt(i, 2));
            attachments.add(attachment);
        }
        return attachments;
    }

    public void deselectRows(MirthTable table, JButton button) {
        table.clearSelection();
        button.setEnabled(false);
    }

    public int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private String getNewUniqueName(MirthTable table) {
        int nameColumn;
        String tempName;
        if (table == this.attachmentsTable) {
            tempName = "Attachment ";
            nameColumn = 0;
        } else if (table == this.headersTable) {
            tempName = "Header ";
            nameColumn = 0;
        } else {
            return null;
        }
        for (int i = 1; i <= table.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int j = 0; j < table.getRowCount(); ++j) {
                if (!((String)table.getValueAt(j, nameColumn)).equalsIgnoreCase(tempName + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return tempName + i;
        }
        return "";
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.smtpHostLabel = new JLabel("SMTP Host:");
        this.smtpHostField = new MirthIconTextField();
        this.sendTestEmailButton = new JButton("Send Test Email");
        this.sendTestEmailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.sendTestEmailButtonActionPerformed();
            }
        });
        this.smtpPortLabel = new JLabel("SMTP Port:");
        this.smtpPortField = new MirthTextField();
        this.overrideLocalBindingLabel = new JLabel("Override Local Binding:");
        ButtonGroup overrideLocalBindingButtonGroup = new ButtonGroup();
        this.overrideLocalBindingYesRadio = new MirthRadioButton("Yes");
        this.overrideLocalBindingYesRadio.setBackground(this.getBackground());
        this.overrideLocalBindingYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.overrideLocalBindingFieldsEnabled(true);
            }
        });
        overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingYesRadio);
        this.overrideLocalBindingNoRadio = new MirthRadioButton("No");
        this.overrideLocalBindingNoRadio.setBackground(this.getBackground());
        this.overrideLocalBindingNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.overrideLocalBindingFieldsEnabled(false);
            }
        });
        overrideLocalBindingButtonGroup.add((AbstractButton)this.overrideLocalBindingNoRadio);
        this.localAddressLabel = new JLabel("Local Address:");
        this.localAddressField = new MirthTextField();
        this.localPortLabel = new JLabel("Local Port:");
        this.localPortField = new MirthTextField();
        this.sendTimeoutLabel = new JLabel("Send Timeout (ms):");
        this.sendTimeoutField = new MirthTextField();
        this.encryptionLabel = new JLabel("Encryption:");
        ButtonGroup encryptionButtonGroup = new ButtonGroup();
        this.encryptionNone = new MirthRadioButton("None");
        this.encryptionNone.setBackground(this.getBackground());
        encryptionButtonGroup.add((AbstractButton)this.encryptionNone);
        this.encryptionTls = new MirthRadioButton("STARTTLS");
        this.encryptionTls.setBackground(this.getBackground());
        encryptionButtonGroup.add((AbstractButton)this.encryptionTls);
        this.encryptionSsl = new MirthRadioButton("SSL");
        this.encryptionSsl.setBackground(this.getBackground());
        encryptionButtonGroup.add((AbstractButton)this.encryptionSsl);
        this.useAuthenticationLabel = new JLabel("Use Authentication:");
        ButtonGroup useAuthenticationButtonGroup = new ButtonGroup();
        this.useAuthenticationYes = new MirthRadioButton("Yes");
        this.useAuthenticationYes.setBackground(this.getBackground());
        this.useAuthenticationYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.setAuthenticationFieldsEnabled(true);
            }
        });
        useAuthenticationButtonGroup.add((AbstractButton)this.useAuthenticationYes);
        this.useAuthenticationNo = new MirthRadioButton("No");
        this.useAuthenticationNo.setBackground(this.getBackground());
        this.useAuthenticationNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.setAuthenticationFieldsEnabled(false);
            }
        });
        useAuthenticationButtonGroup.add((AbstractButton)this.useAuthenticationNo);
        this.usernameLabel = new JLabel("Username:");
        this.usernameField = new MirthTextField();
        this.passwordLabel = new JLabel("Password:");
        this.passwordField = new MirthPasswordField();
        this.toLabel = new JLabel("To:");
        this.toField = new MirthTextField();
        this.fromLabel = new JLabel("From:");
        this.fromField = new MirthTextField();
        this.subjectLabel = new JLabel("Subject:");
        this.subjectField = new MirthTextField();
        this.charsetEncodingLabel = new JLabel("Charset Encoding:");
        this.charsetEncodingComboBox = new MirthComboBox();
        this.htmlLabel = new JLabel("HTML Body:");
        ButtonGroup htmlButtonGroup = new ButtonGroup();
        this.htmlYes = new MirthRadioButton("Yes");
        this.htmlYes.setBackground(this.getBackground());
        htmlButtonGroup.add((AbstractButton)this.htmlYes);
        this.htmlNo = new MirthRadioButton("No");
        this.htmlNo.setBackground(this.getBackground());
        htmlButtonGroup.add((AbstractButton)this.htmlNo);
        this.bodyLabel = new JLabel("Body:");
        this.bodyTextPane = new MirthSyntaxTextArea();
        this.bodyTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.headersLabel = new JLabel("Headers:");
        this.headersTable = new MirthTable();
        this.headersPane = new JScrollPane((Component)this.headersTable);
        this.newHeaderButton = new JButton("New");
        this.newHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.newHeaderButtonActionPerformed();
            }
        });
        this.deleteHeaderButton = new JButton("Delete");
        this.deleteHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.deleteHeaderButtonActionPerformed();
            }
        });
        this.useHeadersTableRadio = new MirthRadioButton("Use Table");
        this.useHeadersTableRadio.setBackground(this.getBackground());
        this.useHeadersTableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.useHeadersVariableFieldsEnabled(false);
            }
        });
        this.useHeadersVariableRadio = new MirthRadioButton("Use Map:");
        this.useHeadersVariableRadio.setBackground(this.getBackground());
        this.useHeadersVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.useHeadersVariableFieldsEnabled(true);
            }
        });
        ButtonGroup headersSourceButtonGroup = new ButtonGroup();
        headersSourceButtonGroup.add((AbstractButton)this.useHeadersTableRadio);
        headersSourceButtonGroup.add((AbstractButton)this.useHeadersVariableRadio);
        this.headersVariableField = new MirthTextField();
        this.attachmentsLabel = new JLabel("Attachments:");
        this.attachmentsTable = new MirthTable();
        this.attachmentsPane = new JScrollPane((Component)this.attachmentsTable);
        this.newAttachmentButton = new JButton("New");
        this.newAttachmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.newAttachmentButtonActionPerformed();
            }
        });
        this.deleteAttachmentButton = new JButton("Delete");
        this.deleteAttachmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.deleteAttachmentButtonActionPerformed();
            }
        });
        this.useAttachmentsListRadio = new MirthRadioButton("Use Table");
        this.useAttachmentsListRadio.setBackground(this.getBackground());
        this.useAttachmentsListRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.useAttachmentsVariableFieldsEnabled(false);
            }
        });
        this.useAttachmentsVariableRadio = new MirthRadioButton("Use List:");
        this.useAttachmentsVariableRadio.setBackground(this.getBackground());
        this.useAttachmentsVariableRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SmtpSender.this.useAttachmentsVariableFieldsEnabled(true);
            }
        });
        ButtonGroup attachmentSourceButtonGroup = new ButtonGroup();
        attachmentSourceButtonGroup.add((AbstractButton)this.useAttachmentsListRadio);
        attachmentSourceButtonGroup.add((AbstractButton)this.useAttachmentsVariableRadio);
        this.attachmentsVariableField = new MirthTextField();
    }

    private void initToolTips() {
        this.smtpHostField.setToolTipText("<html>Enter the DNS domain name or IP address of the SMTP server to use to send the email messages.<br>Note that sending email to an SMTP server that is not expecting it may result in the IP of the box running BridgeLink being added to the server's \"blacklist.\"</html>");
        this.smtpPortField.setToolTipText("<html>The port number of the SMTP server to send the email message to.<br>Generally, the default port of 25 is used.</html>");
        String toolTipText = "<html>Select Yes to override the local address and port that the client socket will be bound to.<br/>Select No to use the default value picked by the Socket class.<br/>A local port of zero (0) indicates that the OS should assign an ephemeral port automatically.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>";
        this.overrideLocalBindingYesRadio.setToolTipText(toolTipText);
        this.overrideLocalBindingNoRadio.setToolTipText(toolTipText);
        this.localAddressField.setToolTipText("<html>The local address that the client socket will be bound to, if Override Local Binding is set to Yes.<br/></html>");
        this.localPortField.setToolTipText("<html>The local port that the client socket will be bound to, if Override Local Binding is set to Yes.<br/><br/>Note that if a specific (non-zero) local port is chosen, then after a socket is closed it's up to the<br/>underlying OS to release the port before the next socket creation, otherwise the bind attempt will fail.<br/></html>");
        this.sendTimeoutField.setToolTipText("<html>Enter the number of milliseconds for the SMTP socket connection timeout.</html>");
        toolTipText = "Selects whether STARTTLS or SSL should be used for optional connection security.";
        this.encryptionNone.setToolTipText(toolTipText);
        this.encryptionTls.setToolTipText(toolTipText);
        this.encryptionSsl.setToolTipText(toolTipText);
        this.useAuthenticationYes.setToolTipText("Use SMTP authentication.");
        this.useAuthenticationNo.setToolTipText("Do not use SMTP authentication.");
        this.usernameField.setToolTipText("If the SMTP server requires authentication to send a message, enter the username here.");
        this.passwordField.setToolTipText("If the SMTP server requires authentication to send a message, enter the password here.");
        this.toField.setToolTipText("The name of the mailbox (person, usually) to which the email should be sent.");
        this.fromField.setToolTipText("The name that should appear as the \"From address\" in the email.");
        this.subjectField.setToolTipText("The text that should appear as the subject of the email, as seen by the receiver's email client.");
        this.charsetEncodingComboBox.setToolTipText("<html>Select the character set encoding used by the sender of the message,<br> or Default to assume the default character set encoding for the JVM running BridgeLink.</html>");
        toolTipText = "Selects whether HTML tags can be used in the email message body.";
        this.htmlYes.setToolTipText(toolTipText);
        this.htmlNo.setToolTipText(toolTipText);
        this.useHeadersTableRadio.setToolTipText("<html>The table below will be used to populate headers.</html>");
        this.useHeadersVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.headersVariableField.setToolTipText("<html>The variable of a Java map to use to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.useAttachmentsListRadio.setToolTipText("<html>The table below will be used to populate attachments.</html>");
        this.useAttachmentsVariableRadio.setToolTipText("<html>The Java list specified by the following variable will be used to populate attachments.<br/>The list must contain AttachmentEntry values - anything else is ignored.</html>");
        this.attachmentsVariableField.setToolTipText("<html>The variable of a Java list to use to populate attachments.<br/>The list must contain AttachmentEntry values.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 8 0 8, novisualpadding, hidemode 3, gap 12 6", "[][]6[]", "[][]4[]4[][][]4[]4[]4[][][][][][]4[]4[][][]"));
        this.add(this.smtpHostLabel, "right");
        this.add((Component)this.smtpHostField, "w 200!, sx, split 2");
        this.add(this.sendTestEmailButton, "gapbefore 6");
        this.add(this.smtpPortLabel, "newline, right");
        this.add((Component)this.smtpPortField, "w 50!, sx");
        this.add(this.overrideLocalBindingLabel, "newline, right");
        this.add((Component)this.overrideLocalBindingYesRadio, "split 2");
        this.add((Component)this.overrideLocalBindingNoRadio);
        this.add(this.localAddressLabel, "newline, right");
        this.add((Component)this.localAddressField, "w 200!, sx");
        this.add(this.localPortLabel, "newline, right");
        this.add((Component)this.localPortField, "w 50!, sx");
        this.add(this.sendTimeoutLabel, "newline, right");
        this.add((Component)this.sendTimeoutField, "w 75!, sx");
        this.add(this.encryptionLabel, "newline, right");
        this.add((Component)this.encryptionNone, "split 3");
        this.add((Component)this.encryptionTls);
        this.add((Component)this.encryptionSsl);
        this.add(this.useAuthenticationLabel, "newline, right");
        this.add((Component)this.useAuthenticationYes, "split 2");
        this.add((Component)this.useAuthenticationNo);
        this.add(this.usernameLabel, "newline, right");
        this.add((Component)this.usernameField, "w 125!, sx");
        this.add(this.passwordLabel, "newline, right");
        this.add((Component)this.passwordField, "w 125!, sx");
        this.add(this.toLabel, "newline, right");
        this.add((Component)this.toField, "w 200!, sx");
        this.add(this.fromLabel, "newline, right");
        this.add((Component)this.fromField, "w 200!, sx");
        this.add(this.subjectLabel, "newline, right");
        this.add((Component)this.subjectField, "w 250!, sx");
        this.add(this.charsetEncodingLabel, "newline, right");
        this.add((Component)this.charsetEncodingComboBox);
        this.add(this.htmlLabel, "newline, right");
        this.add((Component)this.htmlYes, "split 2");
        this.add((Component)this.htmlNo);
        this.add(this.bodyLabel, "newline, top, right");
        this.add((Component)this.bodyTextPane, "grow, push, sx, h 89:");
        this.add(this.headersLabel, "newline, right");
        this.add((Component)this.useHeadersTableRadio, "split 3");
        this.add((Component)this.useHeadersVariableRadio);
        this.add((Component)this.headersVariableField, "w 125");
        this.add(this.headersPane, "newline, growx, pushx, skip 1, span 2, h 85!");
        this.add(this.newHeaderButton, "top, flowy, split 2, w 44!");
        this.add(this.deleteHeaderButton, "w 44!");
        this.add(this.attachmentsLabel, "newline, right");
        this.add((Component)this.useAttachmentsListRadio, "split 3");
        this.add((Component)this.useAttachmentsVariableRadio);
        this.add((Component)this.attachmentsVariableField, "w 125");
        this.add(this.attachmentsPane, "newline, growx, pushx, skip 1, span 2, h 85!");
        this.add(this.newAttachmentButton, "top, flowy, split 2, w 44!");
        this.add(this.deleteAttachmentButton, "w 44!");
    }

    private void newAttachmentButtonActionPerformed() {
        ((DefaultTableModel)this.attachmentsTable.getModel()).addRow(new Object[]{this.getNewUniqueName(this.attachmentsTable), ""});
        this.attachmentsTable.setRowSelectionInterval(this.attachmentsTable.getRowCount() - 1, this.attachmentsTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void deleteAttachmentButtonActionPerformed() {
        if (this.getSelectedRow(this.attachmentsTable) != -1 && !this.attachmentsTable.isEditing()) {
            ((DefaultTableModel)this.attachmentsTable.getModel()).removeRow(this.getSelectedRow(this.attachmentsTable));
            if (this.attachmentsTable.getRowCount() != 0) {
                if (this.attachmentsLastIndex == 0) {
                    this.attachmentsTable.setRowSelectionInterval(0, 0);
                } else if (this.attachmentsLastIndex == this.attachmentsTable.getRowCount()) {
                    this.attachmentsTable.setRowSelectionInterval(this.attachmentsLastIndex - 1, this.attachmentsLastIndex - 1);
                } else {
                    this.attachmentsTable.setRowSelectionInterval(this.attachmentsLastIndex, this.attachmentsLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void setAuthenticationFieldsEnabled(boolean useAuthentication) {
        this.usernameLabel.setEnabled(useAuthentication);
        this.usernameField.setEnabled(useAuthentication);
        this.passwordLabel.setEnabled(useAuthentication);
        this.passwordField.setEnabled(useAuthentication);
    }

    private void sendTestEmailButtonActionPerformed() {
        if (!this.checkProperties(this.getProperties(), true)) {
            this.parent.alertCustomError((Component)this.parent, this.errors, "Please fix the following errors before sending a test email:");
            return;
        }
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    SmtpSender.this.parent.alertError((Component)SmtpSender.this.parent, "Failed to send email.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    SmtpSender.this.parent.alertInformation((Component)SmtpSender.this.parent, connectionTestResponse.getMessage());
                } else {
                    SmtpSender.this.parent.alertWarning((Component)SmtpSender.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((SmtpConnectorServletInterface)this.getServlet(SmtpConnectorServletInterface.class, "Sending test email...", "Failed to send email.\n\n", handler)).sendTestEmail(this.getChannelId(), this.getChannelName(), (SmtpDispatcherProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void newHeaderButtonActionPerformed() {
        ((DefaultTableModel)this.headersTable.getModel()).addRow(new Object[]{this.getNewUniqueName(this.headersTable), ""});
        this.headersTable.setRowSelectionInterval(this.headersTable.getRowCount() - 1, this.headersTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void deleteHeaderButtonActionPerformed() {
        if (this.getSelectedRow(this.headersTable) != -1 && !this.headersTable.isEditing()) {
            ((DefaultTableModel)this.headersTable.getModel()).removeRow(this.getSelectedRow(this.headersTable));
            if (this.headersTable.getRowCount() != 0) {
                if (this.headersLastIndex == 0) {
                    this.headersTable.setRowSelectionInterval(0, 0);
                } else if (this.headersLastIndex == this.headersTable.getRowCount()) {
                    this.headersTable.setRowSelectionInterval(this.headersLastIndex - 1, this.headersLastIndex - 1);
                } else {
                    this.headersTable.setRowSelectionInterval(this.headersLastIndex, this.headersLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void overrideLocalBindingFieldsEnabled(boolean isUseLocal) {
        this.localAddressField.setEnabled(isUseLocal);
        this.localAddressLabel.setEnabled(isUseLocal);
        this.localPortField.setEnabled(isUseLocal);
        this.localPortLabel.setEnabled(isUseLocal);
    }

    private void useAttachmentsVariableFieldsEnabled(boolean useVariable) {
        this.attachmentsVariableField.setEnabled(useVariable);
        this.attachmentsTable.setEnabled(!useVariable);
        this.newAttachmentButton.setEnabled(!useVariable);
        this.deleteAttachmentButton.setEnabled(!useVariable && this.attachmentsTable.getSelectedRow() > -1);
    }

    private void useHeadersVariableFieldsEnabled(boolean useVariable) {
        this.headersVariableField.setEnabled(useVariable);
        this.headersTable.setEnabled(!useVariable);
        this.newHeaderButton.setEnabled(!useVariable);
        this.deleteHeaderButton.setEnabled(!useVariable && this.headersTable.getSelectedRow() > -1);
    }
}

