/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.vm;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.connectors.vm.VmDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ChannelWriter
extends ConnectorSettingsPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private Map<String, String> channelList;
    private ArrayList<String> channelNameArray;
    private Boolean channelIdModified = false;
    private Boolean comboBoxModified = false;
    private JLabel URL;
    private JLabel URL1;
    private ButtonGroup buttonGroup1;
    private JTextField channelIdField;
    private MirthComboBox channelNames;
    private JButton deleteButton;
    private JLabel jLabel7;
    private JScrollPane mapVariablesPane;
    private MirthTable mapVariablesTable;
    private JButton newButton;
    private MirthSyntaxTextArea template;

    public ChannelWriter() {
        this.initComponents();
        this.channelIdField.setToolTipText("<html>The destination channel's unique global id.</html>");
        this.channelIdField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChannelWriter.this.updateField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChannelWriter.this.updateField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ChannelWriter.this.updateField();
            }
        });
        class CustomTableCellEditor
        extends TextFieldCellEditor {
            CustomTableCellEditor() {
            }

            protected boolean valueChanged(String value) {
                if (value.length() == 0 || this.checkUniqueProperty(value)) {
                    return false;
                }
                ChannelWriter.this.parent.setSaveEnabled(true);
                return true;
            }

            protected boolean checkUniqueProperty(String property) {
                boolean exists = false;
                for (int rowIndex = 0; rowIndex < ChannelWriter.this.mapVariablesTable.getRowCount(); ++rowIndex) {
                    if (ChannelWriter.this.mapVariablesTable.getValueAt(rowIndex, 0) == null || !((String)ChannelWriter.this.mapVariablesTable.getValueAt(rowIndex, 0)).equalsIgnoreCase(property)) continue;
                    exists = true;
                }
                return exists;
            }
        }
        this.mapVariablesTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new CustomTableCellEditor()));
        this.mapVariablesTable.setSelectionMode(0);
        this.mapVariablesTable.setToolTipText("The following map variables will be included in the source map of the destination channel's message.\nWhen adding rows to this table, only use the map key itself, without the \"${}\" syntax.");
        this.mapVariablesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (ChannelWriter.this.mapVariablesTable.getRowCount() > 0) {
                    ChannelWriter.this.deleteButton.setEnabled(true);
                } else {
                    ChannelWriter.this.deleteButton.setEnabled(false);
                }
            }
        });
        DropTarget gt = new DropTarget();
        try {
            gt.addDropTargetListener(new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                }

                @Override
                public void dragOver(DropTargetDragEvent dtde) {
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    Transferable transferable = dtde.getTransferable();
                    String data = "";
                    try {
                        dtde.acceptDrop(3);
                        data = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        if (data.startsWith("${") && data.endsWith("}")) {
                            data = data.substring(2, data.length() - 1);
                        }
                        ((CustomTableCellEditor)((Object)ChannelWriter.this.mapVariablesTable.getColumnModel().getColumn(0).getCellEditor())).getTextField().setText(data);
                        dtde.dropComplete(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.rejectDrop();
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dtde) {
                }
            });
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
        }
        gt.setFlavorMap(new FlavorMap(){

            @Override
            public Map<String, DataFlavor> getFlavorsForNatives(String[] natives) {
                return null;
            }

            @Override
            public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] flavors) {
                return null;
            }
        });
        CustomTableCellEditor customTableCellEditor = (CustomTableCellEditor)((Object)this.mapVariablesTable.getColumnModel().getColumn(0).getCellEditor());
        customTableCellEditor.getTextField().setDropTarget(gt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateField() {
        try {
            this.channelIdModified = true;
            if (!this.comboBoxModified.booleanValue()) {
                String fieldEntry = this.channelIdField.getText();
                String selection = "";
                if (StringUtils.isBlank((CharSequence)fieldEntry)) {
                    selection = "<None>";
                } else if (this.channelList.containsValue(fieldEntry)) {
                    for (Map.Entry<String, String> entry : this.channelList.entrySet()) {
                        if (!entry.getValue().equals(fieldEntry)) continue;
                        fieldEntry = entry.getKey();
                    }
                    selection = fieldEntry;
                } else {
                    selection = fieldEntry.contains("$") ? "<Map Variable>" : "<Channel Not Found>";
                }
                this.channelNames.getModel().setSelectedItem(selection);
            }
        }
        finally {
            this.channelIdModified = false;
        }
    }

    public String getConnectorName() {
        return new VmDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        VmDispatcherProperties properties = new VmDispatcherProperties();
        properties.setChannelId(StringUtils.isBlank((CharSequence)this.channelIdField.getText()) ? "none" : this.channelIdField.getText());
        properties.setChannelTemplate(this.template.getText());
        properties.setMapVariables(this.getMapVariableTableValues());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        VmDispatcherProperties props = (VmDispatcherProperties)properties;
        this.channelNameArray = new ArrayList();
        this.channelList = new HashMap<String, String>();
        this.channelList.put("<None>", "none");
        String selectedChannelName = "None";
        for (Map.Entry entry : this.parent.channelPanel.getCachedChannelIdsAndNames().entrySet()) {
            String channnelId = (String)entry.getKey();
            String channelName = (String)entry.getValue();
            if (props.getChannelId().equalsIgnoreCase(channnelId)) {
                selectedChannelName = channelName;
            }
            this.channelList.put(channelName, channnelId);
            this.channelNameArray.add(channelName);
        }
        Collections.sort(this.channelNameArray);
        this.channelNameArray.add(0, "<None>");
        this.channelNames.setModel(new DefaultComboBoxModel<Object>(this.channelNameArray.toArray()));
        boolean enabled = this.parent.isSaveEnabled();
        String channelId = props.getChannelId();
        this.channelIdField.setText(channelId.equals("none") ? "" : channelId);
        this.channelNames.setSelectedItem((Object)selectedChannelName);
        this.template.setText(props.getChannelTemplate());
        this.setMapVariableTableValues(props.getMapVariables());
        if (this.mapVariablesTable.getRowCount() > 0) {
            this.mapVariablesTable.setRowSelectionInterval(0, 0);
        }
        this.deleteButton.setEnabled(this.mapVariablesTable.getRowCount() > 0);
        this.parent.setSaveEnabled(enabled);
    }

    public ConnectorProperties getDefaults() {
        return new VmDispatcherProperties();
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        return true;
    }

    public void resetInvalidProperties() {
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.URL = new JLabel();
        this.channelNames = new MirthComboBox();
        this.jLabel7 = new JLabel();
        this.template = new MirthSyntaxTextArea();
        this.channelIdField = new JTextField();
        this.mapVariablesPane = new JScrollPane();
        this.mapVariablesTable = new MirthTable();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.URL1 = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.URL.setText("Channel Id:");
        this.channelNames.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.channelNames.setToolTipText("<html>Select the channel to which messages accepted by this destination's filter should be written,<br> or none to not write the message at all.</html>");
        this.channelNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWriter.this.channelNamesActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Template:");
        this.template.setBorder(BorderFactory.createEtchedBorder());
        this.template.setToolTipText("<html>A Velocity enabled template for the actual message to be written to the channel.<br>In many cases, the default value of \"${message.encodedData}\" is sufficient.</html>");
        this.mapVariablesTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Map Variable"}));
        this.mapVariablesTable.setToolTipText("Query parameters are encoded as x=y pairs as part of the request URL, separated from it by a '?' and from each other by an '&'.");
        this.mapVariablesTable.setDragEnabled(false);
        this.mapVariablesTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        this.mapVariablesTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ChannelWriter.this.mapVariablesTableKeyTyped(evt);
            }
        });
        this.mapVariablesPane.setViewportView((Component)this.mapVariablesTable);
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWriter.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelWriter.this.deleteButtonActionPerformed(evt);
            }
        });
        this.URL1.setText("Message Metadata:");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.URL, GroupLayout.Alignment.TRAILING).addComponent(this.URL1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.mapVariablesPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE).addComponent(this.newButton, -1, -1, Short.MAX_VALUE))).addComponent((Component)this.template, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.channelIdField, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.channelNames, -2, 250, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.URL).addComponent((Component)this.channelNames, -2, -1, -2).addComponent(this.channelIdField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addComponent(this.URL1).addComponent(this.mapVariablesPane, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.template, -1, 113, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelNamesActionPerformed(ActionEvent evt) {
        try {
            this.comboBoxModified = true;
            if (!this.channelIdModified.booleanValue()) {
                String selectedChannelName = this.channelNames.getSelectedItem().toString();
                String channelId = null;
                if (selectedChannelName.equals("<None>")) {
                    channelId = "";
                } else if (this.channelNameArray.contains(selectedChannelName)) {
                    channelId = this.channelList.get(selectedChannelName);
                }
                if (channelId != null) {
                    this.channelIdField.setText(channelId);
                }
            }
        }
        finally {
            this.comboBoxModified = false;
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.mapVariablesTable.getModel();
        Vector<CallSite> row = new Vector<CallSite>();
        String name = "Variable ";
        for (int i = 1; i <= this.mapVariablesTable.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int index = 0; index < this.mapVariablesTable.getRowCount(); ++index) {
                if (!((String)this.mapVariablesTable.getValueAt(index, 0)).equalsIgnoreCase(name + i)) continue;
                exists = true;
            }
            if (exists) continue;
            row.add((CallSite)((Object)(name + i)));
            break;
        }
        model.addRow(row);
        int rowSelectionNumber = this.mapVariablesTable.getRowCount() - 1;
        this.mapVariablesTable.setRowSelectionInterval(rowSelectionNumber, rowSelectionNumber);
        Boolean enabled = this.deleteButton.isEnabled();
        if (!enabled.booleanValue()) {
            this.deleteButton.setEnabled(true);
        }
        this.parent.setSaveEnabled(true);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int rowSelectionNumber = this.mapVariablesTable.getSelectedModelIndex();
        if (rowSelectionNumber > -1) {
            DefaultTableModel model = (DefaultTableModel)this.mapVariablesTable.getModel();
            int viewSelectionRow = this.mapVariablesTable.convertRowIndexToView(rowSelectionNumber);
            model.removeRow(rowSelectionNumber);
            if (this.mapVariablesTable.getRowCount() != 0) {
                if (viewSelectionRow == 0) {
                    this.mapVariablesTable.setRowSelectionInterval(0, 0);
                } else if (viewSelectionRow == this.mapVariablesTable.getRowCount()) {
                    this.mapVariablesTable.setRowSelectionInterval(--viewSelectionRow, viewSelectionRow);
                } else {
                    this.mapVariablesTable.setRowSelectionInterval(viewSelectionRow, viewSelectionRow);
                }
            }
            this.deleteButton.setEnabled(this.mapVariablesTable.getRowCount() != 0);
            this.parent.setSaveEnabled(true);
        }
    }

    private void mapVariablesTableKeyTyped(KeyEvent evt) {
        this.parent.setSaveEnabled(true);
    }

    private List<String> getMapVariableTableValues() {
        ArrayList<String> sourceMap = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < this.mapVariablesTable.getRowCount(); ++rowIndex) {
            String key = this.mapVariablesTable.getValueAt(rowIndex, 0).toString();
            if (StringUtils.isBlank((CharSequence)key)) continue;
            sourceMap.add(key);
        }
        return sourceMap;
    }

    private void setMapVariableTableValues(List<String> sourceMap) {
        ((DefaultTableModel)this.mapVariablesTable.getModel()).setRowCount(0);
        DefaultTableModel tableModel = (DefaultTableModel)this.mapVariablesTable.getModel();
        if (sourceMap != null) {
            for (String entry : sourceMap) {
                tableModel.addRow(new Object[]{entry});
            }
        }
    }
}

