/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class CLibImageWriter
extends ImageWriter {
    private static final Object getDataBufferData(DataBuffer db) {
        Object[] data;
        int dType = db.getDataType();
        switch (dType) {
            case 0: {
                data = ((DataBufferByte)db).getData();
                break;
            }
            case 1: {
                data = ((DataBufferUShort)db).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dType);
            }
        }
        return data;
    }

    private static final int getMediaLibDataType(int dataType) {
        int mlibType;
        switch (dataType) {
            case 0: {
                mlibType = 1;
                break;
            }
            case 1: {
                mlibType = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + dataType);
            }
        }
        return mlibType;
    }

    protected CLibImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    private static final Rectangle getSourceRegion(ImageWriteParam param, int sourceMinX, int sourceMinY, int srcWidth, int srcHeight) {
        Rectangle sourceRegion = new Rectangle(sourceMinX, sourceMinY, srcWidth, srcHeight);
        if (param != null) {
            Rectangle region = param.getSourceRegion();
            if (region != null) {
                sourceRegion = sourceRegion.intersection(region);
            }
            int subsampleXOffset = param.getSubsamplingXOffset();
            int subsampleYOffset = param.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        return sourceRegion;
    }

    protected mediaLibImage getMediaLibImage(RenderedImage image, ImageWriteParam param, boolean allowBilevel) {
        int i;
        int numSourceBands;
        int[] sourceBands;
        Raster raster = null;
        Rectangle sourceRegion = CLibImageWriter.getSourceRegion(param, image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        if (sourceRegion.isEmpty()) {
            throw new IllegalArgumentException("sourceRegion.isEmpty()");
        }
        if (param != null && (param.getSourceXSubsampling() > 1 || param.getSourceYSubsampling() > 1)) {
            AffineTransform transform = new AffineTransform(1.0 / (double)param.getSourceXSubsampling(), 0.0, 0.0, 1.0 / (double)param.getSourceYSubsampling(), (double)param.getSubsamplingXOffset(), (double)param.getSubsamplingYOffset());
            AffineTransformOp affineOp = new AffineTransformOp(transform, 1);
            Raster sourceData = image.getData(sourceRegion);
            sourceData = sourceData.createTranslatedChild(0, 0);
            raster = affineOp.filter(sourceData, null);
            raster = raster.createTranslatedChild(0, 0);
        }
        boolean reformatData = false;
        boolean isBilevel = false;
        SampleModel sampleModel = image.getSampleModel();
        int numBands = sampleModel.getNumBands();
        int[] nArray = sourceBands = param != null ? param.getSourceBands() : null;
        if (sourceBands != null) {
            numSourceBands = sourceBands.length;
            if (numSourceBands != numBands) {
                reformatData = true;
            } else {
                int i2 = 0;
                while (i2 < numBands) {
                    if (sourceBands[i2] != i2) {
                        reformatData = true;
                        break;
                    }
                    ++i2;
                }
            }
        } else {
            numSourceBands = numBands;
        }
        if (!reformatData) {
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
                if (csm.getPixelStride() != numBands) {
                    reformatData = true;
                } else {
                    int[] bandOffsets = csm.getBandOffsets();
                    i = 0;
                    while (i < numBands) {
                        if (bandOffsets[i] != i) {
                            reformatData = true;
                            break;
                        }
                        ++i;
                    }
                }
            } else if (allowBilevel && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1 && sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getDataType() == 0) {
                MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
                if (mppsm.getPixelBitStride() == 1) {
                    isBilevel = true;
                } else {
                    reformatData = true;
                }
            } else {
                reformatData = true;
            }
        }
        if (reformatData) {
            SampleModel newSampleModel;
            int height;
            int width;
            int dataType;
            int[] sampleSize = sampleModel.getSampleSize();
            int bitDepthMax = sampleSize[0];
            i = 1;
            while (i < numBands) {
                bitDepthMax = Math.max(bitDepthMax, sampleSize[i]);
                ++i;
            }
            if (bitDepthMax <= 8) {
                dataType = 0;
            } else if (bitDepthMax <= 16) {
                dataType = 1;
            } else {
                throw new UnsupportedOperationException(I18N.getString("CLibImageWriter0") + " " + bitDepthMax);
            }
            if (raster != null) {
                width = raster.getWidth();
                height = raster.getHeight();
            } else {
                width = sourceRegion.width;
                height = sourceRegion.height;
            }
            int[] newBandOffsets = new int[numSourceBands];
            int i3 = 0;
            while (i3 < numSourceBands) {
                newBandOffsets[i3] = i3;
                ++i3;
            }
            if (allowBilevel && sampleModel.getNumBands() == 1 && bitDepthMax == 1) {
                newSampleModel = new MultiPixelPackedSampleModel(dataType, width, height, 1);
                isBilevel = true;
            } else {
                newSampleModel = new PixelInterleavedSampleModel(dataType, width, height, newBandOffsets.length, width * numBands, newBandOffsets);
            }
            WritableRaster newRaster = Raster.createWritableRaster(newSampleModel, null);
            if (raster != null) {
                if (sourceBands != null) {
                    Raster bandChild = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), sourceBands);
                    newRaster.setRect(bandChild);
                } else {
                    newRaster.setRect(raster);
                }
            } else if (image.getSampleModel().getClass().isInstance(newSampleModel) && newSampleModel.getTransferType() == image.getSampleModel().getTransferType()) {
                WritableRaster translatedChild = newRaster.createWritableTranslatedChild(sourceRegion.x, sourceRegion.y);
                image.copyData(translatedChild);
            } else {
                newRaster.setRect(image.getData(sourceRegion));
            }
            raster = newRaster;
            sampleModel = newRaster.getSampleModel();
        } else if (raster == null) {
            raster = image.getData(sourceRegion).createTranslatedChild(0, 0);
        }
        mediaLibImage mlibImage = null;
        if (isBilevel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            int stride = mppsm.getScanlineStride();
            int offset = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * stride - raster.getSampleModelTranslateX() / 8 + mppsm.getOffset(0, 0);
            Object bitData = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            mlibImage = new mediaLibImage(0, 1, raster.getWidth(), raster.getHeight(), stride, offset, (byte)mppsm.getBitOffset(0), bitData);
        } else {
            int mlibDataType = CLibImageWriter.getMediaLibDataType(sampleModel.getDataType());
            Object data = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            int stride = ((ComponentSampleModel)sampleModel).getScanlineStride();
            int offset = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * stride - raster.getSampleModelTranslateX();
            mlibImage = new mediaLibImage(mlibDataType, numBands, raster.getWidth(), raster.getHeight(), stride, offset, data);
        }
        return mlibImage;
    }
}

