/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.connectors.http.HttpStaticResource;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.ListenerConnectorProperties;
import com.mirth.connect.donkey.model.channel.ListenerConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class HttpReceiverProperties
extends ConnectorProperties
implements ListenerConnectorPropertiesInterface,
SourceConnectorPropertiesInterface {
    private ListenerConnectorProperties listenerConnectorProperties = new ListenerConnectorProperties("80");
    private SourceConnectorProperties sourceConnectorProperties = new SourceConnectorProperties();
    private boolean xmlBody = false;
    private boolean parseMultipart = true;
    private boolean includeMetadata = false;
    private String binaryMimeTypes = "application/.*(?<!json|xml)$|image/.*|video/.*|audio/.*";
    private boolean binaryMimeTypesRegex = true;
    private String responseContentType = "text/plain";
    private boolean responseDataTypeBinary = false;
    private String responseStatusCode = "";
    private Map<String, List<String>> responseHeaders = new LinkedHashMap<String, List<String>>();
    private String responseHeadersVariable = "";
    private boolean useResponseHeadersVariable = false;
    private String charset = "UTF-8";
    private String contextPath = "";
    private String timeout = "30000";
    private List<HttpStaticResource> staticResources = new ArrayList<HttpStaticResource>();

    public boolean isXmlBody() {
        return this.xmlBody;
    }

    public void setXmlBody(boolean xmlBody) {
        this.xmlBody = xmlBody;
    }

    public boolean isParseMultipart() {
        return this.parseMultipart;
    }

    public void setParseMultipart(boolean parseMultipart) {
        this.parseMultipart = parseMultipart;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public String getBinaryMimeTypes() {
        return this.binaryMimeTypes;
    }

    public void setBinaryMimeTypes(String binaryMimeTypes) {
        this.binaryMimeTypes = binaryMimeTypes;
    }

    public boolean isBinaryMimeTypesRegex() {
        return this.binaryMimeTypesRegex;
    }

    public void setBinaryMimeTypesRegex(boolean binaryMimeTypesRegex) {
        this.binaryMimeTypesRegex = binaryMimeTypesRegex;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public boolean isResponseDataTypeBinary() {
        return this.responseDataTypeBinary;
    }

    public void setResponseDataTypeBinary(boolean responseDataTypeBinary) {
        this.responseDataTypeBinary = responseDataTypeBinary;
    }

    public String getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public void setResponseStatusCode(String responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public Map<String, List<String>> getResponseHeadersMap() {
        return this.responseHeaders;
    }

    public void setResponseHeadersMap(Map<String, List<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public boolean isUseHeadersVariable() {
        return this.useResponseHeadersVariable;
    }

    public void setUseHeadersVariable(boolean useResponseHeadersVariable) {
        this.useResponseHeadersVariable = useResponseHeadersVariable;
    }

    public void setResponseHeadersVariable(String headersVariable) {
        this.responseHeadersVariable = headersVariable;
    }

    public String getResponseHeadersVariable() {
        return this.responseHeadersVariable;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public List<HttpStaticResource> getStaticResources() {
        return this.staticResources;
    }

    public void setStaticResources(List<HttpStaticResource> staticResources) {
        this.staticResources = staticResources;
    }

    public String getProtocol() {
        return "HTTP";
    }

    public String getName() {
        return "HTTP Listener";
    }

    public String toFormattedString() {
        return null;
    }

    public ListenerConnectorProperties getListenerConnectorProperties() {
        return this.listenerConnectorProperties;
    }

    public SourceConnectorProperties getSourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    public boolean canBatch() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        boolean xmlBody = false;
        DonkeyElement bodyOnlyElement = element.removeChild("bodyOnly");
        if (bodyOnlyElement != null) {
            xmlBody = !Boolean.parseBoolean(bodyOnlyElement.getTextContent());
        }
        element.addChildElementIfNotExists("xmlBody", Boolean.toString(xmlBody));
        element.addChildElementIfNotExists("parseMultipart", Boolean.toString(!xmlBody));
        element.addChildElementIfNotExists("includeMetadata", Boolean.toString(xmlBody));
        if (xmlBody) {
            element.addChildElementIfNotExists("binaryMimeTypes", "application/, image/, video/, audio/");
        } else {
            element.addChildElementIfNotExists("binaryMimeTypes");
        }
        element.addChildElementIfNotExists("binaryMimeTypesRegex", "false");
        element.addChildElementIfNotExists("responseDataTypeBinary", "false");
        element.addChildElementIfNotExists("staticResources");
    }

    public void migrate3_2_0(DonkeyElement element) {
        if (element.getChildElement("responseHeaders") != null) {
            DonkeyElement oldHeaders = element.removeChild("responseHeaders");
            DonkeyElement newHeaders = element.addChildElement("responseHeaders");
            newHeaders.setAttribute("class", "linked-hash-map");
            for (DonkeyElement oldEntry : oldHeaders.getChildElements()) {
                if (oldEntry.getChildElements().size() < 2) continue;
                DonkeyElement entry = newHeaders.addChildElement("entry");
                entry.addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(0)).getTextContent());
                entry.addChildElement("list").addChildElement("string", ((DonkeyElement)oldEntry.getChildElements().get(1)).getTextContent());
            }
        }
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("sourceConnectorProperties", this.sourceConnectorProperties.getPurgedProperties());
        purgedProperties.put("binaryMimeTypesRegex", this.binaryMimeTypesRegex);
        purgedProperties.put("responseDataTypeBinary", this.responseDataTypeBinary);
        purgedProperties.put("responseHeaderChars", this.responseHeaders.size());
        purgedProperties.put("charset", this.charset);
        purgedProperties.put("timeout", PurgeUtil.getNumericValue((String)this.timeout));
        return purgedProperties;
    }
}

