/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.ncpdp;

import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPReference;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NCPDPReader
extends SAXParser {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private String segmentDelimeter;
    private String groupDelimeter;
    private String fieldDelimeter;
    private String version;

    public NCPDPReader(String segmentDelimeter, String groupDelimeter, String fieldDelimeter) {
        this.segmentDelimeter = segmentDelimeter;
        this.groupDelimeter = groupDelimeter;
        this.fieldDelimeter = fieldDelimeter;
    }

    public void parse(InputSource input) throws SAXException, IOException {
        String message = IOUtils.toString((Reader)input.getCharacterStream()).trim();
        ContentHandler contentHandler = this.getContentHandler();
        contentHandler.startDocument();
        if (message == null || message.length() < 3) {
            throw new SAXException("Unable to parse, message is null or too short: " + message);
        }
        String header = this.parseHeader(message, contentHandler);
        int groupDelimeterIndex = message.indexOf(this.groupDelimeter);
        int segmentDelimeterIndex = message.indexOf(this.segmentDelimeter);
        int bodyIndex = 0;
        bodyIndex = groupDelimeterIndex == -1 || segmentDelimeterIndex < groupDelimeterIndex ? segmentDelimeterIndex : groupDelimeterIndex;
        String body = message.substring(bodyIndex, message.length());
        boolean hasMoreSegments = true;
        boolean inGroup = false;
        boolean firstTransaction = true;
        int groupCounter = 0;
        while (hasMoreSegments) {
            groupDelimeterIndex = body.indexOf(this.groupDelimeter);
            segmentDelimeterIndex = body.indexOf(this.segmentDelimeter);
            if (groupDelimeterIndex > -1 && groupDelimeterIndex < segmentDelimeterIndex) {
                this.parseSegment(body.substring(0, groupDelimeterIndex), contentHandler);
                if (inGroup) {
                    contentHandler.endElement("", "TRANSACTION", "");
                }
                if (firstTransaction) {
                    firstTransaction = false;
                    contentHandler.startElement("", "TRANSACTIONS", "", null);
                }
                AttributesImpl attr = new AttributesImpl();
                attr.addAttribute("", "counter", "counter", "", Integer.toString(++groupCounter));
                contentHandler.startElement("", "TRANSACTION", "", attr);
                inGroup = true;
            } else if (groupDelimeterIndex == -1 && segmentDelimeterIndex == -1) {
                this.parseSegment(body, contentHandler);
                hasMoreSegments = false;
            } else {
                String segment = body.substring(0, segmentDelimeterIndex);
                this.parseSegment(segment, contentHandler);
            }
            body = body.substring(segmentDelimeterIndex + this.segmentDelimeter.length());
        }
        if (inGroup) {
            contentHandler.endElement("", "TRANSACTION", "");
            contentHandler.endElement("", "TRANSACTIONS", "");
        }
        contentHandler.endElement("", header, "");
        contentHandler.endDocument();
    }

    private String parseHeader(String message, ContentHandler contentHandler) throws SAXException {
        Object headerElementName = "";
        if (message.indexOf(this.segmentDelimeter) != -1) {
            String header = message.substring(0, message.indexOf(this.segmentDelimeter));
            if (header.length() > 40) {
                String transactionName = NCPDPReference.getInstance().getTransactionName(header.substring(8, 10));
                this.version = header.substring(6, 8);
                headerElementName = "NCPDP_" + this.version + "_" + transactionName + "_Request";
                contentHandler.startElement("", (String)headerElementName, "", null);
                contentHandler.startElement("", "TransactionHeaderRequest", "", null);
                contentHandler.startElement("", "BinNumber", "", null);
                contentHandler.characters(header.toCharArray(), 0, 6);
                contentHandler.endElement("", "BinNumber", "");
                contentHandler.startElement("", "VersionReleaseNumber", "", null);
                contentHandler.characters(header.toCharArray(), 6, 2);
                contentHandler.endElement("", "VersionReleaseNumber", "");
                contentHandler.startElement("", "TransactionCode", "", null);
                contentHandler.characters(header.toCharArray(), 8, 2);
                contentHandler.endElement("", "TransactionCode", "");
                contentHandler.startElement("", "ProcessorControlNumber", "", null);
                contentHandler.characters(header.toCharArray(), 10, 10);
                contentHandler.endElement("", "ProcessorControlNumber", "");
                contentHandler.startElement("", "TransactionCount", "", null);
                contentHandler.characters(header.toCharArray(), 20, 1);
                contentHandler.endElement("", "TransactionCount", "");
                contentHandler.startElement("", "ServiceProviderIdQualifier", "", null);
                contentHandler.characters(header.toCharArray(), 21, 2);
                contentHandler.endElement("", "ServiceProviderIdQualifier", "");
                contentHandler.startElement("", "ServiceProviderId", "", null);
                contentHandler.characters(header.toCharArray(), 23, 15);
                contentHandler.endElement("", "ServiceProviderId", "");
                contentHandler.startElement("", "DateOfService", "", null);
                contentHandler.characters(header.toCharArray(), 38, 8);
                contentHandler.endElement("", "DateOfService", "");
                contentHandler.startElement("", "SoftwareVendorCertificationId", "", null);
                contentHandler.characters(header.toCharArray(), 46, 10);
                contentHandler.endElement("", "SoftwareVendorCertificationId", "");
                contentHandler.endElement("", "TransactionHeaderRequest", "");
            } else {
                String transaction = NCPDPReference.getInstance().getTransactionName(header.substring(2, 4));
                this.version = header.substring(0, 2);
                headerElementName = "NCPDP_" + this.version + "_" + transaction + "_Response";
                contentHandler.startElement("", (String)headerElementName, "", null);
                contentHandler.startElement("", "TransactionHeaderResponse", "", null);
                contentHandler.startElement("", "VersionReleaseNumber", "", null);
                contentHandler.characters(header.toCharArray(), 0, 2);
                contentHandler.endElement("", "VersionReleaseNumber", "");
                contentHandler.startElement("", "TransactionCode", "", null);
                contentHandler.characters(header.toCharArray(), 2, 2);
                contentHandler.endElement("", "TransactionCode", "");
                contentHandler.startElement("", "TransactionCount", "", null);
                contentHandler.characters(header.toCharArray(), 4, 1);
                contentHandler.endElement("", "TransactionCount", "");
                contentHandler.startElement("", "HeaderResponseStatus", "", null);
                contentHandler.characters(header.toCharArray(), 5, 1);
                contentHandler.endElement("", "HeaderResponseStatus", "");
                contentHandler.startElement("", "ServiceProviderIdQualifier", "", null);
                contentHandler.characters(header.toCharArray(), 6, 2);
                contentHandler.endElement("", "ServiceProviderIdQualifier", "");
                contentHandler.startElement("", "ServiceProviderId", "", null);
                contentHandler.characters(header.toCharArray(), 8, 15);
                contentHandler.endElement("", "ServiceProviderId", "");
                contentHandler.startElement("", "DateOfService", "", null);
                contentHandler.characters(header.toCharArray(), 23, 8);
                contentHandler.endElement("", "DateOfService", "");
                contentHandler.endElement("", "TransactionHeaderResponse", "");
            }
        }
        return headerElementName;
    }

    private void parseSegment(String segment, ContentHandler contentHandler) throws SAXException {
        if (StringUtils.isBlank((CharSequence)segment)) {
            return;
        }
        boolean inCounter = false;
        boolean inCount = false;
        boolean hasMoreFields = true;
        String segmentId = "";
        String subSegment = "";
        Stack<Object> fieldStack = new Stack<Object>();
        int fieldDelimeterIndex = segment.indexOf(this.fieldDelimeter);
        if (fieldDelimeterIndex == 0) {
            segment = segment.substring(fieldDelimeterIndex + this.fieldDelimeter.length());
            fieldDelimeterIndex = segment.indexOf(this.fieldDelimeter);
        }
        if (fieldDelimeterIndex == -1) {
            this.logger.warn("Empty segment with no field seperators. Make sure batch file processing is disabled.");
            hasMoreFields = false;
            segmentId = segment;
        } else {
            segmentId = segment.substring(0, fieldDelimeterIndex);
            subSegment = segment.substring(fieldDelimeterIndex + this.fieldDelimeter.length(), segment.length());
        }
        contentHandler.startElement("", NCPDPReference.getInstance().getSegment(segmentId, this.version), "", null);
        while (hasMoreFields) {
            AttributesImpl attr;
            String field;
            fieldDelimeterIndex = subSegment.indexOf(this.fieldDelimeter);
            if (fieldDelimeterIndex != -1) {
                field = subSegment.substring(0, subSegment.indexOf(this.fieldDelimeter));
                subSegment = subSegment.substring(fieldDelimeterIndex + this.fieldDelimeter.length());
            } else {
                field = subSegment;
                hasMoreFields = false;
            }
            String fieldId = field.substring(0, 2);
            Object fieldDescription = NCPDPReference.getInstance().getDescription(fieldId, this.version);
            String fieldMessage = field.substring(2);
            if (((String)fieldDescription).isEmpty()) {
                fieldDescription = fieldId + "_field";
            }
            if (inCount && !this.isRepeatingField((String)fieldDescription) && !((String)fieldDescription).endsWith("Count")) {
                contentHandler.endElement("", (String)fieldStack.pop(), "");
                if (fieldStack.size() == 0) {
                    inCount = false;
                }
            }
            if (((String)fieldDescription).endsWith("Counter")) {
                if (inCounter) {
                    contentHandler.endElement("", (String)fieldStack.pop(), "");
                }
                inCounter = true;
                attr = new AttributesImpl();
                attr.addAttribute("", "counter", "counter", "", fieldMessage);
                contentHandler.startElement("", (String)fieldDescription, "", attr);
                fieldStack.push(fieldDescription);
                continue;
            }
            if (((String)fieldDescription).endsWith("Count")) {
                inCount = true;
                attr = new AttributesImpl();
                attr.addAttribute("", (String)fieldDescription, (String)fieldDescription, "", fieldMessage);
                contentHandler.startElement("", (String)fieldDescription, "", attr);
                fieldStack.push(fieldDescription);
                continue;
            }
            contentHandler.startElement("", (String)fieldDescription, "", null);
            contentHandler.characters(fieldMessage.toCharArray(), 0, fieldMessage.length());
            contentHandler.endElement("", (String)fieldDescription, "");
        }
        while (fieldStack.size() > 0) {
            contentHandler.endElement("", (String)fieldStack.pop(), "");
        }
        contentHandler.endElement("", NCPDPReference.getInstance().getSegment(segmentId, this.version), "");
    }

    private boolean isRepeatingField(String fieldDescription) {
        return NCPDPReference.getInstance().isRepeatingField(fieldDescription, this.version);
    }
}

