/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.js;

import com.mirth.connect.connectors.js.JavaScriptReceiverProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.PollConnector;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.userutil.RawMessage;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptReceiver
extends PollConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private EventController eventController = this.getEventController();
    private ContextFactoryController contextFactoryController = this.getContextFactoryController();
    private JavaScriptReceiverProperties connectorProperties;
    private String scriptId;
    private String contextFactoryId;
    private boolean debug = false;
    private MirthMain debugger;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private boolean ignoreBreakpoints = false;

    protected EventController getEventController() {
        return ControllerFactory.getFactory().createEventController();
    }

    protected ScriptController getScriptController() {
        return ControllerFactory.getFactory().createScriptController();
    }

    public void onDeploy() throws ConnectorTaskException {
        this.onDeploy(null);
    }

    public void onDebugDeploy(DebugOptions debugOptions) throws ConnectorTaskException {
        this.onDeploy(debugOptions);
    }

    public void onDeploy(DebugOptions debugOptions) throws ConnectorTaskException {
        this.connectorProperties = (JavaScriptReceiverProperties)this.getConnectorProperties();
        this.scriptId = ScriptController.getScriptId((String)"JavaScript_Reader", (String)this.getChannelId());
        try {
            MirthContextFactory contextFactory;
            boolean bl = this.debug = debugOptions != null && debugOptions.isSourceConnectorScripts();
            if (this.debug) {
                contextFactory = this.contextFactoryController.getDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId);
                contextFactory.setContextType(ContextType.SOURCE_RECEIVER);
                contextFactory.setScriptText(this.connectorProperties.getScript());
                contextFactory.setDebugType(Boolean.valueOf(true));
                this.debugger = this.getDebugger(contextFactory);
            } else {
                contextFactory = this.contextFactoryController.getContextFactory(this.getResourceIds());
            }
            this.contextFactoryId = contextFactory.getId();
            this.compileAndAddScript(contextFactory, this.scriptId);
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error compiling " + this.connectorProperties.getName() + " script " + this.scriptId + ".", (Throwable)e);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
        JavaScriptUtil.removeScriptFromCache((String)this.scriptId);
        if (this.debug && this.debugger != null) {
            this.contextFactoryController.removeDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    public void onStart() throws ConnectorTaskException {
        this.ignoreBreakpoints = false;
        if (this.debug && this.debugger != null) {
            this.debugger.enableDebugging();
        }
    }

    public void onStop() throws ConnectorTaskException {
        if (this.debug && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
    }

    public void onHalt() throws ConnectorTaskException {
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws InterruptedException {
        Object result = null;
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.READING));
        try {
            MirthContextFactory contextFactory;
            MirthContextFactory mirthContextFactory = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.getResourceIds());
            if (!this.contextFactoryId.equals(contextFactory.getId())) {
                JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.scriptId);
                this.contextFactoryId = contextFactory.getId();
            }
            result = JavaScriptUtil.execute((JavaScriptTask)new JavaScriptReceiverTask(contextFactory));
            for (com.mirth.connect.donkey.model.message.RawMessage rawMessage : this.convertJavaScriptResult(result)) {
                if (this.isTerminated()) {
                    return;
                }
                if (this.isProcessBatch()) {
                    if (rawMessage.isBinary().booleanValue()) {
                        throw new BatchMessageException("Batch processing is not supported for binary data in channel " + this.getChannelId());
                    }
                    BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(rawMessage.getRawData()), rawMessage.getSourceMap());
                    rawMessage = null;
                    this.dispatchBatchMessage(batchRawMessage, null);
                    continue;
                }
                DispatchResult dispatchResult = null;
                try {
                    dispatchResult = this.dispatchRawMessage(rawMessage);
                }
                catch (ChannelException channelException) {}
                continue;
                finally {
                    this.finishDispatch(dispatchResult);
                }
            }
        }
        catch (JavaScriptExecutorException e) {
            String errorMessage = "Error executing " + this.connectorProperties.getName() + " script " + this.scriptId + ".";
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), errorMessage, (Throwable)e));
            this.logger.error(errorMessage, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (BatchMessageException e) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), "Error processing batch message", (Throwable)e));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), null, t));
            this.logger.error("Error polling in channel: " + this.getChannelId(), t);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
        }
    }

    protected MirthMain getDebugger(MirthContextFactory contextFactory) {
        return MirthMain.mirthMainEmbedded((ContextFactory)contextFactory, (Object)this.scopeProvider, (String)(this.getChannel().getName() + "-" + this.getChannelId()), (String)this.scriptId);
    }

    private List<com.mirth.connect.donkey.model.message.RawMessage> convertJavaScriptResult(Object result) {
        String rawData;
        ArrayList<com.mirth.connect.donkey.model.message.RawMessage> messages = new ArrayList<com.mirth.connect.donkey.model.message.RawMessage>();
        if (result instanceof NativeJavaObject) {
            Object object = ((NativeJavaObject)result).unwrap();
            if (object instanceof List) {
                for (Object element : (List)object) {
                    if (element instanceof RawMessage) {
                        messages.add(this.convertRawMessage(element));
                        continue;
                    }
                    String rawData2 = element.toString();
                    if (!StringUtils.isNotEmpty((CharSequence)rawData2)) continue;
                    messages.add(new com.mirth.connect.donkey.model.message.RawMessage(rawData2));
                }
            } else if (object instanceof RawMessage) {
                messages.add(this.convertRawMessage(object));
            } else {
                String rawData3 = object.toString();
                if (StringUtils.isNotEmpty((CharSequence)rawData3)) {
                    messages.add(new com.mirth.connect.donkey.model.message.RawMessage(rawData3));
                }
            }
        } else if (result != null && !(result instanceof Undefined) && StringUtils.isNotEmpty((CharSequence)(rawData = result.toString()))) {
            messages.add(new com.mirth.connect.donkey.model.message.RawMessage(rawData));
        }
        return messages;
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected ChannelController getChannelController() {
        return ControllerFactory.getFactory().createChannelController();
    }

    private com.mirth.connect.donkey.model.message.RawMessage convertRawMessage(Object object) {
        RawMessage rawMessage = (RawMessage)object;
        if (rawMessage.isBinary().booleanValue()) {
            return new com.mirth.connect.donkey.model.message.RawMessage(rawMessage.getRawBytes(), rawMessage.getDestinationMetaDataIds(), rawMessage.getSourceMap());
        }
        return new com.mirth.connect.donkey.model.message.RawMessage(rawMessage.getRawData(), rawMessage.getDestinationMetaDataIds(), rawMessage.getSourceMap());
    }

    protected void compileAndAddScript(MirthContextFactory contextFactory, String scriptId) throws Exception {
        JavaScriptUtil.compileAndAddScript((String)this.getChannelId(), (MirthContextFactory)contextFactory, (String)scriptId, (String)this.connectorProperties.getScript(), (ContextType)ContextType.SOURCE_RECEIVER, null, null);
    }

    protected CompiledScriptCache getCompiledScriptCache() {
        return CompiledScriptCache.getInstance();
    }

    private class JavaScriptReceiverTask
    extends JavaScriptTask<Object> {
        public JavaScriptReceiverTask(MirthContextFactory contextFactory) {
            super(contextFactory, (SourceConnector)JavaScriptReceiver.this);
        }

        public Object doCall() throws Exception {
            try {
                Scriptable scope = JavaScriptScopeUtil.getMessageReceiverScope((ContextFactory)this.getContextFactory(), (Object)LogManager.getLogger((String)"js-connector"), (String)JavaScriptReceiver.this.getChannelId(), (String)JavaScriptReceiver.this.getChannel().getName());
                if (JavaScriptReceiver.this.debug) {
                    JavaScriptReceiver.this.scopeProvider.setScope(scope);
                    if (JavaScriptReceiver.this.debugger != null && !JavaScriptReceiver.this.ignoreBreakpoints) {
                        JavaScriptReceiver.this.debugger.doBreak();
                        if (!JavaScriptReceiver.this.debugger.isVisible()) {
                            JavaScriptReceiver.this.debugger.setVisible(true);
                        }
                    }
                }
                Object object = JavaScriptUtil.executeScript((JavaScriptTask)this, (String)JavaScriptReceiver.this.scriptId, (Scriptable)scope, (String)JavaScriptReceiver.this.getChannelId(), (String)"Source");
                return object;
            }
            finally {
                Context.exit();
            }
        }
    }
}

