/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.globalmapviewer;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/extensions/globalmapviewer")
@Tag(name="Extension Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface GlobalMapServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "Global Maps";
    public static final String PERMISSION_VIEW = "View Global Maps";

    @GET
    @Path(value="/maps/all")
    @Operation(summary="Retrieves global and/or global channel map information.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="globalMaps", ref="../apiexamples/global_maps_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="globalMaps", ref="../apiexamples/global_maps_json")})})
    @MirthOperation(name="getAllMaps", display="Get global / global channel maps", permission="View Global Maps", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, Map<String, Map<String, String>>> getAllMaps(@Param(value="channelIds") @Parameter(description="The ID of the channel to retrieve global channel map information for.") @QueryParam(value="channelId") Set<String> var1, @Param(value="includeGlobalMap") @Parameter(description="If true, the global map will be returned.") @QueryParam(value="includeGlobalMap") boolean var2) throws ClientException;

    @POST
    @Path(value="/maps/_getAllMaps")
    @Operation(summary="Retrieves global and/or global channel map information. This is a POST request alternative to GET /maps/all that may be used when there are too many channel IDs to include in the query parameters.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="globalMaps", ref="../apiexamples/global_maps_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="globalMaps", ref="../apiexamples/global_maps_json")})})
    @MirthOperation(name="getAllMaps", display="Get global / global channel maps", permission="View Global Maps", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Map<String, Map<String, Map<String, String>>> getAllMapsPost(@Param(value="channelIds") @RequestBody(description="The ID of the channel to retrieve global channel map information for.", content={@Content(mediaType="application/xml", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="channelIds", ref="../apiexamples/guid_set_json")})}) Set<String> var1, @Param(value="includeGlobalMap") @Parameter(description="If true, the global map will be returned.") @QueryParam(value="includeGlobalMap") boolean var2) throws ClientException;

    @GET
    @Path(value="/maps/global")
    @Operation(summary="Retrieves global map information.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="globalMap", ref="../apiexamples/generic_map_xml")}), @Content(mediaType="text/plain", examples={@ExampleObject(name="genericMap", ref="../apiexamples/generic_map_xml")})})
    @MirthOperation(name="getGlobalMap", display="Get global map", permission="View Global Maps", type=Operation.ExecuteType.ASYNC, auditable=false)
    @Produces(value={"application/xml", "text/plain"})
    public Map<String, String> getGlobalMap() throws ClientException;

    @GET
    @Path(value="/maps/{channelId}")
    @Operation(summary="Retrieves global channel map information for a single channel.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="genericMapString", ref="../apiexamples/generic_map_xml")}), @Content(mediaType="text/plain", examples={@ExampleObject(name="genericMapString", ref="../apiexamples/generic_map_xml")})})
    @MirthOperation(name="getGlobalChannelMap", display="Get global channel map", permission="View Global Maps", type=Operation.ExecuteType.ASYNC, auditable=false)
    @Produces(value={"application/xml", "text/plain"})
    public Map<String, String> getGlobalChannelMap(@Param(value="channelId") @Parameter(description="The ID of the channel to retrieve global channel map information for.") @PathParam(value="channelId") String var1) throws ClientException;
}

