/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthIconTextField;
import com.mirth.connect.client.ui.components.MirthPasswordField;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.panels.connectors.ResponseHandler;
import com.mirth.connect.connectors.http.HttpConnectorServletInterface;
import com.mirth.connect.connectors.http.HttpDispatcherProperties;
import com.mirth.connect.connectors.http.SSLWarningPanel;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.model.Connector;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class HttpSender
extends ConnectorSettingsPanel {
    private static final ImageIcon ICON_LOCK_X = new ImageIcon(Frame.class.getResource("images/lock_x.png"));
    private static final Color COLOR_SSL_NOT_CONFIGURED = new Color(0xFFF099);
    private static final String SSL_TOOL_TIP = "<html>The default system certificate store will be used for this connection.<br/>As a result, certain security options are not available and mutual<br/>authentication (two-way authentication) is not supported.</html>";
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String NAME_COLUMN_NAME = "Name";
    private final String VALUE_COLUMN_NAME = "Value";
    private int propertiesLastIndex = -1;
    private int headerLastIndex = -1;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private SSLWarningPanel sslWarningPanel;
    private ButtonGroup authenticationButtonGroup;
    private JLabel authenticationLabel;
    private MirthRadioButton authenticationNoRadio;
    private MirthCheckBox authenticationPreemptiveCheckBox;
    private MirthRadioButton authenticationTypeBasicRadio;
    private ButtonGroup authenticationTypeButtonGroup;
    private MirthRadioButton authenticationTypeDigestRadio;
    private JLabel authenticationTypeLabel;
    private MirthRadioButton authenticationYesRadio;
    private MirthComboBox<String> charsetEncodingCombobox;
    private JLabel charsetEncodingLabel;
    private JLabel contentLabel;
    private MirthSyntaxTextArea contentTextArea;
    private MirthTextField contentTypeField;
    private JLabel contentTypeLabel;
    private MirthRadioButton dataTypeBinaryRadio;
    private ButtonGroup dataTypeButtonGroup;
    private JLabel dataTypeLabel;
    private MirthRadioButton dataTypeTextRadio;
    private MirthRadioButton deleteButton;
    private MirthRadioButton getButton;
    private JButton headersDeleteButton;
    private JLabel headersLabel;
    private JButton headersNewButton;
    private JScrollPane headersPane;
    private MirthTable headersTable;
    protected MirthTextField headersVariableField;
    protected MirthRadioButton useHeadersTableRadio;
    protected MirthRadioButton useHeadersVariableRadio;
    private ButtonGroup includeMetadataButtonGroup;
    private JLabel includeMetadataLabel;
    private MirthRadioButton includeMetadataNoRadio;
    private MirthRadioButton includeMetadataYesRadio;
    private ButtonGroup methodButtonGroup;
    private JLabel methodLabel;
    private ButtonGroup multipartButtonGroup;
    private JLabel multipartLabel;
    private MirthRadioButton multipartNoButton;
    private MirthRadioButton multipartYesButton;
    private ButtonGroup parseMultipartButtonGroup;
    private JLabel parseMultipartLabel;
    private MirthRadioButton parseMultipartNoRadio;
    private MirthRadioButton parseMultipartYesRadio;
    private MirthPasswordField passwordField;
    private JLabel passwordLabel;
    private MirthRadioButton patchButton;
    private MirthRadioButton postButton;
    private MirthTextField proxyAddressField;
    private JLabel proxyAddressLabel;
    private MirthTextField proxyPortField;
    private JLabel proxyPortLabel;
    private ButtonGroup proxyTypeButtonGroup;
    private MirthRadioButton putButton;
    private JButton queryParametersDeleteButton;
    private JLabel queryParametersLabel;
    private JButton queryParametersNewButton;
    private JScrollPane queryParametersPane;
    private MirthTable queryParametersTable;
    protected MirthTextField queryParamsVariableField;
    protected MirthRadioButton useQueryParamsTableRadio;
    protected MirthRadioButton useQueryParamsVariableRadio;
    private MirthTextField responseBinaryMimeTypesField;
    private JLabel responseBinaryMimeTypesLabel;
    private MirthCheckBox responseBinaryMimeTypesRegexCheckBox;
    private ButtonGroup responseContentButtonGroup;
    private JLabel responseContentLabel;
    private MirthRadioButton responseContentPlainBodyRadio;
    private MirthRadioButton responseContentXmlBodyRadio;
    private MirthTextField sendTimeoutField;
    private JLabel sendTimeoutLabel;
    private JButton testConnection;
    private MirthIconTextField urlField;
    private JLabel urlLabel;
    private ButtonGroup usePersistantQueuesButtonGroup;
    private JLabel useProxyServerLabel;
    private MirthRadioButton useProxyServerNoRadio;
    private MirthRadioButton useProxyServerYesRadio;
    private MirthTextField usernameField;
    private JLabel usernameLabel;

    public HttpSender() {
        this.initComponents();
        this.parent.setupCharsetEncodingForConnector(this.charsetEncodingCombobox, true);
        this.queryParametersPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HttpSender.this.deselectRows(HttpSender.this.queryParametersTable, HttpSender.this.queryParametersDeleteButton);
            }
        });
        this.headersPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HttpSender.this.deselectRows(HttpSender.this.headersTable, HttpSender.this.headersDeleteButton);
            }
        });
        this.queryParametersDeleteButton.setEnabled(false);
        this.headersDeleteButton.setEnabled(false);
        this.urlField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HttpSender.this.urlFieldChanged();
            }
        });
        this.sslWarningPanel = new SSLWarningPanel();
        this.contentTypeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HttpSender.this.checkContentEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HttpSender.this.checkContentEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HttpSender.this.checkContentEnabled();
            }
        });
        this.initToolTips();
        this.initLayout();
    }

    public String getConnectorName() {
        return new HttpDispatcherProperties().getName();
    }

    public ConnectorProperties getProperties() {
        HttpDispatcherProperties properties = new HttpDispatcherProperties();
        properties.setHost(this.urlField.getText());
        properties.setUseProxyServer(this.useProxyServerYesRadio.isSelected());
        properties.setProxyAddress(this.proxyAddressField.getText());
        properties.setProxyPort(this.proxyPortField.getText());
        if (this.postButton.isSelected()) {
            properties.setMethod("post");
        } else if (this.getButton.isSelected()) {
            properties.setMethod("get");
        } else if (this.putButton.isSelected()) {
            properties.setMethod("put");
        } else if (this.deleteButton.isSelected()) {
            properties.setMethod("delete");
        } else if (this.patchButton.isSelected()) {
            properties.setMethod("patch");
        }
        properties.setMultipart(this.multipartYesButton.isSelected());
        properties.setSocketTimeout(this.sendTimeoutField.getText());
        properties.setUseAuthentication(this.authenticationYesRadio.isSelected());
        if (this.authenticationTypeBasicRadio.isSelected()) {
            properties.setAuthenticationType("Basic");
        } else {
            properties.setAuthenticationType("Digest");
        }
        properties.setUsePreemptiveAuthentication(this.authenticationPreemptiveCheckBox.isSelected());
        properties.setUsername(this.usernameField.getText());
        properties.setPassword(new String(this.passwordField.getPassword()));
        properties.setResponseXmlBody(this.responseContentXmlBodyRadio.isSelected());
        properties.setResponseParseMultipart(this.parseMultipartYesRadio.isSelected());
        properties.setResponseIncludeMetadata(this.includeMetadataYesRadio.isSelected());
        properties.setResponseBinaryMimeTypes(this.responseBinaryMimeTypesField.getText());
        properties.setResponseBinaryMimeTypesRegex(this.responseBinaryMimeTypesRegexCheckBox.isSelected());
        properties.setDataTypeBinary(this.dataTypeBinaryRadio.isSelected());
        properties.setCharset(this.parent.getSelectedEncodingForConnector(this.charsetEncodingCombobox));
        properties.setParametersMap(this.getProperties((JTable)this.queryParametersTable));
        properties.setUseParametersVariable(this.useQueryParamsVariableRadio.isSelected());
        properties.setParametersVariable(this.queryParamsVariableField.getText());
        properties.setHeadersMap(this.getProperties((JTable)this.headersTable));
        properties.setUseHeadersVariable(this.useHeadersVariableRadio.isSelected());
        properties.setHeadersVariable(this.headersVariableField.getText());
        properties.setContentType(this.contentTypeField.getText());
        properties.setContent(this.contentTextArea.getText());
        return properties;
    }

    public void setProperties(ConnectorProperties properties) {
        HttpDispatcherProperties props = (HttpDispatcherProperties)properties;
        this.urlField.setText(props.getHost());
        this.urlFieldChanged();
        if (props.isUseProxyServer()) {
            this.useProxyServerYesRadio.setSelected(true);
            this.useProxyServerYesRadioActionPerformed(null);
        } else {
            this.useProxyServerNoRadio.setSelected(true);
            this.useProxyServerNoRadioActionPerformed(null);
        }
        this.proxyAddressField.setText(props.getProxyAddress());
        this.proxyPortField.setText(props.getProxyPort());
        if (props.getMethod().equalsIgnoreCase("post")) {
            this.postButton.setSelected(true);
            this.postButtonActionPerformed(null);
        } else if (props.getMethod().equalsIgnoreCase("get")) {
            this.getButton.setSelected(true);
            this.getButtonActionPerformed(null);
        } else if (props.getMethod().equalsIgnoreCase("put")) {
            this.putButton.setSelected(true);
            this.putButtonActionPerformed(null);
        } else if (props.getMethod().equalsIgnoreCase("delete")) {
            this.deleteButton.setSelected(true);
            this.deleteButtonActionPerformed(null);
        } else if (props.getMethod().equalsIgnoreCase("patch")) {
            this.patchButton.setSelected(true);
            this.patchButtonActionPerformed(null);
        }
        if (props.isMultipart()) {
            this.multipartYesButton.setSelected(true);
        } else {
            this.multipartNoButton.setSelected(true);
        }
        this.checkMultipartEnabled();
        this.sendTimeoutField.setText(props.getSocketTimeout());
        if (props.isUseAuthentication()) {
            this.authenticationYesRadio.setSelected(true);
            this.authenticationYesRadioActionPerformed(null);
        } else {
            this.authenticationNoRadio.setSelected(true);
            this.authenticationNoRadioActionPerformed(null);
        }
        if (props.getAuthenticationType().equalsIgnoreCase("Basic")) {
            this.authenticationTypeBasicRadio.setSelected(true);
        } else if (props.getAuthenticationType().equalsIgnoreCase("Digest")) {
            this.authenticationTypeDigestRadio.setSelected(true);
        }
        this.authenticationPreemptiveCheckBox.setSelected(props.isUsePreemptiveAuthentication());
        this.usernameField.setText(props.getUsername());
        this.passwordField.setText(props.getPassword());
        if (props.isResponseXmlBody()) {
            this.responseContentXmlBodyRadio.setSelected(true);
            this.responseContentXmlBodyRadioActionPerformed(null);
        } else {
            this.responseContentPlainBodyRadio.setSelected(true);
            this.responseContentPlainBodyRadioActionPerformed(null);
        }
        if (props.isResponseParseMultipart()) {
            this.parseMultipartYesRadio.setSelected(true);
        } else {
            this.parseMultipartNoRadio.setSelected(true);
        }
        if (props.isResponseIncludeMetadata()) {
            this.includeMetadataYesRadio.setSelected(true);
        } else {
            this.includeMetadataNoRadio.setSelected(true);
        }
        this.responseBinaryMimeTypesField.setText(props.getResponseBinaryMimeTypes());
        this.responseBinaryMimeTypesRegexCheckBox.setSelected(props.isResponseBinaryMimeTypesRegex());
        if (props.getParametersMap() != null) {
            this.setParameters(props.getParametersMap());
        } else {
            this.setParameters(new LinkedHashMap<String, List<String>>());
        }
        if (props.isUseParametersVariable()) {
            this.useQueryParamsVariableRadio.setSelected(true);
        } else {
            this.useQueryParamsTableRadio.setSelected(true);
        }
        this.queryParamsVariableField.setText(props.getParametersVariable());
        this.useQueryParamsVariableFieldsEnabled(props.isUseParametersVariable());
        if (props.getHeadersMap() != null) {
            this.setHeaders(props.getHeadersMap());
        } else {
            this.setHeaders(new LinkedHashMap<String, List<String>>());
        }
        if (props.isUseHeadersVariable()) {
            this.useHeadersVariableRadio.setSelected(true);
        } else {
            this.useHeadersTableRadio.setSelected(true);
        }
        this.headersVariableField.setText(props.getHeadersVariable());
        this.useHeadersVariableFieldsEnabled(props.isUseHeadersVariable());
        this.contentTypeField.setText(props.getContentType());
        if (props.isDataTypeBinary()) {
            this.dataTypeBinaryRadio.setSelected(true);
            this.dataTypeBinaryRadioActionPerformed(null);
        } else {
            this.dataTypeTextRadio.setSelected(true);
            this.dataTypeTextRadioActionPerformed(null);
        }
        this.contentTextArea.setText(props.getContent());
        this.parent.setPreviousSelectedEncodingForConnector(this.charsetEncodingCombobox, props.getCharset(), true);
        this.checkContentEnabled();
    }

    public ConnectorProperties getDefaults() {
        return new HttpDispatcherProperties();
    }

    public void setParameters(Map<String, List<String>> properties) {
        int size = 0;
        for (List<String> property : properties.values()) {
            size += property.size();
        }
        Object[][] tableData = new Object[size][2];
        this.queryParametersTable = new MirthTable();
        int j = 0;
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            for (String keyValue : (ArrayList)entry.getValue()) {
                tableData[j][0] = entry.getKey();
                tableData[j][1] = keyValue;
                ++j;
            }
        }
        this.queryParametersTable.setModel((TableModel)new DefaultTableModel(tableData, new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.queryParametersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (HttpSender.this.getSelectedRow(HttpSender.this.queryParametersTable) != -1) {
                    HttpSender.this.propertiesLastIndex = HttpSender.this.getSelectedRow(HttpSender.this.queryParametersTable);
                    HttpSender.this.queryParametersDeleteButton.setEnabled(true);
                } else {
                    HttpSender.this.queryParametersDeleteButton.setEnabled(false);
                }
            }
        });
        class HTTPTableCellEditor
        extends TextFieldCellEditor {
            boolean checkProperties;

            public HTTPTableCellEditor(boolean checkProperties) {
                this.checkProperties = checkProperties;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    HttpSender.this.queryParametersDeleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                HttpSender.this.queryParametersDeleteButton.setEnabled(true);
                if (this.checkProperties && value.length() == 0) {
                    return false;
                }
                HttpSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.queryParametersTable.getColumnModel().getColumn(this.queryParametersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(true)));
        this.queryParametersTable.getColumnModel().getColumn(this.queryParametersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(false)));
        this.queryParametersTable.setCustomEditorControls(true);
        this.queryParametersTable.setSelectionMode(0);
        this.queryParametersTable.setRowSelectionAllowed(true);
        this.queryParametersTable.setRowHeight(20);
        this.queryParametersTable.setDragEnabled(false);
        this.queryParametersTable.setOpaque(true);
        this.queryParametersTable.setSortable(false);
        this.queryParametersTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.queryParametersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.queryParametersPane.setViewportView((Component)this.queryParametersTable);
    }

    public void setHeaders(Map<String, List<String>> properties) {
        int size = 0;
        for (List<String> property : properties.values()) {
            size += property.size();
        }
        Object[][] tableData = new Object[size][2];
        this.headersTable = new MirthTable();
        int j = 0;
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            for (String keyValue : entry.getValue()) {
                tableData[j][0] = entry.getKey();
                tableData[j][1] = keyValue;
                ++j;
            }
        }
        this.headersTable.setModel((TableModel)new DefaultTableModel(tableData, new String[]{"Name", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.headersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (HttpSender.this.getSelectedRow(HttpSender.this.headersTable) != -1) {
                    HttpSender.this.headerLastIndex = HttpSender.this.getSelectedRow(HttpSender.this.headersTable);
                    HttpSender.this.headersDeleteButton.setEnabled(true);
                } else {
                    HttpSender.this.headersDeleteButton.setEnabled(false);
                }
            }
        });
        class HTTPTableCellEditor
        extends TextFieldCellEditor {
            boolean checkProperties;

            public HTTPTableCellEditor(boolean checkProperties) {
                this.checkProperties = checkProperties;
            }

            public boolean checkUniqueProperty(String property) {
                boolean exists = false;
                for (int i = 0; i < HttpSender.this.headersTable.getRowCount(); ++i) {
                    if (HttpSender.this.headersTable.getValueAt(i, 0) == null || !((String)HttpSender.this.headersTable.getValueAt(i, 0)).equalsIgnoreCase(property)) continue;
                    exists = true;
                }
                return exists;
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    HttpSender.this.headersDeleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                HttpSender.this.headersDeleteButton.setEnabled(true);
                if (this.checkProperties && value.length() == 0) {
                    return false;
                }
                HttpSender.this.parent.setSaveEnabled(true);
                return true;
            }
        }
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Name")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(true)));
        this.headersTable.getColumnModel().getColumn(this.headersTable.getColumnModel().getColumnIndex("Value")).setCellEditor((TableCellEditor)((Object)new HTTPTableCellEditor(false)));
        this.headersTable.setCustomEditorControls(true);
        this.headersTable.setSelectionMode(0);
        this.headersTable.setRowSelectionAllowed(true);
        this.headersTable.setRowHeight(20);
        this.headersTable.setDragEnabled(false);
        this.headersTable.setOpaque(true);
        this.headersTable.setSortable(false);
        this.headersTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.headersTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.headersPane.setViewportView((Component)this.headersTable);
    }

    private Map<String, List<String>> getProperties(JTable table) {
        LinkedHashMap<String, List<String>> properties = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            String key = (String)table.getValueAt(i, 0);
            ArrayList<String> propertiesList = (ArrayList<String>)properties.get(key);
            if (propertiesList == null) {
                propertiesList = new ArrayList<String>();
                properties.put(key, propertiesList);
            }
            propertiesList.add((String)table.getValueAt(i, 1));
        }
        return properties;
    }

    public void deselectRows(MirthTable table, JButton button) {
        table.clearSelection();
        button.setEnabled(false);
    }

    public int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private String getNewPropertyName(MirthTable table) {
        String temp = "Property ";
        for (int i = 1; i <= table.getRowCount() + 1; ++i) {
            boolean exists = false;
            for (int j = 0; j < table.getRowCount(); ++j) {
                if (!((String)table.getValueAt(j, 0)).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    public boolean checkProperties(ConnectorProperties properties, boolean highlight) {
        HttpDispatcherProperties props = (HttpDispatcherProperties)properties;
        boolean valid = true;
        if (props.getHost().length() == 0) {
            valid = false;
            if (highlight) {
                this.urlField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseProxyServer()) {
            if (StringUtils.isBlank((CharSequence)props.getProxyAddress())) {
                valid = false;
                if (highlight) {
                    this.proxyAddressField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (StringUtils.isBlank((CharSequence)props.getProxyPort())) {
                valid = false;
                if (highlight) {
                    this.proxyPortField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
        }
        if (props.getSocketTimeout().length() == 0) {
            valid = false;
            if (highlight) {
                this.sendTimeoutField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseParametersVariable() && StringUtils.isBlank((CharSequence)props.getParametersVariable())) {
            valid = false;
            if (highlight) {
                this.queryParamsVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.isUseHeadersVariable() && StringUtils.isBlank((CharSequence)props.getHeadersVariable())) {
            valid = false;
            if (highlight) {
                this.headersVariableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        if (props.getMethod().equalsIgnoreCase("post") || props.getMethod().equalsIgnoreCase("put") || props.getMethod().equalsIgnoreCase("patch")) {
            if (props.getContentType().length() == 0) {
                valid = false;
                if (highlight) {
                    this.contentTypeField.setBackground(UIConstants.INVALID_COLOR);
                }
            }
            if (this.isUsingFormUrlEncoded(props.getContentType()) && !props.isUseParametersVariable() && MapUtils.isEmpty((Map)props.getParametersMap())) {
                valid = false;
            }
        }
        return valid;
    }

    public void resetInvalidProperties() {
        this.urlField.setBackground(null);
        this.urlFieldChanged();
        this.proxyAddressField.setBackground(null);
        this.proxyPortField.setBackground(null);
        this.sendTimeoutField.setBackground(null);
        this.queryParamsVariableField.setBackground(null);
        this.headersVariableField.setBackground(null);
        this.contentTypeField.setBackground(null);
        this.contentTextArea.setBackground(null);
    }

    public ConnectorTypeDecoration getConnectorTypeDecoration() {
        boolean usingHttps;
        block4: {
            usingHttps = false;
            try {
                URI hostURI = new URI(this.urlField.getText());
                String hostScheme = hostURI.getScheme();
                if (hostScheme != null && hostScheme.toLowerCase().equals("https")) {
                    usingHttps = true;
                }
            }
            catch (URISyntaxException e) {
                if (!this.urlField.getText().toLowerCase().startsWith("https")) break block4;
                usingHttps = true;
            }
        }
        if (usingHttps) {
            return new ConnectorTypeDecoration(Connector.Mode.DESTINATION, "(SSL Not Configured)", ICON_LOCK_X, SSL_TOOL_TIP, (Component)this.sslWarningPanel, COLOR_SSL_NOT_CONFIGURED);
        }
        return new ConnectorTypeDecoration(Connector.Mode.DESTINATION);
    }

    public void doLocalDecoration(ConnectorTypeDecoration connectorTypeDecoration) {
        if (connectorTypeDecoration != null) {
            this.urlField.setIcon((Icon)connectorTypeDecoration.getIcon());
            this.urlField.setAlternateToolTipText(connectorTypeDecoration.getIconToolTipText());
            this.urlField.setIconPopupMenuComponent(connectorTypeDecoration.getIconPopupComponent());
            this.urlField.setBackground(connectorTypeDecoration.getHighlightColor());
        }
    }

    private void urlFieldChanged() {
        this.decorateConnectorType();
    }

    private void checkMultipartEnabled() {
        if (this.postButton.isSelected()) {
            this.multipartLabel.setEnabled(true);
            this.multipartYesButton.setEnabled(true);
            this.multipartNoButton.setEnabled(true);
        } else {
            this.multipartLabel.setEnabled(false);
            this.multipartYesButton.setEnabled(false);
            this.multipartNoButton.setEnabled(false);
            this.multipartNoButton.setSelected(true);
        }
    }

    private boolean isUsingFormUrlEncoded(String contentType) {
        return StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
    }

    private void checkContentEnabled() {
        if (this.postButton.isSelected() || this.putButton.isSelected() || this.patchButton.isSelected()) {
            this.contentTypeLabel.setEnabled(true);
            this.contentTypeField.setEnabled(true);
            if (this.isUsingFormUrlEncoded(this.contentTypeField.getText())) {
                this.multipartLabel.setEnabled(false);
                this.multipartYesButton.setEnabled(false);
                this.multipartNoButton.setEnabled(false);
                this.multipartNoButton.setSelected(true);
                this.dataTypeLabel.setEnabled(false);
                this.dataTypeBinaryRadio.setEnabled(false);
                this.dataTypeTextRadio.setEnabled(false);
                this.dataTypeTextRadio.setSelected(true);
                this.contentLabel.setEnabled(false);
                this.contentTextArea.setEnabled(false);
            } else {
                this.multipartLabel.setEnabled(this.postButton.isSelected());
                this.multipartYesButton.setEnabled(this.postButton.isSelected());
                this.multipartNoButton.setEnabled(this.postButton.isSelected());
                this.dataTypeLabel.setEnabled(true);
                this.dataTypeBinaryRadio.setEnabled(true);
                this.dataTypeTextRadio.setEnabled(true);
                this.contentLabel.setEnabled(true);
                this.contentTextArea.setEnabled(true);
            }
            if (this.dataTypeBinaryRadio.isSelected()) {
                this.dataTypeBinaryRadioActionPerformed(null);
            } else {
                this.dataTypeTextRadioActionPerformed(null);
            }
        } else {
            this.multipartLabel.setEnabled(this.postButton.isSelected());
            this.multipartYesButton.setEnabled(this.postButton.isSelected());
            this.multipartNoButton.setEnabled(this.postButton.isSelected());
            this.contentTypeLabel.setEnabled(false);
            this.contentTypeField.setEnabled(false);
            this.dataTypeLabel.setEnabled(false);
            this.dataTypeBinaryRadio.setEnabled(false);
            this.dataTypeTextRadio.setEnabled(false);
            this.charsetEncodingLabel.setEnabled(false);
            this.charsetEncodingCombobox.setEnabled(false);
            this.contentLabel.setEnabled(false);
            this.contentTextArea.setEnabled(false);
        }
    }

    private void setQueryParametersEnabled(boolean enabled) {
        this.queryParametersLabel.setEnabled(enabled);
        this.queryParametersPane.setEnabled(enabled);
        this.queryParametersTable.setEnabled(enabled);
        this.queryParametersNewButton.setEnabled(enabled);
        this.deselectRows(this.queryParametersTable, this.queryParametersDeleteButton);
    }

    private void setAuthenticationEnabled(boolean enabled) {
        this.authenticationTypeLabel.setEnabled(enabled);
        this.authenticationTypeBasicRadio.setEnabled(enabled);
        this.authenticationTypeDigestRadio.setEnabled(enabled);
        this.authenticationPreemptiveCheckBox.setEnabled(enabled);
        this.usernameLabel.setEnabled(enabled);
        this.usernameField.setEnabled(enabled);
        if (!enabled) {
            this.usernameField.setText("");
        }
        this.passwordLabel.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
        if (!enabled) {
            this.passwordField.setText("");
        }
    }

    private void initComponents() {
        this.methodButtonGroup = new ButtonGroup();
        this.responseContentButtonGroup = new ButtonGroup();
        this.usePersistantQueuesButtonGroup = new ButtonGroup();
        this.multipartButtonGroup = new ButtonGroup();
        this.authenticationButtonGroup = new ButtonGroup();
        this.authenticationTypeButtonGroup = new ButtonGroup();
        this.parseMultipartButtonGroup = new ButtonGroup();
        this.includeMetadataButtonGroup = new ButtonGroup();
        this.proxyTypeButtonGroup = new ButtonGroup();
        this.dataTypeButtonGroup = new ButtonGroup();
        this.urlLabel = new JLabel();
        this.urlField = new MirthIconTextField();
        this.queryParametersNewButton = new JButton();
        this.queryParametersDeleteButton = new JButton();
        this.queryParametersPane = new JScrollPane();
        this.queryParametersTable = new MirthTable();
        this.queryParametersLabel = new JLabel();
        this.queryParamsVariableField = new MirthTextField();
        this.useQueryParamsTableRadio = new MirthRadioButton();
        this.useQueryParamsVariableRadio = new MirthRadioButton();
        this.methodLabel = new JLabel();
        this.postButton = new MirthRadioButton();
        this.getButton = new MirthRadioButton();
        this.headersPane = new JScrollPane();
        this.headersTable = new MirthTable();
        this.headersLabel = new JLabel();
        this.headersNewButton = new JButton();
        this.headersDeleteButton = new JButton();
        this.headersVariableField = new MirthTextField();
        this.useHeadersTableRadio = new MirthRadioButton();
        this.useHeadersVariableRadio = new MirthRadioButton();
        this.responseContentLabel = new JLabel();
        this.responseContentXmlBodyRadio = new MirthRadioButton();
        this.responseContentPlainBodyRadio = new MirthRadioButton();
        this.putButton = new MirthRadioButton();
        this.deleteButton = new MirthRadioButton();
        this.testConnection = new JButton();
        this.multipartLabel = new JLabel();
        this.multipartYesButton = new MirthRadioButton();
        this.multipartNoButton = new MirthRadioButton();
        this.contentTextArea = new MirthSyntaxTextArea(true);
        this.contentLabel = new JLabel();
        this.contentTypeField = new MirthTextField();
        this.contentTypeLabel = new JLabel();
        this.authenticationLabel = new JLabel();
        this.dataTypeBinaryRadio = new MirthRadioButton();
        this.authenticationNoRadio = new MirthRadioButton();
        this.usernameField = new MirthTextField();
        this.usernameLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordField = new MirthPasswordField();
        this.authenticationTypeDigestRadio = new MirthRadioButton();
        this.authenticationTypeBasicRadio = new MirthRadioButton();
        this.authenticationTypeLabel = new JLabel();
        this.charsetEncodingLabel = new JLabel();
        this.charsetEncodingCombobox = new MirthComboBox();
        this.sendTimeoutField = new MirthTextField();
        this.sendTimeoutLabel = new JLabel();
        this.parseMultipartLabel = new JLabel();
        this.parseMultipartYesRadio = new MirthRadioButton();
        this.parseMultipartNoRadio = new MirthRadioButton();
        this.includeMetadataLabel = new JLabel();
        this.includeMetadataYesRadio = new MirthRadioButton();
        this.includeMetadataNoRadio = new MirthRadioButton();
        this.useProxyServerLabel = new JLabel();
        this.useProxyServerYesRadio = new MirthRadioButton();
        this.useProxyServerNoRadio = new MirthRadioButton();
        this.proxyAddressLabel = new JLabel();
        this.proxyAddressField = new MirthTextField();
        this.proxyPortLabel = new JLabel();
        this.proxyPortField = new MirthTextField();
        this.authenticationPreemptiveCheckBox = new MirthCheckBox();
        this.dataTypeLabel = new JLabel();
        this.authenticationYesRadio = new MirthRadioButton();
        this.dataTypeTextRadio = new MirthRadioButton();
        this.responseBinaryMimeTypesLabel = new JLabel();
        this.responseBinaryMimeTypesField = new MirthTextField();
        this.responseBinaryMimeTypesRegexCheckBox = new MirthCheckBox();
        this.patchButton = new MirthRadioButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.urlLabel.setText("URL:");
        this.queryParametersNewButton.setText("New");
        this.queryParametersNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.queryParametersNewButtonActionPerformed(evt);
            }
        });
        this.queryParametersDeleteButton.setText("Delete");
        this.queryParametersDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.queryParametersDeleteButtonActionPerformed(evt);
            }
        });
        this.queryParametersTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        this.queryParametersPane.setViewportView((Component)this.queryParametersTable);
        this.queryParametersLabel.setText("Query Parameters:");
        this.useQueryParamsTableRadio.setText("Use Table");
        this.useQueryParamsTableRadio.setBackground(new Color(255, 255, 255));
        this.useQueryParamsTableRadio.addActionListener(event -> this.useQueryParamsVariableFieldsEnabled(false));
        this.useQueryParamsVariableRadio.setText("Use Map:");
        this.useQueryParamsVariableRadio.setBackground(new Color(255, 255, 255));
        this.useQueryParamsVariableRadio.addActionListener(event -> this.useQueryParamsVariableFieldsEnabled(true));
        ButtonGroup queryParamsButtonGroup = new ButtonGroup();
        queryParamsButtonGroup.add((AbstractButton)this.useQueryParamsTableRadio);
        queryParamsButtonGroup.add((AbstractButton)this.useQueryParamsVariableRadio);
        this.methodLabel.setText("Method:");
        this.postButton.setBackground(new Color(255, 255, 255));
        this.methodButtonGroup.add((AbstractButton)this.postButton);
        this.postButton.setText("POST");
        this.postButton.setMargin(new Insets(0, 0, 0, 0));
        this.postButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.postButtonActionPerformed(evt);
            }
        });
        this.getButton.setBackground(new Color(255, 255, 255));
        this.methodButtonGroup.add((AbstractButton)this.getButton);
        this.getButton.setText("GET");
        this.getButton.setMargin(new Insets(0, 0, 0, 0));
        this.getButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.getButtonActionPerformed(evt);
            }
        });
        this.headersTable.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        this.headersPane.setViewportView((Component)this.headersTable);
        this.headersLabel.setText("Headers:");
        this.headersNewButton.setText("New");
        this.headersNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.headersNewButtonActionPerformed(evt);
            }
        });
        this.headersDeleteButton.setText("Delete");
        this.headersDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.headersDeleteButtonActionPerformed(evt);
            }
        });
        this.useHeadersTableRadio.setText("Use Table");
        this.useHeadersTableRadio.setBackground(new Color(255, 255, 255));
        this.useHeadersTableRadio.addActionListener(event -> this.useHeadersVariableFieldsEnabled(false));
        this.useHeadersVariableRadio.setText("Use Map:");
        this.useHeadersVariableRadio.setBackground(new Color(255, 255, 255));
        this.useHeadersVariableRadio.addActionListener(event -> this.useHeadersVariableFieldsEnabled(true));
        ButtonGroup headersButtonGroup = new ButtonGroup();
        headersButtonGroup.add((AbstractButton)this.useHeadersTableRadio);
        headersButtonGroup.add((AbstractButton)this.useHeadersVariableRadio);
        this.responseContentLabel.setText("Response Content:");
        this.responseContentXmlBodyRadio.setBackground(new Color(255, 255, 255));
        this.responseContentButtonGroup.add((AbstractButton)this.responseContentXmlBodyRadio);
        this.responseContentXmlBodyRadio.setText("XML Body");
        this.responseContentXmlBodyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.responseContentXmlBodyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.responseContentXmlBodyRadioActionPerformed(evt);
            }
        });
        this.responseContentPlainBodyRadio.setBackground(new Color(255, 255, 255));
        this.responseContentButtonGroup.add((AbstractButton)this.responseContentPlainBodyRadio);
        this.responseContentPlainBodyRadio.setText("Plain Body");
        this.responseContentPlainBodyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.responseContentPlainBodyRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.responseContentPlainBodyRadioActionPerformed(evt);
            }
        });
        this.putButton.setBackground(new Color(255, 255, 255));
        this.methodButtonGroup.add((AbstractButton)this.putButton);
        this.putButton.setText("PUT");
        this.putButton.setMargin(new Insets(0, 0, 0, 0));
        this.putButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.putButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setBackground(new Color(255, 255, 255));
        this.methodButtonGroup.add((AbstractButton)this.deleteButton);
        this.deleteButton.setText("DELETE");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.deleteButtonActionPerformed(evt);
            }
        });
        this.testConnection.setText("Test Connection");
        this.testConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.testConnectionActionPerformed(evt);
            }
        });
        this.multipartLabel.setText("Multipart:");
        this.multipartYesButton.setBackground(new Color(255, 255, 255));
        this.multipartButtonGroup.add((AbstractButton)this.multipartYesButton);
        this.multipartYesButton.setText("Yes");
        this.multipartYesButton.setMargin(new Insets(0, 0, 0, 0));
        this.multipartNoButton.setBackground(new Color(255, 255, 255));
        this.multipartButtonGroup.add((AbstractButton)this.multipartNoButton);
        this.multipartNoButton.setText("No");
        this.multipartNoButton.setMargin(new Insets(0, 0, 0, 0));
        this.contentTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.contentLabel.setText("Content:");
        this.contentTypeLabel.setText("Content Type:");
        this.authenticationLabel.setText("Authentication:");
        this.dataTypeBinaryRadio.setBackground(new Color(255, 255, 255));
        this.dataTypeButtonGroup.add((AbstractButton)this.dataTypeBinaryRadio);
        this.dataTypeBinaryRadio.setText("Binary");
        this.dataTypeBinaryRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dataTypeBinaryRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.dataTypeBinaryRadioActionPerformed(evt);
            }
        });
        this.authenticationNoRadio.setBackground(new Color(255, 255, 255));
        this.authenticationButtonGroup.add((AbstractButton)this.authenticationNoRadio);
        this.authenticationNoRadio.setText("No");
        this.authenticationNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.authenticationNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.authenticationNoRadioActionPerformed(evt);
            }
        });
        this.usernameLabel.setText("Username:");
        this.passwordLabel.setText("Password:");
        this.authenticationTypeDigestRadio.setBackground(new Color(255, 255, 255));
        this.authenticationTypeButtonGroup.add((AbstractButton)this.authenticationTypeDigestRadio);
        this.authenticationTypeDigestRadio.setText("Digest");
        this.authenticationTypeDigestRadio.setMargin(new Insets(0, 0, 0, 0));
        this.authenticationTypeBasicRadio.setBackground(new Color(255, 255, 255));
        this.authenticationTypeButtonGroup.add((AbstractButton)this.authenticationTypeBasicRadio);
        this.authenticationTypeBasicRadio.setText("Basic");
        this.authenticationTypeBasicRadio.setMargin(new Insets(0, 0, 0, 0));
        this.authenticationTypeLabel.setText("Authentication Type:");
        this.charsetEncodingLabel.setText("Charset Encoding:");
        this.charsetEncodingCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "utf-8", "iso-8859-1", "utf-16 (le)", "utf-16 (be)", "utf-16 (bom)", "us-ascii"}));
        this.sendTimeoutLabel.setText("Send Timeout (ms):");
        this.parseMultipartLabel.setText("Parse Multipart:");
        this.parseMultipartYesRadio.setBackground(new Color(255, 255, 255));
        this.parseMultipartButtonGroup.add((AbstractButton)this.parseMultipartYesRadio);
        this.parseMultipartYesRadio.setText("Yes");
        this.parseMultipartYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.parseMultipartNoRadio.setBackground(new Color(255, 255, 255));
        this.parseMultipartButtonGroup.add((AbstractButton)this.parseMultipartNoRadio);
        this.parseMultipartNoRadio.setText("No");
        this.parseMultipartNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.includeMetadataLabel.setText("Include Metadata:");
        this.includeMetadataYesRadio.setBackground(new Color(255, 255, 255));
        this.includeMetadataButtonGroup.add((AbstractButton)this.includeMetadataYesRadio);
        this.includeMetadataYesRadio.setText("Yes");
        this.includeMetadataYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.includeMetadataNoRadio.setBackground(new Color(255, 255, 255));
        this.includeMetadataButtonGroup.add((AbstractButton)this.includeMetadataNoRadio);
        this.includeMetadataNoRadio.setText("No");
        this.includeMetadataNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.useProxyServerLabel.setText("Use Proxy Server:");
        this.useProxyServerYesRadio.setBackground(new Color(255, 255, 255));
        this.proxyTypeButtonGroup.add((AbstractButton)this.useProxyServerYesRadio);
        this.useProxyServerYesRadio.setText("Yes");
        this.useProxyServerYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.useProxyServerYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.useProxyServerYesRadioActionPerformed(evt);
            }
        });
        this.useProxyServerNoRadio.setBackground(new Color(255, 255, 255));
        this.proxyTypeButtonGroup.add((AbstractButton)this.useProxyServerNoRadio);
        this.useProxyServerNoRadio.setText("No");
        this.useProxyServerNoRadio.setMargin(new Insets(0, 0, 0, 0));
        this.useProxyServerNoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.useProxyServerNoRadioActionPerformed(evt);
            }
        });
        this.proxyAddressLabel.setText("Proxy Address:");
        this.proxyPortLabel.setText("Proxy Port:");
        this.authenticationPreemptiveCheckBox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.authenticationPreemptiveCheckBox.setText("Preemptive");
        this.dataTypeLabel.setText("Data Type:");
        this.authenticationYesRadio.setBackground(new Color(255, 255, 255));
        this.authenticationButtonGroup.add((AbstractButton)this.authenticationYesRadio);
        this.authenticationYesRadio.setText("Yes");
        this.authenticationYesRadio.setMargin(new Insets(0, 0, 0, 0));
        this.authenticationYesRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.authenticationYesRadioActionPerformed(evt);
            }
        });
        this.dataTypeTextRadio.setBackground(new Color(255, 255, 255));
        this.dataTypeButtonGroup.add((AbstractButton)this.dataTypeTextRadio);
        this.dataTypeTextRadio.setText("Text");
        this.dataTypeTextRadio.setMargin(new Insets(0, 0, 0, 0));
        this.dataTypeTextRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.dataTypeTextRadioActionPerformed(evt);
            }
        });
        this.responseBinaryMimeTypesLabel.setText("Binary MIME Types:");
        this.responseBinaryMimeTypesField.setMinimumSize(new Dimension(200, 21));
        this.responseBinaryMimeTypesField.setPreferredSize(new Dimension(200, 21));
        this.responseBinaryMimeTypesRegexCheckBox.setBackground(new Color(255, 255, 255));
        this.responseBinaryMimeTypesRegexCheckBox.setText("Regular Expression");
        this.patchButton.setBackground(new Color(255, 255, 255));
        this.methodButtonGroup.add((AbstractButton)this.patchButton);
        this.patchButton.setText("PATCH");
        this.patchButton.setMargin(new Insets(0, 0, 0, 0));
        this.patchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HttpSender.this.patchButtonActionPerformed(evt);
            }
        });
    }

    private void initToolTips() {
        this.urlField.setToolTipText("Enter the URL of the HTTP server to send each message to.");
        this.queryParametersTable.setToolTipText("Query parameters are encoded as x=y pairs as part of the request URL, separated from it by a '?' and from each other by an '&'.");
        this.postButton.setToolTipText("Selects the HTTP operation used to send each message.");
        this.getButton.setToolTipText("Selects the HTTP operation used to send each message.");
        this.headersTable.setToolTipText("Header parameters are encoded as HTTP headers in the HTTP request sent to the server.");
        this.responseContentXmlBodyRadio.setToolTipText("<html>If selected, the response content will include the response body as serialized XML.</html>");
        this.responseContentPlainBodyRadio.setToolTipText("<html>If selected, the response content will only include the response body as a raw string.</html>");
        this.putButton.setToolTipText("Selects the HTTP operation used to send each message.");
        this.deleteButton.setToolTipText("Selects the HTTP operation used to send each message.");
        this.multipartYesButton.setToolTipText("Set to use multipart in the Content-Type header. Multipart can only be used with POST.");
        this.multipartNoButton.setToolTipText("Set not to use multipart in the Content-Type header.");
        this.contentTextArea.setToolTipText("The HTTP message body.");
        this.contentTypeField.setToolTipText("<html>The HTTP message body MIME type to use. If<br/>application/x-www-form-urlencoded is used,<br/>the query parameters specified above will be<br/>automatically encoded into the request body.</html>");
        this.dataTypeBinaryRadio.setToolTipText("<html>Select Binary if the outbound message is a Base64 string (will be decoded before it is sent out).<br/>Select Text if the outbound message is text (will be encoded with the specified character set encoding).</html>");
        this.authenticationNoRadio.setToolTipText("<html>Turning on authentication uses a username and password to communicate with the HTTP server.</html>");
        this.usernameField.setToolTipText("The username used to connect to the HTTP server.");
        this.passwordField.setToolTipText("The password used to connect to the HTTP server.");
        this.authenticationTypeDigestRadio.setToolTipText("Use the digest authentication scheme.");
        this.authenticationTypeBasicRadio.setToolTipText("Use the basic authentication scheme.");
        this.charsetEncodingCombobox.setToolTipText("<html>Select the character set encoding used by the sender of the message,<br> or Default to assume the default character set encoding for the JVM running BridgeLink.</html>");
        this.sendTimeoutField.setToolTipText("<html>Sets the socket timeout (SO_TIMEOUT) in milliseconds to be used when executing the method.<br>A timeout value of zero is interpreted as an infinite timeout.</html>");
        this.parseMultipartYesRadio.setToolTipText("<html>Select Yes to automatically parse multipart responses into separate XML nodes.<br/>Select No to always keep the response body as a single XML node.</html>");
        this.parseMultipartNoRadio.setToolTipText("<html>Select Yes to automatically parse multipart responses into separate XML nodes.<br/>Select No to always keep the response body as a single XML node.</html>");
        this.includeMetadataYesRadio.setToolTipText("<html>Select Yes to include response metadata (status<br/>line and headers) in the XML content. Note that<br/>regardless of this setting, the same metadata<br/>will be available in the connector map.</html>");
        this.includeMetadataNoRadio.setToolTipText("<html>Select Yes to include response metadata (status<br/>line and headers) in the XML content. Note that<br/>regardless of this setting, the same metadata<br/>will be available in the connector map.</html>");
        this.useProxyServerYesRadio.setToolTipText("<html>If enabled, requests will be forwarded to the proxy<br/>server specified in the address/port fields below.</html>");
        this.useProxyServerNoRadio.setToolTipText("<html>If enabled, requests will be forwarded to the proxy<br/>server specified in the address/port fields below.</html>");
        this.proxyAddressField.setToolTipText("The domain name or IP address of the proxy server to connect to.");
        this.proxyPortField.setToolTipText("The port on which to connect to the proxy server.");
        this.authenticationPreemptiveCheckBox.setToolTipText("<html>If checked, the authorization header will be sent to the server with the initial<br/>request. Otherwise, the header will only be sent when the server requests it.<br/>When using digest authentication, an Authorization header containing the<br/>realm/nonce/algorithm/qop values must be included in the Headers table.</html>");
        this.authenticationYesRadio.setToolTipText("<html>Turning on authentication uses a username and password to communicate with the HTTP server.</html>");
        this.dataTypeTextRadio.setToolTipText("<html>Select Binary if the outbound message is a Base64 string (will be decoded before it is sent out).<br/>Select Text if the outbound message is text (will be encoded with the specified character set encoding).</html>");
        this.responseBinaryMimeTypesField.setToolTipText("<html>When a response comes in with a Content-Type header that<br/>matches one of these entries, the content will be encoded<br/>into a Base64 string. If Regular Expression is unchecked,<br/>specify multiple entries with commas. Otherwise, enter a<br/>valid regular expression to match MIME types against.</html>");
        this.responseBinaryMimeTypesRegexCheckBox.setToolTipText("<html>When a response comes in with a Content-Type header that<br/>matches one of these entries, the content will be encoded<br/>into a Base64 string. If Regular Expression is unchecked,<br/>specify multiple entries with commas. Otherwise, enter a<br/>valid regular expression to match MIME types against.</html>");
        this.patchButton.setToolTipText("Selects the HTTP operation used to send each message.");
        this.useQueryParamsTableRadio.setToolTipText("<html>The table below will be used to populate query parameters.</html>");
        this.useQueryParamsVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate query parameters.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.queryParamsVariableField.setToolTipText("<html>The variable of a Java map to use to populate query parameters.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.useHeadersTableRadio.setToolTipText("<html>The table below will be used to populate headers.</html>");
        this.useHeadersVariableRadio.setToolTipText("<html>The Java map specified by the following variable will be used to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
        this.headersVariableField.setToolTipText("<html>The variable of a Java map to use to populate headers.<br/>The map must have String keys and either String or List&lt;String&gt; values.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 8 0 8, novisualpadding, hidemode 3, gap 12 6", "[][]6[]", "[][][][][][][][][][][][][][][][][grow][][grow][][][][grow]"));
        this.add(this.urlLabel, "right");
        this.add((Component)this.urlField, "w 312!, sx, split 2");
        this.add(this.testConnection, "gapbefore 6");
        this.add(this.useProxyServerLabel, "newline, right");
        this.add((Component)this.useProxyServerYesRadio, "split 2");
        this.add((Component)this.useProxyServerNoRadio);
        this.add(this.proxyAddressLabel, "newline, right");
        this.add((Component)this.proxyAddressField, "w 202!, sx");
        this.add(this.proxyPortLabel, "newline, right");
        this.add((Component)this.proxyPortField, "w 56!, sx");
        this.add(this.methodLabel, "newline, right");
        this.add((Component)this.postButton, "split 5");
        this.add((Component)this.getButton);
        this.add((Component)this.putButton);
        this.add((Component)this.deleteButton);
        this.add((Component)this.patchButton);
        this.add(this.multipartLabel, "newline, right");
        this.add((Component)this.multipartYesButton, "split 2");
        this.add((Component)this.multipartNoButton);
        this.add(this.sendTimeoutLabel, "newline, right");
        this.add((Component)this.sendTimeoutField, "w 75!, sx");
        this.add(this.responseContentLabel, "newline, right");
        this.add((Component)this.responseContentPlainBodyRadio, "split 2");
        this.add((Component)this.responseContentXmlBodyRadio);
        this.add(this.parseMultipartLabel, "newline, right");
        this.add((Component)this.parseMultipartYesRadio, "split 2");
        this.add((Component)this.parseMultipartNoRadio);
        this.add(this.includeMetadataLabel, "newline, right");
        this.add((Component)this.includeMetadataYesRadio, "split 2");
        this.add((Component)this.includeMetadataNoRadio);
        this.add(this.responseBinaryMimeTypesLabel, "newline, right");
        this.add((Component)this.responseBinaryMimeTypesField, "w 312!, sx, split 3");
        this.add((Component)this.responseBinaryMimeTypesRegexCheckBox);
        this.add(this.authenticationLabel, "newline, right");
        this.add((Component)this.authenticationYesRadio, "split 2");
        this.add((Component)this.authenticationNoRadio);
        this.add(this.authenticationTypeLabel, "newline, right");
        this.add((Component)this.authenticationTypeBasicRadio, "split 3");
        this.add((Component)this.authenticationTypeDigestRadio);
        this.add((Component)this.authenticationPreemptiveCheckBox);
        this.add(this.usernameLabel, "newline, right");
        this.add((Component)this.usernameField, "w 125!, sx");
        this.add(this.passwordLabel, "newline, right");
        this.add((Component)this.passwordField, "w 125!, sx");
        this.add(this.queryParametersLabel, "newline, right");
        this.add((Component)this.useQueryParamsTableRadio, "split 3");
        this.add((Component)this.useQueryParamsVariableRadio);
        this.add((Component)this.queryParamsVariableField, "w 125!, sx");
        this.add(this.queryParametersPane, "newline, growx, pushx, growy, skip 1, span 2, h 84:84:150");
        this.add(this.queryParametersNewButton, "top, flowy, split 2, w 44!");
        this.add(this.queryParametersDeleteButton, "w 44!");
        this.add(this.headersLabel, "newline, right");
        this.add((Component)this.useHeadersTableRadio, "split 3");
        this.add((Component)this.useHeadersVariableRadio);
        this.add((Component)this.headersVariableField, "w 125!, sx");
        this.add(this.headersPane, "newline, growx, pushx, growy, skip 1, span 2, h 84:84:150");
        this.add(this.headersNewButton, "top, flowy, split 2, w 44!");
        this.add(this.headersDeleteButton, "w 44!");
        this.add(this.contentTypeLabel, "newline, right");
        this.add((Component)this.contentTypeField, "w 125!, sx");
        this.add(this.dataTypeLabel, "newline, right");
        this.add((Component)this.dataTypeBinaryRadio, "split 2");
        this.add((Component)this.dataTypeTextRadio);
        this.add(this.charsetEncodingLabel, "newline, right");
        this.add((Component)this.charsetEncodingCombobox);
        this.add(this.contentLabel, "newline, top, right");
        this.add((Component)this.contentTextArea, "grow, push, sx, h 132:");
    }

    private void headersDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedRow(this.headersTable) != -1 && !this.headersTable.isEditing()) {
            ((DefaultTableModel)this.headersTable.getModel()).removeRow(this.getSelectedRow(this.headersTable));
            if (this.headersTable.getRowCount() != 0) {
                if (this.headerLastIndex == 0) {
                    this.headersTable.setRowSelectionInterval(0, 0);
                } else if (this.headerLastIndex == this.headersTable.getRowCount()) {
                    this.headersTable.setRowSelectionInterval(this.headerLastIndex - 1, this.headerLastIndex - 1);
                } else {
                    this.headersTable.setRowSelectionInterval(this.headerLastIndex, this.headerLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void headersNewButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.headersTable.getModel()).addRow(new Object[]{this.getNewPropertyName(this.headersTable), ""});
        this.headersTable.setRowSelectionInterval(this.headersTable.getRowCount() - 1, this.headersTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void postButtonActionPerformed(ActionEvent evt) {
        this.checkMultipartEnabled();
        this.checkContentEnabled();
        this.setQueryParametersEnabled(true);
    }

    private void getButtonActionPerformed(ActionEvent evt) {
        this.checkMultipartEnabled();
        this.checkContentEnabled();
        this.setQueryParametersEnabled(true);
    }

    private void putButtonActionPerformed(ActionEvent evt) {
        this.checkMultipartEnabled();
        this.checkContentEnabled();
        this.setQueryParametersEnabled(true);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.checkMultipartEnabled();
        this.checkContentEnabled();
        this.setQueryParametersEnabled(true);
    }

    private void patchButtonActionPerformed(ActionEvent evt) {
        this.checkMultipartEnabled();
        this.checkContentEnabled();
        this.setQueryParametersEnabled(true);
    }

    private void testConnectionActionPerformed(ActionEvent evt) {
        ResponseHandler handler = new ResponseHandler(){

            public void handle(Object response) {
                ConnectionTestResponse connectionTestResponse = (ConnectionTestResponse)response;
                if (connectionTestResponse == null) {
                    HttpSender.this.parent.alertError((Component)HttpSender.this.parent, "Failed to invoke service.");
                } else if (connectionTestResponse.getType().equals((Object)ConnectionTestResponse.Type.SUCCESS)) {
                    HttpSender.this.parent.alertInformation((Component)HttpSender.this.parent, connectionTestResponse.getMessage());
                } else {
                    HttpSender.this.parent.alertWarning((Component)HttpSender.this.parent, connectionTestResponse.getMessage());
                }
            }
        };
        try {
            ((HttpConnectorServletInterface)this.getServlet(HttpConnectorServletInterface.class, "Testing connection...", "Error testing HTTP connection: ", handler)).testConnection(this.getChannelId(), this.getChannelName(), (HttpDispatcherProperties)this.getFilledProperties());
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    private void queryParametersDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.getSelectedRow(this.queryParametersTable) != -1 && !this.queryParametersTable.isEditing()) {
            ((DefaultTableModel)this.queryParametersTable.getModel()).removeRow(this.getSelectedRow(this.queryParametersTable));
            if (this.queryParametersTable.getRowCount() != 0) {
                if (this.propertiesLastIndex == 0) {
                    this.queryParametersTable.setRowSelectionInterval(0, 0);
                } else if (this.propertiesLastIndex == this.queryParametersTable.getRowCount()) {
                    this.queryParametersTable.setRowSelectionInterval(this.propertiesLastIndex - 1, this.propertiesLastIndex - 1);
                } else {
                    this.queryParametersTable.setRowSelectionInterval(this.propertiesLastIndex, this.propertiesLastIndex);
                }
            }
            this.parent.setSaveEnabled(true);
        }
    }

    private void queryParametersNewButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.queryParametersTable.getModel()).addRow(new Object[]{this.getNewPropertyName(this.queryParametersTable), ""});
        this.queryParametersTable.setRowSelectionInterval(this.queryParametersTable.getRowCount() - 1, this.queryParametersTable.getRowCount() - 1);
        this.parent.setSaveEnabled(true);
    }

    private void authenticationYesRadioActionPerformed(ActionEvent evt) {
        this.setAuthenticationEnabled(true);
    }

    private void authenticationNoRadioActionPerformed(ActionEvent evt) {
        this.setAuthenticationEnabled(false);
    }

    private void responseContentPlainBodyRadioActionPerformed(ActionEvent evt) {
        this.parseMultipartLabel.setEnabled(false);
        this.parseMultipartYesRadio.setEnabled(false);
        this.parseMultipartNoRadio.setEnabled(false);
        this.includeMetadataLabel.setEnabled(false);
        this.includeMetadataYesRadio.setEnabled(false);
        this.includeMetadataNoRadio.setEnabled(false);
    }

    private void responseContentXmlBodyRadioActionPerformed(ActionEvent evt) {
        this.parseMultipartLabel.setEnabled(true);
        this.parseMultipartYesRadio.setEnabled(true);
        this.parseMultipartNoRadio.setEnabled(true);
        this.includeMetadataLabel.setEnabled(true);
        this.includeMetadataYesRadio.setEnabled(true);
        this.includeMetadataNoRadio.setEnabled(true);
    }

    private void useProxyServerYesRadioActionPerformed(ActionEvent evt) {
        this.proxyAddressLabel.setEnabled(true);
        this.proxyAddressField.setEnabled(true);
        this.proxyPortLabel.setEnabled(true);
        this.proxyPortField.setEnabled(true);
    }

    private void useProxyServerNoRadioActionPerformed(ActionEvent evt) {
        this.proxyAddressLabel.setEnabled(false);
        this.proxyAddressField.setEnabled(false);
        this.proxyPortLabel.setEnabled(false);
        this.proxyPortField.setEnabled(false);
    }

    private void dataTypeBinaryRadioActionPerformed(ActionEvent evt) {
        this.charsetEncodingLabel.setEnabled(false);
        this.charsetEncodingCombobox.setEnabled(false);
        this.charsetEncodingCombobox.setSelectedIndex(0);
    }

    private void dataTypeTextRadioActionPerformed(ActionEvent evt) {
        if (this.postButton.isSelected() || this.putButton.isSelected() || this.patchButton.isSelected()) {
            this.charsetEncodingLabel.setEnabled(true);
            this.charsetEncodingCombobox.setEnabled(true);
        }
    }

    private void useHeadersVariableFieldsEnabled(boolean useVariable) {
        this.headersVariableField.setEnabled(useVariable);
        this.headersTable.setEnabled(!useVariable);
        this.headersNewButton.setEnabled(!useVariable);
        this.headersDeleteButton.setEnabled(!useVariable && this.headersTable.getSelectedRow() > -1);
    }

    private void useQueryParamsVariableFieldsEnabled(boolean useVariable) {
        this.queryParamsVariableField.setEnabled(useVariable);
        this.queryParametersTable.setEnabled(!useVariable);
        this.queryParametersNewButton.setEnabled(!useVariable);
        this.queryParametersDeleteButton.setEnabled(!useVariable && this.queryParametersTable.getSelectedRow() > -1);
    }
}

