/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;

public class CustomDriver
implements Driver {
    private Driver delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDriver(ClassLoader classLoader, String className) throws Exception {
        Class ctClass;
        classLoader.loadClass(className);
        String ctClassName = this.getClass().getPackage().getName() + ".DriverManagerShim";
        try {
            ctClass = classLoader.loadClass(ctClassName);
        }
        catch (ClassNotFoundException e) {
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                try {
                    ctClass = classLoader.loadClass(ctClassName);
                }
                catch (ClassNotFoundException e2) {
                    ClassPool classPool = new ClassPool();
                    classPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
                    classPool.appendClassPath("java.util");
                    classPool.appendClassPath("java.sql");
                    CtClass ctShimClassDefinition = classPool.makeClass(ctClassName);
                    CtMethod getDriversMethod = CtNewMethod.make((CtClass)classPool.get(Enumeration.class.getName()), (String)"getDrivers", (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)"return java.sql.DriverManager.getDrivers();", (CtClass)ctShimClassDefinition);
                    ctShimClassDefinition.addMethod(getDriversMethod);
                    CtMethod deregisterDriverMethod = CtNewMethod.make((CtClass)CtClass.voidType, (String)"deregisterDriver", (CtClass[])new CtClass[]{classPool.get(Driver.class.getName())}, (CtClass[])new CtClass[0], (String)"java.sql.DriverManager.deregisterDriver($1);", (CtClass)ctShimClassDefinition);
                    ctShimClassDefinition.addMethod(deregisterDriverMethod);
                    ctClass = ctShimClassDefinition.toClass(classLoader, null);
                }
            }
        }
        Object driverManagerShim = ctClass.newInstance();
        Method getDriversMethod = ctClass.getMethod("getDrivers", new Class[0]);
        Method deregisterDriverMethod = ctClass.getMethod("deregisterDriver", Driver.class);
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            ArrayList currentDrivers = Collections.list((Enumeration)getDriversMethod.invoke(driverManagerShim, new Object[0]));
            this.delegate = (Driver)Class.forName(className, true, classLoader).newInstance();
            ArrayList newDrivers = Collections.list((Enumeration)getDriversMethod.invoke(driverManagerShim, new Object[0]));
            while (newDrivers.size() > currentDrivers.size()) {
                deregisterDriverMethod.invoke(driverManagerShim, newDrivers.get(newDrivers.size() - 1));
                newDrivers = Collections.list((Enumeration)getDriversMethod.invoke(driverManagerShim, new Object[0]));
            }
            // ** MonitorExit[var8_10] (shouldn't be in output)
            return;
        }
    }

    public Connection connect(String url, String username, String password) throws SQLException {
        Properties info = new Properties();
        if (username != null) {
            info.put("user", username);
        }
        if (password != null) {
            info.put("password", password);
        }
        return this.connect(url, info);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.delegate.connect(url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.delegate.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegate.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

