/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.connectors.jdbc.Column;
import com.mirth.connect.connectors.jdbc.CustomDriver;
import com.mirth.connect.connectors.jdbc.DatabaseConnectorServletInterface;
import com.mirth.connect.connectors.jdbc.Table;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseConnectorServlet
extends MirthServlet
implements DatabaseConnectorServletInterface {
    private static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW"};
    private static final Logger logger = LogManager.getLogger(DatabaseConnectorServlet.class);
    private static final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private static final ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();

    public DatabaseConnectorServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "Database Connector Service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<Table> getTables(String channelId, String channelName, String driver, String url, String username, String password, Set<String> tableNamePatterns, String selectLimit, Set<String> resourceIds) {
        CustomDriver customDriver = null;
        Connection connection = null;
        try {
            ResultSet rs;
            String schema;
            block43: {
                url = replacer.replaceValues(url, channelId, channelName);
                username = replacer.replaceValues(username, channelId, channelName);
                password = replacer.replaceValues(password, channelId, channelName);
                schema = null;
                try {
                    MirthContextFactory contextFactory = contextFactoryController.getContextFactory(resourceIds);
                    try {
                        ClassLoader isolatedClassLoader = contextFactory.getIsolatedClassLoader();
                        if (isolatedClassLoader != null) {
                            customDriver = new CustomDriver(isolatedClassLoader, driver);
                            logger.debug("Custom driver created: " + customDriver.toString() + ", Version " + customDriver.getMajorVersion() + "." + customDriver.getMinorVersion());
                            break block43;
                        }
                        logger.debug("Custom classloader is not being used, defaulting to DriverManager.");
                    }
                    catch (Exception e) {
                        logger.debug("Error creating custom driver, defaulting to DriverManager.", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.debug("Error retrieving context factory, defaulting to DriverManager.", (Throwable)e);
                }
            }
            if (customDriver == null) {
                Class.forName(driver);
            }
            int oldLoginTimeout = DriverManager.getLoginTimeout();
            DriverManager.setLoginTimeout(30);
            connection = customDriver != null ? customDriver.connect(url, username, password) : DriverManager.getConnection(url, username, password);
            DriverManager.setLoginTimeout(oldLoginTimeout);
            DatabaseMetaData dbMetaData = connection.getMetaData();
            TreeSet<Table> tableInfoList = new TreeSet<Table>();
            try (ResultSet schemasResult = null;){
                schemasResult = dbMetaData.getSchemas();
                while (schemasResult.next()) {
                    String schemaResult = schemasResult.getString(1);
                    if (!username.equalsIgnoreCase(schemaResult)) continue;
                    schema = schemaResult;
                }
            }
            tableNamePatterns = this.translateTableNamePatterns(tableNamePatterns);
            ArrayList<String> tableNameList = new ArrayList<String>();
            for (String tableNamePattern : tableNamePatterns) {
                rs = null;
                try {
                    rs = dbMetaData.getTables(null, schema, tableNamePattern, TABLE_TYPES);
                    while (rs.next()) {
                        tableNameList.add(rs.getString("TABLE_NAME"));
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            for (String tableName : tableNameList) {
                rs = null;
                ResultSet backupRs = null;
                boolean fallback = false;
                try {
                    ArrayList<Column> columnList = new ArrayList<Column>();
                    if (StringUtils.isEmpty((CharSequence)selectLimit)) {
                        logger.debug("No select limit is defined, using generic method");
                        rs = dbMetaData.getColumns(null, null, tableName, null);
                        int i = 0;
                        while (rs.next()) {
                            Column column = new Column(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), rs.getInt("COLUMN_SIZE"));
                            columnList.add(column);
                            ++i;
                        }
                    } else {
                        logger.debug("Select limit is defined, using specific select query : '" + selectLimit + "'");
                        String schemaTableName = StringUtils.isNotEmpty((CharSequence)schema) ? "\"" + schema + "\".\"" + tableName + "\"" : "\"" + tableName + "\"";
                        String queryString = selectLimit.trim().replaceAll("\\?", Matcher.quoteReplacement(schemaTableName));
                        try (Statement statement = connection.createStatement();){
                            rs = statement.executeQuery(queryString);
                            ResultSetMetaData rsmd = rs.getMetaData();
                            for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                                Column column = new Column(rsmd.getColumnName(i), rsmd.getColumnTypeName(i), rsmd.getPrecision(i));
                                columnList.add(column);
                            }
                        }
                        if (fallback) {
                            columnList = new ArrayList();
                            logger.debug("Using fallback method for retrieving columns");
                            backupRs = dbMetaData.getColumns(null, null, tableName.replace("/", "//"), null);
                            while (backupRs.next()) {
                                Column column = new Column(backupRs.getString("COLUMN_NAME"), backupRs.getString("TYPE_NAME"), backupRs.getInt("COLUMN_SIZE"));
                                columnList.add(column);
                            }
                        }
                    }
                    Table table = new Table(tableName, columnList);
                    tableInfoList.add(table);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (backupRs == null) continue;
                    backupRs.close();
                }
            }
            TreeSet<Table> treeSet = tableInfoList;
            return treeSet;
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)new Exception("Could not retrieve database tables and columns.", e));
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private Set<String> translateTableNamePatterns(Set<String> tableNamePatterns) {
        if (tableNamePatterns == null) {
            throw new IllegalArgumentException("Parameter 'tableNamePatterns' cannot be NULL'");
        }
        HashSet<String> patterns = new HashSet<String>();
        if (tableNamePatterns.isEmpty()) {
            patterns.add("%");
        } else {
            for (String pattern : tableNamePatterns) {
                patterns.add(pattern.trim().replaceAll("\\*", "%"));
            }
        }
        return patterns;
    }
}

