/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.connectors.jdbc.DatabaseReceiverDelegate;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverException;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverProperties;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverQuery;
import com.mirth.connect.connectors.jdbc.DatabaseReceiverScript;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.PollConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.util.CharsetUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatabaseReceiver
extends PollConnector {
    private static Pattern INVALID_XML_ELEMENT_NAMESTARTCHAR = Pattern.compile("[^:A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]");
    private static Pattern INVALID_XML_ELEMENT_NAMECHAR = Pattern.compile("[^:A-Z_a-z-\\.0-9\\xB7\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0300-\\u036F\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u203F-\\u2040\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{EFFFF}]+");
    protected DatabaseReceiverProperties connectorProperties;
    private DatabaseReceiverDelegate delegate;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (DatabaseReceiverProperties)this.getConnectorProperties();
        this.delegate = this.connectorProperties.isUseScript() ? new DatabaseReceiverScript(this) : new DatabaseReceiverQuery(this);
        this.delegate.deploy();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
        this.delegate.undeploy();
    }

    public void onStart() throws ConnectorTaskException {
        this.delegate.start();
    }

    public void onStop() throws ConnectorTaskException {
        this.delegate.stop();
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() throws InterruptedException {
        block19: {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.POLLING));
            Object result = null;
            try {
                result = this.delegate.poll();
                if (this.isTerminated()) {
                    return;
                }
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.READING));
                if (result instanceof ResultSet) {
                    this.processResultSet((ResultSet)result);
                    break block19;
                }
                if (result instanceof List) {
                    this.processResultList((List)result);
                    break block19;
                }
                throw new DatabaseReceiverException("Unrecognized result: " + result.toString());
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Failed to poll for messages from the database in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\"", (Throwable)e);
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), null, e.getCause()));
                return;
            }
            finally {
                if (result instanceof ResultSet) {
                    DbUtils.closeQuietly((ResultSet)((ResultSet)result));
                }
                try {
                    this.delegate.afterPoll();
                }
                catch (DatabaseReceiverException e) {
                    this.logger.error("Error in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\": " + e.getMessage(), ExceptionUtils.getRootCause((Throwable)e));
                    this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), null, e.getCause()));
                }
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
            }
        }
    }

    private void processResultSet(ResultSet resultSet) throws SQLException, InterruptedException, DatabaseReceiverException {
        BasicRowProcessor basicRowProcessor = new BasicRowProcessor();
        try {
            this.checkForDuplicateColumns(resultSet);
            ArrayList<Map<String, Object>> resultsList = null;
            if (this.connectorProperties.isAggregateResults()) {
                resultsList = new ArrayList<Map<String, Object>>();
            }
            while (resultSet.next()) {
                if (this.isTerminated()) {
                    return;
                }
                Map resultMap = basicRowProcessor.toMap(resultSet);
                if (this.connectorProperties.isAggregateResults()) {
                    resultsList.add(resultMap);
                    continue;
                }
                this.processRecord(resultMap);
            }
            if (this.connectorProperties.isAggregateResults() && CollectionUtils.isNotEmpty(resultsList)) {
                if (this.isTerminated()) {
                    return;
                }
                this.processAggregateRecord(resultsList);
            }
        }
        catch (Exception e) {
            if (e instanceof DatabaseReceiverException) {
                throw (DatabaseReceiverException)e;
            }
            throw new DatabaseReceiverException(e);
        }
    }

    void checkForDuplicateColumns(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colCount = metaData.getColumnCount();
        HashSet<String> lowerCaseColumnNames = new HashSet<String>();
        for (int i = 1; i <= colCount; ++i) {
            String columnName = metaData.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = metaData.getColumnName(i);
            }
            if (columnName != null) {
                columnName = columnName.toLowerCase(Locale.ENGLISH);
            }
            if (lowerCaseColumnNames.add(columnName)) continue;
            throw new SQLException("Multiple columns have the alias/name '" + columnName + "' (case-insensitive). To prevent this error from occurring, specify unique aliases for each column.");
        }
    }

    void processResultList(List<Map<String, Object>> resultList) throws InterruptedException, DatabaseReceiverException {
        for (Map<String, Object> object : resultList) {
            if (this.isTerminated()) {
                return;
            }
            if (object instanceof Map) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                HashSet<String> caseInsensitiveKeys = new HashSet<String>();
                for (Map.Entry<String, Object> entry : object.entrySet()) {
                    String lowerCaseKey = entry.getKey();
                    if (lowerCaseKey != null) {
                        lowerCaseKey = lowerCaseKey.toLowerCase(Locale.ENGLISH);
                    }
                    if (caseInsensitiveKeys.add(lowerCaseKey)) {
                        map.put(lowerCaseKey, entry.getValue());
                        continue;
                    }
                    throw new DatabaseReceiverException("Multiple columns have the alias/name '" + lowerCaseKey + "' (case-insensitive). To prevent this error from occurring, specify unique aliases for each column.");
                }
                this.processRecord(map);
                continue;
            }
            String errorMessage = "Received invalid list entry in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\", expected Map<String, Object>: " + object.toString();
            this.logger.error(errorMessage);
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), errorMessage, null));
        }
    }

    void processRecord(Map<String, Object> resultMap) throws InterruptedException, DatabaseReceiverException {
        block8: {
            try {
                if (this.isProcessBatch()) {
                    BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(this.resultMapToXml(resultMap)));
                    this.dispatchBatchMessage(batchRawMessage, new DatabaseResponseHandler(resultMap));
                    break block8;
                }
                DispatchResult dispatchResult = null;
                try {
                    dispatchResult = this.dispatchRawMessage(new RawMessage(this.resultMapToXml(resultMap)));
                }
                catch (Throwable throwable) {
                    this.finishDispatch(dispatchResult);
                    throw throwable;
                }
                this.finishDispatch(dispatchResult);
                if (dispatchResult != null) {
                    if (dispatchResult.getProcessedMessage() != null) {
                        this.delegate.runPostProcess(resultMap, dispatchResult.getProcessedMessage().getMergedConnectorMessage());
                    } else {
                        this.delegate.runPostProcess(resultMap, null);
                    }
                }
            }
            catch (Exception e) {
                String errorMessage = "Failed to process row retrieved from the database in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\"";
                this.logger.error(errorMessage, (Throwable)e);
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), errorMessage, (Throwable)e));
            }
        }
    }

    private void processAggregateRecord(List<Map<String, Object>> resultsList) throws Exception {
        block3: {
            block2: {
                if (!this.isProcessBatch()) break block2;
                BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(this.resultsListToXml(resultsList)));
                this.dispatchBatchMessage(batchRawMessage, new AggregateResponseHandler(resultsList));
                break block3;
            }
            DispatchResult dispatchResult = null;
            try {
                dispatchResult = this.dispatchRawMessage(new RawMessage(this.resultsListToXml(resultsList)));
            }
            catch (Throwable throwable) {
                this.finishDispatch(dispatchResult);
                throw throwable;
            }
            this.finishDispatch(dispatchResult);
            this.runAggregatePostProcess(dispatchResult, resultsList);
        }
    }

    private void runAggregatePostProcess(DispatchResult dispatchResult, List<Map<String, Object>> resultsList) throws Exception {
        if (dispatchResult != null) {
            if (this.connectorProperties.getUpdateMode() == 2) {
                if (dispatchResult.getProcessedMessage() != null) {
                    this.delegate.runAggregatePostProcess(resultsList, dispatchResult.getProcessedMessage().getMergedConnectorMessage());
                } else {
                    this.delegate.runAggregatePostProcess(resultsList, null);
                }
            } else if (this.connectorProperties.getUpdateMode() == 3) {
                for (Map<String, Object> resultMap : resultsList) {
                    if (dispatchResult.getProcessedMessage() != null) {
                        this.delegate.runPostProcess(resultMap, dispatchResult.getProcessedMessage().getMergedConnectorMessage());
                        continue;
                    }
                    this.delegate.runPostProcess(resultMap, null);
                }
            }
        }
    }

    private String resultsListToXml(List<Map<String, Object>> resultsList) throws Exception {
        DonkeyElement results = new DonkeyElement("<results/>");
        for (Map<String, Object> resultMap : resultsList) {
            results.addChildElementFromXml(this.resultMapToXml(resultMap));
        }
        return results.toXml();
    }

    String resultMapToXml(Map<String, Object> resultMap) throws Exception {
        try {
            return this.doResultMapToXml(resultMap, false);
        }
        catch (DOMException e) {
            return this.doResultMapToXml(resultMap, true);
        }
    }

    private String doResultMapToXml(Map<String, Object> resultMap, boolean fixColumnNames) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document document = dbf.newDocumentBuilder().newDocument();
        Element root = document.createElement("result");
        document.appendChild(root);
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            String value = this.objectToString(entry.getValue());
            if (value == null) continue;
            String key = entry.getKey().toLowerCase(Locale.ENGLISH);
            if (fixColumnNames) {
                key = this.fixColumnName(key);
            }
            Element child = document.createElement(key);
            child.appendChild(document.createTextNode(value));
            root.appendChild(child);
        }
        return new DocumentSerializer().toXML(document);
    }

    String fixColumnName(String columnName) {
        if (StringUtils.isNotBlank((CharSequence)columnName)) {
            Matcher matcher = INVALID_XML_ELEMENT_NAMESTARTCHAR.matcher(Character.toString(((String)columnName).charAt(0)));
            if (matcher.find()) {
                columnName = "_" + ((String)columnName).substring(1);
            }
            if ((matcher = INVALID_XML_ELEMENT_NAMECHAR.matcher((CharSequence)columnName)).find()) {
                columnName = matcher.replaceAll("_");
            }
        } else {
            columnName = "_";
        }
        return columnName;
    }

    private String objectToString(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        String charsetEncoding = CharsetUtils.getEncoding((String)this.connectorProperties.getEncoding(), (String)System.getProperty("ca.uhn.hl7v2.llp.charset"));
        if (object instanceof byte[]) {
            return new String((byte[])object, charsetEncoding);
        }
        if (object instanceof Clob) {
            return this.clobToString((Clob)object);
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            return new String(blob.getBytes(1L, (int)blob.length()), charsetEncoding);
        }
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String clobToString(Clob clob) throws Exception {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Reader reader = null;
        BufferedReader bufferedReader = null;
        try {
            int c;
            reader = clob.getCharacterStream();
            bufferedReader = new BufferedReader(reader);
            while ((c = bufferedReader.read()) != -1) {
                stringBuilder.append((char)c);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            ResourceUtil.closeResourceQuietly(bufferedReader);
            ResourceUtil.closeResourceQuietly((Closeable)reader);
            throw throwable;
        }
        ResourceUtil.closeResourceQuietly((Closeable)bufferedReader);
        ResourceUtil.closeResourceQuietly((Closeable)reader);
        return string;
    }

    public class DatabaseResponseHandler
    extends ResponseHandler {
        private Map<String, Object> resultMap;

        public DatabaseResponseHandler(Map<String, Object> resultMap) {
            this.resultMap = resultMap;
        }

        public void responseProcess(int batchSequenceId, boolean batchComplete) throws Exception {
            if (this.dispatchResult.getProcessedMessage() != null) {
                DatabaseReceiver.this.delegate.runPostProcess(this.resultMap, this.dispatchResult.getProcessedMessage().getMergedConnectorMessage());
            } else {
                DatabaseReceiver.this.delegate.runPostProcess(this.resultMap, null);
            }
        }

        public void responseError(ChannelException e) {
        }
    }

    public class AggregateResponseHandler
    extends ResponseHandler {
        private List<Map<String, Object>> resultsList;

        public AggregateResponseHandler(List<Map<String, Object>> resultsList) {
            this.resultsList = resultsList;
        }

        public void responseProcess(int batchSequenceId, boolean batchComplete) throws Exception {
            if (this.isUseFirstResponse() && batchSequenceId == 1 || !this.isUseFirstResponse() && batchComplete) {
                DatabaseReceiver.this.runAggregatePostProcess(this.dispatchResult, this.resultsList);
            }
        }

        public void responseError(ChannelException e) {
        }
    }
}

