/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.server.attachments.MirthAttachmentHandlerProvider;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.StringUtils;

public class JdbcUtils {
    public static String extractParameters(String statement, List<String> params) {
        if (statement == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\$\\{([^\\}]*)\\}");
        Matcher m = p.matcher(statement);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String key = m.group(0);
            m.appendReplacement(sb, "?");
            params.add(key);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static boolean isValidConnection(Connection connection) {
        try {
            return connection.isValid(10000);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object[] getParameters(List<String> paramNames, String channelId, String channelName, ConnectorMessage connectorMessage, Map<String, Object> map, AttachmentHandlerProvider attachmentHandlerProvider, boolean reattach) {
        Object[] params = new Object[paramNames.size()];
        TemplateValueReplacer replacer = new TemplateValueReplacer();
        int i = 0;
        for (String paramName : paramNames) {
            String key = paramName.substring(2, paramName.length() - 1);
            Object value = map != null && map.containsKey(key) ? map.get(key) : (connectorMessage != null ? replacer.replaceValues(paramName, connectorMessage) : replacer.replaceValues(paramName, channelId, channelName));
            if (attachmentHandlerProvider != null && MirthAttachmentHandlerProvider.hasAttachmentKeys((String)value.toString())) {
                value = StringUtils.newString((byte[])attachmentHandlerProvider.reAttachMessage(value.toString(), connectorMessage, "UTF-8", false, reattach), (String)"UTF-8");
            }
            params[i++] = value;
        }
        return params;
    }
}

