/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.filecache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache {
    private static final String ZZZFREE_IS_RUNNING = "ZZZFreeIsRunning";
    private static final String DEFAULT_JOURNAL_FILE_PATH_PATTERN = "yyyy/MM/dd/HH";
    private static final String MINUTE_PATTERN = "mm";
    private static final Logger log = LoggerFactory.getLogger(FileCache.class);
    private File journalRootDir;
    private File cacheRootDir;
    private File freeZZZFile;
    private String journalFileName = ((long)this.hashCode() & 0xFFFFFFFFL) + "-" + ManagementFactory.getRuntimeMXBean().getName();
    private SimpleDateFormat journalFilePathFormat = new SimpleDateFormat("yyyy/MM/dd/HH");
    private int minutesPerJournal = 0;
    private boolean freeIsRunning = false;
    private long maximumFreeTime = 3600000L;
    private int maxFilesInCacheRoot = 0;

    public File getJournalRootDir() {
        return this.journalRootDir;
    }

    public void setJournalRootDir(File journalRootDir) {
        if (journalRootDir != null) {
            FileCache.assertWritableDiretory(journalRootDir);
        }
        this.journalRootDir = journalRootDir;
    }

    public String getJournalFileName() {
        return this.journalFileName;
    }

    public void setJournalFileName(String journalFileName) {
        this.journalFileName = journalFileName;
    }

    public File getCacheRootDir() {
        return this.cacheRootDir;
    }

    public void setCacheRootDir(File cacheRootDir) {
        if (cacheRootDir != null) {
            FileCache.assertWritableDiretory(cacheRootDir);
        }
        this.cacheRootDir = cacheRootDir;
    }

    private static void assertWritableDiretory(File dir) {
        FileCache.mkdirs(dir);
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException("Not a writable directory:" + dir);
        }
    }

    public String getJournalFilePathFormat() {
        return this.journalFilePathFormat.toPattern();
    }

    public void setJournalFilePathFormat(String format) {
        if (this.minutesPerJournal > 0 && !format.endsWith(MINUTE_PATTERN)) {
            format = format + MINUTE_PATTERN;
        }
        this.journalFilePathFormat = new SimpleDateFormat(format);
    }

    public int getMinutesPerJournal() {
        return this.minutesPerJournal;
    }

    public void setMinutesPerJournal(int minutesPerJournal) {
        int n = this.minutesPerJournal = minutesPerJournal > 59 ? 0 : minutesPerJournal;
        if (this.minutesPerJournal > 0 && !this.journalFilePathFormat.toPattern().endsWith(MINUTE_PATTERN)) {
            this.journalFilePathFormat = new SimpleDateFormat(this.journalFilePathFormat.toPattern() + MINUTE_PATTERN);
        }
    }

    public Date findOldestJournalDate() throws IOException {
        return this.findOldestJournalDate(this.journalRootDir);
    }

    private Date findOldestJournalDate(File dir) {
        Object[] fnames = dir.list();
        if (fnames == null || fnames.length == 0) {
            try {
                return this.getJournalDate(dir);
            }
            catch (Exception e) {
                return null;
            }
        }
        Arrays.sort(fnames);
        for (Object fname : fnames) {
            File subdir = new File(dir, (String)fname);
            Date d = this.findOldestJournalDate(subdir);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public void record(File f) throws IOException {
        this.record(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void record(File f, boolean update) throws IOException {
        String path = f.getAbsolutePath().substring(this.cacheRootDir.getAbsolutePath().length() + 1);
        long time = System.currentTimeMillis();
        File journalDir = this.getJournalDirectory(time);
        File journalFile = new File(journalDir, this.journalFileName);
        if (journalFile.exists()) {
            if (update && journalDir.equals(this.getJournalDirectory(f.lastModified()))) {
                log.debug("{} already contains entry for {}", (Object)journalFile, (Object)f);
                return;
            }
            log.debug("M-UPDATE {}", (Object)journalFile);
        } else {
            FileCache.mkdirs(journalFile.getParentFile());
            log.debug("M-WRITE {}", (Object)journalFile);
        }
        FileWriter journal = new FileWriter(journalFile, true);
        try {
            journal.write(path + '\n');
        }
        finally {
            journal.close();
        }
        f.setLastModified(time);
        this.checkMaxFilesInCacheRoot();
    }

    public void checkMaxFilesInCacheRoot() {
        if (this.maxFilesInCacheRoot <= 0) {
            return;
        }
        String[] cachedFiles = this.cacheRootDir.list();
        if (cachedFiles == null) {
            log.warn("Cache root dir " + this.cacheRootDir + " is not readable or contains too many files! Can not free cache! Please correct this issue manually.");
        } else if (cachedFiles.length > this.maxFilesInCacheRoot) {
            log.info("Maximum number of files (" + this.maxFilesInCacheRoot + ") in cacheRoot (" + this.cacheRootDir + ")reached! Delete old files");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileCache.this.free(Integer.MAX_VALUE);
                        log.info("Delete finished! Current number of Files in cache root:" + FileCache.this.cacheRootDir.list().length);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
        }
    }

    private static void mkdirs(File dir) {
        if (dir.mkdirs()) {
            log.info("M-WRITE {}", (Object)dir);
        }
    }

    private synchronized File getJournalDirectory(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        if (this.minutesPerJournal > 0) {
            cal.set(12, cal.get(12) / this.minutesPerJournal * this.minutesPerJournal);
        }
        return new File(this.journalRootDir, this.journalFilePathFormat.format(cal.getTime()));
    }

    public synchronized Date getJournalDate(File dir) throws IOException {
        if (dir.isFile()) {
            dir = dir.getParentFile();
        }
        String sDir = dir.getCanonicalPath();
        String prefix = this.journalRootDir.getCanonicalPath();
        sDir = sDir.substring(prefix.length() + 1);
        sDir = sDir.replace('\\', '/');
        try {
            return this.journalFilePathFormat.parse(sDir);
        }
        catch (ParseException e) {
            log.warn("Can't parse {}", (Object)dir);
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean multiProcessFreeIsRunningFile() {
        try {
            File zzzFreeIsRunning = this.getFreeZZZFile();
            if (zzzFreeIsRunning.createNewFile()) {
                return true;
            }
            log.debug("ZZZFreeIsRunning file already exists! Check if maximumFreeTime is reached.");
            long l = System.currentTimeMillis() - zzzFreeIsRunning.lastModified();
            if (l > this.maximumFreeTime && zzzFreeIsRunning.delete() && zzzFreeIsRunning.createNewFile()) {
                log.debug("Start new free job after maximumFreeTime is reached!");
                return true;
            }
            log.debug("Current free job already runs since {} ms! maximumFreeTime={}", (Object)l, (Object)this.maximumFreeTime);
        }
        catch (IOException e) {
            log.warn("Could not create/delete the free is running file ZZZFreeIsRunning", (Throwable)e);
        }
        return false;
    }

    public long getMaximumFreeTime() {
        return this.maximumFreeTime;
    }

    public void setMaximumFreeTime(long maximumFreeTime) {
        if (maximumFreeTime <= 0L) {
            throw new IllegalArgumentException("maximumFreeTime <= 0 : " + maximumFreeTime);
        }
        this.maximumFreeTime = maximumFreeTime;
    }

    public int getMaxFilesInCacheRoot() {
        return this.maxFilesInCacheRoot;
    }

    public void setMaxFilesInCacheRoot(int maxFilesInCacheRoot) {
        this.maxFilesInCacheRoot = maxFilesInCacheRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long free(long size) throws IOException {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.freeIsRunning) {
                log.debug("Free is already running on {}!", (Object)this.cacheRootDir);
                return -1L;
            }
            this.freeIsRunning = this.multiProcessFreeIsRunningFile();
            if (!this.freeIsRunning) {
                return -1L;
            }
        }
        try {
            long l = this.free(size, this.journalRootDir, true);
            return l;
        }
        finally {
            this.freeIsRunning = false;
            this.getFreeZZZFile().delete();
        }
    }

    public void clearCache() {
        FileCache.deleteFilesOrDirectories(this.journalRootDir.listFiles());
        FileCache.deleteFilesOrDirectories(this.cacheRootDir.listFiles());
    }

    public boolean isEmpty() {
        return this.cacheRootDir.list().length == 0;
    }

    public static void deleteFilesOrDirectories(File[] files) {
        if (files != null) {
            for (File f : files) {
                FileCache.deleteFileOrDirectory(f);
            }
        }
    }

    public static boolean deleteFileOrDirectory(File f) {
        if (f.isDirectory()) {
            FileCache.deleteFilesOrDirectories(f.listFiles());
        }
        if (!f.delete()) {
            log.warn("Failed to delete {}", (Object)f);
            return false;
        }
        log.info("M-DELETE {}", (Object)f);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long free(long size, File dir, boolean endMost) throws IOException {
        long free = 0L;
        if (dir.isDirectory()) {
            Object[] fnames = dir.list();
            if (fnames == null) {
                log.warn("Directory " + dir + " not readable! Skipped.");
            } else {
                Arrays.sort(fnames);
                int i = fnames.length;
                for (Object fname : fnames) {
                    if ((free += this.free(size - free, new File(dir, (String)fname), endMost && i-- < 2)) >= size) break;
                }
            }
        } else {
            if (endMost) {
                log.warn("Got to the last (current) journal system without being able to clean up enough space, not cleaning current journal to prevent race condition.");
                return 0L;
            }
            BufferedReader journal = new BufferedReader(new FileReader(dir));
            boolean deleteJournalFile = true;
            try {
                String path;
                while ((path = journal.readLine()) != null) {
                    File f = new File(this.cacheRootDir, path);
                    if (!f.exists()) {
                        log.debug("{} already deleted", (Object)f);
                        continue;
                    }
                    if (this.getJournalDirectory(f.lastModified()).compareTo(dir.getParentFile()) > 0) {
                        log.debug("{} was accessed after record in {}", (Object)f, (Object)dir);
                        continue;
                    }
                    long flen = FileCache.sizeOfFileOrDirectory(f);
                    if (FileCache.deleteFileAndParents(f, this.cacheRootDir)) {
                        free += flen;
                        continue;
                    }
                    deleteJournalFile = false;
                }
            }
            finally {
                journal.close();
            }
            if (deleteJournalFile) {
                FileCache.deleteFileAndParents(dir, this.journalRootDir);
            } else {
                log.warn("Do not delete journal file {}! Deletion of one ore more referenced files was not successful.", (Object)dir);
            }
        }
        return free;
    }

    public static long sizeOfFileOrDirectory(File f) {
        if (f.isFile()) {
            return f.length();
        }
        long size = 0L;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                size += FileCache.sizeOfFileOrDirectory(files[i]);
            }
        }
        return size;
    }

    public static boolean deleteFileAndParents(File f, File baseDir) {
        if (!FileCache.deleteFileOrDirectory(f)) {
            return false;
        }
        File dir = f.getParentFile();
        while (!dir.equals(baseDir) && dir.delete()) {
            log.info("M-DELETE {}", (Object)dir);
            dir = dir.getParentFile();
        }
        return true;
    }

    private synchronized File getFreeZZZFile() throws IOException {
        if (this.freeZZZFile == null) {
            this.freeZZZFile = new File(this.cacheRootDir, ZZZFREE_IS_RUNNING);
        }
        return this.freeZZZFile;
    }
}

