/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file.filesystems;

import com.mirth.connect.connectors.file.FTPSchemeProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileConnection;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.connectors.file.filesystems.FtpConnection;
import com.mirth.connect.connectors.file.filesystems.S3Connection;
import com.mirth.connect.connectors.file.filesystems.SftpConnection;
import com.mirth.connect.connectors.file.filesystems.SmbFileConnection;
import com.mirth.connect.connectors.file.filesystems.WebDavConnection;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class FileSystemConnectionFactory
implements PooledObjectFactory<FileSystemConnection> {
    private static transient Log logger = LogFactory.getLog(FileSystemConnectionFactory.class);
    protected FileScheme scheme;
    protected FileSystemConnectionOptions fileSystemOptions;
    protected String host;
    protected int port;
    protected boolean passive;
    protected boolean secure;
    protected int timeout;

    public FileSystemConnectionFactory(FileScheme scheme, FileSystemConnectionOptions userCredentials, String host, int port, boolean passive, boolean secure, int timeout) {
        this.scheme = scheme;
        this.fileSystemOptions = userCredentials;
        this.host = host;
        this.port = port;
        this.passive = passive;
        this.secure = secure;
        this.timeout = timeout;
    }

    public String getPoolKey() {
        String username = this.fileSystemOptions.getUsername();
        String password = this.fileSystemOptions.getPassword();
        if (this.scheme.equals((Object)FileScheme.FILE)) {
            return "file://";
        }
        if (this.scheme.equals((Object)FileScheme.FTP)) {
            List commandList;
            StringBuilder poolKey = new StringBuilder("ftp://" + username + ":" + password + "@" + this.host + ":" + this.port);
            FTPSchemeProperties ftpSchemeProperties = (FTPSchemeProperties)this.fileSystemOptions.getSchemeProperties();
            if (ftpSchemeProperties != null && CollectionUtils.isNotEmpty((Collection)(commandList = ftpSchemeProperties.getInitialCommands()))) {
                for (String command : commandList) {
                    poolKey.append(":" + command);
                }
            }
            return poolKey.toString();
        }
        if (this.scheme.equals((Object)FileScheme.SFTP)) {
            Map configSettings;
            String knownHostsFile;
            StringBuilder poolKey = new StringBuilder();
            SftpSchemeProperties sftpSchemeProperties = (SftpSchemeProperties)this.fileSystemOptions.getSchemeProperties();
            poolKey.append("sftp://");
            poolKey.append(username);
            if (sftpSchemeProperties.isPasswordAuth()) {
                poolKey.append(":");
                poolKey.append(password);
            }
            if (sftpSchemeProperties.isKeyAuth()) {
                poolKey.append(":");
                poolKey.append(sftpSchemeProperties.getKeyFile());
                poolKey.append(":");
                poolKey.append(sftpSchemeProperties.getPassPhrase());
            }
            if (StringUtils.isNotEmpty((CharSequence)(knownHostsFile = sftpSchemeProperties.getKnownHostsFile()))) {
                poolKey.append(":");
                poolKey.append(knownHostsFile);
            }
            if (MapUtils.isNotEmpty((Map)(configSettings = sftpSchemeProperties.getConfigurationSettings()))) {
                for (Map.Entry setting : configSettings.entrySet()) {
                    poolKey.append(":" + (String)setting.getValue());
                }
            }
            poolKey.append("@");
            poolKey.append(this.host);
            poolKey.append(":");
            poolKey.append(this.port);
            return poolKey.toString();
        }
        if (this.scheme.equals((Object)FileScheme.S3)) {
            StringBuilder poolKey = new StringBuilder();
            S3SchemeProperties s3SchemeProperties = (S3SchemeProperties)this.fileSystemOptions.getSchemeProperties();
            poolKey.append("s3://");
            if (!s3SchemeProperties.isUseDefaultCredentialProviderChain()) {
                poolKey.append(username);
                poolKey.append(':');
                poolKey.append(password);
            }
            if (s3SchemeProperties.isUseTemporaryCredentials()) {
                poolKey.append(":STS");
            }
            poolKey.append('@');
            poolKey.append(s3SchemeProperties.getRegion());
            return poolKey.toString();
        }
        if (this.scheme.equals((Object)FileScheme.SMB)) {
            return "smb://" + username + ":" + password + "@" + this.host + ":" + this.port;
        }
        if (this.scheme.equals((Object)FileScheme.WEBDAV)) {
            String webdavScheme = "";
            if (this.secure) {
                webdavScheme = "https://";
                if (this.port < 0) {
                    this.port = 443;
                }
            } else {
                webdavScheme = "http://";
                if (this.port < 0) {
                    this.port = 80;
                }
            }
            if (username.equals("null")) {
                return webdavScheme + this.host + ":" + this.port;
            }
            return webdavScheme + username + ":" + password + "@" + this.host + ":" + this.port;
        }
        logger.error((Object)("getPoolKey doesn't handle scheme " + String.valueOf(this.scheme)));
        return "default";
    }

    public PooledObject<FileSystemConnection> makeObject() throws Exception {
        if (this.scheme.equals((Object)FileScheme.FILE)) {
            return new DefaultPooledObject((Object)new FileConnection());
        }
        if (this.scheme.equals((Object)FileScheme.FTP)) {
            return new DefaultPooledObject((Object)new FtpConnection(this.host, this.port, this.fileSystemOptions, this.passive, this.timeout));
        }
        if (this.scheme.equals((Object)FileScheme.SFTP)) {
            return new DefaultPooledObject((Object)new SftpConnection(this.host, this.port, this.fileSystemOptions, this.timeout));
        }
        if (this.scheme.equals((Object)FileScheme.S3)) {
            return new DefaultPooledObject((Object)new S3Connection(this.fileSystemOptions, this.timeout));
        }
        if (this.scheme.equals((Object)FileScheme.SMB)) {
            return new DefaultPooledObject((Object)new SmbFileConnection(this.host, this.fileSystemOptions, this.timeout));
        }
        if (this.scheme.equals((Object)FileScheme.WEBDAV)) {
            return new DefaultPooledObject((Object)new WebDavConnection(this.host, this.secure, this.fileSystemOptions));
        }
        logger.error((Object)("makeObject doesn't handle scheme " + String.valueOf(this.scheme)));
        throw new IOException("Unimplemented or unrecognized scheme");
    }

    public void destroyObject(PooledObject<FileSystemConnection> pooledConnection) throws Exception {
        ((FileSystemConnection)pooledConnection.getObject()).destroy();
    }

    public void activateObject(PooledObject<FileSystemConnection> pooledConnection) throws Exception {
        ((FileSystemConnection)pooledConnection.getObject()).activate();
    }

    public void passivateObject(PooledObject<FileSystemConnection> pooledConnection) throws Exception {
        ((FileSystemConnection)pooledConnection.getObject()).passivate();
    }

    public boolean validateObject(PooledObject<FileSystemConnection> pooledConnection) {
        return ((FileSystemConnection)pooledConnection.getObject()).isValid();
    }
}

