/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.mirth.connect.plugins.dynamiclookup.server.cache.CachedValue;
import com.mirth.connect.plugins.dynamiclookup.server.cache.FifoCacheWrapper;
import com.mirth.connect.plugins.dynamiclookup.server.cache.GuavaCacheWrapper;
import com.mirth.connect.plugins.dynamiclookup.server.cache.NoCacheWrapper;
import com.mirth.connect.plugins.dynamiclookup.server.cache.SimpleCache;
import com.mirth.connect.plugins.dynamiclookup.server.dao.LookupGroupDao;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.util.TtlUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupCacheManager {
    public static final String POLICY_LRU = "LRU";
    public static final String POLICY_FIFO = "FIFO";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Map<Integer, SimpleCache<String, CachedValue>> groupCaches = new ConcurrentHashMap<Integer, SimpleCache<String, CachedValue>>();
    private final LookupGroupDao groupDao;

    public LookupCacheManager(LookupGroupDao lookupGroupDao) {
        this.groupDao = lookupGroupDao;
    }

    public void createOrRebuildGroupCache(LookupGroup lookupGroup) {
        if (lookupGroup == null) {
            this.logger.error("group must not be null");
            return;
        }
        this.groupCaches.put(lookupGroup.getId(), this.buildCacheForGroup(lookupGroup));
        if (lookupGroup.getCacheSize() <= 0) {
            this.logger.info("Cache disabled for group {} (ID: {}, size={})", (Object)lookupGroup.getName(), (Object)lookupGroup.getId(), (Object)lookupGroup.getCacheSize());
        } else {
            this.logger.info("Cache (policy={}, size={}) initialized for group {} (ID: {})", (Object)lookupGroup.getCachePolicy(), (Object)lookupGroup.getCacheSize(), (Object)lookupGroup.getName(), (Object)lookupGroup.getId());
        }
    }

    public void removeGroupCache(int n) {
        this.groupCaches.remove(n);
        this.logger.info("Cache removed for groupId={}", (Object)n);
    }

    public SimpleCache<String, CachedValue> buildCacheForGroup(LookupGroup lookupGroup) {
        int n = lookupGroup.getCacheSize();
        String string = lookupGroup.getCachePolicy();
        if (n <= 0) {
            return new NoCacheWrapper<String, CachedValue>();
        }
        if (POLICY_FIFO.equalsIgnoreCase(string)) {
            return new FifoCacheWrapper<String, CachedValue>(n);
        }
        Cache cache = CacheBuilder.newBuilder().maximumSize((long)n).recordStats().build();
        return new GuavaCacheWrapper<String, CachedValue>(cache);
    }

    public String getValue(int n, String string, long l) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        if (simpleCache == null) {
            return null;
        }
        CachedValue cachedValue = simpleCache.get(string);
        if (cachedValue == null) {
            return null;
        }
        if (TtlUtils.isWithinTtlSeconds((Date)cachedValue.getUpdatedAt(), (long)l)) {
            return cachedValue.getValue();
        }
        return null;
    }

    public void putValue(int n, String string, String string2, Date date) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        if (simpleCache == null) {
            this.logger.debug("Skip cache put: cache not initialized for groupId={}", (Object)n);
            return;
        }
        simpleCache.put(string, new CachedValue(string2, date));
    }

    public void removeValue(int n, String string) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        if (simpleCache != null) {
            simpleCache.remove(string);
        }
    }

    public void clearGroupCache(int n) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        if (simpleCache != null) {
            simpleCache.clear();
        }
    }

    public void clearAllCaches() {
        this.groupCaches.values().forEach(SimpleCache::clear);
    }

    public int getCacheSize(int n) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        return simpleCache != null ? simpleCache.size() : 0;
    }

    public int getCacheMaxSize(int n) {
        if (this.groupDao == null) {
            return -1;
        }
        LookupGroup lookupGroup = this.groupDao.getGroupById(n);
        return lookupGroup != null ? lookupGroup.getCacheSize() : -1;
    }

    public CacheStats getCacheStats(int n) {
        SimpleCache<String, CachedValue> simpleCache = this.getCache(n);
        if (simpleCache instanceof GuavaCacheWrapper) {
            GuavaCacheWrapper guavaCacheWrapper = (GuavaCacheWrapper)simpleCache;
            return guavaCacheWrapper.getGuavaCache().stats();
        }
        return null;
    }

    private SimpleCache<String, CachedValue> getCache(int n) {
        return this.groupCaches.get(n);
    }
}

