/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.exception;

import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ErrorResponseFactory;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class LookupApiException
extends WebApplicationException {
    public LookupApiException() {
        super(LookupApiException.buildJsonResponse(Response.Status.INTERNAL_SERVER_ERROR, "UNKNOWN_ERROR", "An unexpected error occurred."));
    }

    public LookupApiException(Response.Status status) {
        super(LookupApiException.buildJsonResponse(status, status.name(), status.getReasonPhrase()));
    }

    public LookupApiException(Response.Status status, String string, String string2) {
        super(LookupApiException.buildJsonResponse(status, string, string2));
    }

    public LookupApiException(int n, String string, String string2) {
        super(LookupApiException.buildJsonResponse(Response.Status.fromStatusCode((int)n), string, string2));
    }

    public LookupApiException(Throwable throwable) {
        super(LookupApiException.buildJsonResponse(Response.Status.INTERNAL_SERVER_ERROR, "INTERNAL_ERROR", throwable.getMessage()));
    }

    public LookupApiException(Response response) {
        super(response);
    }

    private static Response buildJsonResponse(Response.Status status, String string, String string2) {
        try {
            return Response.status((Response.Status)status).type("application/json").entity((Object)JsonUtils.toJson((Object)ErrorResponseFactory.build((String)string, (String)string2))).build();
        }
        catch (Exception exception) {
            String string3 = "{\"status\":\"error\",\"code\":\"INTERNAL_ERROR\",\"message\":\"Failed to serialize error response\",\"timestamp\":\"" + ZonedDateTime.now(ZoneOffset.UTC).toString() + "\"}";
            return Response.status((Response.Status)status).type("application/json").entity((Object)string3).build();
        }
    }
}

