/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.migration;

import com.mirth.connect.plugins.dynamiclookup.server.migration.LookupSchemaMigrator;
import com.mirth.connect.plugins.dynamiclookup.server.migration.SqlScriptRunner;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupDbUtil;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.DatabaseInfo;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LookupDatabaseMigrator {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final SqlSessionManager sqlSessionManager;

    public LookupDatabaseMigrator(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    public void initializeDatabase() throws Exception {
        this.logger.info("Initializing database schema...");
        boolean bl = false;
        try (SqlSession sqlSession = this.sqlSessionManager.openSession();){
            bl = LookupDbUtil.tableExists(sqlSession.getConnection(), "LOOKUP_GROUP");
        }
        if (!bl) {
            DatabaseInfo.DatabaseType databaseType = LookupJsonCapability.getInstance().getDatabaseInfo().getType();
            String string = SqlScriptRunner.loadScript(this.getCreateSchemaScriptPath(databaseType));
            SqlScriptRunner.runWithSemicolon(this.sqlSessionManager, string);
            this.logger.info("Database schema initialized successfully");
        }
        this.logger.info("Running schema migrations (including fresh install)...");
        new LookupSchemaMigrator(this.sqlSessionManager).migrate();
        this.logger.info("Database schema migration completed");
    }

    private String getCreateSchemaScriptPath(DatabaseInfo.DatabaseType databaseType) {
        return switch (databaseType) {
            case DatabaseInfo.DatabaseType.POSTGRESQL -> "/sql/postgres/create_lookup_tables.sql";
            case DatabaseInfo.DatabaseType.MYSQL -> "/sql/mysql/create_lookup_tables.sql";
            case DatabaseInfo.DatabaseType.SQLSERVER -> "/sql/sqlserver/create_lookup_tables.sql";
            case DatabaseInfo.DatabaseType.ORACLE -> "/sql/oracle/create_lookup_tables.sql";
            default -> "/sql/derby/create_lookup_tables.sql";
        };
    }
}

