/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service.support;

import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldCriterion;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldIndexDefinition;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonIndexNaming;
import com.mirth.connect.plugins.dynamiclookup.server.util.JsonFieldUtils;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupTableNaming;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostgresJsonFieldDialect
implements JsonFieldDialect {
    @Override
    public List<JsonFieldIndexDefinition> buildIndexDefinitions(LookupGroup lookupGroup) {
        if (lookupGroup == null) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            return Collections.emptyList();
        }
        Set<String> set = JsonFieldUtils.parseIndexedFieldPaths(lookupGroupExtra.getIndexedJsonFields());
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        String string = LookupTableNaming.valueTableName(lookupGroup);
        ArrayList<JsonFieldIndexDefinition> arrayList = new ArrayList<JsonFieldIndexDefinition>();
        for (String string2 : set) {
            String string3 = this.buildIndexExpression(string2);
            String string4 = JsonIndexNaming.buildIndexName(string, string2);
            JsonFieldIndexDefinition jsonFieldIndexDefinition = new JsonFieldIndexDefinition();
            jsonFieldIndexDefinition.setFieldPath(string2);
            jsonFieldIndexDefinition.setIndexName(string4);
            jsonFieldIndexDefinition.setExpression(string3);
            jsonFieldIndexDefinition.setTableName(string);
            arrayList.add(jsonFieldIndexDefinition);
        }
        return arrayList;
    }

    @Override
    public List<JsonFieldCriterion> buildCriteria(LookupGroup lookupGroup, List<JsonCondition> list) {
        if (lookupGroup == null || list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            throw new IllegalStateException("Group extra missing for group: " + lookupGroup.getId());
        }
        return this.buildFieldCriterion(lookupGroup, list);
    }

    private List<JsonFieldCriterion> buildFieldCriterion(LookupGroup lookupGroup, List<JsonCondition> list) {
        ArrayList<JsonFieldCriterion> arrayList = new ArrayList<JsonFieldCriterion>();
        for (JsonCondition jsonCondition : list) {
            if (jsonCondition == null) continue;
            String string = jsonCondition.getField().trim();
            JsonValueType jsonValueType = jsonCondition.getValueType();
            String string2 = this.buildTypeCheckSql(string, jsonValueType);
            String string3 = this.buildCriterionExpression(string, jsonValueType);
            String string4 = this.buildOperatorSql(jsonCondition.getOp());
            JsonFieldCriterion jsonFieldCriterion = new JsonFieldCriterion();
            jsonFieldCriterion.setTypeCheckSql(string2);
            jsonFieldCriterion.setExpression(string3);
            jsonFieldCriterion.setOperatorSql(string4);
            jsonFieldCriterion.setValue(jsonCondition.getValue());
            jsonFieldCriterion.setValueSql(this.buildValueSql(jsonValueType));
            arrayList.add(jsonFieldCriterion);
        }
        return arrayList;
    }

    private static void mergePath(Map<String, Object> linkedHashMap, String[] stringArray, Object object) {
        LinkedHashMap<String, Object> linkedHashMap2 = linkedHashMap;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = string = stringArray[i] == null ? "" : stringArray[i].trim();
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Invalid JSON field path part");
            }
            if (i == stringArray.length - 1) {
                linkedHashMap2.put(string, object);
                return;
            }
            Object object2 = linkedHashMap2.get(string);
            if (object2 == null) {
                LinkedHashMap<String, Object> linkedHashMap3 = new LinkedHashMap<String, Object>();
                linkedHashMap2.put(string, linkedHashMap3);
                linkedHashMap2 = linkedHashMap3;
                continue;
            }
            if (object2 instanceof Map) {
                linkedHashMap2 = (LinkedHashMap<String, Object>)object2;
                continue;
            }
            throw new IllegalArgumentException("Conflicting JSON path: cannot descend into non-object at '" + string + "'");
        }
    }

    private String buildIndexExpression(String string) {
        if (!string.contains(".")) {
            return "VALUE_DATA->>'" + string + "'";
        }
        String string2 = "{" + string.replace(".", ",") + "}";
        return "VALUE_DATA #>> '" + string2 + "'";
    }

    private String buildTypeCheckSql(String string, JsonValueType jsonValueType) {
        String string2;
        if (jsonValueType == null || jsonValueType == JsonValueType.STRING) {
            return null;
        }
        boolean bl = string.contains(".");
        if (!bl) {
            string2 = "VALUE_DATA->'" + string + "'";
        } else {
            String string3 = "{" + string.replace(".", ",") + "}";
            string2 = "VALUE_DATA #> '" + string3 + "'";
        }
        if (jsonValueType == JsonValueType.NUMBER) {
            return "jsonb_typeof(" + string2 + ") = 'number'";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return "jsonb_typeof(" + string2 + ") = 'boolean'";
        }
        return null;
    }

    private String buildCriterionExpression(String string, JsonValueType jsonValueType) {
        String string2;
        boolean bl = string.contains(".");
        if (!bl) {
            string2 = "VALUE_DATA->>'" + string + "'";
        } else {
            String string3 = "{" + string.replace(".", ",") + "}";
            string2 = "VALUE_DATA #>> '" + string3 + "'";
        }
        if (jsonValueType == JsonValueType.NUMBER) {
            return "(" + string2 + ")::numeric";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return "(" + string2 + ")::boolean";
        }
        return string2;
    }

    private String buildValueSql(JsonValueType jsonValueType) {
        JsonValueType jsonValueType2 = jsonValueType != null ? jsonValueType : JsonValueType.STRING;
        switch (jsonValueType2) {
            case NUMBER: {
                return "CAST(#{c.value} AS numeric)";
            }
            case BOOLEAN: {
                return "CAST(#{c.value} AS boolean)";
            }
        }
        return "#{c.value}";
    }

    private String buildOperatorSql(JsonOperator jsonOperator) {
        if (jsonOperator == null) {
            return "=";
        }
        switch (jsonOperator) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
        }
        throw new IllegalArgumentException("Unsupported JsonOperator for PostgreSQL: " + String.valueOf(jsonOperator));
    }
}

