/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.service.support;

import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldCriterion;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldDialect;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonFieldIndexDefinition;
import com.mirth.connect.plugins.dynamiclookup.server.service.support.JsonIndexNaming;
import com.mirth.connect.plugins.dynamiclookup.server.util.JsonFieldUtils;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupTableNaming;
import com.mirth.connect.plugins.dynamiclookup.shared.constant.LookupConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonCondition;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonOperator;
import com.mirth.connect.plugins.dynamiclookup.shared.model.json.JsonValueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlServerJsonFieldDialect
implements JsonFieldDialect {
    @Override
    public List<JsonFieldIndexDefinition> buildIndexDefinitions(LookupGroup lookupGroup) {
        if (lookupGroup == null) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            return Collections.emptyList();
        }
        Set<String> set = JsonFieldUtils.parseIndexedFieldPaths(lookupGroupExtra.getIndexedJsonFields());
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        String string = LookupTableNaming.valueTableName(lookupGroup);
        ArrayList<JsonFieldIndexDefinition> arrayList = new ArrayList<JsonFieldIndexDefinition>();
        for (String string2 : set) {
            String string3 = this.buildIndexExpression(string2);
            String string4 = this.buildComputedColumnName(string2);
            String string5 = JsonIndexNaming.buildIndexName(string, string2);
            JsonFieldIndexDefinition jsonFieldIndexDefinition = new JsonFieldIndexDefinition();
            jsonFieldIndexDefinition.setFieldPath(string2);
            jsonFieldIndexDefinition.setIndexName(string5);
            jsonFieldIndexDefinition.setExpression(string3);
            jsonFieldIndexDefinition.setComputedColumnName(string4);
            jsonFieldIndexDefinition.setTableName(string);
            arrayList.add(jsonFieldIndexDefinition);
        }
        return arrayList;
    }

    @Override
    public List<JsonFieldCriterion> buildCriteria(LookupGroup lookupGroup, List<JsonCondition> list) {
        if (lookupGroup == null || list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra == null) {
            throw new IllegalStateException("Group extra missing for group: " + lookupGroup.getId());
        }
        return this.buildFieldCriterion(lookupGroup, list);
    }

    public List<JsonFieldCriterion> buildFieldCriterion(LookupGroup lookupGroup, List<JsonCondition> list) {
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        String string = LookupConstants.normalizeJsonIndexMode((String)lookupGroupExtra.getJsonIndexMode());
        List list2 = LookupConstants.isFieldMode((String)string) ? this.buildIndexDefinitions(lookupGroup) : Collections.emptyList();
        Map<String, JsonFieldIndexDefinition> map = list2.stream().collect(Collectors.toMap(JsonFieldIndexDefinition::getFieldPath, jsonFieldIndexDefinition -> jsonFieldIndexDefinition, (jsonFieldIndexDefinition, jsonFieldIndexDefinition2) -> jsonFieldIndexDefinition));
        ArrayList<JsonFieldCriterion> arrayList = new ArrayList<JsonFieldCriterion>();
        for (JsonCondition jsonCondition : list) {
            if (jsonCondition == null) continue;
            String string2 = jsonCondition.getField();
            JsonValueType jsonValueType = jsonCondition.getValueType();
            JsonFieldIndexDefinition jsonFieldIndexDefinition3 = map.get(string2);
            String string3 = this.canUseFieldIndex(string, jsonFieldIndexDefinition3) ? jsonFieldIndexDefinition3.getComputedColumnName() : null;
            String string4 = this.buildTypeCheckSql(string2, jsonValueType, string3);
            String string5 = this.buildCriterionExpression(string2, jsonValueType, string3);
            String string6 = this.buildSqlOperator(jsonCondition.getOp());
            JsonFieldCriterion jsonFieldCriterion = new JsonFieldCriterion();
            jsonFieldCriterion.setTypeCheckSql(string4);
            jsonFieldCriterion.setExpression(string5);
            jsonFieldCriterion.setOperatorSql(string6);
            jsonFieldCriterion.setValue(jsonCondition.getValue());
            jsonFieldCriterion.setValueSql(this.buildValueSql(jsonValueType));
            arrayList.add(jsonFieldCriterion);
        }
        return arrayList;
    }

    private String buildIndexExpression(String string) {
        String string2 = this.normalizeJsonPath(string);
        return "JSON_VALUE(VALUE_DATA, '" + string2 + "')";
    }

    private boolean canUseFieldIndex(String string, JsonFieldIndexDefinition jsonFieldIndexDefinition) {
        if (!LookupConstants.isFieldMode((String)string)) {
            return false;
        }
        if (jsonFieldIndexDefinition == null) {
            return false;
        }
        String string2 = jsonFieldIndexDefinition.getComputedColumnName();
        return string2 != null && !string2.isEmpty();
    }

    private String buildComputedColumnName(String string) {
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder("JSON_");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].toUpperCase().replaceAll("[^A-Z0-9]", "_");
            stringBuilder.append(string2);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    private String buildTypeCheckSql(String string, JsonValueType jsonValueType, String string2) {
        if (jsonValueType == null || jsonValueType == JsonValueType.STRING) {
            return null;
        }
        String string3 = this.resolveBaseExpr(string, string2);
        if (jsonValueType == JsonValueType.NUMBER) {
            return "TRY_CONVERT(DECIMAL(38,10), " + string3 + ") IS NOT NULL AND TRY_CONVERT(DECIMAL(38,10), #{c.value}) IS NOT NULL";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return string3 + " IN ('true','false') AND #{c.value} IN ('true','false')";
        }
        return null;
    }

    private String buildCriterionExpression(String string, JsonValueType jsonValueType, String string2) {
        String string3 = this.resolveBaseExpr(string, string2);
        if (jsonValueType == JsonValueType.NUMBER) {
            return "TRY_CONVERT(DECIMAL(38,10), " + string3 + ")";
        }
        if (jsonValueType == JsonValueType.BOOLEAN) {
            return "CASE WHEN " + string3 + " = 'true' THEN CAST(1 AS BIT) WHEN " + string3 + " = 'false' THEN CAST(0 AS BIT) ELSE NULL END";
        }
        return string3;
    }

    private String resolveBaseExpr(String string, String string2) {
        if (string2 != null && !string2.isEmpty()) {
            return string2;
        }
        String string3 = this.normalizeJsonPath(string);
        return "JSON_VALUE(VALUE_DATA, '" + string3 + "')";
    }

    private String buildValueSql(JsonValueType jsonValueType) {
        JsonValueType jsonValueType2 = jsonValueType != null ? jsonValueType : JsonValueType.STRING;
        switch (jsonValueType2) {
            case NUMBER: {
                return "TRY_CONVERT(DECIMAL(38,10), #{c.value})";
            }
            case BOOLEAN: {
                return "CASE WHEN #{c.value} = 'true' THEN CAST(1 AS BIT) WHEN #{c.value} = 'false' THEN CAST(0 AS BIT) ELSE NULL END";
            }
        }
        return "#{c.value}";
    }

    private String buildSqlOperator(JsonOperator jsonOperator) {
        if (jsonOperator == null) {
            return "=";
        }
        switch (jsonOperator) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
        }
        throw new IllegalArgumentException("Unsupported JsonOperator for SQL Server: " + String.valueOf(jsonOperator));
    }

    private String normalizeJsonPath(String string) {
        if (string == null) {
            return "$";
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return "$";
        }
        String[] stringArray = string2.split("\\.");
        StringBuilder stringBuilder = new StringBuilder("$");
        for (String string3 : stringArray) {
            if (string3 == null || string3.isEmpty()) continue;
            stringBuilder.append(".\"").append(string3.replace("\"", "\\\"")).append("\"");
        }
        return stringBuilder.toString();
    }
}

