/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.userutil;

import com.mirth.connect.plugins.dynamiclookup.server.audit.LookupAuditLogger;
import com.mirth.connect.plugins.dynamiclookup.server.exception.DuplicateGroupNameException;
import com.mirth.connect.plugins.dynamiclookup.server.service.LookupService;
import com.mirth.connect.plugins.dynamiclookup.server.util.LookupGroupConverter;
import com.mirth.connect.plugins.dynamiclookup.shared.builder.AdvancedJsonFilterBuilder;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.CacheStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.model.AdvancedJsonFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupStatistics;
import com.mirth.connect.plugins.dynamiclookup.shared.util.TtlUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupHelper {
    private static final String SYSTEM_USER_ID = "0";
    private static final Logger logger = LogManager.getLogger(LookupHelper.class);
    private static LookupService lookupService;

    public static void initialize(LookupService lookupService) {
        LookupHelper.lookupService = lookupService;
    }

    public static String get(String string, String string2) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return null;
            }
            return lookupService.getValue(lookupGroup.getId(), string2);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve lookup value [group='{}', key='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public static String get(String string, String string2, long l) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return null;
            }
            long l2 = TtlUtils.hoursToSeconds((long)l);
            return lookupService.getValue(lookupGroup.getId(), string2, l2);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve lookup value [group='{}', key='{}', ttl={}]: {}", (Object)string, (Object)string2, (Object)l, (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public static String get(String string, String string2, long l, long l2) {
        try {
            if (l < 0L || l2 < 0L) {
                logger.error("TTL hours and minutes must be non-negative");
                return null;
            }
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return null;
            }
            long l3 = TtlUtils.hoursMinutesToSeconds((long)l, (long)l2);
            return lookupService.getValue(lookupGroup.getId(), string2, l3);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve lookup value [group='{}', key='{}', ttlHours={}, ttlMinutes={}]: {}", (Object)string, (Object)string2, (Object)l, (Object)l2, (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public static String get(String string, String string2, String string3) {
        String string4 = LookupHelper.get(string, string2);
        return string4 != null ? string4 : string3;
    }

    public static String get(String string, String string2, long l, String string3) {
        String string4 = LookupHelper.get(string, string2, l);
        return string4 != null ? string4 : string3;
    }

    public static String get(String string, String string2, long l, long l2, String string3) {
        String string4 = LookupHelper.get(string, string2, l, l2);
        return string4 != null ? string4 : string3;
    }

    public static long getMatchingCount(String string, String string2) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return 0L;
            }
            return lookupService.getMatchingValuesCount(lookupGroup.getId(), string2);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve matching lookup values count [group='{}', pattern='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return 0L;
        }
    }

    public static Map<String, String> getMatching(String string, String string2) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            return lookupService.getMatchingValues(lookupGroup.getId(), string2);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve matching lookup values [group='{}', pattern='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getMatching(String string, String string2, int n) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            return lookupService.getMatchingValues(lookupGroup.getId(), string2, n);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve matching lookup values [group='{}', pattern='{}', limit={}]: {}", (Object)string, (Object)string2, (Object)n, (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getBatch(String string, List<String> list) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            return lookupService.getBatchValues(lookupGroup.getId(), list);
        }
        catch (Exception exception) {
            logger.error("Error in lookup operation: {}", (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getBatch(String string, List<String> list, long l) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            long l2 = TtlUtils.hoursToSeconds((long)l);
            return lookupService.getBatchValues(lookupGroup.getId(), list, l2);
        }
        catch (Exception exception) {
            logger.error("Error in TTL-based lookup operation: {}", (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> getBatch(String string, List<String> list, long l, long l2) {
        try {
            if (l < 0L || l2 < 0L) {
                logger.error("TTL hours and minutes must be non-negative");
                return Collections.emptyMap();
            }
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            long l3 = TtlUtils.hoursMinutesToSeconds((long)l, (long)l2);
            return lookupService.getBatchValues(lookupGroup.getId(), list, l3);
        }
        catch (Exception exception) {
            logger.error("Failed to retrieve batch lookup values [group='{}', keys={}, ttlHours={}, ttlMinutes={}]: {}", (Object)string, list, (Object)l, (Object)l2, (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static boolean exists(String string, String string2) {
        try {
            return LookupHelper.get(string, string2) != null;
        }
        catch (Exception exception) {
            logger.error("Error checking key existence: {}", (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static Map<String, Object> getCacheStats(String string) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return Collections.emptyMap();
            }
            CacheStatistics cacheStatistics = lookupService.getCacheStatistics(lookupGroup.getId());
            LookupStatistics lookupStatistics = lookupService.getStatistics(lookupGroup.getId());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (cacheStatistics != null) {
                hashMap.put("hitCount", cacheStatistics.getHitCount());
                hashMap.put("missCount", cacheStatistics.getMissCount());
                hashMap.put("hitRatio", cacheStatistics.getHitRatio());
                hashMap.put("missRatio", cacheStatistics.getMissRatio());
                hashMap.put("evictionCount", cacheStatistics.getEvictionCount());
            }
            if (lookupStatistics != null) {
                hashMap.put("totalLookups", lookupStatistics.getTotalLookups());
                hashMap.put("cacheHits", lookupStatistics.getCacheHits());
                hashMap.put("lastAccessed", lookupStatistics.getLastAccessed());
            }
            return hashMap;
        }
        catch (Exception exception) {
            logger.error("Error getting cache stats: {}", (Object)exception.getMessage(), (Object)exception);
            return Collections.emptyMap();
        }
    }

    public static boolean set(String string, String string2, String string3) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            lookupService.setValue(lookupGroup.getId(), string2, string3, SYSTEM_USER_ID);
            return true;
        }
        catch (Exception exception) {
            logger.error("Failed to set lookup value [group='{}', key='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static boolean deleteValue(String string, String string2) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            lookupService.deleteValue(lookupGroup.getId(), string2, SYSTEM_USER_ID);
            return true;
        }
        catch (Exception exception) {
            logger.error("Failed to delete lookup value [group='{}', key='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static boolean deleteAllValues(String string) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            lookupService.deleteAllValues(lookupGroup.getId(), SYSTEM_USER_ID);
            return true;
        }
        catch (Exception exception) {
            logger.error("Failed to delete all lookup values [group='{}']: {}", (Object)string, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static Map<String, Object> importValues(String string, Map<String, String> map, boolean bl) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                linkedHashMap.put("ok", "false");
                linkedHashMap.put("errorCode", "GROUP_NOT_FOUND");
                linkedHashMap.put("errorMessage", "Lookup group not found: " + string);
                return linkedHashMap;
            }
            int n = lookupService.importValues(lookupGroup.getId(), map, bl, SYSTEM_USER_ID);
            linkedHashMap.put("ok", "true");
            linkedHashMap.put("groupId", lookupGroup.getId());
            linkedHashMap.put("importedCount", n);
            return linkedHashMap;
        }
        catch (Exception exception) {
            logger.error("Failed to import lookup values [group='{}']: {}", (Object)string, (Object)exception.getMessage(), (Object)exception);
            linkedHashMap.put("ok", "false");
            linkedHashMap.put("errorCode", "IMPORT_FAILED");
            linkedHashMap.put("errorMessage", exception.getMessage());
            return linkedHashMap;
        }
    }

    public static boolean putIfAbsent(String string, String string2, String string3) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            return lookupService.putIfAbsent(lookupGroup.getId(), string2, string3, SYSTEM_USER_ID);
        }
        catch (Exception exception) {
            logger.error("Failed to putIfAbsent lookup value [group='{}', key='{}']: {}", (Object)string, (Object)string2, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static boolean compareAndSwap(String string, String string2, String string3, String string4) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            return lookupService.compareAndSwap(lookupGroup.getId(), string2, string3, string4, SYSTEM_USER_ID);
        }
        catch (Exception exception) {
            logger.error("Failed to compareAndSwap lookup value [group='{}', key='{}', expectedValue='{}', newValue='{}']: {}", (Object)string, (Object)string2, (Object)string3, (Object)string4, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static boolean updateValueByDelta(String string, String string2, long l) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            return lookupService.updateValueByDelta(lookupGroup.getId(), string2, l, SYSTEM_USER_ID);
        }
        catch (Exception exception) {
            logger.error("Failed to updateValueByDelta lookup value [group='{}', key='{}', delta='{}']: {}", (Object)string, (Object)string2, (Object)l, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }

    public static Map<String, String> searchValuesByJsonFields(String string, String string2, String string3) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return null;
            }
            AdvancedJsonFilterState advancedJsonFilterState = AdvancedJsonFilterBuilder.fromLookupHelperInputs((String)string2, (String)string3);
            return lookupService.searchValuesByJsonFields(lookupGroup.getId(), advancedJsonFilterState);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Invalid lookup JSON filter [group='{}', keyPattern={}, filterJson={}]: {}", (Object)string, (Object)string2, (Object)string3, (Object)illegalArgumentException.getMessage());
            return null;
        }
        catch (Exception exception) {
            logger.error("Failed to search lookup values [group='{}', keyPattern={}, filterJson={}]: {}", (Object)string, (Object)string2, (Object)string3, (Object)exception.getMessage(), (Object)exception);
            return null;
        }
    }

    public static Map<String, Object> createGroup(Map<String, String> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        try {
            LookupGroup lookupGroup = LookupGroupConverter.toLookupGroup(map);
            int n = lookupService.createGroup(lookupGroup);
            LookupAuditLogger.getInstance().logHelperGroupCreated(lookupGroup);
            LookupGroup lookupGroup2 = lookupService.getGroupById(n);
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            linkedHashMap2.put("id", lookupGroup2.getId());
            linkedHashMap2.put("name", lookupGroup2.getName());
            linkedHashMap2.put("description", lookupGroup2.getDescription());
            linkedHashMap2.put("version", lookupGroup2.getVersion());
            linkedHashMap2.put("cacheSize", lookupGroup2.getCacheSize());
            linkedHashMap2.put("cachePolicy", lookupGroup2.getCachePolicy());
            linkedHashMap2.put("statisticsEnabled", lookupGroup2.isStatisticsEnabled());
            linkedHashMap2.put("valueType", lookupGroup2.getValueType());
            LookupGroupExtra lookupGroupExtra = lookupGroup2.getExtra();
            if (lookupGroupExtra != null) {
                linkedHashMap2.put("jsonIndexMode", lookupGroupExtra.getJsonIndexMode());
                linkedHashMap2.put("indexedJsonFields", lookupGroupExtra.getIndexedJsonFields());
            }
            linkedHashMap.put("ok", "true");
            linkedHashMap.put("group", linkedHashMap2);
            return linkedHashMap;
        }
        catch (DuplicateGroupNameException duplicateGroupNameException) {
            logger.warn("Duplicate group name: {}", (Object)map.get("name"));
            linkedHashMap.put("ok", "false");
            linkedHashMap.put("errorCode", "DUPLICATE_GROUP_NAME");
            linkedHashMap.put("errorMessage", "Group name already exists: " + map.get("name"));
            return linkedHashMap;
        }
        catch (Exception exception) {
            logger.error("Failed to create lookup group [name='{}']: {}", (Object)map.get("name"), (Object)exception.getMessage(), (Object)exception);
            linkedHashMap.put("ok", "false");
            linkedHashMap.put("errorCode", "CREATE_FAILED");
            linkedHashMap.put("errorMessage", exception.getMessage());
            return linkedHashMap;
        }
    }

    public static boolean deleteGroup(String string) {
        try {
            LookupGroup lookupGroup = lookupService.getGroupByName(string);
            if (lookupGroup == null) {
                logger.error("Lookup group not found: {}", (Object)string);
                return false;
            }
            lookupService.deleteGroup(lookupGroup.getId());
            LookupAuditLogger.getInstance().logHelperGroupDeleted(string, lookupGroup.getId());
            return true;
        }
        catch (Exception exception) {
            logger.error("Failed to delete lookup group [group='{}']: {}", (Object)string, (Object)exception.getMessage(), (Object)exception);
            return false;
        }
    }
}

