/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.server.util;

import com.mirth.connect.model.converters.DocumentSerializer;
import com.mirth.connect.plugins.dynamiclookup.server.config.DatabaseSettings;
import com.mirth.connect.plugins.dynamiclookup.server.config.DatabaseSettingsLoader;
import com.mirth.connect.server.util.SqlConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SqlSessionManagerProvider {
    private static final Logger logger = LogManager.getLogger(SqlSessionManagerProvider.class);
    private static SqlSessionManager sessionManager;

    public static synchronized SqlSessionManager get() {
        if (sessionManager != null) {
            return sessionManager;
        }
        DatabaseSettings databaseSettings = DatabaseSettingsLoader.load();
        if (!databaseSettings.isUseExternalDb()) {
            sessionManager = SqlConfig.getInstance().getSqlSessionManager();
            return sessionManager;
        }
        try {
            SqlSessionFactory sqlSessionFactory = SqlSessionManagerProvider.createFactory(databaseSettings.getDatabase(), databaseSettings);
            sessionManager = SqlSessionManager.newInstance((SqlSessionFactory)sqlSessionFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create external SqlSessionManager", exception);
        }
        return sessionManager;
    }

    private static SqlSessionFactory createFactory(String string, DatabaseSettings databaseSettings) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(Resources.getResourceAsReader((String)"config/sqlmap-config.xml"));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(bufferedReader));
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentSerializer documentSerializer = new DocumentSerializer();
        StringReader stringReader = new StringReader(documentSerializer.toXML(document));
        Properties properties = databaseSettings.getProperties();
        properties.setProperty("database", string);
        return new SqlSessionFactoryBuilder().build((Reader)stringReader, "external", properties);
    }
}

