/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.EntityException;
import com.mirth.connect.client.core.ForbiddenException;
import com.mirth.connect.client.core.MirthClientResponse;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.RequestAbortedException;
import com.mirth.connect.client.core.UnauthorizedException;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.HttpUtil;
import com.mirth.connect.util.MirthSSLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class ServerConnection
implements Connector {
    public static final String EXECUTE_TYPE_PROPERTY = "executeType";
    public static final String OPERATION_PROPERTY = "operation";
    public static final String CUSTOM_HEADERS_PROPERTY = "customHeaders";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int IDLE_TIMEOUT = 300000;
    private Logger logger = LogManager.getLogger(this.getClass());
    private Registry<ConnectionSocketFactory> socketFactoryRegistry;
    private PoolingHttpClientConnectionManager httpClientConnectionManager;
    private CookieStore cookieStore;
    private SocketConfig socketConfig;
    private RequestConfig requestConfig;
    private CloseableHttpClient client;
    private final Operation currentOp = new Operation(null, null, null, false);
    private HttpRequestBase syncRequestBase;
    private HttpRequestBase abortPendingRequestBase;
    private HttpClientContext abortPendingClientContext = null;
    private final AbortTask abortTask = new AbortTask();
    private ExecutorService abortExecutor = Executors.newSingleThreadExecutor();
    private IdleConnectionMonitor idleConnectionMonitor;
    private ConnectionKeepAliveStrategy keepAliveStrategy;

    public ServerConnection(int timeout, String[] httpsProtocols, String[] httpsCipherSuites) {
        this(timeout, httpsProtocols, httpsCipherSuites, false);
    }

    public ServerConnection(int timeout, String[] httpsProtocols, String[] httpsCipherSuites, boolean allowHTTP) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (Exception e) {
            this.logger.error("Unable to build SSL context.", (Throwable)e);
        }
        String[] enabledProtocols = MirthSSLUtil.getEnabledHttpsProtocols(httpsProtocols);
        String[] enabledCipherSuites = MirthSSLUtil.getEnabledHttpsCipherSuites(httpsCipherSuites);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, enabledProtocols, enabledCipherSuites, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        RegistryBuilder builder = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory);
        if (allowHTTP) {
            builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        }
        this.socketFactoryRegistry = builder.build();
        this.cookieStore = new BasicCookieStore();
        this.socketConfig = SocketConfig.custom().setSoTimeout(timeout).build();
        this.requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(timeout).build();
        this.keepAliveStrategy = new CustomKeepAliveStrategy();
        this.createClient();
    }

    public ClientResponse apply(ClientRequest request) {
        Operation operation = (Operation)request.getConfiguration().getProperty(OPERATION_PROPERTY);
        if (operation == null) {
            throw new ProcessingException("No operation provided for request: " + String.valueOf(request));
        }
        Operation.ExecuteType executeType = (Operation.ExecuteType)((Object)request.getConfiguration().getProperty(EXECUTE_TYPE_PROPERTY));
        if (executeType == null) {
            executeType = operation.getExecuteType();
        }
        Map customHeaders = (Map)request.getConfiguration().getProperty(CUSTOM_HEADERS_PROPERTY);
        if (this.logger.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder(operation.getDisplayName()).append('\n');
            debugMessage.append(request.getMethod()).append(' ').append(request.getUri());
            this.logger.debug(debugMessage.toString());
        }
        try {
            switch (executeType) {
                case SYNC: {
                    return this.executeSync(request, operation, customHeaders);
                }
                case ASYNC: {
                    return this.executeAsync(request, customHeaders);
                }
                case ABORT_PENDING: {
                    return this.executeAbortPending(request, customHeaders);
                }
            }
        }
        catch (ClientException e) {
            throw new ProcessingException((Throwable)e);
        }
        return null;
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "Mirth Server Connection";
    }

    public void close() {
    }

    private void createClient() {
        this.httpClientConnectionManager = new PoolingHttpClientConnectionManager(this.socketFactoryRegistry);
        this.httpClientConnectionManager.setDefaultMaxPerRoute(5);
        this.httpClientConnectionManager.setDefaultSocketConfig(this.socketConfig);
        this.httpClientConnectionManager.setValidateAfterInactivity(5000);
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager).setDefaultCookieStore(this.cookieStore).setKeepAliveStrategy(this.keepAliveStrategy);
        HttpUtil.configureClientBuilder(clientBuilder);
        this.client = clientBuilder.build();
        this.idleConnectionMonitor = new IdleConnectionMonitor();
        this.idleConnectionMonitor.start();
    }

    public synchronized void shutdown() {
        this.idleConnectionMonitor.shutdown();
        this.abortExecutor.shutdownNow();
        HttpClientUtils.closeQuietly((HttpClient)this.client);
    }

    public synchronized void restart() {
        this.shutdown();
        this.abortExecutor = Executors.newSingleThreadExecutor();
        this.createClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Collection<Operation> operations) {
        Operation operation = this.currentOp;
        synchronized (operation) {
            if (operations.contains(this.currentOp)) {
                this.syncRequestBase.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ClientResponse executeSync(ClientRequest request, Operation operation, Map<String, List<String>> customHeaders) throws ClientException {
        ClientResponse clientResponse;
        Operation operation2 = this.currentOp;
        synchronized (operation2) {
            this.currentOp.setName(operation.getName());
            this.currentOp.setDisplayName(operation.getDisplayName());
            this.currentOp.setAuditable(operation.isAuditable());
        }
        HttpRequestBase requestBase = null;
        CloseableHttpResponse response = null;
        boolean shouldClose = true;
        try {
            requestBase = this.setupRequestBase(request, customHeaders, Operation.ExecuteType.SYNC);
            response = this.client.execute((HttpUriRequest)requestBase);
            ClientResponse responseContext = this.handleResponse(request, requestBase, response, true);
            if (responseContext.hasEntity()) {
                shouldClose = false;
            }
            clientResponse = responseContext;
            if (!shouldClose) return clientResponse;
        }
        catch (Error e) {
            try {
                HttpUtil.closeVeryQuietly(response);
                this.restart();
                throw e;
                catch (Exception e2) {
                    if (e2 instanceof IllegalStateException) {
                        HttpUtil.closeVeryQuietly(response);
                        this.restart();
                    }
                    if (requestBase != null && requestBase.isAborted()) {
                        throw new RequestAbortedException(e2);
                    }
                    if (!(e2 instanceof ClientException)) throw new ClientException(e2);
                    throw (ClientException)e2;
                }
            }
            catch (Throwable throwable) {
                if (!shouldClose) throw throwable;
                HttpUtil.closeVeryQuietly(response);
                Operation operation3 = this.currentOp;
                synchronized (operation3) {
                    this.currentOp.setName(null);
                    this.currentOp.setDisplayName(null);
                    this.currentOp.setAuditable(false);
                    throw throwable;
                }
            }
        }
        HttpUtil.closeVeryQuietly(response);
        Operation operation4 = this.currentOp;
        synchronized (operation4) {
            this.currentOp.setName(null);
            this.currentOp.setDisplayName(null);
            this.currentOp.setAuditable(false);
            return clientResponse;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientResponse executeAsync(ClientRequest request, Map<String, List<String>> customHeaders) throws ClientException {
        ClientResponse clientResponse;
        block10: {
            HttpRequestBase requestBase = null;
            CloseableHttpResponse response = null;
            boolean shouldClose = true;
            try {
                requestBase = this.setupRequestBase(request, customHeaders, Operation.ExecuteType.ASYNC);
                response = this.client.execute((HttpUriRequest)requestBase);
                ClientResponse responseContext = this.handleResponse(request, requestBase, response);
                if (responseContext.hasEntity()) {
                    shouldClose = false;
                }
                clientResponse = responseContext;
                if (!shouldClose) break block10;
            }
            catch (Error e) {
                try {
                    HttpUtil.closeVeryQuietly(response);
                    this.restart();
                    throw e;
                    catch (Exception e2) {
                        if (e2 instanceof IllegalStateException) {
                            HttpUtil.closeVeryQuietly(response);
                            this.restart();
                        }
                        if (requestBase != null && requestBase.isAborted()) {
                            throw new RequestAbortedException(e2);
                        }
                        if (e2 instanceof ClientException) {
                            throw (ClientException)e2;
                        }
                        throw new ClientException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (shouldClose) {
                        HttpUtil.closeVeryQuietly(response);
                    }
                    throw throwable;
                }
            }
            HttpUtil.closeVeryQuietly(response);
        }
        return clientResponse;
    }

    /*
     * Exception decompiling
     */
    private ClientResponse executeAbortPending(ClientRequest request, Map<String, List<String>> customHeaders) throws ClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpRequestBase createRequestBase(String method) {
        HttpGet requestBase = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)method)) {
            requestBase = new HttpGet();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"POST", (CharSequence)method)) {
            requestBase = new HttpPost();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"PUT", (CharSequence)method)) {
            requestBase = new HttpPut();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"DELETE", (CharSequence)method)) {
            requestBase = new HttpDelete();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"OPTIONS", (CharSequence)method)) {
            requestBase = new HttpOptions();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"PATCH", (CharSequence)method)) {
            requestBase = new HttpPatch();
        }
        requestBase.setConfig(this.requestConfig);
        return requestBase;
    }

    private HttpRequestBase getRequestBase(Operation.ExecuteType executeType, String method) {
        HttpRequestBase requestBase = this.createRequestBase(method);
        if (executeType == Operation.ExecuteType.SYNC) {
            this.syncRequestBase = requestBase;
        } else if (executeType == Operation.ExecuteType.ABORT_PENDING) {
            this.abortPendingRequestBase = requestBase;
        }
        return requestBase;
    }

    private HttpRequestBase setupRequestBase(ClientRequest request, Map<String, List<String>> customHeaders, Operation.ExecuteType executeType) {
        HttpRequestBase requestBase = this.getRequestBase(executeType, request.getMethod());
        requestBase.setURI(request.getUri());
        requestBase.addHeader("X-Requested-With", "nextgen-connect-client");
        for (Map.Entry entry : request.getStringHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                requestBase.addHeader((String)entry.getKey(), value);
            }
        }
        if (MapUtils.isNotEmpty(customHeaders)) {
            for (Map.Entry entry : customHeaders.entrySet()) {
                String key = (String)entry.getKey();
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) continue;
                for (String value : (List)entry.getValue()) {
                    requestBase.addHeader(key, value);
                }
            }
        }
        if (request.hasEntity() && requestBase instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityRequestBase = (HttpEntityEnclosingRequestBase)requestBase;
            entityRequestBase.setEntity((HttpEntity)new ClientRequestEntity(request));
        }
        return requestBase;
    }

    private ClientResponse handleResponse(ClientRequest request, HttpRequestBase requestBase, CloseableHttpResponse response) throws IOException, ClientException {
        return this.handleResponse(request, requestBase, response, false);
    }

    private ClientResponse handleResponse(ClientRequest request, HttpRequestBase requestBase, CloseableHttpResponse response, boolean sync) throws IOException, ClientException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        MirthClientResponse responseContext = new MirthClientResponse(Statuses.from((int)statusCode), request);
        MultivaluedHashMap headerMap = new MultivaluedHashMap();
        for (Header header : response.getAllHeaders()) {
            headerMap.add((Object)header.getName(), (Object)header.getValue());
        }
        responseContext.headers((MultivaluedMap)headerMap);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity != null) {
            responseContext.setEntityStream(new EntityInputStreamWrapper(response, responseEntity.getContent(), sync));
        }
        if (statusCode == 401) {
            if (responseContext.hasEntity()) {
                try {
                    Object entity = responseContext.readEntity(Object.class);
                    throw new UnauthorizedException(statusLine.toString(), entity);
                }
                catch (ProcessingException entity) {
                    // empty catch block
                }
            }
            throw new UnauthorizedException(statusLine.toString());
        }
        if (statusCode == 403) {
            throw new ForbiddenException(statusLine.toString());
        }
        if (statusCode >= 400) {
            if (responseContext.hasEntity()) {
                try {
                    Charset charsetObj;
                    ContentType contentType = null;
                    String contentTypeString = responseContext.getHeaderString("Content-Type");
                    if (StringUtils.isNotBlank((CharSequence)contentTypeString)) {
                        contentType = ContentType.parse((String)contentTypeString);
                    }
                    String charset = null;
                    if (contentType != null && (charsetObj = contentType.getCharset()) != null) {
                        charset = charsetObj.name();
                    }
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    Throwable t = null;
                    String entityString = IOUtils.toString((InputStream)responseContext.getEntityStream(), (String)charset);
                    if (contentType == null || StringUtils.equalsIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)"application/xml")) {
                        try {
                            Object entity = ObjectXMLSerializer.getInstance().deserialize(entityString, Object.class);
                            t = entity instanceof Throwable ? (Throwable)entity : new EntityException(entity);
                        }
                        catch (SerializerException e) {
                            try {
                                t = ObjectXMLSerializer.getInstance().deserialize(entityString, Throwable.class);
                            }
                            catch (SerializerException serializerException) {
                                // empty catch block
                            }
                        }
                    }
                    if (t == null) {
                        t = new EntityException((Object)entityString);
                    }
                    throw new ClientException("Method failed: " + String.valueOf(statusLine), t);
                }
                catch (ProcessingException processingException) {
                    // empty catch block
                }
            }
            throw new ClientException("Method failed: " + String.valueOf(statusLine));
        }
        return responseContext;
    }

    private class AbortTask
    implements Runnable {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private int requestsInQueue = 0;
        private boolean abortAllowed = false;

        private AbortTask() {
        }

        public synchronized void incrementRequestsInQueue() {
            ++this.requestsInQueue;
        }

        public synchronized void decrementRequestsInQueue() {
            --this.requestsInQueue;
        }

        public synchronized void setAbortAllowed(boolean abortAllowed) {
            this.abortAllowed = abortAllowed;
        }

        public boolean isRunning() {
            return this.running.get();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class CustomKeepAliveStrategy
    extends DefaultConnectionKeepAliveStrategy {
        private CustomKeepAliveStrategy() {
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long keepAlive = super.getKeepAliveDuration(response, context);
            if (keepAlive <= 0L) {
                keepAlive = 300000L;
            }
            return keepAlive;
        }
    }

    private class IdleConnectionMonitor
    extends Thread {
        private volatile boolean shutdown;

        private IdleConnectionMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitor idleConnectionMonitor = this;
                    synchronized (idleConnectionMonitor) {
                        this.wait(5000L);
                        ServerConnection.this.httpClientConnectionManager.closeExpiredConnections();
                        ServerConnection.this.httpClientConnectionManager.closeIdleConnections(300000L, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitor idleConnectionMonitor = this;
            synchronized (idleConnectionMonitor) {
                this.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class ClientRequestEntity
    extends AbstractHttpEntity {
        private ClientRequest request;

        public ClientRequestEntity(ClientRequest request) {
            this.request = request;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(final OutputStream outstream) throws IOException {
            this.request.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                public OutputStream getOutputStream(int contentLength) throws IOException {
                    return outstream;
                }
            });
            this.request.writeEntity();
        }

        public boolean isStreaming() {
            return true;
        }
    }

    private class EntityInputStreamWrapper
    extends InputStream {
        private CloseableHttpResponse response;
        private InputStream delegate;
        private boolean sync;

        public EntityInputStreamWrapper(CloseableHttpResponse response, InputStream delegate, boolean sync) {
            this.response = response;
            this.delegate = delegate;
            this.sync = sync;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
                if (this.sync) {
                    Operation operation = ServerConnection.this.currentOp;
                    synchronized (operation) {
                        ServerConnection.this.currentOp.setName(null);
                        ServerConnection.this.currentOp.setDisplayName(null);
                        ServerConnection.this.currentOp.setAuditable(false);
                    }
                }
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

