/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.inject.Singleton;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
@Singleton
public class CalendarParamConverterProvider
implements ParamConverterProvider {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.getName().equals(Calendar.class.getName())) {
            return new ParamConverter<T>(){

                public T fromString(String value) {
                    if (value == null) {
                        return null;
                    }
                    try {
                        Calendar date = Calendar.getInstance();
                        date.setTime(format.parse(value));
                        return date;
                    }
                    catch (ParseException e) {
                        throw new ProcessingException((Throwable)e);
                    }
                }

                public String toString(T value) {
                    if (value == null) {
                        return null;
                    }
                    return format.format(((Calendar)value).getTime());
                }
            };
        }
        return null;
    }
}

