/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.util;

import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class OperationUtil {
    public static Operation getOperation(Class<?> servletInterface, Method method) {
        return OperationUtil.getOperation(servletInterface, method.getName(), method.getParameterTypes());
    }

    public static Operation getOperation(Class<?> servletInterface, String methodName, Class<?> ... parameterTypes) {
        try {
            Method matchingMethod = servletInterface.getMethod(methodName, parameterTypes);
            MirthOperation annotation = matchingMethod.getAnnotation(MirthOperation.class);
            if (annotation != null) {
                return new Operation(annotation.name(), annotation.display(), annotation.type(), annotation.auditable());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Set<Operation> getOperations(Class<?> servletInterface) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (Method method : servletInterface.getMethods()) {
            MirthOperation annotation = method.getAnnotation(MirthOperation.class);
            if (annotation == null) continue;
            operations.add(new Operation(annotation.name(), annotation.display(), annotation.type(), annotation.auditable()));
        }
        return operations;
    }

    public static Set<Operation> getAbortableOperations(Class<?> servletInterface) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (Method method : servletInterface.getMethods()) {
            MirthOperation annotation = method.getAnnotation(MirthOperation.class);
            if (annotation == null || !annotation.abortable()) continue;
            operations.add(new Operation(annotation.name(), annotation.display(), annotation.type(), annotation.auditable()));
        }
        return operations;
    }

    public static String[] getOperationNamesForPermission(String permissionName) {
        return OperationUtil.getOperationNamesForPermission(permissionName, null, new String[0]);
    }

    public static String[] getOperationNamesForPermission(String permissionName, Class<?> servletInterface, String ... extraOperationNames) {
        HashSet<String> operationNames = new HashSet<String>();
        for (Class coreServletInterface : new Reflections("com.mirth.connect.client.core.api.servlets", new Scanner[0]).getSubTypesOf(BaseServletInterface.class)) {
            OperationUtil.addOperationName(permissionName, coreServletInterface, operationNames);
        }
        if (servletInterface != null) {
            OperationUtil.addOperationName(permissionName, servletInterface, operationNames);
        }
        if (ArrayUtils.isNotEmpty((Object[])extraOperationNames)) {
            operationNames.addAll(Arrays.asList(extraOperationNames));
        }
        return operationNames.toArray(new String[operationNames.size()]);
    }

    private static void addOperationName(String permissionName, Class<?> servletInterface, Set<String> operationNames) {
        for (Method method : servletInterface.getMethods()) {
            MirthOperation operationAnnotation = method.getAnnotation(MirthOperation.class);
            if (operationAnnotation == null || !operationAnnotation.permission().equals(permissionName)) continue;
            operationNames.add(operationAnnotation.name());
        }
    }
}

