/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.Transformer;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DocumentReader;
import org.w3c.dom.Element;

public class InvalidChannel
extends Channel {
    private Throwable cause;
    private String channelXml;

    public InvalidChannel(String preUnmarshalXml, DonkeyElement channel, Throwable cause, HierarchicalStreamReader reader) {
        while (reader != null && reader.underlyingReader() instanceof DocumentReader && ((DocumentReader)reader.underlyingReader()).getCurrent() instanceof Element && !((DocumentReader)reader.underlyingReader()).getCurrent().equals(channel.getElement())) {
            reader.moveUp();
        }
        if (preUnmarshalXml == null || channel == null) {
            throw new SerializerException("Could not create invalid channel. The channel element or XML is null.");
        }
        DonkeyElement id = channel.getChildElement("id");
        DonkeyElement name = channel.getChildElement("name");
        DonkeyElement revision = channel.getChildElement("revision");
        if (id == null || name == null || revision == null) {
            throw new SerializerException("Could not create invalid channel. The channel ID, name, or revision is missing.");
        }
        try {
            this.init(id.getTextContent(), name.getTextContent(), Integer.valueOf(revision.getTextContent()), cause, preUnmarshalXml);
        }
        catch (Exception e) {
            throw new SerializerException((Throwable)e);
        }
    }

    private void init(String id, String name, Integer revision, Throwable cause, String channelXml) {
        this.setId(id);
        this.setName(name);
        this.setRevision(revision);
        this.cause = cause;
        this.channelXml = channelXml;
        this.getExportData().getMetadata().setEnabled(false);
        this.setDescription("This channel is invalid. Verify all required extensions are loaded correctly.");
        Connector sourceConnector = new Connector();
        sourceConnector.setFilter(new Filter());
        sourceConnector.setTransformer(new Transformer());
        this.setSourceConnector(sourceConnector);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public String getChannelXml() {
        return this.channelXml;
    }

    public void setChannelXml(String channelXml) {
        this.channelXml = channelXml;
    }

    @Override
    public void setId(String id) {
        this.setProperty("id", id);
        super.setId(id);
    }

    @Override
    public void setName(String name) {
        this.setProperty("name", name);
        super.setName(name);
    }

    @Override
    public void setRevision(int revision) {
        this.setProperty("revision", String.valueOf(revision));
        super.setRevision(revision);
    }

    private void setProperty(String key, String value) {
        if (this.channelXml != null) {
            try {
                DonkeyElement root = new DonkeyElement(this.channelXml);
                DonkeyElement child = root.getChildElement(key);
                if (child != null) {
                    child.setTextContent(value);
                }
                this.channelXml = root.toXml();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

