/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.converters;

import com.mirth.connect.donkey.util.ByteCounterOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;

public class DICOMConverter {
    public static DicomObject byteArrayToDicomObject(byte[] bytes, boolean decodeBase64) throws IOException {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        DicomInputStream dis = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            InputStream inputStream = decodeBase64 ? new BufferedInputStream((InputStream)new Base64InputStream((InputStream)bais)) : bais;
            dis = new DicomInputStream(inputStream);
            dis.setAllocateLimit(-1);
            dis.readDicomObject((DicomObject)basicDicomObject, -1);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)dis);
        return basicDicomObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] dicomObjectToByteArray(DicomObject dicomObject) throws IOException {
        BasicDicomObject basicDicomObject = (BasicDicomObject)dicomObject;
        DicomOutputStream dos = null;
        try {
            ByteArrayOutputStream baos;
            ByteCounterOutputStream bcos = new ByteCounterOutputStream();
            if (basicDicomObject.fileMetaInfo().isEmpty()) {
                try {
                    dos = new DicomOutputStream((OutputStream)bcos);
                    dos.writeDataset((DicomObject)basicDicomObject, TransferSyntax.ImplicitVRLittleEndian);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(dos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)dos);
                baos = new ByteArrayOutputStream(bcos.size());
                dos = new DicomOutputStream((OutputStream)baos);
                dos.writeDataset((DicomObject)basicDicomObject, TransferSyntax.ImplicitVRLittleEndian);
            } else {
                try {
                    dos = new DicomOutputStream((OutputStream)bcos);
                    dos.writeDicomFile((DicomObject)basicDicomObject);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(dos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)dos);
                baos = new ByteArrayOutputStream(bcos.size());
                dos = new DicomOutputStream((OutputStream)baos);
                dos.writeDicomFile((DicomObject)basicDicomObject);
            }
            dicomObject.clear();
            byte[] byArray = baos.toByteArray();
            IOUtils.closeQuietly((OutputStream)dos);
            return byArray;
        }
        catch (IOException e) {
            throw e;
            catch (Throwable t) {
                t.printStackTrace();
                byte[] byArray = null;
                return byArray;
            }
        }
        finally {
            IOUtils.closeQuietly(dos);
        }
    }
}

