/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ErrorContent;
import com.mirth.connect.donkey.model.message.MapContent;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.util.MapUtil;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MessageEncryptionUtil {
    public static void decryptMessage(Message message, Encryptor encryptor) {
        for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
            MessageEncryptionUtil.decryptConnectorMessage(connectorMessage, encryptor);
        }
        if (message.getAttachments() != null) {
            for (Attachment attachment : message.getAttachments()) {
                MessageEncryptionUtil.decryptAttachment(attachment, encryptor);
            }
        }
    }

    public static void decryptConnectorMessage(ConnectorMessage connectorMessage, Encryptor encryptor) {
        if (connectorMessage != null) {
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getRaw(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getProcessedRaw(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getTransformed(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getEncoded(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getSent(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getResponse(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getResponseTransformed(), encryptor);
            MessageEncryptionUtil.decryptMessageContent(connectorMessage.getProcessedResponse(), encryptor);
            MessageEncryptionUtil.decryptMapContent(connectorMessage.getSourceMapContent(), encryptor);
            MessageEncryptionUtil.decryptMapContent(connectorMessage.getConnectorMapContent(), encryptor);
            MessageEncryptionUtil.decryptMapContent(connectorMessage.getChannelMapContent(), encryptor);
            MessageEncryptionUtil.decryptMapContent(connectorMessage.getResponseMapContent(), encryptor);
            MessageEncryptionUtil.decryptErrorContent(connectorMessage.getProcessingErrorContent(), encryptor);
            MessageEncryptionUtil.decryptErrorContent(connectorMessage.getPostProcessorErrorContent(), encryptor);
            MessageEncryptionUtil.decryptErrorContent(connectorMessage.getResponseErrorContent(), encryptor);
            MessageEncryptionUtil.decryptMetaDataMap(connectorMessage.getMetaDataMap(), encryptor);
        }
    }

    public static void decryptMessageContent(MessageContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && content.isEncrypted()) {
            content.setContent(encryptor.decrypt(content.getContent()));
            content.setEncrypted(false);
        }
    }

    public static void decryptMapContent(MapContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && content.isEncrypted()) {
            content.setMap(MapUtil.deserializeMap((Serializer)ObjectXMLSerializer.getInstance(), (String)encryptor.decrypt((String)content.getContent())));
            content.setEncrypted(false);
        }
    }

    public static void decryptErrorContent(ErrorContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && content.isEncrypted()) {
            content.setContent(encryptor.decrypt(content.getContent()));
            content.setEncrypted(false);
        }
    }

    public static void decryptAttachment(Attachment attachment, Encryptor encryptor) {
        if (attachment != null && attachment.getContent() != null && attachment.isEncrypted()) {
            attachment.setContent(encryptor.decrypt(attachment.getEncryptionHeader(), attachment.getContent()));
            attachment.setEncryptionHeader(null);
            attachment.setEncrypted(false);
        }
    }

    public static void decryptMetaDataMap(Map<String, Object> metaDataMap, Encryptor encryptor) {
        if (metaDataMap != null) {
            for (String key : metaDataMap.keySet().toArray(new String[metaDataMap.size()])) {
                Object value = metaDataMap.get(key);
                if (!(value instanceof String) || !StringUtils.startsWith((CharSequence)((String)value), (CharSequence)"{alg=")) continue;
                metaDataMap.put(key, encryptor.decrypt((String)value));
            }
        }
    }

    public static void encryptMessage(Message message, Encryptor encryptor) {
        for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
            MessageEncryptionUtil.encryptConnectorMessage(connectorMessage, encryptor);
        }
        if (message.getAttachments() != null) {
            for (Attachment attachment : message.getAttachments()) {
                MessageEncryptionUtil.encryptAttachment(attachment, encryptor);
            }
        }
    }

    public static void encryptConnectorMessage(ConnectorMessage connectorMessage, Encryptor encryptor) {
        if (connectorMessage != null) {
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getRaw(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getProcessedRaw(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getTransformed(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getEncoded(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getSent(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getResponse(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getResponseTransformed(), encryptor);
            MessageEncryptionUtil.encryptMessageContent(connectorMessage.getProcessedResponse(), encryptor);
            MessageEncryptionUtil.encryptMapContent(connectorMessage.getSourceMapContent(), encryptor);
            MessageEncryptionUtil.encryptMapContent(connectorMessage.getConnectorMapContent(), encryptor);
            MessageEncryptionUtil.encryptMapContent(connectorMessage.getChannelMapContent(), encryptor);
            MessageEncryptionUtil.encryptMapContent(connectorMessage.getResponseMapContent(), encryptor);
            MessageEncryptionUtil.encryptErrorContent(connectorMessage.getProcessingErrorContent(), encryptor);
            MessageEncryptionUtil.encryptErrorContent(connectorMessage.getPostProcessorErrorContent(), encryptor);
            MessageEncryptionUtil.encryptErrorContent(connectorMessage.getResponseErrorContent(), encryptor);
            MessageEncryptionUtil.encryptMetaDataMap(connectorMessage.getMetaDataMap(), encryptor);
        }
    }

    public static void encryptMessageContent(MessageContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && !content.isEncrypted()) {
            content.setContent(encryptor.encrypt(content.getContent()));
            content.setEncrypted(true);
        }
    }

    public static void encryptMapContent(MapContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && !content.isEncrypted()) {
            content.setContent((Object)encryptor.encrypt(MapUtil.serializeMap((Serializer)ObjectXMLSerializer.getInstance(), (Map)content.getMap())));
            content.setEncrypted(true);
        }
    }

    public static void encryptErrorContent(ErrorContent content, Encryptor encryptor) {
        if (content != null && content.getContent() != null && !content.isEncrypted()) {
            content.setContent(encryptor.encrypt(content.getContent()));
            content.setEncrypted(true);
        }
    }

    public static void encryptAttachment(Attachment attachment, Encryptor encryptor) {
        if (attachment != null && attachment.getContent() != null && !attachment.isEncrypted()) {
            Encryptor.EncryptedData result = encryptor.encrypt(attachment.getContent());
            attachment.setEncryptionHeader(result.getHeader());
            attachment.setContent(result.getEncryptedData());
            attachment.setEncrypted(true);
        }
    }

    public static void encryptMetaDataMap(Map<String, Object> metaDataMap, Encryptor encryptor) {
        if (metaDataMap != null) {
            for (String key : metaDataMap.keySet().toArray(new String[metaDataMap.size()])) {
                Object value = metaDataMap.get(key);
                if (!(value instanceof String) || StringUtils.startsWith((CharSequence)((String)value), (CharSequence)"{alg=")) continue;
                metaDataMap.put(key, encryptor.encrypt((String)value));
            }
        }
    }
}

