/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;

public abstract class PropertyLoader {
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final boolean LOAD_AS_RESOURCE_BUNDLE = false;
    private static final String SUFFIX = ".properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith(SUFFIX)) {
            name = name.substring(0, name.length() - SUFFIX.length());
        }
        Properties result = null;
        InputStream in = null;
        try {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (!(name = name.replace('.', '/')).endsWith(SUFFIX)) {
                name = name.concat(SUFFIX);
            }
            if ((in = loader.getResourceAsStream(name)) != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (Exception e) {
            result = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("could not load [" + name + "] as a classloader resource");
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return PropertyLoader.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    public static String getProperty(Properties properties, String propertyKey) {
        String property = properties.getProperty(propertyKey);
        if (property == null) {
            LogManager.getLogger(PropertyLoader.class).error("Property \"" + propertyKey + "\" was not found.");
        }
        return property;
    }

    public static String getProperty(Properties properties, String propertyKey, String defaultValue) {
        return properties.getProperty(propertyKey, defaultValue);
    }
}

