/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;

public class VfsUtils {
    private static Map<String, String> uriExtensionMap = new HashMap<String, String>();
    private static FileSystemManager fileSystemManager;

    public static String pathToUri(String path) {
        for (Map.Entry<String, String> entry : uriExtensionMap.entrySet()) {
            String ext = entry.getKey();
            String prefix = entry.getValue();
            if (path.length() < ext.length() || !path.substring(path.length() - ext.length()).equalsIgnoreCase(ext) || path.length() >= prefix.length() && path.substring(0, prefix.length()).equals(prefix)) continue;
            return prefix + path;
        }
        return path;
    }

    public static FileSystemManager getManager() throws FileSystemException {
        if (fileSystemManager == null) {
            StandardFileSystemManager stdFileSystemManager = new StandardFileSystemManager();
            stdFileSystemManager.setClassLoader(VfsUtils.class.getClassLoader());
            stdFileSystemManager.init();
            fileSystemManager = stdFileSystemManager;
        }
        return fileSystemManager;
    }

    static {
        uriExtensionMap.put("zip", "zip://");
        uriExtensionMap.put("tar.gz", "tgz://");
        uriExtensionMap.put("tar.bz2", "tbz2://");
        uriExtensionMap.put("tar", "tar://");
    }
}

