/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util.messagewriter;

import com.mirth.commons.encryption.Encryptor;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.MapContent;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.util.MapUtil;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.util.MessageEncryptionUtil;
import com.mirth.connect.util.ValueReplacer;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MessageWriterFile
implements MessageWriter {
    private String path;
    private String filePattern;
    private ContentType contentType;
    private boolean destinationContent;
    private boolean encrypted;
    private Encryptor encryptor;
    private String currentFile;
    private Writer writer;
    private ValueReplacer replacer = new ValueReplacer();
    private Serializer serializer = ObjectXMLSerializer.getInstance();

    public MessageWriterFile(String path, String exportFilePattern, ContentType contentType, boolean destinationContent, boolean encrypted, Encryptor encryptor) {
        this.path = path;
        this.filePattern = exportFilePattern;
        this.contentType = contentType;
        this.destinationContent = destinationContent;
        this.encrypted = encrypted;
        this.encryptor = encryptor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean write(Message message) throws MessageWriterException {
        try {
            String file = this.path + IOUtils.DIR_SEPARATOR;
            String content = null;
            boolean replaced = false;
            if (this.contentType == null) {
                if (this.encrypted) {
                    file = file + this.replacer.replaceValues(this.filePattern, message);
                    replaced = true;
                }
                content = this.toXml(message);
            } else {
                content = this.extractContent(message);
            }
            if (StringUtils.isNotBlank((CharSequence)content)) {
                if (!replaced) {
                    file = file + this.replacer.replaceValues(this.filePattern, message);
                }
                if (!file.equals(this.currentFile)) {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                    this.currentFile = file;
                    File fileObject = new File(file);
                    if (fileObject.isDirectory()) {
                        throw new MessageWriterException("Cannot save message to file \"" + file + "\", it is a directory");
                    }
                    this.writer = new OutputStreamWriter(FileUtils.openOutputStream((File)fileObject, (boolean)true));
                }
                this.writer.write(content);
                this.writer.append(IOUtils.LINE_SEPARATOR_WINDOWS);
                this.writer.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new MessageWriterException(e);
        }
    }

    private String toXml(Message message) {
        if (this.encrypted) {
            MessageEncryptionUtil.encryptMessage(message, this.encryptor);
        } else {
            MessageEncryptionUtil.decryptMessage(message, this.encryptor);
        }
        return this.serializer.serialize((Object)message);
    }

    private String extractContent(Message message) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : message.getConnectorMessages().entrySet()) {
            Integer metaDataId = (Integer)entry.getKey();
            ConnectorMessage connectorMessage = (ConnectorMessage)entry.getValue();
            if ((!this.destinationContent || metaDataId == 0) && (this.destinationContent || metaDataId != 0)) continue;
            Object content = null;
            content = this.contentType == ContentType.SOURCE_MAP ? message.getMergedConnectorMessage().getSourceMapContent() : (this.contentType == ContentType.CHANNEL_MAP ? message.getMergedConnectorMessage().getChannelMapContent() : (this.contentType == ContentType.RESPONSE_MAP ? message.getMergedConnectorMessage().getResponseMapContent() : connectorMessage.getMessageContent(this.contentType)));
            if (content == null) continue;
            String stringContent = null;
            boolean contentEncrypted = content.isEncrypted();
            if (this.contentType == ContentType.SENT) {
                tempContent = (String)content.getContent();
                if (contentEncrypted) {
                    tempContent = this.encryptor.decrypt((String)tempContent);
                    contentEncrypted = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)tempContent)) {
                    ConnectorProperties sentContent = (ConnectorProperties)this.serializer.deserialize((String)tempContent, ConnectorProperties.class);
                    stringContent = sentContent.toFormattedString();
                }
            } else if (content instanceof MapContent) {
                tempContent = (Map)content.getContent();
                if (MapUtils.isNotEmpty((Map)tempContent)) {
                    stringContent = MapUtil.serializeMap((Serializer)this.serializer, (Map)tempContent);
                }
            } else {
                stringContent = (String)content.getContent();
            }
            if (!StringUtils.isNotEmpty((CharSequence)stringContent)) continue;
            if (this.encrypted) {
                if (!contentEncrypted) {
                    stringContent = this.encryptor.encrypt(stringContent);
                }
            } else if (contentEncrypted) {
                stringContent = this.encryptor.decrypt(stringContent);
            }
            if (!StringUtils.isNotBlank((CharSequence)stringContent)) continue;
            stringBuilder.append(stringContent);
            stringBuilder.append(IOUtils.LINE_SEPARATOR_WINDOWS);
            stringBuilder.append(IOUtils.LINE_SEPARATOR_WINDOWS);
        }
        return stringBuilder.toString();
    }

    @Override
    public void finishWrite() throws MessageWriterException {
    }

    @Override
    public void close() throws MessageWriterException {
        this.currentFile = null;
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (Exception e) {
                throw new MessageWriterException(e);
            }
        }
    }
}

