/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.custom;

import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.plugins.httpauth.Authenticator;
import com.mirth.connect.plugins.httpauth.AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.custom.CustomHttpAuthProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.util.LinkedHashMap;
import java.util.Map;

public class CustomAuthenticatorProvider
extends AuthenticatorProvider {
    private static final ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private static final TemplateValueReplacer replacer = new TemplateValueReplacer();

    public CustomAuthenticatorProvider(Connector connector, HttpAuthConnectorPluginProperties properties) {
        super(connector, properties);
    }

    @Override
    public Authenticator getAuthenticator() throws Exception {
        CustomHttpAuthProperties props = (CustomHttpAuthProperties)this.getProperties();
        String channelId = this.getConnector().getChannelId();
        String channelName = this.getConnector().getChannel().getName();
        String authenticatorClass = replacer.replaceValues(props.getAuthenticatorClass(), channelId, channelName);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry entry : props.getProperties().entrySet()) {
            properties.put(replacer.replaceValues((String)entry.getKey(), channelId, channelName), replacer.replaceValues((String)entry.getValue(), channelId, channelName));
        }
        Class<?> clazz = Class.forName(authenticatorClass, true, contextFactoryController.getContextFactory(this.getConnector().getResourceIds()).getApplicationClassLoader());
        try {
            return (Authenticator)clazz.getConstructor(Map.class).newInstance(properties);
        }
        catch (Exception e) {
            return (Authenticator)clazz.newInstance();
        }
    }
}

