/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.converters.XMLPrettyPrinter;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedDeserializationProperties;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedReader;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedSerializationProperties;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedXMLHandler;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DelimitedSerializer
implements IMessageSerializer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private DelimitedSerializationProperties serializationProperties;
    private DelimitedDeserializationProperties deserializationProperties;

    public DelimitedSerializer(SerializerProperties properties) {
        this.serializationProperties = (DelimitedSerializationProperties)properties.getSerializationProperties();
        this.deserializationProperties = (DelimitedDeserializationProperties)properties.getDeserializationProperties();
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        if (toXml) {
            if (!(this.serializationProperties.getColumnDelimiter().equals(",") && this.serializationProperties.getRecordDelimiter().equals("\\n") && this.serializationProperties.getColumnWidths() == null && this.serializationProperties.getQuoteToken().equals("\"") && this.serializationProperties.isEscapeWithDoubleQuote() && this.serializationProperties.getQuoteEscapeToken().equals("\\") && this.serializationProperties.getColumnNames() == null && !this.serializationProperties.isNumberedRows() && this.serializationProperties.isIgnoreCR())) {
                serializationRequired = true;
            }
        } else if (!(this.deserializationProperties.getColumnDelimiter().equals(",") && this.deserializationProperties.getRecordDelimiter().equals("\\n") && this.deserializationProperties.getColumnWidths() == null && this.deserializationProperties.getQuoteToken().equals("\"") && this.deserializationProperties.isEscapeWithDoubleQuote() && this.deserializationProperties.getQuoteEscapeToken().equals("\\"))) {
            serializationRequired = true;
        }
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        return null;
    }

    public String fromXML(String source) throws MessageSerializerException {
        StringBuilder builder = new StringBuilder();
        try {
            DelimitedXMLHandler handler = new DelimitedXMLHandler(this.deserializationProperties);
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xr.setContentHandler(handler);
            xr.setErrorHandler(handler);
            xr.parse(new InputSource(new StringReader(source)));
            builder.append((CharSequence)handler.getOutput());
        }
        catch (Exception e) {
            String exceptionMessage = e.getClass().getName() + ":" + e.getMessage();
            this.logger.error(exceptionMessage);
            throw new MessageSerializerException("Error converting XML to delimited text", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to delimited text", (Throwable)e));
        }
        return builder.toString();
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLPrettyPrinter serializer = new XMLPrettyPrinter((Writer)stringWriter);
            serializer.setEncodeEntities(true);
            DelimitedReader delimitedReader = new DelimitedReader(this.serializationProperties);
            delimitedReader.setContentHandler((ContentHandler)serializer);
            delimitedReader.parse(new InputSource(new StringReader(source)));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting delimited text to XML", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting delimited text to XML", (Throwable)e));
        }
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mirth_version", "");
        map.put("message_type", "delimited");
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }
}

