/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.mapper;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Step;
import com.mirth.connect.plugins.mapper.MapperStep;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class MapperPanel
extends EditorPanel<Step> {
    private static final int REGEX_COLUMN = 0;
    private static final int REPLACEMENT_COLUMN = 1;
    private static final String REGEX_COLUMN_NAME = "Regular Expression";
    private static final String REPLACEMENT_COLUMN_NAME = "Replace With";
    private ActionListener nameActionListener;
    private JLabel variableLabel;
    private JTextField variableField;
    private JLabel addToLabel;
    private MirthComboBox<MapperStep.Scope> addToComboBox;
    private JLabel mappingLabel;
    private JTextField mappingField;
    private JLabel defaultValueLabel;
    private JTextField defaultValueField;
    private JLabel replacementLabel;
    private MirthTable regularExpressionsTable;
    private JScrollPane regularExpressionsScrollPane;
    private JButton newButton;
    private JButton deleteButton;

    public MapperPanel() {
        this.initComponents();
        this.initLayout();
    }

    public Step getDefaults() {
        return new MapperStep();
    }

    public Step getProperties() {
        MapperStep props = new MapperStep();
        props.setVariable(this.variableField.getText().trim());
        props.setMapping(this.mappingField.getText().trim());
        props.setDefaultValue(this.defaultValueField.getText().trim());
        ArrayList<ImmutablePair> replacements = new ArrayList<ImmutablePair>();
        for (int i = 0; i < this.regularExpressionsTable.getModel().getRowCount(); ++i) {
            String regex = (String)this.regularExpressionsTable.getModel().getValueAt(i, 0);
            if (!StringUtils.isNotBlank((CharSequence)regex)) continue;
            replacements.add(new ImmutablePair((Object)regex, (Object)((String)this.regularExpressionsTable.getValueAt(i, 1))));
        }
        props.setReplacements(replacements);
        props.setScope((MapperStep.Scope)this.addToComboBox.getSelectedItem());
        return props;
    }

    public void setProperties(Step properties) {
        MapperStep props = (MapperStep)properties;
        this.variableField.setText(props.getVariable());
        this.mappingField.setText(props.getMapping());
        this.defaultValueField.setText(props.getDefaultValue());
        List replacements = props.getReplacements();
        if (replacements != null) {
            this.setRegexProperties(replacements);
        } else {
            this.setRegexProperties(new ArrayList<Pair<String, String>>());
        }
        this.addToComboBox.setSelectedItem((Object)props.getScope());
    }

    public String checkProperties(Step properties, boolean highlight) {
        MapperStep props = (MapperStep)properties;
        Object errors = "";
        if (StringUtils.isBlank((CharSequence)props.getVariable())) {
            errors = (String)errors + "The variable name cannot be blank.\n";
            if (highlight) {
                this.variableField.setBackground(UIConstants.INVALID_COLOR);
            }
        }
        return errors;
    }

    public void resetInvalidProperties() {
        this.variableField.setBackground(null);
    }

    public void setNameActionListener(ActionListener actionListener) {
        this.nameActionListener = actionListener;
    }

    public void stopEditing() {
        if (this.regularExpressionsTable.isEditing()) {
            this.regularExpressionsTable.getCellEditor(this.regularExpressionsTable.getEditingRow(), this.regularExpressionsTable.getEditingColumn()).stopCellEditing();
        }
    }

    private void setRegexProperties(List<Pair<String, String>> properties) {
        Object[][] tableData = new Object[properties.size()][2];
        if (properties != null) {
            int i = 0;
            for (Pair<String, String> pair : properties) {
                tableData[i][0] = pair.getLeft();
                tableData[i][1] = pair.getRight();
                ++i;
            }
        }
        ((RefreshTableModel)this.regularExpressionsTable.getModel()).refreshDataVector(tableData);
    }

    private void deselectRows() {
        this.regularExpressionsTable.clearSelection();
        this.deleteButton.setEnabled(false);
    }

    private int getSelectedRow() {
        if (this.regularExpressionsTable.isEditing()) {
            return this.regularExpressionsTable.getEditingRow();
        }
        return this.regularExpressionsTable.getSelectedRow();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.variableLabel = new JLabel("Variable:");
        this.variableField = new JTextField();
        this.variableField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.documentChanged(evt);
            }

            private void documentChanged(DocumentEvent evt) {
                try {
                    String text = evt.getDocument().getText(0, evt.getDocument().getLength());
                    if (MapperPanel.this.nameActionListener != null) {
                        MapperPanel.this.nameActionListener.actionPerformed(new ActionEvent(this, 1001, text));
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.addToLabel = new JLabel("Add to:");
        this.addToComboBox = new MirthComboBox();
        this.addToComboBox.setModel(new DefaultComboBoxModel<MapperStep.Scope>(MapperStep.Scope.values()));
        this.mappingLabel = new JLabel("Mapping:");
        this.mappingField = new JTextField();
        this.defaultValueLabel = new JLabel("Default Value:");
        this.defaultValueField = new JTextField();
        this.replacementLabel = new JLabel("String Replacement:");
        this.regularExpressionsTable = new MirthTable();
        this.regularExpressionsTable.setModel((TableModel)new RefreshTableModel((Object[])new String[]{REGEX_COLUMN_NAME, REPLACEMENT_COLUMN_NAME}, 0));
        this.regularExpressionsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (MapperPanel.this.getSelectedRow() != -1) {
                    MapperPanel.this.deleteButton.setEnabled(true);
                } else {
                    MapperPanel.this.deleteButton.setEnabled(false);
                }
            }
        });
        class RegExTableCellEditor
        extends TextFieldCellEditor {
            RegExTableCellEditor() {
            }

            public boolean isCellEditable(EventObject evt) {
                boolean editable = super.isCellEditable(evt);
                if (editable) {
                    MapperPanel.this.deleteButton.setEnabled(false);
                }
                return editable;
            }

            protected boolean valueChanged(String value) {
                MapperPanel.this.deleteButton.setEnabled(true);
                return true;
            }
        }
        this.regularExpressionsTable.getColumnModel().getColumn(this.regularExpressionsTable.getColumnModel().getColumnIndex(REGEX_COLUMN_NAME)).setCellEditor((TableCellEditor)((Object)new RegExTableCellEditor()));
        this.regularExpressionsTable.getColumnModel().getColumn(this.regularExpressionsTable.getColumnModel().getColumnIndex(REPLACEMENT_COLUMN_NAME)).setCellEditor((TableCellEditor)((Object)new RegExTableCellEditor()));
        this.regularExpressionsTable.setCustomEditorControls(true);
        this.regularExpressionsTable.setSelectionMode(0);
        this.regularExpressionsTable.setRowSelectionAllowed(true);
        this.regularExpressionsTable.setRowHeight(20);
        this.regularExpressionsTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.regularExpressionsTable.setDragEnabled(false);
        this.regularExpressionsTable.setOpaque(true);
        this.regularExpressionsTable.setSortable(false);
        this.regularExpressionsTable.setEditable(true);
        this.regularExpressionsTable.getTableHeader().setReorderingAllowed(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.regularExpressionsTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.regularExpressionsScrollPane = new JScrollPane((Component)this.regularExpressionsTable);
        this.regularExpressionsScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MapperPanel.this.deselectRows();
            }
        });
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapperPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setEnabled(false);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 6"));
        this.add(this.variableLabel, "right, gapafter 6");
        this.add(this.variableField, "growx, sx, split 3");
        this.add(this.addToLabel, "gapbefore 12, gapafter 6");
        this.add((Component)this.addToComboBox);
        this.add(this.mappingLabel, "newline, right, gapafter 6");
        this.add(this.mappingField, "sx, growx");
        this.add(this.defaultValueLabel, "newline, right, gapafter 6");
        this.add(this.defaultValueField, "sx, growx");
        this.add(this.replacementLabel, "newline, top, right, gapafter 6");
        this.add(this.regularExpressionsScrollPane, "grow, push, sy");
        this.add(this.newButton, "top, flowy, split 2, sgx");
        this.add(this.deleteButton, "top, sgx");
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1 && !this.regularExpressionsTable.isEditing()) {
            ((RefreshTableModel)this.regularExpressionsTable.getModel()).removeRow(this.regularExpressionsTable.convertRowIndexToModel(selectedRow));
            if (this.regularExpressionsTable.getRowCount() > 0) {
                if (selectedRow < this.regularExpressionsTable.getRowCount()) {
                    this.regularExpressionsTable.setRowSelectionInterval(selectedRow, selectedRow);
                } else {
                    this.regularExpressionsTable.setRowSelectionInterval(this.regularExpressionsTable.getRowCount() - 1, this.regularExpressionsTable.getRowCount() - 1);
                }
            }
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        ((DefaultTableModel)this.regularExpressionsTable.getModel()).addRow(new Object[]{"", ""});
        this.regularExpressionsTable.setRowSelectionInterval(this.regularExpressionsTable.getRowCount() - 1, this.regularExpressionsTable.getRowCount() - 1);
    }
}

