/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.dialog;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.client.service.LookupServiceClient;
import com.mirth.connect.plugins.dynamiclookup.shared.capability.LookupJsonCapability;
import com.mirth.connect.plugins.dynamiclookup.shared.constant.LookupConstants;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroupExtra;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import com.mirth.connect.plugins.dynamiclookup.shared.validation.FieldPathFormatValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupGroupDialog
extends MirthDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel descriptionLabel;
    private JTextArea descriptionField;
    private JScrollPane descriptionScrollPane;
    private JLabel versionLabel;
    private JTextField versionField;
    private JLabel cacheSizeLabel;
    private JTextField cacheSizeField;
    private JLabel cachePolicyLabel;
    private JComboBox<String> cachePolicyComboBox;
    private JLabel statisticsEnabledLabel;
    private JCheckBox statisticsEnabledCheckBox;
    private JLabel valueTypeLabel;
    private JComboBox<String> valueTypeComboBox;
    private JLabel jsonIndexTypeLabel;
    private JComboBox<String> jsonIndexTypeComboBox;
    private JLabel jsonIndexFieldsLabel;
    private DefaultListModel<String> jsonIndexFieldsModel;
    private JList<String> jsonIndexFieldsList;
    private JScrollPane jsonIndexFieldsScroll;
    private JButton addJsonFieldButton;
    private JButton removeJsonFieldButton;
    private JButton saveButton;
    private JButton cancelButton;
    private Frame parent;
    private LookupGroup lookupGroup;
    private boolean isEdit = false;
    private boolean saved = false;

    public LookupGroupDialog(Frame frame, LookupGroup lookupGroup, boolean bl) {
        super((Window)frame, true);
        this.parent = frame;
        this.lookupGroup = lookupGroup;
        this.isEdit = bl;
        this.initComponents();
        this.initLayout();
        this.configureJsonControls();
        this.resetComponents(lookupGroup);
        this.setDefaultCloseOperation(2);
        this.setTitle(String.format("%s", bl ? "Edit Group" : "Add Group"));
        this.pack();
        this.setLocationRelativeTo((Component)frame);
        this.setVisible(true);
    }

    private void initComponents() {
        boolean bl = false;
        try {
            LookupJsonCapability lookupJsonCapability = LookupJsonCapability.getInstance();
            bl = lookupJsonCapability.isJsonSupported();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.nameLabel = new JLabel("Name:");
        this.nameField = new JTextField();
        this.descriptionLabel = new JLabel("Description:");
        this.descriptionField = new JTextArea();
        this.descriptionField.setWrapStyleWord(true);
        this.descriptionField.setLineWrap(true);
        this.descriptionScrollPane = new JScrollPane(this.descriptionField, 20, 31);
        this.descriptionScrollPane.setPreferredSize(new Dimension(200, 50));
        this.versionLabel = new JLabel("Version:");
        this.versionField = new JTextField();
        this.cacheSizeLabel = new JLabel("Cache Size:");
        this.cacheSizeField = new JTextField();
        this.cacheSizeField.setDocument((Document)new MirthFieldConstraints(8, false, false, true));
        this.cachePolicyLabel = new JLabel("Cache Policy:");
        this.cachePolicyComboBox = new JComboBox();
        this.cachePolicyComboBox.addItem("LRU");
        this.cachePolicyComboBox.addItem("FIFO");
        this.cachePolicyComboBox.getModel().setSelectedItem("LRU");
        this.statisticsEnabledLabel = new JLabel("Statistics Enabled:");
        this.statisticsEnabledCheckBox = new JCheckBox();
        this.statisticsEnabledCheckBox.setSelected(true);
        this.statisticsEnabledCheckBox.setBackground(new Color(255, 255, 255));
        this.valueTypeLabel = new JLabel("Value Type:");
        this.valueTypeComboBox = new JComboBox();
        this.valueTypeComboBox.addItem("TEXT");
        if (bl) {
            this.valueTypeComboBox.addItem("JSON");
        }
        this.valueTypeComboBox.setSelectedItem("TEXT");
        this.valueTypeComboBox.addActionListener(actionEvent -> this.updateJsonIndexControls());
        this.jsonIndexTypeLabel = new JLabel("JSON Index:");
        this.jsonIndexTypeComboBox = new JComboBox();
        this.jsonIndexTypeComboBox.addItem("NONE");
        this.jsonIndexTypeComboBox.addItem("FIELD");
        this.jsonIndexTypeComboBox.setSelectedItem("NONE");
        this.jsonIndexTypeComboBox.addActionListener(actionEvent -> this.updateJsonIndexControls());
        this.jsonIndexFieldsLabel = new JLabel("Indexed JSON Fields:");
        this.jsonIndexFieldsModel = new DefaultListModel();
        this.jsonIndexFieldsList = new JList<String>(this.jsonIndexFieldsModel);
        this.jsonIndexFieldsList.setVisibleRowCount(5);
        this.jsonIndexFieldsScroll = new JScrollPane(this.jsonIndexFieldsList, 20, 31);
        this.addJsonFieldButton = new JButton("Add");
        this.removeJsonFieldButton = new JButton("Remove");
        this.addJsonFieldButton.addActionListener(actionEvent -> this.addJsonField());
        this.removeJsonFieldButton.addActionListener(actionEvent -> this.removeJsonField());
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(actionEvent -> this.save());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(actionEvent -> this.close());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, hidemode 0, align center, insets 0 0 0 0, fill", "25[right][fill]"));
        jPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setMinimumSize(this.getMinimumSize());
        jPanel.setMaximumSize(this.getMaximumSize());
        jPanel.add((Component)this.nameLabel, "right");
        jPanel.add((Component)this.nameField, "w 200!");
        jPanel.add((Component)this.descriptionLabel, "newline, right");
        jPanel.add(this.descriptionScrollPane);
        jPanel.add((Component)this.versionLabel, "newline, right");
        jPanel.add((Component)this.versionField, "w 100!");
        jPanel.add((Component)this.cacheSizeLabel, "newline, right");
        jPanel.add((Component)this.cacheSizeField, "w 100!, split 2");
        JLabel jLabel = new JLabel("<html><span style='color:#666;'>0 = disabled</span></html>");
        jPanel.add((Component)jLabel, "gapleft 6");
        jPanel.add((Component)this.cachePolicyLabel, "newline, right");
        jPanel.add(this.cachePolicyComboBox, "w 100!");
        jPanel.add((Component)this.statisticsEnabledLabel, "newline, right");
        jPanel.add((Component)this.statisticsEnabledCheckBox, "w 20!");
        jPanel.add((Component)this.valueTypeLabel, "newline, right");
        jPanel.add(this.valueTypeComboBox, "w 120!");
        jPanel.add((Component)this.jsonIndexTypeLabel, "newline, right");
        jPanel.add(this.jsonIndexTypeComboBox, "w 120!");
        jPanel.add((Component)this.jsonIndexFieldsLabel, "newline, right, top");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("insets 0, gap 4, fillx", "[grow]", "[]4[]"));
        jPanel2.add((Component)this.addJsonFieldButton, "growx, wrap");
        jPanel2.add((Component)this.removeJsonFieldButton, "growx");
        jPanel.add((Component)this.jsonIndexFieldsScroll, "w 200!, h 80!, split 2");
        jPanel.add((Component)jPanel2, "top");
        this.add(jPanel, "growx");
        this.add(new JSeparator(), "newline, sx, growx");
        this.add(this.saveButton, "newline, sx, right, split 2");
        this.add(this.cancelButton);
    }

    private void configureJsonControls() {
    }

    private void resetComponents(LookupGroup lookupGroup) {
        this.nameField.setText(lookupGroup.getName());
        this.descriptionField.setText(lookupGroup.getDescription());
        this.versionField.setText(lookupGroup.getVersion());
        this.cacheSizeField.setText(String.valueOf(lookupGroup.getCacheSize()));
        this.cachePolicyComboBox.getModel().setSelectedItem(lookupGroup.getCachePolicy());
        this.statisticsEnabledCheckBox.setSelected(lookupGroup.isStatisticsEnabled());
        String string = LookupConstants.normalizeValueType((String)lookupGroup.getValueType());
        this.valueTypeComboBox.setSelectedItem(lookupGroup.getValueType());
        LookupGroupExtra lookupGroupExtra = lookupGroup.getExtra();
        if (lookupGroupExtra != null) {
            String string2 = lookupGroupExtra.getJsonIndexMode() != null ? lookupGroupExtra.getJsonIndexMode() : "NONE";
            this.jsonIndexTypeComboBox.setSelectedItem(string2);
            this.jsonIndexFieldsModel.clear();
            if (LookupConstants.isJsonValueType((String)string) && LookupConstants.isFieldMode((String)string2) && lookupGroupExtra.getIndexedJsonFields() != null) {
                try {
                    List list = JsonUtils.fromJsonList((String)lookupGroupExtra.getIndexedJsonFields(), String.class);
                    for (String string3 : list) {
                        if (string3 == null || string3.isEmpty()) continue;
                        this.jsonIndexFieldsModel.addElement(string3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.updateJsonIndexControls();
    }

    private void addJsonField() {
        String string = JOptionPane.showInputDialog((Component)((Object)this), "JSON field path (e.g. email, address.city):", "Add JSON Field", -1);
        if (string != null && !(string = string.trim()).isEmpty() && !this.jsonIndexFieldsModel.contains(string)) {
            this.jsonIndexFieldsModel.addElement(string);
        }
    }

    private void removeJsonField() {
        List<String> list = this.jsonIndexFieldsList.getSelectedValuesList();
        for (String string : list) {
            this.jsonIndexFieldsModel.removeElement(string);
        }
    }

    private void updateJsonIndexControls() {
        if (this.isEdit) {
            this.valueTypeComboBox.setEnabled(false);
        }
        String string = (String)this.valueTypeComboBox.getSelectedItem();
        boolean bl = LookupConstants.isJsonValueType((String)string);
        this.jsonIndexTypeLabel.setEnabled(bl);
        this.jsonIndexTypeComboBox.setEnabled(bl);
        if (!bl) {
            this.jsonIndexTypeComboBox.setSelectedItem("NONE");
        }
        String string2 = (String)this.jsonIndexTypeComboBox.getSelectedItem();
        boolean bl2 = bl && "FIELD".equals(string2);
        this.jsonIndexFieldsLabel.setEnabled(bl2);
        this.jsonIndexFieldsList.setEnabled(bl2);
        this.jsonIndexFieldsScroll.setEnabled(bl2);
        this.addJsonFieldButton.setEnabled(bl2);
        this.removeJsonFieldButton.setEnabled(bl2);
    }

    private void save() {
        String string;
        if (!this.validateProperties()) {
            return;
        }
        this.lookupGroup.setName(this.nameField.getText().trim());
        this.lookupGroup.setDescription(this.descriptionField.getText().trim());
        this.lookupGroup.setVersion(this.versionField.getText().trim());
        this.lookupGroup.setCacheSize(Integer.parseInt(this.cacheSizeField.getText().trim()));
        this.lookupGroup.setCachePolicy((String)this.cachePolicyComboBox.getSelectedItem());
        this.lookupGroup.setValueType((String)this.valueTypeComboBox.getSelectedItem());
        this.lookupGroup.setStatisticsEnabled(this.statisticsEnabledCheckBox.isSelected());
        String string2 = (String)this.valueTypeComboBox.getSelectedItem();
        LookupGroupExtra lookupGroupExtra = new LookupGroupExtra();
        if (LookupConstants.isJsonValueType((String)string2)) {
            string = (String)this.jsonIndexTypeComboBox.getSelectedItem();
            lookupGroupExtra.setJsonIndexMode(string);
            if (LookupConstants.isFieldMode((String)string)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.jsonIndexFieldsModel.size(); ++i) {
                    arrayList.add(this.jsonIndexFieldsModel.get(i));
                }
                if (!arrayList.isEmpty()) {
                    try {
                        String string3 = JsonUtils.toJson(arrayList);
                        lookupGroupExtra.setIndexedJsonFields(string3);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to serialize indexed JSON fields", exception);
                    }
                }
            }
        }
        this.lookupGroup.setExtra(lookupGroupExtra);
        try {
            string = this.lookupGroup.getId() > 0 ? LookupServiceClient.getInstance().updateGroup(this.lookupGroup) : LookupServiceClient.getInstance().createGroup(this.lookupGroup);
            this.lookupGroup.setId(string.getId());
            this.lookupGroup.setCreatedDate(string.getCreatedDate());
            this.lookupGroup.setUpdatedDate(string.getUpdatedDate());
            this.saved = true;
            this.close();
        }
        catch (LookupApiClientException lookupApiClientException) {
            this.showError(lookupApiClientException.getError().getMessage());
        }
        catch (Exception exception) {
            this.logger.error("Unexpected error while saving group", (Throwable)exception);
            this.showError("Unexpected error: " + exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }

    private void close() {
        this.dispose();
    }

    public boolean isSaved() {
        return this.saved;
    }

    private boolean validateProperties() {
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        this.resetInvalidComponents();
        String string5 = this.nameField.getText().trim();
        if (StringUtils.isEmpty((CharSequence)string5)) {
            bl = false;
            this.nameField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a name.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string4 = this.versionField.getText().trim()))) {
            bl = false;
            this.versionField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a version.").append(System.lineSeparator());
        }
        if (StringUtils.isEmpty((CharSequence)(string3 = this.cacheSizeField.getText().trim()))) {
            bl = false;
            this.cacheSizeField.setBackground(UIConstants.INVALID_COLOR);
            stringBuilder.append("Please provide a cache size.").append(System.lineSeparator());
        }
        if (LookupConstants.isJsonValueType((String)(string2 = (String)this.valueTypeComboBox.getSelectedItem())) && LookupConstants.isFieldMode((String)(string = (String)this.jsonIndexTypeComboBox.getSelectedItem()))) {
            for (int i = 0; i < this.jsonIndexFieldsModel.size(); ++i) {
                String string6 = this.jsonIndexFieldsModel.get(i);
                try {
                    FieldPathFormatValidator.validate((String)string6);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                    this.jsonIndexFieldsList.setBackground(UIConstants.INVALID_COLOR);
                    stringBuilder.append("Indexed JSON field #").append(i + 1).append(": ").append(illegalArgumentException.getMessage()).append(System.lineSeparator());
                }
            }
        }
        if (!bl) {
            this.showError(stringBuilder.toString());
        }
        return bl;
    }

    public void resetInvalidComponents() {
        this.nameField.setBackground(null);
        this.versionField.setBackground(null);
        this.cacheSizeField.setBackground(null);
        this.jsonIndexFieldsList.setBackground(UIConstants.BACKGROUND_COLOR);
    }

    protected void showInformation(String string) {
        PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), string);
    }

    protected void showError(String string) {
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), string);
    }
}

